/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.constants;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationArgumentVisitor;
import org.jetbrains.kotlin.resolve.constants.CompileTimeConstant;
import org.jetbrains.kotlin.types.ErrorUtils;
import org.jetbrains.kotlin.types.JetType;

public abstract class ErrorValue
extends CompileTimeConstant<Void> {
    public ErrorValue() {
        super(null, true, false, false);
    }

    @Override
    @Deprecated
    public Void getValue() {
        throw new UnsupportedOperationException();
    }

    @Override
    public <R, D> R accept(AnnotationArgumentVisitor<R, D> visitor, D data2) {
        return visitor.visitErrorValue(this, data2);
    }

    @NotNull
    public static ErrorValue create(@NotNull String message) {
        return new ErrorValueWithMessage(message);
    }

    public static class ErrorValueWithMessage
    extends ErrorValue {
        private final String message;

        public ErrorValueWithMessage(@NotNull String message) {
            this.message = message;
        }

        public String getMessage() {
            return this.message;
        }

        @Override
        @NotNull
        public JetType getType(@NotNull KotlinBuiltIns kotlinBuiltIns) {
            return ErrorUtils.createErrorType(this.message);
        }

        public String toString() {
            return this.getMessage();
        }
    }
}

