/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.scopes;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PackageViewDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.scopes.JetScope;

public class JetScopeSelectorUtil {
    public static final ScopeByNameSelector<ClassifierDescriptor> CLASSIFIER_DESCRIPTOR_SCOPE_SELECTOR = new ScopeByNameSelector<ClassifierDescriptor>(){

        @Override
        @Nullable
        public ClassifierDescriptor get(@NotNull JetScope scope2, @NotNull Name name) {
            return scope2.getClassifier(name);
        }
    };
    public static final ScopeByNameSelector<PackageViewDescriptor> PACKAGE_SCOPE_SELECTOR = new ScopeByNameSelector<PackageViewDescriptor>(){

        @Override
        @Nullable
        public PackageViewDescriptor get(@NotNull JetScope scope2, @NotNull Name name) {
            return scope2.getPackage(name);
        }
    };
    public static final ScopeByNameSelector<VariableDescriptor> VARIABLE_DESCRIPTOR_SCOPE_SELECTOR = new ScopeByNameSelector<VariableDescriptor>(){

        @Override
        @Nullable
        public VariableDescriptor get(@NotNull JetScope scope2, @NotNull Name name) {
            return scope2.getLocalVariable(name);
        }
    };
    public static final ScopeByNameMultiSelector<FunctionDescriptor> NAMED_FUNCTION_SCOPE_SELECTOR = new ScopeByNameMultiSelector<FunctionDescriptor>(){

        @Override
        @NotNull
        public Collection<FunctionDescriptor> get(@NotNull JetScope scope2, @NotNull Name name) {
            return scope2.getFunctions(name);
        }
    };
    public static final ScopeByNameMultiSelector<VariableDescriptor> NAMED_PROPERTIES_SCOPE_SELECTOR = new ScopeByNameMultiSelector<VariableDescriptor>(){

        @Override
        @NotNull
        public Collection<VariableDescriptor> get(@NotNull JetScope scope2, @NotNull Name name) {
            return scope2.getProperties(name);
        }
    };

    private JetScopeSelectorUtil() {
    }

    @NotNull
    public static <D extends DeclarationDescriptor> Collection<D> collect(Collection<JetScope> scopes, ScopeByNameMultiSelector<D> selector, Name name) {
        HashSet<D> descriptors = new HashSet<D>();
        for (JetScope scope2 : scopes) {
            descriptors.addAll(selector.get(scope2, name));
        }
        return descriptors;
    }

    @Nullable
    public static <D extends DeclarationDescriptor> D getFirstMatch(@NotNull JetScope[] scopes, @NotNull Name name, @NotNull ScopeByNameSelector<D> descriptorSelector) {
        for (JetScope scope2 : scopes) {
            D descriptor2 = descriptorSelector.get(scope2, name);
            if (descriptor2 == null) continue;
            return descriptor2;
        }
        return null;
    }

    @NotNull
    public static <D extends DeclarationDescriptor> Set<D> getFromAllScopes(@NotNull JetScope[] scopes, @NotNull Name name, @NotNull ScopeByNameMultiSelector<D> descriptorsSelector) {
        if (scopes.length == 0) {
            return Collections.emptySet();
        }
        LinkedHashSet<D> descriptors = new LinkedHashSet<D>();
        for (JetScope jetScope : scopes) {
            descriptors.addAll(descriptorsSelector.get(jetScope, name));
        }
        return descriptors;
    }

    public static interface ScopeByNameMultiSelector<D extends DeclarationDescriptor> {
        @NotNull
        public Collection<D> get(JetScope var1, Name var2);
    }

    public static interface ScopeByNameSelector<D extends DeclarationDescriptor> {
        @Nullable
        public D get(@NotNull JetScope var1, @NotNull Name var2);
    }
}

