/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmh.profile;

import java.io.BufferedReader;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import joptsimple.OptionException;
import joptsimple.OptionParser;
import joptsimple.OptionSpec;
import org.openjdk.jmh.infra.BenchmarkParams;
import org.openjdk.jmh.profile.AbstractPerfAsmProfiler;
import org.openjdk.jmh.profile.ProfilerException;
import org.openjdk.jmh.util.Deduplicator;
import org.openjdk.jmh.util.FileUtils;
import org.openjdk.jmh.util.HashMultimap;
import org.openjdk.jmh.util.InputStreamDrainer;
import org.openjdk.jmh.util.IntervalMap;
import org.openjdk.jmh.util.Multiset;
import org.openjdk.jmh.util.TreeMultiset;
import org.openjdk.jmh.util.Utils;

public class LinuxPerfAsmProfiler
extends AbstractPerfAsmProfiler {
    private final long sampleFrequency;
    private OptionSpec<Long> optFrequency;

    public LinuxPerfAsmProfiler(String initLine) throws ProfilerException {
        super(initLine, "cycles", "instructions");
        Collection<String> failMsg = Utils.tryWith("perf", "stat", "--log-fd", "2", "echo", "1");
        if (!failMsg.isEmpty()) {
            throw new ProfilerException(failMsg.toString());
        }
        try {
            this.sampleFrequency = (Long)this.set.valueOf(this.optFrequency);
        }
        catch (OptionException e) {
            throw new ProfilerException(e.getMessage());
        }
    }

    @Override
    protected void addMyOptions(OptionParser parser) {
        this.optFrequency = parser.accepts("frequency", "Sampling frequency. This is synonymous to perf record --freq #").withRequiredArg().ofType(Long.class).describedAs("freq").defaultsTo((Object)1000L, (Object[])new Long[0]);
    }

    @Override
    public Collection<String> addJVMInvokeOptions(BenchmarkParams params) {
        return Arrays.asList("perf", "record", "--freq", String.valueOf(this.sampleFrequency), "--event", Utils.join(this.events, ","), "--output", this.perfBinData);
    }

    @Override
    public String getDescription() {
        return "Linux perf + PrintAssembly Profiler";
    }

    @Override
    protected void parseEvents() {
        try {
            ProcessBuilder pb = new ProcessBuilder("perf", "script", "--fields", "time,event,ip,sym,dso", "--input", this.perfBinData);
            Process p = pb.start();
            FileOutputStream fos = new FileOutputStream(this.perfParsedData);
            InputStreamDrainer errDrainer = new InputStreamDrainer(p.getErrorStream(), fos);
            InputStreamDrainer outDrainer = new InputStreamDrainer(p.getInputStream(), fos);
            errDrainer.start();
            outDrainer.start();
            p.waitFor();
            errDrainer.join();
            outDrainer.join();
            FileUtils.safelyClose(fos);
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
        catch (InterruptedException ex) {
            throw new IllegalStateException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected AbstractPerfAsmProfiler.PerfEvents readEvents(double skipSec) {
        FileReader fr = null;
        try {
            String line;
            Deduplicator<AbstractPerfAsmProfiler.MethodDesc> dedup = new Deduplicator<AbstractPerfAsmProfiler.MethodDesc>();
            fr = new FileReader(this.perfParsedData);
            BufferedReader reader = new BufferedReader(fr);
            HashMultimap<AbstractPerfAsmProfiler.MethodDesc, Long> methods = new HashMultimap<AbstractPerfAsmProfiler.MethodDesc, Long>();
            LinkedHashMap<String, Multiset<Long>> events = new LinkedHashMap<String, Multiset<Long>>();
            for (String evName : this.events) {
                events.put(evName, new TreeMultiset());
            }
            Double startTime = null;
            while ((line = reader.readLine()) != null) {
                Long addr;
                Multiset evs;
                String[] elems;
                if (line.startsWith("#") || (elems = line.trim().split("[ ]+")).length < 4) continue;
                String strTime = elems[0].replace(":", "");
                String evName = elems[1].replace(":", "");
                String strAddr = elems[2];
                String symbol = Utils.join(Arrays.copyOfRange(elems, 3, elems.length - 1), " ");
                String lib = elems[elems.length - 1];
                lib = lib.substring(lib.lastIndexOf("/") + 1, lib.length()).replace("(", "").replace(")", "");
                try {
                    Double time = Double.valueOf(strTime);
                    if (startTime == null) {
                        startTime = time;
                    } else if (time - startTime < skipSec) {
                    }
                }
                catch (NumberFormatException e) {}
                continue;
                if ((evs = (Multiset)events.get(evName)) == null) continue;
                try {
                    addr = Long.valueOf(strAddr, 16);
                }
                catch (NumberFormatException e) {
                    try {
                        addr = new BigInteger(strAddr, 16).longValue();
                    }
                    catch (NumberFormatException e1) {
                        addr = 0L;
                    }
                }
                evs.add(addr);
                methods.put(dedup.dedup(AbstractPerfAsmProfiler.MethodDesc.nativeMethod(symbol, lib)), addr);
            }
            IntervalMap<AbstractPerfAsmProfiler.MethodDesc> methodMap = new IntervalMap<AbstractPerfAsmProfiler.MethodDesc>();
            for (AbstractPerfAsmProfiler.MethodDesc md : methods.keys()) {
                Collection addrs = methods.get(md);
                methodMap.add(md, (Long)Utils.min(addrs), (Long)Utils.max(addrs));
            }
            AbstractPerfAsmProfiler.PerfEvents perfEvents = new AbstractPerfAsmProfiler.PerfEvents(this.events, events, methodMap);
            return perfEvents;
        }
        catch (IOException e) {
            AbstractPerfAsmProfiler.PerfEvents perfEvents = new AbstractPerfAsmProfiler.PerfEvents(this.events);
            return perfEvents;
        }
        finally {
            FileUtils.safelyClose(fr);
        }
    }

    @Override
    protected String perfBinaryExtension() {
        return ".perfbin";
    }
}

