let validCheckEmail = (email) => {
    if(email == "" || email == null) return false;

    const regx = /^([\w-]+(?:\.[\w-]+)*)@((?:[\w-]+\.)*\w[\w-]{0,66})\.([a-z]{2,6}(?:\.[a-z]{2})?)$/i;
    return regx.test(email);
}

let validCheckCellphone = (number) => {
    if(number == "" || number == null) return false;

    const regx = /^[0-9\+\-\s]+$/i;
    return regx.test(number);
}

let validCheckName = (keyword) => {
    if(keyword == "" || keyword == null) return false;

    const regx = /[`~!@#$%^&*|\\\'\";:\/?]/gi;
    return regx.test(keyword);
}

let validCheckIp = (ip) => {
    if(ip == "" || ip == null) return false;

    return /^(([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])\.){3}([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])$|^(([a-zA-Z]|[a-zA-Z][a-zA-Z0-9\-]*[a-zA-Z0-9])\.)*([A-Za-z]|[A-Za-z][A-Za-z0-9\-]*[A-Za-z0-9])$|^\s*((([0-9A-Fa-f]{1,4}:){7}([0-9A-Fa-f]{1,4}|:))|(([0-9A-Fa-f]{1,4}:){6}(:[0-9A-Fa-f]{1,4}|((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3})|:))|(([0-9A-Fa-f]{1,4}:){5}(((:[0-9A-Fa-f]{1,4}){1,2})|:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3})|:))|(([0-9A-Fa-f]{1,4}:){4}(((:[0-9A-Fa-f]{1,4}){1,3})|((:[0-9A-Fa-f]{1,4})?:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){3}(((:[0-9A-Fa-f]{1,4}){1,4})|((:[0-9A-Fa-f]{1,4}){0,2}:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){2}(((:[0-9A-Fa-f]{1,4}){1,5})|((:[0-9A-Fa-f]{1,4}){0,3}:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){1}(((:[0-9A-Fa-f]{1,4}){1,6})|((:[0-9A-Fa-f]{1,4}){0,4}:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(:(((:[0-9A-Fa-f]{1,4}){1,7})|((:[0-9A-Fa-f]{1,4}){0,5}:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:)))(%.+)?\s*$/.test(ip);
}

let printCsvText = (text) => {
    text = text.replace(/\"/g, "\"\"");
    text = text.replace(/[\r|\n]/g, ' ');

    return text;
}

let printEscape = (method) => {
    let res = method,
        len = res.length,
        max = 1000;

    res = res.replace(/&/g, '&amp;');
    res = res.replace(/>/g, '&gt;');
    res = res.replace(/</g, '&lt;');
    res = res.replace(/"/g, '&quot;');
    res = res.replace(/'/g, '&apos;');
    res = res.replace(/\\/g, '\\\\');
    res = res.replace(/[\r|\n]/g, ' ');

    if(len > max) {
        return res.substr(0, max) + "...";
    }

    return res;
}

let printOidNames = (sid, oids) => {
    if(oids.length > 0) {
        let newOids = [];

        for(let i = 0; i < oids.length; i++) {
            if(!isNaN(oids[i])) {
                newOids.push(oids[i]);
            }
        }

        if(newOids.length > 0) {
            let names = [];

            $.ajax({
                url: "/agent/names/oids",
                method: "GET",
                async: false,
                data: {
                    format: "json",
                    sid: sid,
                    oids: newOids
                },
                success: function(list) {
                    names = list;
                }
            });

            return names.join(",");
        }
    }

    return "";
}

let getChartTarget = (value) => {
    if(value > 10) {
        let preDigits = ("" + value).split(""),
            digits = ("" + Math.ceil(value * 1.2)).split("");

        for (let i = 1; i < digits.length; i++) {
            if (preDigits[i - 1] == digits[i - 1]) {
                digits[i] = "5";
            } else {
                digits[i] = "0";
            }
        }

        return parseInt(digits.join(""));
    } else if(value == 0) {
        return 1;
    }

    return value * 1.2;
}

let setSortEff = (column, e, isBlack, isMulti) => {
    $(column.element).parent().find("i").remove();

    let color = (!isBlack) ? " icon-white" : "";
    let $icon = $("<i class='icon-arrow3" + color + "'></i>");

    if(column.order == "desc") {
        $icon = $("<i class='icon-arrow1" + color + "'></i>");
    }

    if(!isMulti) {
        $icon.css({ "position": "static", "float": "right", "margin-left": "-20px" });
    } else {
        $icon.css({ "margin-left": "3px" });
    }

    $(column.element).find("i").remove();
    $(column.element).append($icon);
}

let setMultiSortEff = (column, isMulti) => {
    $(column.element).find("i").remove();

    let $icon = null;

    if(column.order == "desc") {
        $icon = $("<i class='icon-arrow1'></i>");
    } else if(column.order == "asc") {
        $icon = $("<i class='icon-arrow3'></i>");
    }

    if($icon != null) {
        if(!isMulti) {
            $icon.css({ "position": "static", "float": "right", "margin-left": "-20px" });
        } else {
            $icon.css({ "margin-left": "3px" });
        }

        $(column.element).append($icon);
    }
}

let setExpandEff = (row) => {
    if(!row) return;
    $(row.list[0]).html("<i class='icon-right'></i>");
}

let setExpandEndEff = (row) => {
    if(!row) return;
    $(row.list[0]).html("<i class='icon-left'></i>");
}

let printBrText = (text) => {
    text = text.replace(/\</g, '&lt;');
    text = text.replace(/\>/g, '&gt;');
    text = text.replace(/\n/g, '<br>');

    return (text == "null") ? "" : text;
}

let printTimeRange = (time, range, maxTime) => {
    let sdate = getServerMoment(time),
        sdateStr = sdate.format(Date.getLongDateFormat());

    if(range == "1440" || range == "all")
        return sdateStr;

    let edate = sdate.add(parseInt(range) * 1000 * 60, "milliseconds");
    let etime = edate.valueOf();

    if(maxTime && etime > maxTime) {
        return sdateStr + " ~ " + getServerMoment(maxTime).format("HH:mm");
    }

    let edateFormat = edate.format("HH:mm");

    if (edateFormat == "00:00" && sdateStr.indexOf(edateFormat) > -1) {
        return sdateStr.replace(edateFormat, "");
    }

    return sdateStr + " ~ " + edateFormat;
}

let onDragPrevent = () => {
    $("body").bind("selectstart", function(e) {
        e.preventDefault();
    }).bind("contextmenu", function(e) {
        e.preventDefault();
    });
}

let offDragPrevent = () => {
    $("body").unbind("selectstart").unbind("contextmenu");
}

let setBookmark = (elem) => {
    if($(elem).hasClass("prevent")) {
        alert(i18n.get("M0541"));
    } else {
        if($(elem).hasClass("active")) {
            $.get("/user/bookmark/remove", {
                uri: location.pathname
            }, function(res) {
                if(res) {
                    $(elem).removeClass("active");
                }
            });
        } else {
            let uri = location.pathname,
                params = "";

            // 사용자정의 대시보드일 때, 예외사항
            if(uri == "/userdefine/dashboard") {
                params = "?" + location.href.split("?")[1];
            }

            $.get("/user/bookmark/add" + params, {
                uri: uri
            }, function(res) {
                if(res) {
                    $(elem).addClass("active");
                } else {
                    alert(i18n.get("M0483"));
                }
            });
        }
    }
}

let linkManual = () => {
    let width = 1024, height = 768,
        url = `/manual/${ariesuser.language}/index.html`;

    let ajaxManualUrl = (sessionStorage) ? sessionStorage.getItem("ajaxManualUrl") : "",
        popupUrl = (mng.ui.type == "hide") ? location.pathname : ajaxManualUrl;

    url += "#" + popupUrl.split("/").join("_").substr(1);

    let popup = window.open(url, "manual", 'width=' + width + ',height=' + height + ',history=no,resizable=no,status=no,scrollbars=no,menubar=no');
    popup.focus();
}

let hashManual = (hash) => {
    let width = 1024, height = 768;
    let url = `/manual/${ariesuser.language}/index.html`;

    if(hash.startsWith("/mng/")) {
        url += `#${hash.split("/").join("_").substr(1)}`;
    } else {
        url += `#${hash}`;
    }

    let popup = window.open(url, "manual", 'width=' + width + ',height=' + height + ',history=no,resizable=no,status=no,scrollbars=no,menubar=no');
    popup.focus();
}

let setSessionKeys = (key, items) => {
    sessionStorage.removeItem(key);
    sessionStorage.setItem(key, items.join(","));
}

let getSessionKeys = (key) => {
    let result = [],
        items = sessionStorage.getItem(key);

    if(items != null) {
        result = items.split(",");
    }

    for(let i = 0; i < result.length; i++) {
        result[i] = parseInt(result[i]);
    }

    return result;
}

//@david
//array 만을 집어넣는 위 메소드를 보완하기 위해 생성한 메소드
//json-string을 저장, 불러온다.
let getSessionObj = (key) => {
    let string = sessionStorage.getItem(key);

    let result;

    try {
        result = JSON.parse(string);
    } catch (e){
        console.log("call getSessionObj parse problem ");
        console.log(string);
        return {};
    }

    return result;
}

let setSessionObj = (key, obj) => {
    sessionStorage.setItem(key, JSON.stringify(obj));
}

let showDBPlanPopup = (sid, stime, etime, key, params, bindParams) => {
    let pop = window.open('', 'dbplanPopup', "width=1050,height=780,location='no',history='no',resizable='no',status='no',scrollbars='no',toolbar='no',menubar='no'");

    if(typeof(pop) != "undefined") pop.focus();

    // TODO: [JJC-1627] backslash는 _.escape 함수로 완벽하게 처리되지 않음
    if(typeof(params) == "object") {
        for (let i = 0; i < params.length; i++) {
            params[i].value = printEscape(params[i].value);
        }
    }
    if(typeof(bindParams) == "object") {
        for (let i = 0; i < bindParams.length; i++) {
            bindParams[i].value = printEscape(bindParams[i].value);
        }
    }

    let $form = $(
        '<form id="popup_frm" method="post" action="/popup/dbplan" target="dbplanPopup">' +
        '<input name="sid" type="hidden" />' +
        '<input name="key" type="hidden" />' +
        '<input name="stime" type="hidden" />' +
        '<input name="etime" type="hidden" />' +
        '<input name="params" type="hidden" />' +
        '<input name="bindParams" type="hidden" /></form>');

    $("#popup_frm").remove();
    $("body").append($form);

    $form.find("input[name=sid]").val(sid);
    $form.find("input[name=key]").val(key);
    $form.find("input[name=stime]").val(stime);
    $form.find("input[name=etime]").val(etime);
    $form.find("input[name=params]").val(JSON.stringify(params));
    $form.find("input[name=bindParams]").val(JSON.stringify(bindParams));
    $form.submit();
}

let showSherpaOraclePopup = (url) => {
    let pop = window.open(url, 'sherpaOraclePopup', "width=1280,height=768,location='no',history='no',resizable='no',status='no',scrollbars='yes',toolbar='no',menubar='no'");
    if(typeof(pop) != "undefined") pop.focus();
}

let copyClipboard = (text) => {
    if(window.clipboardData) {
        window.clipboardData.setData("Text", text);
        alert(i18n.get("M0127"));
    } else {
        prompt(i18n.get("M0128"), text);
        $(alertModal[2].root).find(".body > .input").select();

        try {
            document.execCommand("copy");
        } catch(e) {
            console.log(e);
        }
    }
}

let checkPermission = (type) =>  {
    let perList = [],
        tmpList = server.permission.split(",");

    for(let i = 0; i < tmpList.length; i++) {
        perList.push(parseInt(tmpList[i]));
    }

    return $.inArray(type, perList) != -1;
}

let getLanguageType = (langType) => {
    let key = ((server.platform == "net") ? "dot_net" : server.platform).toUpperCase();
    return (langType == 0 || !langType) ? LanguageTypeDef[key] : langType;
}

let updateAgentStatusMessage = (sid, oid, code, callback) => {
    $.ajax({
        method: "GET",
        url: "/agent/feature",
        data: {
            format: "json",
            sid: sid,
            oid: oid,
            code: code
        },
        success: function(res) {
            callback(res);
        }
    });
}

let showThemeTool = () => {
    let pop = window.open('', 'themeTool', "width=1024,height=768,location='no',history='no',resizable='no',status='no',scrollbars='no',toolbar='no',menubar='no'"),
        _frm = document.frm;

    if(typeof(pop) != "undefined") pop.focus();
    $('#frm').empty().append("<input type='hidden' name='layout' value='" + $("body").attr("class") + "' />");

    _frm.method =  'post';
    _frm.action = '/popup/themeTool';
    _frm.target = 'themeTool';
    _frm.submit();
}

let ajaxGroup = (params, before, progress, after, ui_layer) => {
    let data = [];

    let p = $.extend({
        method: "POST",
        sessionUrl: null,
        sessionParams: null,
        dataUrl: null,
        dataKey: "sessionKey"
    }, params);

    $.ajax({
        method: p.method,
        url: p.sessionUrl,
        data: p.sessionParams,
        success: function(key) {
            if(typeof(before) == "function") {
                before(key);
            }

            startPollingData(key);
        },
        error: function(e) {
            if(typeof(after) == "function") {
                after(data);
            }
        }
    });

    var startPollingData = (key) => {
        if(typeof(ui_layer) == "object" && ui_layer.type == "hide") {
            return;
        }

        let dataParams = {};
        dataParams[p.dataKey] = key;

        $.ajax({
            method: p.method,
            url: p.dataUrl,
            data: dataParams,
            success: function(json) {
                for(let i = 0; i < json.partialData.length; i++) {
                    data.push(json.partialData[i]);
                }

                if(!json.hasNext) {
                    if(typeof(after) == "function") {
                        after(data);
                    }
                } else {
                    if(typeof(progress) == "function") {
                        progress(data, json.progress);
                    }

                    startPollingData(key);
                }
            },
            error: function(e) {
                if(typeof(after) == "function") {
                    after(data);
                }
            }
        });
    }
}

/**
 * realtime과 dashboard 화면인지 체크하는 함수
 * batch 모드일 경우, 도메인그룹 박스와 트리에서 비활성화 유무를 체크할 때 사용함
 *
 * @returns {boolean}
 */
let isRealtimePage = () => {
    let path = location.pathname;

    if(path.startsWith("/analysis") || path.startsWith("/statistics") || path.startsWith("/report")) {
        return false;
    }

    return true;
}

// TODO: jui 의존성 제거를 위해 해당 함수는 제거하자.
let downloadCsv = (fileName, options) => {
    let _ = jui.include("util.base");
    let $form = $('<form id="form_csv" method="post" action="/file/download/csv"><input name="name" type="hidden" /><input name="csv" type="hidden" /></form>');

    $("body").append($form);
    $form.find("input[name=name]").val(fileName + ".csv");
    $form.find("input[name=csv]").val(_.dataToCsv2(options));
    $form.submit();
    $("#form_csv").remove();
}

let downloadText = (fileName, text) => {
    let $form = $('<form id="form_csv" method="post" action="/file/download/csv"><input name="name" type="hidden" /><input name="csv" type="hidden" /></form>');

    $("body").append($form);
    $form.find("input[name=name]").val(fileName + ".txt");
    $form.find("input[name=csv]").val(text);
    $form.submit();
    $("#form_csv").remove();
}

let getByteLength = (s,b,i,c) => {
    for(b=i=0;c=s.charCodeAt(i++);b+=c>>11?3:c>>7?2:1);
    return b;
}

let getTimeRangeBasedOnDayOfWeek = (c, s, e) => {
    var current = getServerMoment(c);
    current.set("hour", 0);
    current.set("minute", 0);
    current.set("second", 0);
    current.set("millisecond", 0);

    // 오늘 요일과 마지막 요일이 같을 경우, 하루를 빼준다.
    var isSameDay = false;
    if(current.day() == e) {
        current.add(-7, "day");
        isSameDay = true;
    }

    var endTime = (isSameDay == true) ? current : getPrevTime(current, e);
    var startTime = getPrevTime(endTime, s);

    function getPrevTime(current, day) {
        var nc = current.clone();

        while(true) {
            if(day != nc.day()) {
                nc.add(-1, "day");
            } else {
                break;
            }
        }

        return nc;
    }

    return [ startTime.valueOf(), endTime.valueOf() ];
}

let resizeIframeHeight = (iframe, minHeight) => {
    if (iframe) {
        var iframeWin = iframe.contentWindow || iframe.contentDocument.parentWindow;
        var iframeMinHeight = minHeight - 35;

        if (iframeWin.document.body) {
            iframe.height = 0;
            var tmpHeight = (iframeWin.document.documentElement.scrollHeight || iframeWin.document.body.scrollHeight);
            iframe.height = (tmpHeight < iframeMinHeight) ? iframeMinHeight : tmpHeight;
        }
    }

    return 0 ;
}

let getModifyUserMsg = (code) => {
    var msg_pwd = "";

    $.ajax({
        url: "/user/password/policy/get",
        type: "post",
        async: false,
        success: function (policy) {
            var msg = i18n.get("M0104");

            msg = msg.replace("%d", policy.passwordLength);
            msg = msg.replace("%d", policy.minLowercase);
            msg = msg.replace("%d", policy.minUppercase);
            msg = msg.replace("%d", policy.minDigit);
            msg = msg.replace("%d", policy.minSpecial);

            msg_pwd = msg;
        }
    });

    if (code == "M0104") {
        return msg_pwd;
    }

    return i18n.get(code);
}


function JSONreplacer(key, value) {
    if (typeof value === 'number' && !isFinite(value)) {
        return String(value);
    }
    return value;
}


/**
 * DataView.js
 * !!시작!!
 */
if (typeof TextDecoder == 'undefined') {
    DataView.prototype.getString = function(byteOffset, length){
        var strView = new Uint8Array(this.buffer, byteOffset, length);
        var encodedString =  String.fromCharCode.apply(null, strView);		//FIXME: 문자열변환 메모리 릭 발생, 일단은 다른 문자열로 대체함.
        return encodedString;
    };
} else {
    window.jenniferStringDecoder = new TextDecoder('utf-8');
    DataView.prototype.getString = function(byteOffset, length){
        var strView = new Uint8Array(this.buffer, byteOffset, length);
        return jenniferStringDecoder.decode(strView);
    };
}
/**
 * DataView.js
 * !!종료!!
 */



/**
 * CanvasGraphicsUtil.js
 * !!시작!!
 */

var checkTableVar = /iPhone|iPod|iPad|Android/i.test(navigator.userAgent);

function checkTablet () {
    return /iPhone|iPod|iPad|Android/i.test(navigator.userAgent);
}

function enabledShadow() {

    if (checkTableVar) {
        return false;
    }

    //TODO : instance 가 많을 때 shadow 는 canvas 성능저하를 가지고 옴.
    //return false;
    return true;
}

function shadowXY(context, offsetX, offsetY, blur, color) {
    if (!enabledShadow()) return ;
    context.shadowOffsetX = offsetX;
    context.shadowOffsetY = offsetY;
    context.shadowBlur = blur;
    context.shadowColor = color;
}

function shadowY(context, offsetY, blur, color) {
    if (!enabledShadow()) return ;
    context.shadowOffsetY = offsetY;
    context.shadowBlur = blur;
    context.shadowColor = color;
}

function shadow(context, blur, color) {
    if (!enabledShadow()) return ;
    context.shadowBlur = blur;
    context.shadowColor = color;
}

function drawParticle(context, x, y, color, size, renderPercent){
    var colorAlpha = Color.create(color);
    colorAlpha.setAlpha(1-renderPercent);``

    context.fillStyle = colorAlpha.toString();
    var renderSize = size * (1-renderPercent)
    context.beginPath();
    context.arc(x, y, renderSize, 0, Math.PI * 2, true);
    context.closePath();
    context.fill();

    context.fillStyle = color;
    if(0.4 <= renderPercent){
        var renderSize = size * (1-0.4);
        var largeSize = renderSize / 3;
        var smallSize = renderSize / 6;

        var particePercent = renderPercent - 0.4;

        var move=particePercent*size*4;
        var half_move = move / 2;

        var fullSize = renderSize+move;
        var fullLargeSize = largeSize+half_move;

        context.beginPath();
        context.arc(x, y+fullSize, largeSize, 0, Math.PI * 2, true);
        context.fill();


        context.beginPath();
        context.arc(x, y-fullSize, largeSize, 0, Math.PI * 2, true);
        context.fill();

        context.beginPath();
        context.arc(x+fullSize, y, largeSize, 0, Math.PI * 2, true);
        context.fill();


        context.beginPath();
        context.arc(x-fullSize, y, largeSize, 0, Math.PI * 2, true);
        context.fill();

        context.beginPath();
        context.arc(x+fullLargeSize, y+fullLargeSize, smallSize, 0, Math.PI * 2, true);
        context.fill();


        context.beginPath();
        context.arc(x+fullLargeSize, y-fullLargeSize, smallSize, 0, Math.PI * 2, true);
        context.fill();

        context.beginPath();
        context.arc(x-fullLargeSize, y-fullLargeSize, smallSize, 0, Math.PI * 2, true);
        context.fill();

        context.beginPath();
        context.arc(x-fullLargeSize, y+fullLargeSize, smallSize, 0, Math.PI * 2, true);
        context.fill();
    }
}

function drawParticle2(context, x, y, color, size, renderPercent){
    var colorAlpha = Color.create(color);
    colorAlpha.setAlpha(0.7-(renderPercent)*0.7);

    context.fillStyle = colorAlpha.toString();
    var renderSize = size * (1-renderPercent)
    context.beginPath();
    context.arc(x, y, renderSize, 0, Math.PI * 2, true);
    context.closePath();
    context.fill();
}

//value를 아래쪽에 표시함.
function drawValueBottom(context, value, x, y){
    context.font = "bold 11px Arial";
    var strWidth = context.measureText(value).width;
    var boxWidth = strWidth + 10;

    //박스 그리기
    context.fillStyle = 'rgb(90, 90, 90)';
    context.roundRect(x-boxWidth/2, y, x+boxWidth/2, y+14, 2);
    context.fill();

    context.beginPath();
    context.moveTo(x, y-5);
    context.lineTo(x+3, y);
    context.lineTo(x-3, y);
    context.closePath();
    context.fill();

    //text
    context.fillStyle = 'rgb(255, 255, 255)';
    context.textBaseline = "middle";
    context.textAlign = 'center';
    context.fillText(value, x, y+7);
}

function drawCloseButton(context, x, y) {
    var size = 10;

    context.beginPath();
    context.lineWidth = 2;
    context.strokeStyle = "#ffffff";
    var gradient = context.createLinearGradient(0, y-10, 0, y+10);
    gradient.addColorStop(0, "#a075d9");
    gradient.addColorStop(1, "#7c51b5");
    context.fillStyle = gradient;
    context.arc(x, y, size, 0, Math.PI * 2, true);

    context.save();
    shadowXY(context, 2, 2, 2, "rgba(0, 0, 0, 0.25)");
    //context.shadowOffsetX = 2;
    //context.shadowOffsetY = 2;
    //context.shadowBlur = 2;
    //context.shadowColor = "rgba(0, 0, 0, 0.25)";
    context.fill();
    context.stroke();
    context.restore();

    context.lineWidth = 3;
    context.beginPath();
    context.moveTo(x-4, y+4);
    context.lineTo(x+4, y-4);
    context.moveTo(x+4, y+4);
    context.lineTo(x-4, y-4);
    context.stroke();

    context.beginPath();
    context.arc(x, y, size+3, 0, Math.PI * 2, true);
    context.closePath();
}

//runtimelinechart에서 클릭한 라인의 맥스값 표시
//말풍선 안에 text렌더링
function renderSelectPointText(context, value, x, y, pointColor) {
    context.beginPath();
    context.fillStyle = pointColor;
    context.strokeStyle = 'rgb(255, 255, 255)';
    context.arc(x, y, 4, 0, Math.PI * 2, false);
    context.closePath();
    context.stroke();
    context.fill();

    context.font = "bold 11px Arial";
    var strWidth = context.measureText(value).width;
    var boxWidth = strWidth + 10;

    //박스 그리기
    context.fillStyle = 'rgb(90, 90, 90)';
    context.roundRect(x-boxWidth/2, y-9-14, x+boxWidth/2, y-8, 2);
    context.fill();

    context.beginPath();
    context.moveTo(x, y-3);
    context.lineTo(x+3, y-8);
    context.lineTo(x-3, y-8);
    context.closePath();
    context.fill();

    //text
    context.fillStyle = 'rgb(255, 255, 255)';
    context.textAlign = 'center';
    context.textBaseline = "middle";
    context.fillText(value, x, y-15);
}

// xview 변경이력 말풍선 그리기
function renderDeployDataArea(context,value,  x, y, options) {
    context.font = "bold 11px Arial";
    var strWidth = context.measureText(value).width;
    var boxWidth = strWidth + 8;

    //박스 그리기
    context.fillStyle = options.background;

    var x1 = x-boxWidth/2;
    var y1 = y - 14 - 9;
    var x2 = x+boxWidth/2;
    var y2 = y - 8;

    context.roundRectTooltip(x1, y1, x2, y2, 2, 100 /* is full */, 'top');
    context.fill();

    return { x1 : x1, y1 : y1, x2 : x2, y2: y2 };
}

// xview 변경이력 말풍선 그리기
function renderDeployDataText(context, value, x, y, options) {
    context.font = "bold 11px Arial";
    var strWidth = context.measureText(value).width;
    var boxWidth = strWidth + 8;

    //박스 그리기
    context.fillStyle = options.background;

    var x1 = x-boxWidth/2;
    var y1 = y - 14 - 9;
    var x2 = x+boxWidth/2;
    var y2 = y - 8;

    context.roundRectTooltip(x1, y1, x2, y2, 2, 100 /* is full */, 'top');
    context.fill();

    //text
    context.fillStyle = options.color;
    context.textAlign = 'center';
    context.textBaseline = "middle";
    context.fillText(value, x, y-15);

    return { x1 : x1, y1 : y1, x2 : x2, y2: y2 };
}

// xview 변경이력 말풍선 그리기
function renderDeployDataTooltip(context, value, x, y) {
    context.font = "bold 11px Arial";
    var strWidth = context.measureText(value).width;
    var boxWidth = strWidth + 10;

    //박스 그리기
    context.fillStyle = 'rgb(90, 90, 90)';
    context.roundRectTooltip(x-boxWidth/2, y-9-14, x+boxWidth/2, y-4, 2, 4, 'top');
    context.fill();

    context.beginPath();
    context.moveTo(x, y-3);
    context.lineTo(x+3, y-8);
    context.lineTo(x-3, y-8);
    context.closePath();
    context.fill();

    //text
    context.fillStyle = 'rgb(255, 255, 255)';
    context.textAlign = 'center';
    context.textBaseline = "middle";
    context.fillText(value, x, y - 15);
}


//RuntimeLineChart에서 maxValue를 표시
//text만 뿌린다.
function renderPointText(context, value, x, y, pointColor, alpha) {
    if(pointColor instanceof Color){
        var fillColor = pointColor.copy();
        if(!!alpha) fillColor.setAlpha(alpha);
    }else{
        var fillColor = Color.create(pointColor);
    }

    var textColor = new Color(0, 0, 0);
    if(!!alpha) textColor.setAlpha(alpha);

    context.beginPath();
    context.fillStyle = fillColor.toString();
    context.strokeStyle = "rgb(255, 255, 255)";
    context.arc(x, y, 4, 0, Math.PI * 2, false);
    context.closePath();
    context.stroke();
    context.fill();

    //text
    context.fillStyle = textColor.toString();
    context.font = "bold 11px Arial";
    context.textBaseline = "middle";
    context.textAlign = 'center';

    context.fillText(value, x, y-11);
}

function renderAxisTime(context, time, x, valueY, bottomY, axisColor, fontColor){
    if(typeof(fontColor) == "undefined") {
        fontColor = axisColor;
    }

    context.fillStyle = fontColor;
    context.textBaseline = "middle";
    context.textAlign = 'center';
    context.font = "10px Arial";
    context.fillText(time, x, valueY);

    context.strokeStyle = axisColor;
    context.lineWidth = 1;
    context.beginPath();
    context.moveTo(x, valueY+10);
    context.lineTo(x, bottomY);
    context.stroke();

    context.fillStyle = axisColor;
    context.lineWidth = 1;
    context.beginPath();
    context.moveTo(x, valueY+10);
    context.lineTo(x-4, valueY+6);
    context.lineTo(x+4, valueY+6);
    context.closePath();
    context.fill();
}

//상단만 둥근바
//http://stackoverflow.com/questions/1255512/how-to-draw-a-rounded-rectangle-on-html-canvas
CanvasRenderingContext2D.prototype.roundBar = function(sx,sy,ex,ey,r) {
    var r2d = Math.PI/180;
    if(sx > ex) ex = sx;
    if(sy > ey) ey = sy;
    if( ( ex - sx ) - ( 2 * r ) < 0 ) { r = ( ( ex - sx ) / 2 ); } //ensure that the radius isn't too large for x
    if( ( ey - sy ) - ( 2 * r ) < 0 ) { r = ( ( ey - sy ) / 2 ); } //ensure that the radius isn't too large for y
    this.beginPath();
    this.moveTo(sx+r,sy);
    this.lineTo(ex-r,sy);
    this.arc(ex-r,sy+r,r,r2d*270,r2d*360,false);
    this.lineTo(ex,ey);
    this.lineTo(sx,ey);
    this.lineTo(sx,sy+r);
    this.arc(sx+r,sy+r,r,r2d*180,r2d*270,false);
    this.closePath();
};

//http://stackoverflow.com/questions/1255512/how-to-draw-a-rounded-rectangle-on-html-canvas
CanvasRenderingContext2D.prototype.roundRect = function(sx,sy,ex,ey,r) {
    var r2d = Math.PI/180;
    if( ( ex - sx ) - ( 2 * r ) < 0 ) { r = ( ( ex - sx ) / 2 ); } //ensure that the radius isn't too large for x
    if( ( ey - sy ) - ( 2 * r ) < 0 ) { r = ( ( ey - sy ) / 2 ); } //ensure that the radius isn't too large for y
    this.beginPath();
    this.moveTo(sx+r,sy);
    this.lineTo(ex-r,sy);
    this.arc(ex-r,sy+r,r,r2d*270,r2d*360,false);
    this.lineTo(ex,ey-r);
    this.arc(ex-r,ey-r,r,r2d*0,r2d*90,false);
    this.lineTo(sx+r,ey);
    this.arc(sx+r,ey-r,r,r2d*90,r2d*180,false);
    this.lineTo(sx,sy+r);
    this.arc(sx+r,sy+r,r,r2d*180,r2d*270,false);
    this.closePath();
};

// 왼쪽만 색칠함.
CanvasRenderingContext2D.prototype.roundRectLeft = function(sx,sy,ex,ey,r) {
    var r2d = Math.PI/180;
    if( ( ex - sx ) - ( 2 * r ) < 0 ) { r = ( ( ex - sx ) / 2 ); } //ensure that the radius isn't too large for x
    if( ( ey - sy ) - ( 2 * r ) < 0 ) { r = ( ( ey - sy ) / 2 ); } //ensure that the radius isn't too large for y
    this.beginPath();
    this.moveTo(sx+r,sy);
    this.lineTo(ex,sy);
    this.lineTo(ex,ey);
    this.lineTo(sx+r,ey);
    this.arc(sx+r,ey-r,r,r2d*90,r2d*180,false);
    this.lineTo(sx,sy+r);
    this.arc(sx+r,sy+r,r,r2d*180,r2d*270,false);
    this.closePath();
};

//http://stackoverflow.com/questions/1255512/how-to-draw-a-rounded-rectangle-on-html-canvas
CanvasRenderingContext2D.prototype.roundRectTooltip = function(sx, sy, ex, ey, r, arrowWidth, direction) {
    direction = direction || "top";
    arrowWidth = arrowWidth || 4;
    var r2d = Math.PI/180;
    if( ( ex - sx ) - ( 2 * r ) < 0 ) { r = ( ( ex - sx ) / 2 ); } //ensure that the radius isn't too large for x
    if( ( ey - sy ) - ( 2 * r ) < 0 ) { r = ( ( ey - sy ) / 2 ); } //ensure that the radius isn't too large for y


    if (Math.abs(sx - ex) < arrowWidth * 2) {
        arrowWidth = (Math.abs(sx - ex) - 2*r) / 2;
    }

    var centerX = sx + Math.abs(sx - ex)/2;

    this.beginPath();
    this.moveTo(sx+r,sy);

    if (direction == 'bottom') {
        this.lineTo(centerX-arrowWidth, sy);
        this.lineTo(centerX, sy - arrowWidth);
        this.lineTo(centerX+arrowWidth, sy);
    }

    this.lineTo(ex-r,sy);
    this.arc(ex-r,sy+r,r,r2d*270,r2d*360,false);
    this.lineTo(ex,ey-r);
    this.arc(ex-r,ey-r,r,r2d*0,r2d*90,false);

    if (direction == 'top') {
        this.lineTo(centerX+arrowWidth, ey);
        this.lineTo(centerX, ey + arrowWidth);
        this.lineTo(centerX-arrowWidth, ey);
    }
    this.lineTo(sx+r,ey);

    this.arc(sx+r,ey-r,r,r2d*90,r2d*180,false);
    this.lineTo(sx,sy+r);
    this.arc(sx+r,sy+r,r,r2d*180,r2d*270,false);
    this.closePath();
};

//http://stackoverflow.com/questions/1255512/how-to-draw-a-rounded-rectangle-on-html-canvas
CanvasRenderingContext2D.prototype.roundBalloon = function(sx,sy,ex,ey,r,py) {
    var r2d = Math.PI/180;
    if( ( ex - sx ) - ( 2 * r ) < 0 ) { r = ( ( ex - sx ) / 2 ); } //ensure that the radius isn't too large for x
    if( ( ey - sy ) - ( 2 * r ) < 0 ) { r = ( ( ey - sy ) / 2 ); } //ensure that the radius isn't too large for y
    this.beginPath();
    this.moveTo(sx+r,sy);
    this.lineTo(ex-r,sy);
    this.arc(ex-r,sy+r,r,r2d*270,r2d*360,false);
    this.lineTo(ex,ey-r);
    this.arc(ex-r,ey-r,r,r2d*0,r2d*90,false);

    //꼭지점
    this.lineTo((sx+ex)*0.5+(py-ey)*0.5, ey);
    this.lineTo((sx+ex)*0.5, py);
    this.lineTo((sx+ex)*0.5-(py-ey)*0.5, ey);

    this.lineTo(sx+r,ey);
    this.arc(sx+r,ey-r,r,r2d*90,r2d*180,false);
    this.lineTo(sx,sy+r);
    this.arc(sx+r,sy+r,r,r2d*180,r2d*270,false);
    this.closePath();
};

//http://stackoverflow.com/questions/1255512/how-to-draw-a-rounded-rectangle-on-html-canvas
CanvasRenderingContext2D.prototype.roundRectDetail = function(sx,sy,ex,ey,ltr,rtr,rbr,lbr) {
    var r2d = Math.PI/180;
    this.beginPath();
    this.moveTo(sx+ltr,sy);
    this.lineTo(ex-rtr,sy);
    this.arc(ex-rtr,sy+rtr,rtr,r2d*270,r2d*360,false);
    this.lineTo(ex,ey-rbr);
    this.arc(ex-rbr,ey-rbr,rbr,r2d*0,r2d*90,false);
    this.lineTo(sx+lbr,ey);
    this.arc(sx+lbr,ey-lbr,lbr,r2d*90,r2d*180,false);
    this.lineTo(sx,sy+ltr);
    this.arc(sx+ltr,sy+ltr,ltr,r2d*180,r2d*270,false);
    this.closePath();
};

/**
 * CanvasGraphicsUtil.js
 * !!종료!!
 */



/**
 * 실제 서버단 Def 클래스와 이름이 다르기 때문에 차후에 제거해야함
 *
 * @author alvin
 */

var CMD = MxDef;
var PType = PTypeDef;
var OType = OTypeDef;
var OIDGroup = OIDGroupDef;
var OIDs = OIDDef;

/**
 * String 객체 프로퍼티 정의 시작 !!
 * */

/*
 * StringBuffer Class
 */
function StringBuffer() {
    this.buffer = [];
}

StringBuffer.prototype.append = function(string) {
    this.buffer.push(string);
    return this;
};

StringBuffer.prototype.clear = function() {
    this.buffer = [];

    return this;
};

StringBuffer.prototype.toString = function() {
    return this.buffer.join('');
};

StringBuffer.prototype.size = function() {
    return this.buffer.length;
};

String.prototype.toLocaleForAries = function() {
    return Number(this).toLocaleForAries();
};

// TODO: 차후 제거해야함. 혹시모를 호환성을 위해 남겨둠.
String.prototype.toLocaleForJennifer = function() {
    return this.toLocaleForAries();
};

String.format = function (format, value) {
//	if(".0f" == format) {
//		return value.toFixed(0);
//	} else if(".1f" == format) {
//		return value.toFixed(1);
//	} else if(".2f" == format) {
//		return value.toFixed(2);
//	} else {
//		return value;
//	}
    return value;
}

String.prototype.format = function (format, value) {
    return String.format(format, value);
}

/**
 * Number 객체 프로퍼티 정의 시작 !!
 * */

Number.prototype.format = function(){
    if(this==0) return 0;

    var reg = /(^[+-]?\d+)(\d{3})/;
    var n = (this + '');

    while (reg.test(n)) n = n.replace(reg, '$1' + ',' + '$2');

    return n;
};

/**
 * IpUtil.java 와 동일한 룰이어야 한다.
 * @param ip
 * @param ipType
 * @returns {*}
 */
Number.generateIP = function (ip, ipType) {
    if (!ip) return null;

    if (ipType == 'v4') {
        var arr = [0, 0, 0, 0];

        arr[0] = (ip & (0xff << 24)) >>> 24;
        arr[1] = (ip & (0xff << 16)) >>> 16;
        arr[2] = (ip & (0xff << 8)) >>> 8;
        arr[3] = (ip & (0xff)) ;

        return arr.join(".");
    } else if (ipType == 'v6') {
        /*
        //과거 버젼에서 사용했던 방법..
        var temp = [];
        for(var i = 0, len = ip.length; i < len; i++) {
            temp[i] = ('0000' + ip[i].toString(16)).substr(-4);
        }

        return temp.join(":");
        */

        var text = "";
        var startPos = -1;
        var endPos = -1;

        var digit = ip[0];
        for(var i = 0, len = ip.length; i < len; i++) {
            text = text + ip[i].toString(16) + ":";
            var nextDigit = 1;
            if(i < ip.length - 1) {
                nextDigit = ip[i+1];

                if(digit == 0 && nextDigit == 0) {
                    if (startPos == -1)
                    {
                        startPos = Math.max(0, text.length - 3);
                    }
                    endPos = text.length + 2;
                }
            }

            digit = nextDigit;
        }

        if (startPos != -1 && endPos != -1)
        {
            var hi = text.substring(0, startPos);
            var lo = text.substring(endPos);
            if (lo.length == 0)
            {
                return hi + "::";
            }
            text = hi + "::" + lo;
        }

        return text.substring(0, text.length - 1);
    }

    return null;
}

Number.parseIp = function (ip, ipType) {
    var arr = [0, 0, 0, 0];

    arr[0] = (ip & (0xff << 24)) >>> 24;
    arr[1] = (ip & (0xff << 16)) >>> 16;
    arr[2] = (ip & (0xff << 8)) >>> 8;
    arr[3] = (ip & (0xff)) ;

    return arr.join(".");
}

Number.parseLong = function (str) {
    var high = str.substr(0, str.length - 6);
    var low = str.substr(-6);

    return { h : parseFloat(high), l : (parseInt(low, 10) | 0) };
}

Number.toLongString = function (low, high) {
    return ((low < 0) ? '-0x' + (low * -1).toString(16)  : '0x' + low.toString(16)) + high.toString(16);
}

Number.prototype.toLocaleForAries = function() {
    // FIXME: IE 의 경우 프로파일링을 할 때  toLocaleString() 실행하는게 무한루프 도는거 같다. stack 공간 부족이라는 오류로 인해서 그냥 멈춘다.
    // FIXME: IE 의 경우 프로파일링을 할 때  toLocaleString()  주석처리하고 프로파일링을 하자.

    return this.toShortForAries().toLocaleString();
};

Number.prototype.toShortForAries = function() {
    //	if(this < 100) {
//		return this.toLocaleString(window.locale, {maximumFractionDigits: 2});
//	} else {
//		return parseInt(this).toLocaleString(window.locale);
//	}

    //ARIES-247
    //chrome 31버젼에서 locale넘겼을때 안되는 현상이 있었음
    //현재도 맥-사파리를 비롯한 테블릿에서 지원하지 않음.

    if(isNaN(this)) {
        return 0;
    }

    if(this < 100) {
        var value = parseInt(this * 100) / 100;
        return value;
    } else {
        return parseInt(this)
    }
}

// TODO: 차후 제거해야함. 혹시모를 호환성을 위해 남겨둠.
Number.prototype.toLocaleForJennifer = function() {
    return this.toLocaleForAries();
}
Number.prototype.toShortForJennifer = function() {
    return this.toShortForAries();
}

Number.prototype.fillZero = function(val) {
    return this.toString().fillZero(val);
};

Number.UNIT_STRING = ['', 'K', 'M', 'G'];

Number.prototype.toUnitString = function (base) {
    base = base || 1000;

    var originValue = this;
    var value = this;
    var len = base.toLocaleForAries().length;

    // 기본 숫자 가 base 보다 작으면 기존 로직 그대로 출력
    if (value < base) {
        return (Math.round(value * 100) / 100).toLocaleForAries();
    }

    originValue = value;
    value = Math.round(originValue) / base;

    // base 로 나눈 몫이 base 보다 작을 때
    if (value < base) {

        // base 랑 같은 등급이면 그대로 살려주자.
        if (originValue.toLocaleForAries().length == len) {
            return (Math.round(originValue * 100) / 100).toLocaleForAries();
        }

        return Math.round(value * 100) / 100 + Number.UNIT_STRING[1];
    }

    originValue = value;
    value = Math.round(originValue) / base;

    // base 로 나눈 몫이 base 보다 작을 때
    if (value < base) {

        // base 랑 같은 등급이면 그대로 살려주자.
        if (originValue.toLocaleForAries().length == len) {
            return (Math.round(originValue * 100) / 100).toLocaleForAries() + Number.UNIT_STRING[1];
        }

        return Math.round(value * 100) / 100 + Number.UNIT_STRING[2];
    }

    originValue = value;
    value = Math.round(originValue) / base;

    // base 로 나눈 몫이 base 보다 작을 때
    if (value < base) {

        // base 랑 같은 등급이면 그대로 살려주자.
        if (originValue.toLocaleForAries().length == len) {
            return (Math.round(originValue * 100) / 100).toLocaleForAries() + Number.UNIT_STRING[2];
        }

        return Math.round(value * 100) / 100 + Number.UNIT_STRING[3];
    }

    return originValue.toLocaleForAries();
}

/**
 * Number 객체 프로퍼티 정의 종료 !!
 * */

/**
 * Date 객체 프로퍼티 정의 시작 !!
 */
Date.getShortDateFormat = function() {
    var DATE_FORMAT_LIST = {"ar-SA":"DD/MM/YY","bg-BG":"DD.M.YYYY","ca-ES":"DD/MM/YYYY","zh-TW":"YYYY/M/D","cs-CZ":"D.M.YYYY","da-DK":"DD-MM-YYYY","de-DE":"DD.MM.YYYY","el-GR":"D/M/YYYY","en-US":"M/D/YYYY","fi-FI":"D.M.YYYY","fr-FR":"DD/MM/YYYY",
        "he-IL":"DD/MM/YYYY","hu-HU":"YYYY. MM. DD.","is-IS":"D.M.YYYY","it-IT":"DD/MM/YYYY","ja-JP":"YYYY/MM/DD","ko-KR":"YYYY-MM-DD","nl-NL":"d-M-YYYY","nb-NO":"DD.MM.YYYY","pl-PL":"YYYY-MM-DD","pt-BR":"D/M/YYYY","ro-RO":"DD.MM.YYYY","ru-RU":"DD.MM.YYYY",
        "hr-HR":"D.M.YYYY","sk-SK":"D. M. YYYY","sq-AL":"YYYY-MM-DD","sv-SE":"YYYY-MM-DD","th-TH":"D/M/YYYY","tr-TR":"DD.MM.YYYY","ur-PK":"DD/MM/YYYY","id-ID":"DD/MM/YYYY","uk-UA":"DD.MM.YYYY","be-BY":"DD.MM.YYYY","sl-SI":"D.M.YYYY","et-EE":"D.MM.YYYY",
        "lv-LV":"YYYY.MM.DD.","lt-LT":"YYYY.MM.DD","fa-IR":"MM/DD/YYYY","vi-VN":"DD/MM/YYYY","hy-AM":"DD.MM.YYYY","az-Latn-AZ":"DD.MM.YYYY","eu-ES":"YYYY/MM/DD","mk-MK":"DD.MM.YYYY","af-ZA":"YYYY/MM/DD","ka-GE":"DD.MM.YYYY","fo-FO":"DD-MM-YYYY","hi-IN":"DD-MM-YYYY",
        "ms-MY":"DD/MM/YYYY","kk-KZ":"DD.MM.YYYY","	ky-KG":"DD.MM.YY","sw-KE":"M/D/YYYY","uz-Latn-UZ":"DD/MM YYYY","tt-RU":"DD.MM.YYYY","pa-IN":"DD-MM-YY","gu-IN":"DD-MM-YY","ta-IN":"DD-MM-YYYY","te-IN":"DD-MM-YY","kn-IN":"DD-MM-YY","mr-IN":"DD-MM-YYYY","sa-IN":"DD-MM-YYYY",
        "mn-MN":"YY.MM.DD","gl-ES":"DD/MM/YY","kok-IN":"DD-MM-YYYY","syr-SY":"DD/MM/YYYY","dv-MV":"DD/MM/YY","ar-IQ":"DD/MM/YYYY","zh-CN":"YYYY/M/D","de-CH":"DD.MM.YYYY","en-GB":"DD/MM/YYYY","es-MX":"DD/MM/YYYY","fr-BE":"D/MM/YYYY","it-CH":"DD.MM.YYYY","nl-BE":"D/MM/YYYY",
        "nn-NO":"DD.MM.YYYY","pt-PT":"DD-MM-YYYY","sr-Latn-CS":"D.M.YYYY","sv-FI":"D.M.YYYY","az-Cyrl-AZ":"DD.MM.YYYY","ms-BN":"DD/MM/YYYY","uz-Cyrl-UZ":"DD.MM.YYYY","ar-EG":"DD/MM/YYYY","zh-HK":"D/M/YYYY","de-AT":"DD.MM.YYYY","en-AU":"D/MM/YYYY","es-ES":"DD/MM/YYYY",
        "fr-CA":"YYYY-MM-DD","sr-Cyrl-CS":"D.M.YYYY","ar-LY":"DD/MM/YYYY","zh-SG":"D/M/YYYY","de-LU":"DD.MM.YYYY","en-CA":"DD/MM/YYYY","es-GT":"DD/MM/YYYY","fr-CH":"DD.MM.YYYY","ar-DZ":"DD-MM-YYYY","zh-MO":"D/M/YYYY","de-LI":"DD.MM.YYYY","en-NZ":"D/MM/YYYY","es-CR":"DD/MM/YYYY",
        "fr-LU":"DD/MM/YYYY","ar-MA":"DD-MM-YYYY","en-IE":"DD/MM/YYYY","es-PA":"MM/DD/YYYY","fr-MC":"DD/MM/YYYY","ar-TN":"DD-MM-YYYY","en-ZA":"YYYY/MM/DD","es-DO":"DD/MM/YYYY","ar-OM":"DD/MM/YYYY","en-JM":"DD/MM/YYYY","es-VE":"DD/MM/YYYY","ar-YE":"DD/MM/YYYY","en-029":"MM/DD/YYYY",
        "es-CO":"DD/MM/YYYY","ar-SY":"DD/MM/YYYY","en-BZ":"DD/MM/YYYY","es-PE":"DD/MM/YYYY","ar-JO":"DD/MM/YYYY","en-TT":"DD/MM/YYYY","es-AR":"DD/MM/YYYY","ar-LB":"DD/MM/YYYY","en-ZW":"M/D/YYYY","es-EC":"DD/MM/YYYY","ar-KW":"DD/MM/YYYY","en-PH":"M/D/YYYY","es-CL":"DD-MM-YYYY",
        "ar-AE":"DD/MM/YYYY","es-UY":"DD/MM/YYYY","ar-BH":"DD/MM/YYYY","es-PY":"DD/MM/YYYY","ar-QA":"DD/MM/YYYY","es-BO":"DD/MM/YYYY","es-SV":"DD/MM/YYYY","es-HN":"DD/MM/YYYY","es-NI":"DD/MM/YYYY","es-PR":"DD/MM/YYYY","am-ET":"D/M/YYYY","tzm-Latn-DZ":"DD-MM-YYYY","iu-Latn-CA":"D/MM/YYYY",
        "sma-NO":"DD.MM.YYYY","mn-Mong-CN":"YYYY/M/D","gd-GB":"DD/MM/YYYY","en-MY":"D/M/YYYY","prs-AF":"DD/MM/YY","bn-BD":"DD-MM-YY","wo-SN":"DD/MM/YYYY","rw-RW":"M/D/YYYY","qut-GT":"DD/MM/YYYY","sah-RU":"MM.DD.	YYYY","gsw-FR":"DD/MM/YYYY","co-FR":"DD/MM/YYYY","oc-FR":"DD/MM/YYYY",
        "mi-NZ":"DD/MM/YYYY","ga-IE":"DD/MM/YYYY","se-SE":"YYYY-MM-DD","br-FR":"DD/MM/YYYY","smn-FI":"D.M.YYYY","moh-CA":"M/D/YYYY","arn-CL":"DD-MM-YYYY","ii-CN":"YYYY/M/D","dsb-DE":"D. M. YYYY","ig-NG":"D/M/YYYY","kl-GL":"DD-MM-YYYY","lb-LU":"DD/MM/YYYY","ba-RU":"DD.MM.YY",
        "nso-ZA":"YYYY/MM/DD","quz-BO":"DD/MM/YYYY","yo-NG":"D/M/YYYY","ha-Latn-NG":"D/M/YYYY","fil-PH":"M/D/YYYY","ps-AF":"DD/MM/YY","fy-NL":"d-M-YYYY","ne-NP":"M/D/YYYY","se-NO":"DD.MM.YYYY","iu-Cans-CA":"D/M/YYYY","sr-Latn-RS":"D.M.YYYY","si-LK":"YYYY-MM-DD","sr-Cyrl-RS":"D.M.YYYY",
        "lo-LA":"DD/MM/YYYY","km-KH":"YYYY-MM-DD","cy-GB":"DD/MM/YYYY","bo-CN":"YYYY/M/D","sms-FI":"D.M.YYYY","as-IN":"DD-MM-YYYY","ml-IN":"DD-MM-YY","en-IN":"DD-MM-YYYY","or-IN":"DD-MM-YY","bn-IN":"DD-MM-YY","tk-TM":"DD.MM.YY","bs-Latn-BA":"D.M.YYYY","mt-MT":"DD/MM/YYYY",
        "sr-Cyrl-ME":"D.M.YYYY","se-FI":"D.M.YYYY","zu-ZA":"YYYY/MM/DD","xh-ZA":"YYYY/MM/DD","tn-ZA":"YYYY/MM/DD","hsb-DE":"D. M. YYYY","bs-Cyrl-BA":"d	.M.YYYY","tg-Cyrl-TJ":"DD.MM.YY","sr-Latn-BA":"D.M.YYYY","smj-NO":"DD.MM.YYYY","rm-CH":"DD/MM/YYYY","smj-SE":"YYYY-MM-DD",
        "quz-EC":"DD/MM/YYYY","quz-PE":"DD/MM/YYYY","hr-BA":"D.M.YYYY.","sr-Latn-ME":"D.M.YYYY","sma-SE":"YYYY-MM-DD","en-SG":"D/M/YYYY","ug-CN":"YYYY-M-d","sr-Cyrl-BA":"D.M.YYYY","es-US":"M/D/YYYY", "ko": "YYYY-MM-DD"};

    var format = "MM/DD/YYYY";

    if(DATE_FORMAT_LIST.hasOwnProperty(window.server.locale)) {
        format = DATE_FORMAT_LIST[window.server.locale];
    }

    return format;
};

Date.getLongDateFormat = function() {
    return this.getShortDateFormat() + " HH:mm";
};

Date.getLongDateWithSecFormat = function() {
    return this.getLongDateFormat() + ":ss";
};

//var DATE_FORMAT_LIST = {"ar-SA":"dd/MM/yy","bg-BG":"dd.M.yyyy","ca-ES":"dd/MM/yyyy","zh-TW":"yyyy/M/d","cs-CZ":"d.M.yyyy","da-DK":"dd-MM-yyyy","de-DE":"dd.MM.yyyy","el-GR":"d/M/yyyy","en-US":"M/d/yyyy","fi-FI":"d.M.yyyy","fr-FR":"dd/MM/yyyy","he-IL":"dd/MM/yyyy","hu-HU":"yyyy. MM. dd.","is-IS":"d.M.yyyy","it-IT":"dd/MM/yyyy","ja-JP":"yyyy/MM/dd","ko-KR":"yyyy-MM-dd","nl-NL":"d-M-yyyy","nb-NO":"dd.MM.yyyy","pl-PL":"yyyy-MM-dd","pt-BR":"d/M/yyyy","ro-RO":"dd.MM.yyyy","ru-RU":"dd.MM.yyyy","hr-HR":"d.M.yyyy","sk-SK":"d. M. yyyy","sq-AL":"yyyy-MM-dd","sv-SE":"yyyy-MM-dd","th-TH":"d/M/yyyy","tr-TR":"dd.MM.yyyy","ur-PK":"dd/MM/yyyy","id-ID":"dd/MM/yyyy","uk-UA":"dd.MM.yyyy","be-BY":"dd.MM.yyyy","sl-SI":"d.M.yyyy","et-EE":"d.MM.yyyy","lv-LV":"yyyy.MM.dd.","lt-LT":"yyyy.MM.dd","fa-IR":"MM/dd/yyyy","vi-VN":"dd/MM/yyyy","hy-AM":"dd.MM.yyyy","az-Latn-AZ":"dd.MM.yyyy","eu-ES":"yyyy/MM/dd","mk-MK":"dd.MM.yyyy","af-ZA":"yyyy/MM/dd","ka-GE":"dd.MM.yyyy","fo-FO":"dd-MM-yyyy","hi-IN":"dd-MM-yyyy","ms-MY":"dd/MM/yyyy","kk-KZ":"dd.MM.yyyy","	ky-KG":"dd.MM.yy","sw-KE":"M/d/yyyy","uz-Latn-UZ":"dd/MM yyyy","tt-RU":"dd.MM.yyyy","pa-IN":"dd-MM-yy","gu-IN":"dd-MM-yy","ta-IN":"dd-MM-yyyy","te-IN":"dd-MM-yy","kn-IN":"dd-MM-yy","mr-IN":"dd-MM-yyyy","sa-IN":"dd-MM-yyyy","mn-MN":"yy.MM.dd","gl-ES":"dd/MM/yy","kok-IN":"dd-MM-yyyy","syr-SY":"dd/MM/yyyy","dv-MV":"dd/MM/yy","ar-IQ":"dd/MM/yyyy","zh-CN":"yyyy/M/d","de-CH":"dd.MM.yyyy","en-GB":"dd/MM/yyyy","es-MX":"dd/MM/yyyy","fr-BE":"d/MM/yyyy","it-CH":"dd.MM.yyyy","nl-BE":"d/MM/yyyy","nn-NO":"dd.MM.yyyy","pt-PT":"dd-MM-yyyy","sr-Latn-CS":"d.M.yyyy","sv-FI":"d.M.yyyy","az-Cyrl-AZ":"dd.MM.yyyy","ms-BN":"dd/MM/yyyy","uz-Cyrl-UZ":"dd.MM.yyyy","ar-EG":"dd/MM/yyyy","zh-HK":"d/M/yyyy","de-AT":"dd.MM.yyyy","en-AU":"d/MM/yyyy","es-ES":"dd/MM/yyyy","fr-CA":"yyyy-MM-dd","sr-Cyrl-CS":"d.M.yyyy","ar-LY":"dd/MM/yyyy","zh-SG":"d/M/yyyy","de-LU":"dd.MM.yyyy","en-CA":"dd/MM/yyyy","es-GT":"dd/MM/yyyy","fr-CH":"dd.MM.yyyy","ar-DZ":"dd-MM-yyyy","zh-MO":"d/M/yyyy","de-LI":"dd.MM.yyyy","en-NZ":"d/MM/yyyy","es-CR":"dd/MM/yyyy","fr-	LU":"dd/MM/yyyy","ar-MA":"dd-MM-yyyy","en-IE":"dd/MM/yyyy","es-PA":"MM/dd/yyyy","fr-MC":"dd/MM/yyyy","ar-TN":"dd-MM-yyyy","en-ZA":"yyyy/MM/dd","es-DO":"dd/MM/yyyy","ar-OM":"dd/MM/yyyy","en-JM":"dd/MM/yyyy","es-VE":"dd/MM/yyyy","ar-YE":"dd/MM/yyyy","en-029":"MM/dd/yyyy","es-CO":"dd/MM/yyyy","ar-SY":"dd/MM/yyyy","en-BZ":"dd/MM/yyyy","es-PE":"dd/MM/yyyy","ar-JO":"dd/MM/yyyy","en-TT":"dd/MM/yyyy","es-AR":"dd/MM/yyyy","ar-LB":"dd/MM/yyyy","en-ZW":"M/d/yyyy","es-EC":"dd/MM/yyyy","ar-KW":"dd/MM/yyyy","en-PH":"M/d/yyyy","es-CL":"dd-MM-yyyy","ar-AE":"dd/MM/yyyy","es-UY":"dd/MM/yyyy","ar-BH":"dd/MM/yyyy","es-PY":"dd/MM/yyyy","ar-QA":"dd/MM/yyyy","es-BO":"dd/MM/yyyy","es-SV":"dd/MM/yyyy","es-HN":"dd/MM/yyyy","es-NI":"dd/MM/yyyy","es-PR":"dd/MM/yyyy","am-ET":"d/M/yyyy","tzm-Latn-DZ":"dd-MM-yyyy","iu-Latn-CA":"d/MM/yyyy","sma-NO":"dd.MM.yyyy","mn-Mong-CN":"yyyy/M/d","gd-GB":"dd/MM/yyyy","en-MY":"d/M/yyyy","prs-AF":"dd/MM/yy","bn-BD":"dd-MM-yy","wo-SN":"dd/MM/yyyy","rw-RW":"M/d/yyyy","qut-GT":"dd/MM/yyyy","sah-RU":"MM.dd.	yyyy","gsw-FR":"dd/MM/yyyy","co-FR":"dd/MM/yyyy","oc-FR":"dd/MM/yyyy","mi-NZ":"dd/MM/yyyy","ga-IE":"dd/MM/yyyy","se-SE":"yyyy-MM-dd","br-FR":"dd/MM/yyyy","smn-FI":"d.M.yyyy","moh-CA":"M/d/yyyy","arn-CL":"dd-MM-yyyy","ii-CN":"yyyy/M/d","dsb-DE":"d. M. yyyy","ig-NG":"d/M/yyyy","kl-GL":"dd-MM-yyyy","lb-LU":"dd/MM/yyyy","ba-RU":"dd.MM.yy","nso-ZA":"yyyy/MM/dd","quz-BO":"dd/MM/yyyy","yo-NG":"d/M/yyyy","ha-Latn-NG":"d/M/yyyy","fil-PH":"M/d/yyyy","ps-AF":"dd/MM/yy","fy-NL":"d-M-yyyy","ne-NP":"M/d/yyyy","se-NO":"dd.MM.yyyy","iu-Cans-CA":"d/M/yyyy","sr-Latn-RS":"d.M.yyyy","si-LK":"yyyy-MM-dd","sr-Cyrl-RS":"d.M.yyyy","lo-LA":"dd/MM/yyyy","km-KH":"yyyy-MM-dd","cy-GB":"dd/MM/yyyy","bo-CN":"yyyy/M/d","sms-FI":"d.M.yyyy","as-IN":"dd-MM-yyyy","ml-IN":"dd-MM-yy","en-IN":"dd-MM-yyyy","or-IN":"dd-MM-yy","bn-IN":"dd-MM-yy","tk-TM":"dd.MM.yy","bs-Latn-BA":"d.M.yyyy","mt-MT":"dd/MM/yyyy","sr-Cyrl-ME":"d.M.yyyy","se-FI":"d.M.yyyy","zu-ZA":"yyyy/MM/dd","xh-ZA":"yyyy/MM/dd","tn-ZA":"yyyy/MM/dd","hsb-DE":"d. M. yyyy","bs-Cyrl-BA":"d	.M.yyyy","tg-Cyrl-TJ":"dd.MM.yy","sr-Latn-BA":"d.M.yyyy","smj-NO":"dd.MM.yyyy","rm-CH":"dd/MM/yyyy","smj-SE":"yyyy-MM-dd","quz-EC":"dd/MM/yyyy","quz-PE":"dd/MM/yyyy","hr-BA":"d.M.yyyy.","sr-Latn-ME":"d.M.yyyy","sma-SE":"yyyy-MM-dd","en-SG":"d/M/yyyy","ug-CN":"yyyy-M-d","sr-Cyrl-BA":"d.M.yyyy","es-US":"M/d/yyyy"};
Date.prototype.toLocaleDateShortString = function(){
    var format = Date.getShortDateFormat(), year = this.getFullYear(), month = this.getMonth()+1, day = this.getDate();

    function z(s){
        s=''+s;

        return s.length>1?s:'0'+s;
    }

    format = format.replace(/YYYY/ ,year);
    format = format.replace(/YY/,String(year).substr(2));
    format = format.replace(/MM/,z(month));
    format = format.replace(/M/, month);
    format = format.replace(/DD/,z(day));
    format = format.replace(/D/, day);

    return format;
};

Date.prototype.toLocaleDateLongString = function(){
    var format = Date.getLongDateFormat(), year = this.getFullYear(), month = this.getMonth()+1, day = this.getDate(),
        hour = this.getHours(), minute = this.getMinutes();

    function z(s){
        s=''+s;

        return s.length>1?s:'0'+s;
    }


    format = format.replace(/YYYY/ ,year);
    format = format.replace(/YY/,String(year).substr(2));
    format = format.replace(/MM/,z(month));
    format = format.replace(/M/, month);
    format = format.replace(/DD/,z(day));
    format = format.replace(/D/, day);
    format = format.replace(/HH/,z(hour));
    format = format.replace(/mm/,z(minute));

    return format;
};

Date.prototype.isToday = function() {
    var serverDate = new Date(getServerTime());

    if(this.getFullYear() == serverDate.getFullYear() && this.getMonth() == serverDate.getMonth() && this.getDate() == serverDate.getDate()) {
        return true;
    }

    return false;
};

Date.prototype.getServerTime = function() {
    return this.getTime() + (this.getTimezoneOffset()*-1 - window.server.minuteOffset) * 1000 * 60;
};

Date.prototype.format = function(f) {
    var d = this;

    return f.replace(/(yyyy|mmmm|mmm|mm|dddd|ddd|dd|hh|HH|nn|ss|a|A)/gi, function($1) {
        switch ($1) {
            case 'yyyy': return d.getFullYear();
            case 'mmmm': return gsMonthNames[d.getMonth()];
            case 'mmm': return gsMonthNames[d.getMonth()].substr(0, 3);
            case 'mm': return (d.getMonth() + 1).fillZero(2);
            case 'dddd': return gsDayNames[d.getDay()];
            case 'ddd': return gsDayNames[d.getDay()].substr(0, 3);
            case 'dd': return d.getDate().fillZero(2);
            case 'hh': return ((h = d.getHours() % 12) ? h : 12).fillZero(2);
            case 'HH': return d.getHours().fillZero(2);
            case 'nn': return d.getMinutes().fillZero(2);
            case 'ss': return d.getSeconds().fillZero(2);
            case 'a': return d.getHours() < 12 ? 'am' : 'pm';
            case 'A': return d.getHours() < 12 ? 'AM' : 'PM';
        }
    });
};

if(!Date.now) {
    Date.now = function () {
        return +(new Date);
    };
}

var BrowserSupport = {
    isEdge : navigator.userAgent.indexOf('Edge/') > 0
};