/*
 * Decompiled with CFR 0.152.
 */
package com.aries.extension.starter;

import com.aries.extension.data.PluginData;
import com.aries.extension.starter.PluginController;
import com.aries.extension.util.FileManager;
import com.aries.extension.util.I18nManager;
import com.aries.extension.util.ResourceUtil;
import com.aries.extension.view.MarkupView;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.StringWriter;
import java.util.Map;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader;
import org.springframework.stereotype.Service;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

@Service
public class PluginStarter
extends HandlerInterceptorAdapter {
    public static String DEFAULT_THEME;
    public static String DEFAULT_LANGUAGE;
    private static String DEFAULT_SUBJECT;
    private static String DEFAULT_FILE_PATH;
    private static PluginData META_DATA;

    public PluginStarter() {
        DEFAULT_THEME = System.getProperty("theme", "classic");
        DEFAULT_LANGUAGE = System.getProperty("language", "ko");
        DEFAULT_SUBJECT = "JENNIFER Labs (Independent Runtime Environment)";
        DEFAULT_FILE_PATH = "/";
        META_DATA = this.getMetadata();
    }

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) {
        if (META_DATA == null) {
            this.printErrorTemplate(response, "package.json does not exist or is invalid.");
            return false;
        }
        String mainUrl = META_DATA.getMainUrl();
        if (mainUrl != null) {
            if (!mainUrl.startsWith("/plugin")) {
                this.printErrorTemplate(response, "The 'mainUrl' property must begin with '/plugin'.");
                return false;
            }
            if (mainUrl.equals(request.getRequestURI())) {
                HandlerMethod method = (HandlerMethod)handler;
                if (method.getBeanType().getSuperclass() != PluginController.class) {
                    this.printErrorTemplate(response, "The class of the 'mainUrl' handler method must inherit from 'PluginController'.");
                    return false;
                }
                if (method.getMethod().getReturnType() != ModelAndView.class && META_DATA.getMainTpl() != null) {
                    this.printErrorTemplate(response, "The response type for the 'mainUrl' handler method is the ModelAndView class.");
                    return false;
                }
            }
        } else {
            this.printErrorTemplate(response, "The 'mainUrl' property is required.");
            return false;
        }
        return true;
    }

    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object handler, ModelAndView modelAndView) {
        if (!this.invalidHandle(request, response, handler, modelAndView)) {
            VelocityContext mainContext = new VelocityContext();
            mainContext.put("subject", DEFAULT_SUBJECT);
            mainContext.put("theme", DEFAULT_THEME);
            mainContext.put("language", DEFAULT_LANGUAGE);
            mainContext.put("title", META_DATA.getTitle());
            mainContext.put("description", META_DATA.getDescription());
            mainContext.put("layout", request.getParameter("layout"));
            mainContext.put("contents", this.getMainHtml((Map)modelAndView.getModelMap(), META_DATA));
            mainContext.put("outputCss", this.getMergedRootPaths(META_DATA.getOutputCss()));
            mainContext.put("outputJs", this.getMergedRootPaths(META_DATA.getOutputJs()));
            modelAndView.setView((View)new MarkupView(this.createTemplate(mainContext, "templates/plugin_index.vm")));
        }
    }

    public boolean invalidHandle(HttpServletRequest request, HttpServletResponse response, Object handler, ModelAndView modelAndView) {
        byte[] tpl;
        if (modelAndView == null) {
            return true;
        }
        if (META_DATA.getMainUrl() == null || META_DATA.getMainTpl() == null) {
            String key = META_DATA.getMainUrl() == null ? "mainUrl" : "mainTpl";
            VelocityContext context = new VelocityContext();
            context.put("message", "The '" + key + "' property is required.");
            modelAndView.setView((View)new MarkupView(this.createTemplate(context, "templates/plugin_error.vm")));
            return true;
        }
        String viewName = modelAndView.getViewName();
        if (viewName.endsWith(".vm")) {
            if (ResourceUtil.getBytes(null, viewName) != null) {
                META_DATA.setMainTpl(viewName);
            }
        } else if (META_DATA.getMainTpl() != null && (tpl = ResourceUtil.getBytes(null, META_DATA.getMainTpl())) == null) {
            VelocityContext context = new VelocityContext();
            context.put("message", "The path to the 'mainTpl' template file is invalid.");
            modelAndView.setView((View)new MarkupView(this.createTemplate(context, "templates/plugin_error.vm")));
            return true;
        }
        return false;
    }

    private String getMainHtml(Map map, PluginData metadata) {
        VelocityContext context = new VelocityContext();
        context.put("theme", DEFAULT_THEME);
        context.put("language", DEFAULT_LANGUAGE);
        context.put("i18n", new I18nManager(metadata, DEFAULT_LANGUAGE));
        context.put("file", new FileManager(DEFAULT_FILE_PATH));
        for (String key : map.keySet()) {
            context.put(key, map.get(key));
        }
        return this.createTemplate(context, metadata.getMainTpl());
    }

    private String createTemplate(VelocityContext context, String tpl) {
        VelocityEngine ve = new VelocityEngine();
        ve.setProperty("input.encoding", "UTF-8");
        ve.setProperty("file.resource.loader.class", ClasspathResourceLoader.class.getName());
        ve.init();
        Template t = ve.getTemplate(tpl);
        StringWriter writer = new StringWriter();
        t.merge(context, writer);
        return writer.toString();
    }

    private PluginData getMetadata() {
        PluginData plugin = new PluginData();
        String propStr = ResourceUtil.getTexts(null, "application.properties");
        if (propStr != null) {
            try {
                ByteArrayInputStream is = new ByteArrayInputStream(propStr.getBytes("UTF-8"));
                Properties prop = new Properties();
                prop.load(is);
                plugin.setMainUrl(prop.getProperty("aries.main.url", null));
                plugin.setMainTpl(prop.getProperty("aries.main.tpl", null));
                plugin.setOutputCss(prop.getProperty("aries.output.css", null));
                plugin.setOutputJs(prop.getProperty("aries.output.js", null));
                plugin.setTitle(prop.getProperty("aries.title", ""));
                plugin.setDescription(prop.getProperty("aries.description", ""));
                String pathI18n = prop.getProperty("aries.directory.i18n", null);
                if (pathI18n != null) {
                    byte[] dataZh;
                    byte[] dataJa;
                    byte[] dataEn;
                    byte[] dataKo = ResourceUtil.getBytes(null, pathI18n + "/message_ko.properties");
                    if (dataKo != null) {
                        plugin.addI18n("ko", dataKo);
                    }
                    if ((dataEn = ResourceUtil.getBytes(null, pathI18n + "/message_en.properties")) != null) {
                        plugin.addI18n("en", dataEn);
                    }
                    if ((dataJa = ResourceUtil.getBytes(null, pathI18n + "/message_ja.properties")) != null) {
                        plugin.addI18n("ja", dataJa);
                    }
                    if ((dataZh = ResourceUtil.getBytes(null, pathI18n + "/message_zh.properties")) != null) {
                        plugin.addI18n("zh", dataZh);
                    }
                }
                return plugin;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    private void printErrorTemplate(HttpServletResponse response, String message) {
        VelocityContext context = new VelocityContext();
        context.put("message", message);
        response.setContentType("text/html;charset=utf-8");
        MarkupView.setResponseData(response, this.createTemplate(context, "templates/plugin_error.vm"));
    }

    private String[] getMergedRootPaths(String[] paths) {
        if (paths != null) {
            String[] newPaths = new String[paths.length];
            for (int i = 0; i < paths.length; ++i) {
                newPaths[i] = DEFAULT_FILE_PATH + paths[i];
            }
            return newPaths;
        }
        return null;
    }
}

