/*
 * Decompiled with CFR 0.152.
 */
package com.aries.extension.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;

public class ResourceUtil {
    public static byte[] getBytes(String id, String path) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        InputStream stream = classLoader.getResourceAsStream(path);
        URL url = classLoader.getResource(path);
        if (url != null) {
            long size = url.getFile().length();
            if (size > Integer.MAX_VALUE) {
                return null;
            }
            byte[] buffer = new byte[(int)size];
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            try {
                int line;
                while ((line = stream.read(buffer)) != -1) {
                    os.write(buffer, 0, line);
                }
                stream.close();
                os.flush();
                os.close();
                return os.toByteArray();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public static String getTexts(String id, String path) {
        byte[] datas = ResourceUtil.getBytes(id, path);
        if (datas != null) {
            try {
                return new String(datas, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
        return null;
    }
}

