var BrowserSupport = {
    isEdge : navigator.userAgent.indexOf('Edge/') > 0
}




var Exporter = {


    /**
     * // 게시판 내보내기
     *
     * Exporter.board({
     *      title : '',
     *      description : ''
     * }, callback); 
     *
     * @param obj
     * @param callback
     */
    board: function (obj, callback) {
        var param = {
            title : obj.title || "",
            key : obj.key || "",
            description : obj.description || "",
            writeTime: obj.writeTime || 0,
            files : JSON.stringify(obj.files || [])
        };

        $.post('/report/board/save', param, function (data) {
            if (data.result == 'true') {
                var article = JSON.parse(data.article);

                if (typeof callback == 'function') {
                    callback(data.result, article);
                }
            } else {
                if (typeof callback == 'function') {
                    callback(data.result, {});
                }
            }
        });
    },

    // 게시판에 이미지 내보내기
    image : function (dataURL, obj, callback) {
        var imgTag = "<div><img src='"+dataURL+"' class='exporter' /></div>";
        this.board({
            title : obj.title,
            description : obj.description + " " + imgTag,
            key: obj.key,
            writeTime: obj.writeTime,
            files: obj.files
        }, callback);
    },

    // 캔버스 이미지를 게시판에 내보내기 (레티나디스플레이 적용)
    canvas : function (originCanvas, obj, callback) {
        if (originCanvas) {

            // 같은 크기의 canvas 로 옮겨서
            var captureCanvas = document.createElement('canvas');

            captureCanvas.width = originCanvas.width;
            captureCanvas.height = originCanvas.height;
            captureCanvas.style.width = originCanvas.style.width + 'px';
            captureCanvas.style.height = originCanvas.style.height + 'px';

            var captureContext = captureCanvas.getContext('2d');
            captureContext.fillStyle = CanvasChartStyle.export_background_color;
            captureContext.fillRect(0, 0, captureCanvas.width, captureCanvas.height);
            captureContext.drawImage(originCanvas, 0, 0);



            var dataURL = captureCanvas.toDataURL("image/png");
            var file = this.convertDataURLToBlob(dataURL, "image/png");

            // 파일 이름 지정

            file.fileName = obj.fileName;
            Exporter.upload(file, function (fileData) {

                fileData.width = obj.width;
                fileData.height = obj.height;

                obj.files = [fileData];
                Exporter.board(obj, callback);
            });

        }
    },

    convertDataURLToBlob : function (dataurl, mimetype) {
        var png = dataurl.split(',')[1];

        var binary = window.atob(png);
        var byteStringLength = binary.length,
            arrayBuffer = new ArrayBuffer(byteStringLength),
            intArray = new Uint8Array(arrayBuffer);

        for (var i = 0; i < byteStringLength; i++) {
            intArray[i] = binary.charCodeAt(i);
        }

        return new Blob([intArray],  {type: mimetype || 'image/png', encoding: 'utf-8'});
    },

    // 작은 텍스트 보내기
    text : function (title, description, callback) {
      Exporter.board({
          title: title,
          description: description
      }, callback);
    },

    // 아주 큰 텍스트 보내기 ,
    // 이때는 텍스트를 파일을 업로드 형태로 구성한다.
    largeText : function (data, obj, callback) {
        var file = Exporter.toHTML(data);
        file.fileName = obj.fileName;
        Exporter.upload(file, function (fileData) {
            obj.files = [fileData];
            Exporter.board(obj, callback);
        })
    },

    // blob 파일 만들기
    toBlob: function (data, type) {
        return new Blob([data], { type : type || 'text/plain' });
    },

    toHTML : function (data) {
        return Exporter.toBlob(data, 'text/html');
    },

    // 들어온 파일을 업로드한다.
    upload : function (file, callback, file_progress) {
        var formData = new FormData();
        formData.append("file", file, file.fileName);

        $.ajax({
            url: "/report/board/upload",
            type: "POST",
            data: formData,
            processData: false,
            contentType: false,
            dataType:"JSON",
            xhr: function() {
                var myXhr = $.ajaxSettings.xhr();
                if (file_progress) {
                    if(myXhr.upload){
                        myXhr.upload.addEventListener('progress',function (event) {
                            file_progress(event.loaded/event.total);
                        }, false);
                    }
                }

                return myXhr;
            },
            success: function (data) {
                if (typeof callback == 'function') {
                    callback(data);
                }
            },
            resetForm: true
        });
    }


}
window.requestAniFrame = (function () {
    return window.requestAnimationFrame ||
            window.webkitRequestAnimationFrame ||
            window.mozRequestAnimationFrame ||
            window.oRequestAnimationFrame ||
            function (callback) {
                return window.setTimeout(callback, 1000 / 60); // shoot for 60 fps
            };
})();
window.cancelAniFrame = (function () {
    return window.cancelAnimationFrame ||
            window.webkitCancelAnimationFrame ||
            window.mozCancelAnimationFrame ||
            window.oCancelAnimationFrame ||
            function (id) {
                window.clearTimeout(id);
            };
})();
window.BitSet = function(nbits) {
	this.ADDRESS_BITS_PER_UNIT = 5;
	
	//32
	this.BITS_PER_UNIT = 1 << this.ADDRESS_BITS_PER_UNIT;
	
	//31
	this.BIT_INDEX_MASK = this.BITS_PER_UNIT - 1;
	
	this.capacity_1 = nbits - 1;
    this.bits = new Array((this.unitIndex(nbits - 1) + 1));
    this.unitsInUse = 0;
    
};

BitSet.prototype = {

	bit :  function(i){
		return 1 << (i & this.BIT_INDEX_MASK);
	},
	
	mark : function(i){
		var unitIndex = this.unitIndex(i);
		var unitsRequired = unitIndex + 1;
		if (typeof this.bits[unitIndex] == 'undefined' ) {
			this.bits[unitIndex] = 0;
		}
		if (this.unitsInUse < unitsRequired) {
			this.bits[unitIndex] |= this.bit(i);
			this.unitsInUse = unitsRequired;
		} else {
			this.bits[unitIndex] |= this.bit(i);
		}
	},
	
	clear : function(){
		while (this.unitsInUse > 0)
			this.bits[--this.unitsInUse] = 0;
	},

	isMarked : function(i) {
		var b = false;
		var unitIndex = this.unitIndex(i);
		if (unitIndex < this.unitsInUse)
			b = ((this.bits[unitIndex] & this.bit(i)) != 0);

		return b;
	},
	
	unitIndex : function(i){
		return i >> this.ADDRESS_BITS_PER_UNIT;
	},
	
    toString : function() {
    	var output = new Array ();

        for (key in this) output.push (key + ' : ' + this[key]);

        return Console.log(output.join(','));
    }
};

var checkTableVar = /iPhone|iPod|iPad|Android/i.test(navigator.userAgent);

function checkTablet () {
	return /iPhone|iPod|iPad|Android/i.test(navigator.userAgent);
}

function enabledShadow() {
	
	if (checkTableVar) {
		return false; 
	}
	
	//TODO : instance 가 많을 때 shadow 는 canvas 성능저하를 가지고 옴.
	//return false;
	return true;
}

function shadowXY(context, offsetX, offsetY, blur, color) {
	if (!enabledShadow()) return ;
	context.shadowOffsetX = offsetX;
	context.shadowOffsetY = offsetY;
	context.shadowBlur = blur;
	context.shadowColor = color;
}

function shadowY(context, offsetY, blur, color) {
	if (!enabledShadow()) return ;	
	context.shadowOffsetY = offsetY;
	context.shadowBlur = blur;
	context.shadowColor = color;
}

function shadow(context, blur, color) {
	if (!enabledShadow()) return ;	
	context.shadowBlur = blur;
	context.shadowColor = color;
}

/*
var particle = new Image();
particle.src = "/image/chart/particle/speedhorizon-bubble.png";

var particleSize = 40;
var particleCenterX = 20;
*/

//하위의 메소드는 chart.core로 옮기는중.
//다 교체하였다면 하위 코드는 모두 삭제해야됨.
//버블 차트에서 사용
/*
function drawParticle(context, centerX, centerY, color, size, renderPercent){

	var key = (renderPercent * 1000)|0;

	var rows = 25;
	var cols = 40;

	if (key == 0) {
		var col = 0;
		var row = 0;
	} else {
		var col = (key - 1) % cols;
		var row = Math.ceil(key / cols) - 1;
	}

	context.drawImage(particle, col * particleSize, row * particleSize, particleSize, particleSize, centerX - 20, centerY - 20, 40, 40);
}

var particleCache = {};
function createParticle (context, w, h, centerX, centerY, color, size, renderPercent, halfCellSize) {
	var key = (renderPercent * 1000)|0;

	if (!particleCache[key]) {

		var x = w/2, y = h/2;
		var canvas = document.createElement('canvas');
		canvas.width = w;
		canvas.height = h;
		var cacheContext = canvas.getContext('2d');

		var colorAlpha = Color.create(color);
		colorAlpha.setAlpha(1-renderPercent);

		cacheContext.fillStyle = colorAlpha.toString();
		var renderSize = size * (1-renderPercent)
		cacheContext.beginPath();
		cacheContext.arc(x, y, renderSize, 0, ClientUtilities.PI2, true);
		cacheContext.closePath();
		cacheContext.fill();

		cacheContext.fillStyle = color;
		if(0.4 <= renderPercent){
			var renderSize = size * (1-0.4);
			var largeSize = renderSize / (size/2);
			var smallSize = renderSize / size;

			var particePercent = renderPercent - 0.4;

			var move=particePercent*size*4;
			var half_move = move / 2;

			var fullSize = renderSize+move;
			var fullLargeSize = largeSize+half_move;

			cacheContext.beginPath();
			cacheContext.arc(x, y+fullSize, largeSize, 0, ClientUtilities.PI2, true);
			cacheContext.fill();


			cacheContext.beginPath();
			cacheContext.arc(x, y-fullSize, largeSize, 0, ClientUtilities.PI2, true);
			cacheContext.fill();

			cacheContext.beginPath();
			cacheContext.arc(x+fullSize, y, largeSize, 0, ClientUtilities.PI2, true);
			cacheContext.fill();


			cacheContext.beginPath();
			cacheContext.arc(x-fullSize, y, largeSize, 0, ClientUtilities.PI2, true);
			cacheContext.fill();

			cacheContext.beginPath();
			cacheContext.arc(x+fullLargeSize, y+fullLargeSize, smallSize, 0, ClientUtilities.PI2, true);
			cacheContext.fill();


			cacheContext.beginPath();
			cacheContext.arc(x+fullLargeSize, y-fullLargeSize, smallSize, 0, ClientUtilities.PI2, true);
			cacheContext.fill();

			cacheContext.beginPath();
			cacheContext.arc(x-fullLargeSize, y-fullLargeSize, smallSize, 0, ClientUtilities.PI2, true);
			cacheContext.fill();

			cacheContext.beginPath();
			cacheContext.arc(x-fullLargeSize, y+fullLargeSize, smallSize, 0, ClientUtilities.PI2, true);
			cacheContext.fill();
		}

		particleCache[key] = canvas;
	}

	context.drawImage(particleCache[key], centerX - halfCellSize, centerY - halfCellSize);
}

function createParticleImage (width, height, renderSize) {
	renderSize = renderSize || 6;
	var col = 40;
	var row = 25;

	var cellSize = width/col;
	var halfCellSize = cellSize/2;

	var canvas = document.createElement('canvas');
	canvas.width = width;
	canvas.height = height;
	var cacheContext = canvas.getContext('2d');

	for(var i = 1; i <= 1000; i++) {

		var centerX = ((i-1) % col) * cellSize + halfCellSize ;
		var centerY = (Math.ceil(i / col) - 1)  * cellSize + halfCellSize;

		createParticle(cacheContext, cellSize, cellSize, centerX, centerY, "rgb(168, 217, 241)", renderSize, i*0.001, halfCellSize);
	}


	window.open(canvas.toDataURL("image/png"));
}
*/

function drawParticle(context, x, y, color, size, renderPercent){
	var colorAlpha = Color.create(color);
	colorAlpha.setAlpha(1-renderPercent);
    
	context.fillStyle = colorAlpha.toString();
	var renderSize = size * (1-renderPercent) 
	context.beginPath();
	context.arc(x, y, renderSize, 0, ClientUtilities.PI2, true);
	context.closePath();
	context.fill();
	
	context.fillStyle = color;
	if(0.4 <= renderPercent){
		var renderSize = size * (1-0.4); 
		var largeSize = renderSize / 3;
		var smallSize = renderSize / 6;

		var particePercent = renderPercent - 0.4;
		
		var move=particePercent*size*4;
		var half_move = move / 2; 
		
		var fullSize = renderSize+move;
		var fullLargeSize = largeSize+half_move;

		context.beginPath();
		context.arc(x, y+fullSize, largeSize, 0, ClientUtilities.PI2, true);
		context.fill();
		
		
		context.beginPath();
		context.arc(x, y-fullSize, largeSize, 0, ClientUtilities.PI2, true);
		context.fill(); 
		
		context.beginPath();
		context.arc(x+fullSize, y, largeSize, 0, ClientUtilities.PI2, true);
		context.fill();
		
		
		context.beginPath();
		context.arc(x-fullSize, y, largeSize, 0, ClientUtilities.PI2, true);
		context.fill(); 
		
		context.beginPath();
		context.arc(x+fullLargeSize, y+fullLargeSize, smallSize, 0, ClientUtilities.PI2, true);
		context.fill();

		
		context.beginPath();
		context.arc(x+fullLargeSize, y-fullLargeSize, smallSize, 0, ClientUtilities.PI2, true);
		context.fill();
		
		context.beginPath();
		context.arc(x-fullLargeSize, y-fullLargeSize, smallSize, 0, ClientUtilities.PI2, true);
		context.fill();
		
		context.beginPath();
		context.arc(x-fullLargeSize, y+fullLargeSize, smallSize, 0, ClientUtilities.PI2, true);
		context.fill();
	}
}

function drawParticle2(context, x, y, color, size, renderPercent){
	var colorAlpha = Color.create(color);
	colorAlpha.setAlpha(0.7-(renderPercent)*0.7);
    
	context.fillStyle = colorAlpha.toString();
	var renderSize = size * (1-renderPercent) 
	context.beginPath();
	context.arc(x, y, renderSize, 0, ClientUtilities.PI2, true);
	context.closePath();
	context.fill();
}




//value를 아래쪽에 표시함.
function drawValueBottom(context, value, x, y){
	context.font = ChartStyle.chart_value_font;
	var strWidth = context.measureText(value).width;
	var boxWidth = strWidth + 10;
	
	//박스 그리기
	context.fillStyle = 'rgb(90, 90, 90)';
	context.roundRect(x-boxWidth/2, y, x+boxWidth/2, y+14, 2);
	context.fill();
	
	context.beginPath();
	context.moveTo(x, y-5);
	context.lineTo(x+3, y);
	context.lineTo(x-3, y);
	context.closePath();
	context.fill();
	
	//text
	context.fillStyle = 'rgb(255, 255, 255)';
	context.textBaseline = "middle";
	context.textAlign = 'center';
	context.fillText(value, x, y+7);
}

function drawCloseButton(context, x, y) {
	var size = 10;
	
	context.beginPath();
	context.lineWidth = 2;
	context.strokeStyle = "#ffffff";
	var gradient = context.createLinearGradient(0, y-10, 0, y+10);
	gradient.addColorStop(0, "#a075d9");
	gradient.addColorStop(1, "#7c51b5");
	context.fillStyle = gradient;
	context.arc(x, y, size, 0, ClientUtilities.PI2, true);
	
	context.save();
	shadowXY(context, 2, 2, 2, "rgba(0, 0, 0, 0.25)");
	//context.shadowOffsetX = 2;
	//context.shadowOffsetY = 2;
	//context.shadowBlur = 2;
	//context.shadowColor = "rgba(0, 0, 0, 0.25)";
	context.fill();
	context.stroke();
	context.restore();
	
	context.lineWidth = 3;
	context.beginPath();
	context.moveTo(x-4, y+4);
	context.lineTo(x+4, y-4);
	context.moveTo(x+4, y+4);
	context.lineTo(x-4, y-4);
	context.stroke();
	
	context.beginPath();
	context.arc(x, y, size+3, 0, ClientUtilities.PI2, true);
	context.closePath();
}

//runtimelinechart에서 클릭한 라인의 맥스값 표시
//말풍선 안에 text렌더링
function renderSelectPointText(context, value, x, y, pointColor) {
	context.beginPath();
	context.fillStyle = pointColor;
	context.strokeStyle = 'rgb(255, 255, 255)';
	context.arc(x, y, 4, 0, ClientUtilities.PI2, false);
	context.closePath();
	context.stroke();
	context.fill();
	
	context.font = ChartStyle.chart_value_font;
	var strWidth = context.measureText(value).width;
	var boxWidth = strWidth + 10;
	
	//박스 그리기
	context.fillStyle = 'rgb(90, 90, 90)';
	context.roundRect(x-boxWidth/2, y-9-14, x+boxWidth/2, y-8, 2);
	context.fill();
	
	context.beginPath();
	context.moveTo(x, y-3);
	context.lineTo(x+3, y-8);
	context.lineTo(x-3, y-8);
	context.closePath();
	context.fill();
	
	//text
	context.fillStyle = 'rgb(255, 255, 255)';
	context.textAlign = 'center';
	context.textBaseline = "middle";
	context.fillText(value, x, y-15);
}

// xview 변경이력 말풍선 그리기
function renderDeployDataArea(context,value,  x, y, options) {
    context.font = ChartStyle.chart_value_font;
    var strWidth = context.measureText(value).width;
    var boxWidth = strWidth + 8;

    //박스 그리기
    context.fillStyle = options.background;

    var x1 = x-boxWidth/2;
    var y1 = y - 14 - 9;
    var x2 = x+boxWidth/2;
    var y2 = y - 8;

    context.roundRectTooltip(x1, y1, x2, y2, 2, 100 /* is full */, 'top');
    context.fill();

    return { x1 : x1, y1 : y1, x2 : x2, y2: y2 };
}

// xview 변경이력 말풍선 그리기
function renderDeployDataText(context, value, x, y, options) {
	context.font = ChartStyle.chart_value_font;
	var strWidth = context.measureText(value).width;
	var boxWidth = strWidth + 8;

	//박스 그리기
	context.fillStyle = options.background;

	var x1 = x-boxWidth/2;
	var y1 = y - 14 - 9;
	var x2 = x+boxWidth/2;
	var y2 = y - 8;

	context.roundRectTooltip(x1, y1, x2, y2, 2, 100 /* is full */, 'top');
	context.fill();

	//text
	context.fillStyle = options.color;
	context.textAlign = 'center';
	context.textBaseline = "middle";
	context.fillText(value, x, y-15);

	return { x1 : x1, y1 : y1, x2 : x2, y2: y2 };
}

// xview 변경이력 말풍선 그리기
function renderDeployDataTooltip(context, value, x, y) {
	context.font = ChartStyle.chart_value_font;
	var strWidth = context.measureText(value).width;
	var boxWidth = strWidth + 10;

	//박스 그리기
	context.fillStyle = 'rgb(90, 90, 90)';
	context.roundRectTooltip(x-boxWidth/2, y-9-14, x+boxWidth/2, y-4, 2, 4, 'top');
	context.fill();

	context.beginPath();
	context.moveTo(x, y-3);
	context.lineTo(x+3, y-8);
	context.lineTo(x-3, y-8);
	context.closePath();
	context.fill();

	//text
	context.fillStyle = 'rgb(255, 255, 255)';
	context.textAlign = 'center';
	context.textBaseline = "middle";
	context.fillText(value, x, y - 15);
}


//RuntimeLineChart에서 maxValue를 표시 
//text만 뿌린다.
function renderPointText(context, value, x, y, pointColor, alpha) {
	if(pointColor instanceof Color){
		var fillColor = pointColor.copy();
		if(!!alpha) fillColor.setAlpha(alpha);
	}else{
		var fillColor = Color.create(pointColor);
	}
	
	var textColor = new Color(0, 0, 0);
	if(!!alpha) textColor.setAlpha(alpha);
	
	context.beginPath();
	context.fillStyle = fillColor.toString();
	context.strokeStyle = "rgb(255, 255, 255)";
	context.arc(x, y, 4, 0, ClientUtilities.PI2, false);
	context.closePath();
	context.stroke();
	context.fill();
	
	//text
	context.fillStyle = textColor.toString();
	context.font = ChartStyle.chart_value_font;
	context.textBaseline = "middle";
	context.textAlign = 'center';
	
	context.fillText(value, x, y-11);
}

function renderAxisTime(context, time, x, valueY, bottomY, axisColor, fontColor){
	if(_.isUndefined(fontColor)) {
		fontColor = axisColor;
	}
	
	context.fillStyle = fontColor;
	context.textBaseline = "middle";
	context.textAlign = 'center';
	context.font = "10px Arial";
	context.fillText(time, x, valueY);
	
	context.strokeStyle = axisColor;
	context.lineWidth = 1;
	context.beginPath();
	context.moveTo(x, valueY+10);
	context.lineTo(x, bottomY);
	context.stroke();
	
	context.fillStyle = axisColor;
	context.lineWidth = 1;
	context.beginPath();
	context.moveTo(x, valueY+10);
	context.lineTo(x-4, valueY+6);
	context.lineTo(x+4, valueY+6);
	context.closePath();
	context.fill();
}

/**
 * Created by kimhakjin on 15. 12. 1..
 */
//레티나 지원을 위해 HighDPI를 지원
var DevicePixelRatioUtil = {

    isCanvasPointPath : function(context, mousePos, fixPixelRatio) {
        //if (!context.isPointInPath) return false;
        var pixelRatio = (fixPixelRatio)? fixPixelRatio : window.devicePixelRatio || 1;

        //canvas의 context가 이미 devicePixelRatio값으로 scale 되어있기 때문에 (aries.chart.core.js)
        //devicePixelRatio를 곱해서 체크한다.

        if(mousePos && context.isPointInPath(mousePos.x * pixelRatio, mousePos.y * pixelRatio)) {
            return true;
        }

        return false;
    },

    isCanvasPointStroke : function(context, mousePos, fixPixelRatio) {
        if (!context.isPointInStroke) return false;
        var pixelRatio = (fixPixelRatio)? fixPixelRatio : window.devicePixelRatio || 1;
        //canvas의 context가 이미 devicePixelRatio값으로 scale 되어있기 때문에 (aries.chart.core.js)
        //devicePixelRatio를 곱해서 체크한다.
        if(mousePos && context.isPointInStroke(mousePos.x * pixelRatio, mousePos.y * pixelRatio)) {
            return true;
        }

        return false;
    },

    getMousePosImageData : function(context, mousePos, fixPixelRatio){
        var pixelRatio = (fixPixelRatio)? fixPixelRatio : window.devicePixelRatio || 1;

        var imageData = context.getImageData(mousePos.x * pixelRatio, mousePos.y * pixelRatio, 1, 1).data;

        return imageData;
    }


};

/*
 * 차트를 그리기 위한 확장함수를 이곳에서 정의한다.
 */


//CanvasRenderingContext2D.setLineDash() 로 대체함.
//차트에서 배경으로  점선을 표현할때 사용한다.
/*
CanvasRenderingContext2D.prototype.dashedLine = function (fromX, fromY, toX, toY, pattern) {
	// Our growth rate for our line can be one of the following:
	//   (+,+), (+,-), (-,+), (-,-)
	// Because of this, our algorithm needs to understand if the x-coord and
	// y-coord should be getting smaller or larger and properly cap the values
	// based on (x,y).
	var lt = function (a, b) { return a <= b; };
	var gt = function (a, b) { return a >= b; };
	var capmin = function (a, b) { return Math.min(a, b); };
	var capmax = function (a, b) { return Math.max(a, b); };
	var checkX = { thereYet: gt, cap: capmin };
	var checkY = { thereYet: gt, cap: capmin };
	if (fromY - toY > 0) {
		checkY.thereYet = lt;
		checkY.cap = capmax;
	}
	
	if (fromX - toX > 0) {
		checkX.thereYet = lt;
		checkX.cap = capmax;
	}
	
	this.moveTo(fromX, fromY);
	
	var offsetX = fromX;
	var offsetY = fromY;
	var idx = 0, dash = true;
	while (!(checkX.thereYet(offsetX, toX) && checkY.thereYet(offsetY, toY))) {
		var ang = Math.atan2(toY - fromY, toX - fromX);
		var len = pattern[idx];
		offsetX = checkX.cap(toX, offsetX + (Math.cos(ang) * len));
		offsetY = checkY.cap(toY, offsetY + (Math.sin(ang) * len));
		if (dash) this.lineTo(offsetX, offsetY);
		else this.moveTo(offsetX, offsetY);
		idx = (idx + 1) % pattern.length;
		dash = !dash;
	}
};
*/

//상단만 둥근바
//http://stackoverflow.com/questions/1255512/how-to-draw-a-rounded-rectangle-on-html-canvas
CanvasRenderingContext2D.prototype.roundBar = function(sx,sy,ex,ey,r) {
	var r2d = Math.PI/180;
	if(sx > ex) ex = sx;
    if(sy > ey) ey = sy;
    if( ( ex - sx ) - ( 2 * r ) < 0 ) { r = ( ( ex - sx ) / 2 ); } //ensure that the radius isn't too large for x
    if( ( ey - sy ) - ( 2 * r ) < 0 ) { r = ( ( ey - sy ) / 2 ); } //ensure that the radius isn't too large for y
    this.beginPath();
    this.moveTo(sx+r,sy);
    this.lineTo(ex-r,sy);
    this.arc(ex-r,sy+r,r,r2d*270,r2d*360,false);
    this.lineTo(ex,ey);
    this.lineTo(sx,ey);
    this.lineTo(sx,sy+r);
    this.arc(sx+r,sy+r,r,r2d*180,r2d*270,false);
    this.closePath();
};

//http://stackoverflow.com/questions/1255512/how-to-draw-a-rounded-rectangle-on-html-canvas
CanvasRenderingContext2D.prototype.roundRect = function(sx,sy,ex,ey,r) {
    var r2d = Math.PI/180;
    if( ( ex - sx ) - ( 2 * r ) < 0 ) { r = ( ( ex - sx ) / 2 ); } //ensure that the radius isn't too large for x
    if( ( ey - sy ) - ( 2 * r ) < 0 ) { r = ( ( ey - sy ) / 2 ); } //ensure that the radius isn't too large for y
    this.beginPath();
    this.moveTo(sx+r,sy);
    this.lineTo(ex-r,sy);
    this.arc(ex-r,sy+r,r,r2d*270,r2d*360,false);
    this.lineTo(ex,ey-r);
    this.arc(ex-r,ey-r,r,r2d*0,r2d*90,false);
    this.lineTo(sx+r,ey);
    this.arc(sx+r,ey-r,r,r2d*90,r2d*180,false);
    this.lineTo(sx,sy+r);
    this.arc(sx+r,sy+r,r,r2d*180,r2d*270,false);
    this.closePath();
};

// 왼쪽만 색칠함.
CanvasRenderingContext2D.prototype.roundRectLeft = function(sx,sy,ex,ey,r) {
    var r2d = Math.PI/180;
    if( ( ex - sx ) - ( 2 * r ) < 0 ) { r = ( ( ex - sx ) / 2 ); } //ensure that the radius isn't too large for x
    if( ( ey - sy ) - ( 2 * r ) < 0 ) { r = ( ( ey - sy ) / 2 ); } //ensure that the radius isn't too large for y
    this.beginPath();
    this.moveTo(sx+r,sy);
    this.lineTo(ex,sy);
    this.lineTo(ex,ey);
    this.lineTo(sx+r,ey);
    this.arc(sx+r,ey-r,r,r2d*90,r2d*180,false);
    this.lineTo(sx,sy+r);
    this.arc(sx+r,sy+r,r,r2d*180,r2d*270,false);
    this.closePath();
};

//http://stackoverflow.com/questions/1255512/how-to-draw-a-rounded-rectangle-on-html-canvas
CanvasRenderingContext2D.prototype.roundRectTooltip = function(sx, sy, ex, ey, r, arrowWidth, direction) {
    direction = direction || "top";
    arrowWidth = arrowWidth || 4;
    var r2d = Math.PI/180;
    if( ( ex - sx ) - ( 2 * r ) < 0 ) { r = ( ( ex - sx ) / 2 ); } //ensure that the radius isn't too large for x
    if( ( ey - sy ) - ( 2 * r ) < 0 ) { r = ( ( ey - sy ) / 2 ); } //ensure that the radius isn't too large for y


    if (Math.abs(sx - ex) < arrowWidth * 2) {
        arrowWidth = (Math.abs(sx - ex) - 2*r) / 2;
    }

    var centerX = sx + Math.abs(sx - ex)/2;

    this.beginPath();
    this.moveTo(sx+r,sy);

    if (direction == 'bottom') {
        this.lineTo(centerX-arrowWidth, sy);
        this.lineTo(centerX, sy - arrowWidth);
        this.lineTo(centerX+arrowWidth, sy);
    }

    this.lineTo(ex-r,sy);
    this.arc(ex-r,sy+r,r,r2d*270,r2d*360,false);
    this.lineTo(ex,ey-r);
    this.arc(ex-r,ey-r,r,r2d*0,r2d*90,false);

    if (direction == 'top') {
        this.lineTo(centerX+arrowWidth, ey);
        this.lineTo(centerX, ey + arrowWidth);
        this.lineTo(centerX-arrowWidth, ey);
    }
    this.lineTo(sx+r,ey);

    this.arc(sx+r,ey-r,r,r2d*90,r2d*180,false);
    this.lineTo(sx,sy+r);
    this.arc(sx+r,sy+r,r,r2d*180,r2d*270,false);
    this.closePath();
};

//http://stackoverflow.com/questions/1255512/how-to-draw-a-rounded-rectangle-on-html-canvas
CanvasRenderingContext2D.prototype.roundBalloon = function(sx,sy,ex,ey,r,py) {
    var r2d = Math.PI/180;
    if( ( ex - sx ) - ( 2 * r ) < 0 ) { r = ( ( ex - sx ) / 2 ); } //ensure that the radius isn't too large for x
    if( ( ey - sy ) - ( 2 * r ) < 0 ) { r = ( ( ey - sy ) / 2 ); } //ensure that the radius isn't too large for y
    this.beginPath();
    this.moveTo(sx+r,sy);
    this.lineTo(ex-r,sy);
    this.arc(ex-r,sy+r,r,r2d*270,r2d*360,false);
    this.lineTo(ex,ey-r);
    this.arc(ex-r,ey-r,r,r2d*0,r2d*90,false);
    
    //꼭지점
    this.lineTo((sx+ex)*0.5+(py-ey)*0.5, ey);
    this.lineTo((sx+ex)*0.5, py);
    this.lineTo((sx+ex)*0.5-(py-ey)*0.5, ey);
    
    this.lineTo(sx+r,ey);
    this.arc(sx+r,ey-r,r,r2d*90,r2d*180,false);
    this.lineTo(sx,sy+r);
    this.arc(sx+r,sy+r,r,r2d*180,r2d*270,false);
    this.closePath();
};

//http://stackoverflow.com/questions/1255512/how-to-draw-a-rounded-rectangle-on-html-canvas
CanvasRenderingContext2D.prototype.roundRectDetail = function(sx,sy,ex,ey,ltr,rtr,rbr,lbr) {
    var r2d = Math.PI/180;
    this.beginPath();
    this.moveTo(sx+ltr,sy);
    this.lineTo(ex-rtr,sy);
    this.arc(ex-rtr,sy+rtr,rtr,r2d*270,r2d*360,false);
    this.lineTo(ex,ey-rbr);
    this.arc(ex-rbr,ey-rbr,rbr,r2d*0,r2d*90,false);
    this.lineTo(sx+lbr,ey);
    this.arc(sx+lbr,ey-lbr,lbr,r2d*90,r2d*180,false);
    this.lineTo(sx,sy+ltr);
    this.arc(sx+ltr,sy+ltr,ltr,r2d*180,r2d*270,false);
    this.closePath();
};


var ClientUtilities = {
	EMPTY_STRING : "", 
		
	DAILY_BAR_UNIT_COUNT : 40,
	
	ONE_SECOND : 1000,

	TWO_SECONDS : 1000 * 2,

	FIVE_SECONDS : 1000 * 5,

	TEN_SECONDS : 1000 * 10,

	ONE_MINUTE : 1000 * 60,

	FIVE_MINUTES : 1000 * 60 * 5,

	TEN_MINUTES : 1000 * 60 * 10,
	
	ONE_HOUR : 1000 * 60 * 60,
	
	FIVE_HOUR : 1000 * 60 * 60 * 5,
	
	ONE_DAY : 1000 * 60 * 60 * 24, // // ARIES-5081 썸머타임 문제해결시 체크해야함
	
	PI2 : Math.PI * 2,
	
	HALF_PI : Math.PI /2 ,
	
	MINUS_HALF_PI :  -(Math.PI /2) ,
	
	getMaxValue : function(maxValue) {
		if(maxValue === 0) {
			return 0;
		}
		
		var exponent; // exponent of range
		var fraction; // fractional part of range
		var niceFraction; // rounded fraction
		var tempMaxValue = maxValue * (100/98.5); //차트의 value는 축 maxValue의 98.5% 넘지 않는다. highChart 참고  

		var log10Range = Math.log(tempMaxValue) / Math.log(10);

		exponent = Math.floor(log10Range);
		fraction = tempMaxValue / Math.pow(10, exponent);

		niceFraction = Math.ceil(fraction);

		var returnValue = niceFraction * Math.pow(10, exponent);

		return parseInt(returnValue * 100) / 100;
	},
	
	getTimeLineUnitValue : function(maxValue) {
		var exponent; // exponent of range
		var fraction; // fractional part of range
		var niceFraction; // rounded fraction
		
		var unitValue = maxValue / 20;
		var log10Range = Math.log(unitValue) / Math.log(10);

		exponent = Math.floor(log10Range);
		
		fraction = unitValue / Math.pow(10, exponent);
		var niceFraction = Math.ceil(fraction*10)/10;

		var niceUnitValue = Math.pow(10, exponent) * niceFraction;
//		$.log("maxValue !! " + maxValue);
//		$.log("unitValue !! " + unitValue);
		
		//return parseInt(niceUnitValue);
		return niceUnitValue |0;
	},
	
	getProperValue : function(value, height){
		for(var i=-5; i<8; i++){
			var pow = Math.pow(10, i) ; 
			if(pow < value && value <= Math.pow(10, i+1)){
				//var fixValue = parseInt(value / Math.pow(10, i)) * Math.pow(10, i);
				var fixValue = ((value / pow) | 0) * pow;
				
				return fixValue;
			}
		}
		
		return 0;
	},
	
	getSplitUnit : function(maxValue, height) {
	    var numOfLine = height / 25;
		if (numOfLine < 1)
			numOfLine = 1;

		var result = maxValue / numOfLine;
		

		var exponent = Math.floor(Math.log(maxValue) / Math.log(10));
		var fraction = result / Math.pow(10, exponent);

		var niceFraction = Math.ceil(fraction);
		
		result = niceFraction * Math.pow(10, exponent);

		
		return result;
	},
	
	getTimeUnit : function(scale) {
		var result = scale;
		if (scale <= this.ONE_SECOND) {
			result = this.ONE_SECOND;
		} else if (scale <= this.ONE_SECOND * 2) {
			result = this.ONE_SECOND * 2;
		} else if (scale <= this.ONE_SECOND * 5) {
			result = this.ONE_SECOND * 5;
		} else if (scale <= this.ONE_SECOND * 10) {
			result = this.ONE_SECOND * 10;
		} else if (scale <= this.ONE_SECOND * 15) {
			result = this.ONE_SECOND * 15;
		} else if (scale <= this.ONE_SECOND * 30) {
			result = this.ONE_SECOND * 30;
		} else if (scale <= this.ONE_MINUTE) {
			result = this.ONE_MINUTE;
		} else if (scale <= this.ONE_MINUTE * 2) {
			result = this.ONE_MINUTE * 2;
		} else if (scale <= this.ONE_MINUTE * 5) {
			result = this.ONE_MINUTE * 5;
		} else if (scale <= this.ONE_MINUTE * 10) {
			result = this.ONE_MINUTE * 10;
		} else if (scale <= this.ONE_MINUTE * 15) {
			result = this.ONE_MINUTE * 15;
		} else if (scale <= this.ONE_MINUTE * 30) {
			result = this.ONE_MINUTE * 30;
		} else if (scale <= this.ONE_HOUR) {
			result = this.ONE_HOUR;
		} else if (scale <= this.ONE_HOUR * 2) {
			result = this.ONE_HOUR * 2;
		} else if (scale <= this.ONE_HOUR * 3) {
			result = this.ONE_HOUR * 3;
		} else if (scale <= this.ONE_HOUR * 4) {
			result = this.ONE_HOUR * 4;
		} else if (scale <= this.ONE_HOUR * 6) {
			result = this.ONE_HOUR * 6;
		} else if (scale <= this.ONE_HOUR * 12) {
			result = this.ONE_HOUR * 12;
		}
		return result;
	},

	getTimeHHmmssOrHHmm : function(timeStamp, needSec) {
		var hours = Math.floor(timeStamp/ClientUtilities.ONE_HOUR);

        var HH = ("0" + hours).slice(-2);
        var mm = ("0" + Math.floor((timeStamp%ClientUtilities.ONE_HOUR)/ClientUtilities.ONE_MINUTE)).slice(-2);
        var ss = ("0" + Math.floor((timeStamp%ClientUtilities.ONE_MINUTE)/ClientUtilities.ONE_SECOND)).slice(-2);

        //100시간이 넘을때는 3자리 이상이다.
        if(timeStamp/ClientUtilities.ONE_HOUR/100 >= 1) HH = Math.floor(timeStamp/ClientUtilities.ONE_HOUR/100) + HH;

        return (needSec)? HH+":"+mm+":"+ss : HH+":"+mm;
	}
	
};
/**
 * 실제 서버단 Def 클래스와 이름이 다르기 때문에 차후에 제거해야함
 * 
 * @author alvin
 */

var CMD = MxDef;
var PType = PTypeDef;
var OType = OTypeDef;
var OIDGroup = OIDGroupDef;
var OIDs = OIDDef;
if (typeof(Color) == 'undefined') Color = {};

function Color(r, g, b, a) {
	this.FACTOR = 0.7;
	
	this.alpha = a;
	this.alpha2 = a;
	if(!this.alpha) {
		this.alpha = 1;
	}
	
	if(!this.alpha2) {
		this.alpha2 = 255;
	}
	
	this.value = ((this.alpha & 0xFF) <<  24) | ((r & 0xFF) <<  16) | ((g & 0xFF) <<  8) | ((b & 0xFF) <<  0);
	this.value2 = (this.alpha2  <<  24) | (b <<  16) | (g <<  8) | (r);
	this.value3 = (b <<  24) | (this.alpha2 <<  16) | (r <<  8) | (g );
}

Color.create = function(color) {
	var result;
	
	if(color && color.indexOf("rgba") > -1) {
		var t = color.replace("rgba", "").replace("(", "").replace(")", "");
		var rgba = t.split(",");

		result = new Color(rgba[0],rgba[1],rgba[2],rgba[3]);
	} else if(color && color.indexOf("rgb") > -1) {
		var t = color.replace("rgb", "").replace("(", "").replace(")", "");
		var rgba = t.split(",");
		
		result = new Color(rgba[0],rgba[1],rgba[2]);
	} else if(color && color.indexOf("#") > -1) {
		
		var r = parseInt(color.substr(1, 2), 16);
		var g = parseInt(color.substr(3, 2), 16);
		var b = parseInt(color.substr(5, 2), 16);
		
		result = new Color(r, g, b);
	}
	
	try {
		return result;
	} finally {
		result = null;
	}
}

Color.prototype = {
    getRGB : function() {
        return this.value;	
    },
    
    getRGB2 : function() {
    	return this.value2;	
    },
    
    getRGB3 : function() {
    	return this.value3;	
    },
    
    
    getRGBA : function() {
		return this.value;
	},
	
    
	getRed : function() {
    	return (this.getRGB() >> 16) & 0xFF;
    },
    
    
    getGreen : function() {
    	return (this.getRGB() >> 8) & 0xFF;
    },
    
    
    getBlue : function() {
    	return (this.getRGB() >> 0) & 0xFF;
    },
    
    
    getAlpha : function() {
    	return this.alpha;
    },
    
    setAlpha : function(alpha) {
    	this.alpha = alpha;
    },
    
    copy : function(){
    	var copyColor = new Color(this.getRed(), this.getGreen(), this.getBlue());
    	return copyColor;
    },
    

    /**
     * http://en.wikipedia.org/wiki/HSL_color_space
     * Basic HSL(Hue, Saturation, Lightness)
     * more bright, more dark
     * 
     */
   
    toTranslationColor : function(saturation, lightness) {
    	//RGB to HSL
    	var r = this.getRed()/255;
    	var g = this.getGreen()/255;
    	var b = this.getBlue()/255;
    	
        var max = Math.max(r, g, b), min = Math.min(r, g, b);
        var h, s, l = (max + min) / 2;

        if(max == min){
            h = s = 0; // achromatic
        }else{
            var d = max - min;
            s = l > 0.5 ? d / (2 - max - min) : d / (max + min);
            switch(max){
                case r: h = (g - b) / d + (g < b ? 6 : 0); break;
                case g: h = (b - r) / d + 2; break;
                case b: h = (r - g) / d + 4; break;
            }
            h /= 6;
        }
        //complete RGB to HSL
        
        
        //trans color
        s += saturation;
        l += lightness;
        
        //HSL to RGB
        var q = l < 0.5 ? l * (1 + s) : l + s - l * s;
        var p = 2 * l - q;
        r = hue2rgb(p, q, h + 1/3);
        g = hue2rgb(p, q, h);
        b = hue2rgb(p, q, h - 1/3);
        
        //complete HSL to RGB
        
        return new Color(r,
                g,
                b);	
    },
    
    brighter : function() {
        var r = this.getRed();
        var g = this.getGreen();
        var b = this.getBlue();

        //var i = parseInt(1.0/(1.0-this.FACTOR));
        var i = (1.0/(1.0-this.FACTOR)) | 0;
        if (r == 0 && g == 0 && b == 0) {
           return new Color(i, i, i);
        }
        if (r > 0 && r < i) r = i;
        if (g > 0 && g < i) g = i;
        if (b > 0 && b < i) b = i;

        /*
        return new Color(Math.min(parseInt(r/this.FACTOR), 255),
                         Math.min(parseInt(g/this.FACTOR), 255),
                         Math.min(parseInt(b/this.FACTOR), 255)); */
        return new Color(Math.min((r/this.FACTOR)|0, 255),
        		Math.min((g/this.FACTOR)|0, 255),
        		Math.min((b/this.FACTOR)|0, 255));
    },
    
    darker : function() {
    	/*return new Color(Math.max(parseInt(this.getRed() * this.FACTOR), 0),
    			         Math.max(parseInt(this.getGreen() * this.FACTOR), 0),
    			         Math.max(parseInt(this.getBlue() * this.FACTOR), 0));*/
    	return new Color(Math.max((this.getRed() * this.FACTOR)|0, 0),
    			Math.max((this.getGreen() * this.FACTOR)|0, 0),
    			Math.max((this.getBlue() * this.FACTOR)|0, 0));
    },
    
    toString : function() {
    	return "rgba(" + this.getRed() + "," + this.getGreen() + "," + this.getBlue() + "," + this.getAlpha() + ")"; 
    },
    
    toStringNoAlpha : function() {
    	/*var red = parseInt(this.getAlpha() * this.getRed()); 
    	var green = parseInt(this.getAlpha() * this.getGreen());
    	var blue = parseInt(this.getAlpha() * this.getBlue());*/
    	var red = (this.getAlpha() * this.getRed())|0; 
    	var green = (this.getAlpha() * this.getGreen())|0;
    	var blue = (this.getAlpha() * this.getBlue())|0;
    	return "rgb(" + red + "," + green + "," + blue + ")";
    }
    
};

function hue2rgb(p, q, t){
    if(t < 0) t += 1;
    if(t > 1) t -= 1;
    if(t < 1/6) return p + (q - p) * 6 * t;
    if(t < 1/2) return q;
    if(t < 2/3) return p + (q - p) * (2/3 - t) * 6;
    return p;
}
//지울까???
jQuery.fn.debug = function() {
	return this.each(function() {
		if (!!window.console)
		    console.log(this);
	    else
		    alert(this);
	});
};

jQuery.log =  function(msg) {
	if (!!window.console) {
		//console.log(arguments.callee.caller); 
		console.log(msg); 
	} else {
		var css = 'border:3px solid #000; font-size:12px; z-index:999;',
		    debugWindow = document.getElementById('__debugWindow');
		if (!debugWindow) {
			var oDiv = document.createElement('div');
			oDiv.id = '__debugWindow';
			oDiv.style.cssText = css;

			debugWindow = document.body.appendChild(oDiv);
		}

		debugWindow.innerHTML += msg + '<br \/>';
	}
};

jQuery.debug =  function(msg) {
	if (!!window.console) {
		console.log(msg); 
	} else {
		var css = 'border:3px solid #000; font-size:12px; z-index:999;',
	        debugWindow = document.getElementById('__debugWindow');
		if (!debugWindow) {
			var oDiv = document.createElement('div');
			oDiv.id = '__debugWindow';
			oDiv.style.cssText = css;
			
			debugWindow = document.body.appendChild(oDiv);
		}
		
		debugWindow.innerHTML += msg + '<br \/>';
	}
};
var GenerateKey = {
		makeShortKeyByTime : function() {
			if(performance) {
				//performance.now()의 값은 페이지가 시작된 이후의 경과시간 값이다. 
				//따라서 이 값은 예전에 생성된 값과 중복될 위험이 있다. 
				return performance.now().toString(32);
			}
			
			return Date.now().toString(32);
		},
		
		makeLongKeyByTime : function() {
			var timestamp = Date.now();
			
			if(performance) {
				//nanoTime까지 더해 확실한 유니크 키를 생성
				var nonoValue = performance.now();
				timestamp += (nonoValue-parseInt(nonoValue));
			}
			
			return timestamp.toString(32);
		}
		
};
Map = function() {
	this.map = new Object();
};

Map.prototype = {
	put: function(key, value) {
		this.map[key] = value;
	},

	add: function(key, value) {
		this.map[key] = value;
		return this;
	},
	
	get: function(key) {
		return this.map[key];
	},
	
	containsKey: function(key) {
		return key in this.map;
	},
	
	containsValue: function(value) {
		for (var prop in this.map) {
			if (this.map[prop] == value) {
				return true;
			}
		}
		return false;
	},
	
	isEmpty: function(key) {
		return (this.size() == 0);
	},
	
	clear: function() {
		for (var prop in this.map) {
			delete this.map[prop];
		}
	},
	
	remove: function(key) {
		delete this.map[key];
	},
	
	keys: function() {
//		var keys = new Array();
//		for (var prop in this.map) {
//			keys.push(prop);
//		}
		return Object.keys(this.map);
	},
	
	values: function() {
		var values = new Array();
		for (var prop in this.map) {
			values.push(this.map[prop]);
		}
		return values;
	},

	size: function() {
		var count = 0;
		for (var prop in this.map) {
			count++;
		}
		return count;
	}
};
function LinkedList() {
    this._length = 0;
    this._head = null;
}

LinkedList.prototype = {
    add: function (data) {
        var node = {
                data: data,
                next: null
            },

            current;

        if (this._head === null) {
            this._head = node;
        } else {
            current = this._head;

            while(current.next) {
                current = current.next;
            }

            current.next = node;
        }

        this._length++;
    },
    
    remove: function(index) {
        if (index > -1 && index < this._length) {
            var current = this._head,
                previous,
                i = 0;

            if (index === 0) {
                this._head = current.next;
            } else {
                while(i++ < index){
                    previous = current;
                    current = current.next;
                }

                previous.next = current.next;
            }

            this._length--;

            return current.data;            
        } else {
            return null;
        }
    }
};
function LinkedQueue() {
    this._length = 0;
    this._head = null;
}

LinkedQueue.prototype = {
    add: function (data) {
        var node = {
                data: data,
                next: null
            },

            current;

        if (this._head === null) {
            this._head = node;
        } else {
            current = this._head;

            while(current.next) {
                current = current.next;
            }

            current.next = node;
        }

        this._length++;
    },
    
    item: function(index){
    	if(!this._head) {
    		return null;
    	}
    	
        if (index > -1 && index < this._length) {
            var current = this._head,
                i = 0;

            while(i++ < index) {
                current = current.next;
            }

            return current.data;
        } else {
            return null;
        }
    },
    
    poll: function () {
    	return this.remove(0);
    },
    
    remove: function(index) {
        if (index > -1 && index < this._length) {
            var current = this._head,
                previous,
                i = 0;

            if (index === 0) {
                this._head = current.next;
            } else {
                while(i++ < index) {
                    previous = current;
                    current = current.next;
                }

                previous.next = current.next;
            }

            this._length--;

            return current.data;            
        } else {
            return null;
        }
    },
    
    clear : function(){
    	this._length = 0;
        this._head = null;
    }
};

if (typeof TextDecoder == 'undefined') {
	DataView.prototype.getString = function(byteOffset, length){
		var strView = new Uint8Array(this.buffer, byteOffset, length);
		var encodedString =  String.fromCharCode.apply(null, strView);		//FIXME: 문자열변환 메모리 릭 발생, 일단은 다른 문자열로 대체함.
		return encodedString;
	};
} else {
	window.jenniferStringDecoder = new TextDecoder('utf-8');
	DataView.prototype.getString = function(byteOffset, length){
		var strView = new Uint8Array(this.buffer, byteOffset, length);
		return jenniferStringDecoder.decode(strView);
	};
}


Number.prototype.format = function(){
    if(this==0) return 0;
 
    var reg = /(^[+-]?\d+)(\d{3})/;
    var n = (this + '');
 
    while (reg.test(n)) n = n.replace(reg, '$1' + ',' + '$2');
 
    return n;
};

/**
 * IpUtil.java 와 동일한 룰이어야 한다.
 * @param ip
 * @param ipType
 * @returns {*}
 */
Number.generateIP = function (ip, ipType) {
    if (!ip) return null;

    if (ipType == 'v4') {
        var arr = [0, 0, 0, 0];

        arr[0] = (ip & (0xff << 24)) >>> 24;
        arr[1] = (ip & (0xff << 16)) >>> 16;
        arr[2] = (ip & (0xff << 8)) >>> 8;
        arr[3] = (ip & (0xff)) ;

        return arr.join(".");
    } else if (ipType == 'v6') {
    	/*
    	//과거 버젼에서 사용했던 방법..
        var temp = [];
        for(var i = 0, len = ip.length; i < len; i++) {
            temp[i] = ('0000' + ip[i].toString(16)).substr(-4);
        }

        return temp.join(":");
        */

        var text = "";
        var startPos = -1;
        var endPos = -1;

        var digit = ip[0];
		for(var i = 0, len = ip.length; i < len; i++) {
			text = text + ip[i].toString(16) + ":";
			var nextDigit = 1;
			if(i < ip.length - 1) {
                nextDigit = ip[i+1];

				if(digit == 0 && nextDigit == 0) {
                    if (startPos == -1)
                    {
                        startPos = Math.max(0, text.length - 3);
                    }
                    endPos = text.length + 2;
				}
			}

			digit = nextDigit;
		}

        if (startPos != -1 && endPos != -1)
        {
            var hi = text.substring(0, startPos);
            var lo = text.substring(endPos);
            if (lo.length == 0)
            {
                return hi + "::";
            }
            text = hi + "::" + lo;
        }

        return text.substring(0, text.length - 1);
    }

    return null;
}

Number.parseIp = function (ip, ipType) {
	var arr = [0, 0, 0, 0];

	arr[0] = (ip & (0xff << 24)) >>> 24;
	arr[1] = (ip & (0xff << 16)) >>> 16;
	arr[2] = (ip & (0xff << 8)) >>> 8;
	arr[3] = (ip & (0xff)) ;

	return arr.join(".");
}

Number.parseLong = function (str) {
	var high = str.substr(0, str.length - 6);
	var low = str.substr(-6);

	return { h : parseFloat(high), l : (parseInt(low, 10) | 0) };
}

Number.toLongString = function (low, high) {
	return ((low < 0) ? '-0x' + (low * -1).toString(16)  : '0x' + low.toString(16)) + high.toString(16);
}

Number.prototype.toLocaleForAries = function() {
	// FIXME: IE 의 경우 프로파일링을 할 때  toLocaleString() 실행하는게 무한루프 도는거 같다. stack 공간 부족이라는 오류로 인해서 그냥 멈춘다.
	// FIXME: IE 의 경우 프로파일링을 할 때  toLocaleString()  주석처리하고 프로파일링을 하자.

	return this.toShortForAries().toLocaleString();
};

Number.prototype.toShortForAries = function() {
	//	if(this < 100) {
//		return this.toLocaleString(window.locale, {maximumFractionDigits: 2});
//	} else {
//		return parseInt(this).toLocaleString(window.locale);
//	}

	//ARIES-247
	//chrome 31버젼에서 locale넘겼을때 안되는 현상이 있었음
	//현재도 맥-사파리를 비롯한 테블릿에서 지원하지 않음.

	if(_.isNaN(this)) {
		return 0;
	}

	if(this < 100) {
		var value = parseInt(this * 100) / 100;
		return value;
	} else {
		return parseInt(this)
	}
}

// TODO: 차후 제거해야함. 혹시모를 호환성을 위해 남겨둠.
Number.prototype.toLocaleForJennifer = function() {
    return this.toLocaleForAries();
}
Number.prototype.toShortForJennifer = function() {
    return this.toShortForAries();
}

Number.prototype.fillZero = function(val) {
	return this.toString().fillZero(val);
};

Number.UNIT_STRING = ['', 'K', 'M', 'G'];

Number.prototype.toUnitString = function (base) {
	base = base || 1000;

	var originValue = this;
	var value = this;
	var len = base.toLocaleForAries().length;

	// 기본 숫자 가 base 보다 작으면 기존 로직 그대로 출력
	if (value < base) {
		return (Math.round(value * 100) / 100).toLocaleForAries();
	}

	originValue = value;
	value = Math.round(originValue) / base;

	// base 로 나눈 몫이 base 보다 작을 때
	if (value < base) {

		// base 랑 같은 등급이면 그대로 살려주자.
		if (originValue.toLocaleForAries().length == len) {
			return (Math.round(originValue * 100) / 100).toLocaleForAries();
		}

		return Math.round(value * 100) / 100 + Number.UNIT_STRING[1];
	}

	originValue = value;
	value = Math.round(originValue) / base;

	// base 로 나눈 몫이 base 보다 작을 때
	if (value < base) {

		// base 랑 같은 등급이면 그대로 살려주자.
		if (originValue.toLocaleForAries().length == len) {
			return (Math.round(originValue * 100) / 100).toLocaleForAries() + Number.UNIT_STRING[1];
		}

		return Math.round(value * 100) / 100 + Number.UNIT_STRING[2];
	}

	originValue = value;
	value = Math.round(originValue) / base;

	// base 로 나눈 몫이 base 보다 작을 때
	if (value < base) {

		// base 랑 같은 등급이면 그대로 살려주자.
		if (originValue.toLocaleForAries().length == len) {
			return (Math.round(originValue * 100) / 100).toLocaleForAries() + Number.UNIT_STRING[2];
		}

		return Math.round(value * 100) / 100 + Number.UNIT_STRING[3];
	}

	return originValue.toLocaleForAries();
}


Date.getShortDateFormat = function() {
	var DATE_FORMAT_LIST = {"ar-SA":"DD/MM/YY","bg-BG":"DD.M.YYYY","ca-ES":"DD/MM/YYYY","zh-TW":"YYYY/M/D","cs-CZ":"D.M.YYYY","da-DK":"DD-MM-YYYY","de-DE":"DD.MM.YYYY","el-GR":"D/M/YYYY","en-US":"M/D/YYYY","fi-FI":"D.M.YYYY","fr-FR":"DD/MM/YYYY",
			"he-IL":"DD/MM/YYYY","hu-HU":"YYYY. MM. DD.","is-IS":"D.M.YYYY","it-IT":"DD/MM/YYYY","ja-JP":"YYYY/MM/DD","ko-KR":"YYYY-MM-DD","nl-NL":"d-M-YYYY","nb-NO":"DD.MM.YYYY","pl-PL":"YYYY-MM-DD","pt-BR":"D/M/YYYY","ro-RO":"DD.MM.YYYY","ru-RU":"DD.MM.YYYY",
			"hr-HR":"D.M.YYYY","sk-SK":"D. M. YYYY","sq-AL":"YYYY-MM-DD","sv-SE":"YYYY-MM-DD","th-TH":"D/M/YYYY","tr-TR":"DD.MM.YYYY","ur-PK":"DD/MM/YYYY","id-ID":"DD/MM/YYYY","uk-UA":"DD.MM.YYYY","be-BY":"DD.MM.YYYY","sl-SI":"D.M.YYYY","et-EE":"D.MM.YYYY",
			"lv-LV":"YYYY.MM.DD.","lt-LT":"YYYY.MM.DD","fa-IR":"MM/DD/YYYY","vi-VN":"DD/MM/YYYY","hy-AM":"DD.MM.YYYY","az-Latn-AZ":"DD.MM.YYYY","eu-ES":"YYYY/MM/DD","mk-MK":"DD.MM.YYYY","af-ZA":"YYYY/MM/DD","ka-GE":"DD.MM.YYYY","fo-FO":"DD-MM-YYYY","hi-IN":"DD-MM-YYYY",
			"ms-MY":"DD/MM/YYYY","kk-KZ":"DD.MM.YYYY","	ky-KG":"DD.MM.YY","sw-KE":"M/D/YYYY","uz-Latn-UZ":"DD/MM YYYY","tt-RU":"DD.MM.YYYY","pa-IN":"DD-MM-YY","gu-IN":"DD-MM-YY","ta-IN":"DD-MM-YYYY","te-IN":"DD-MM-YY","kn-IN":"DD-MM-YY","mr-IN":"DD-MM-YYYY","sa-IN":"DD-MM-YYYY",
			"mn-MN":"YY.MM.DD","gl-ES":"DD/MM/YY","kok-IN":"DD-MM-YYYY","syr-SY":"DD/MM/YYYY","dv-MV":"DD/MM/YY","ar-IQ":"DD/MM/YYYY","zh-CN":"YYYY/M/D","de-CH":"DD.MM.YYYY","en-GB":"DD/MM/YYYY","es-MX":"DD/MM/YYYY","fr-BE":"D/MM/YYYY","it-CH":"DD.MM.YYYY","nl-BE":"D/MM/YYYY",
			"nn-NO":"DD.MM.YYYY","pt-PT":"DD-MM-YYYY","sr-Latn-CS":"D.M.YYYY","sv-FI":"D.M.YYYY","az-Cyrl-AZ":"DD.MM.YYYY","ms-BN":"DD/MM/YYYY","uz-Cyrl-UZ":"DD.MM.YYYY","ar-EG":"DD/MM/YYYY","zh-HK":"D/M/YYYY","de-AT":"DD.MM.YYYY","en-AU":"D/MM/YYYY","es-ES":"DD/MM/YYYY",
			"fr-CA":"YYYY-MM-DD","sr-Cyrl-CS":"D.M.YYYY","ar-LY":"DD/MM/YYYY","zh-SG":"D/M/YYYY","de-LU":"DD.MM.YYYY","en-CA":"DD/MM/YYYY","es-GT":"DD/MM/YYYY","fr-CH":"DD.MM.YYYY","ar-DZ":"DD-MM-YYYY","zh-MO":"D/M/YYYY","de-LI":"DD.MM.YYYY","en-NZ":"D/MM/YYYY","es-CR":"DD/MM/YYYY",
			"fr-LU":"DD/MM/YYYY","ar-MA":"DD-MM-YYYY","en-IE":"DD/MM/YYYY","es-PA":"MM/DD/YYYY","fr-MC":"DD/MM/YYYY","ar-TN":"DD-MM-YYYY","en-ZA":"YYYY/MM/DD","es-DO":"DD/MM/YYYY","ar-OM":"DD/MM/YYYY","en-JM":"DD/MM/YYYY","es-VE":"DD/MM/YYYY","ar-YE":"DD/MM/YYYY","en-029":"MM/DD/YYYY",
			"es-CO":"DD/MM/YYYY","ar-SY":"DD/MM/YYYY","en-BZ":"DD/MM/YYYY","es-PE":"DD/MM/YYYY","ar-JO":"DD/MM/YYYY","en-TT":"DD/MM/YYYY","es-AR":"DD/MM/YYYY","ar-LB":"DD/MM/YYYY","en-ZW":"M/D/YYYY","es-EC":"DD/MM/YYYY","ar-KW":"DD/MM/YYYY","en-PH":"M/D/YYYY","es-CL":"DD-MM-YYYY",
			"ar-AE":"DD/MM/YYYY","es-UY":"DD/MM/YYYY","ar-BH":"DD/MM/YYYY","es-PY":"DD/MM/YYYY","ar-QA":"DD/MM/YYYY","es-BO":"DD/MM/YYYY","es-SV":"DD/MM/YYYY","es-HN":"DD/MM/YYYY","es-NI":"DD/MM/YYYY","es-PR":"DD/MM/YYYY","am-ET":"D/M/YYYY","tzm-Latn-DZ":"DD-MM-YYYY","iu-Latn-CA":"D/MM/YYYY",
			"sma-NO":"DD.MM.YYYY","mn-Mong-CN":"YYYY/M/D","gd-GB":"DD/MM/YYYY","en-MY":"D/M/YYYY","prs-AF":"DD/MM/YY","bn-BD":"DD-MM-YY","wo-SN":"DD/MM/YYYY","rw-RW":"M/D/YYYY","qut-GT":"DD/MM/YYYY","sah-RU":"MM.DD.	YYYY","gsw-FR":"DD/MM/YYYY","co-FR":"DD/MM/YYYY","oc-FR":"DD/MM/YYYY",
			"mi-NZ":"DD/MM/YYYY","ga-IE":"DD/MM/YYYY","se-SE":"YYYY-MM-DD","br-FR":"DD/MM/YYYY","smn-FI":"D.M.YYYY","moh-CA":"M/D/YYYY","arn-CL":"DD-MM-YYYY","ii-CN":"YYYY/M/D","dsb-DE":"D. M. YYYY","ig-NG":"D/M/YYYY","kl-GL":"DD-MM-YYYY","lb-LU":"DD/MM/YYYY","ba-RU":"DD.MM.YY",
			"nso-ZA":"YYYY/MM/DD","quz-BO":"DD/MM/YYYY","yo-NG":"D/M/YYYY","ha-Latn-NG":"D/M/YYYY","fil-PH":"M/D/YYYY","ps-AF":"DD/MM/YY","fy-NL":"d-M-YYYY","ne-NP":"M/D/YYYY","se-NO":"DD.MM.YYYY","iu-Cans-CA":"D/M/YYYY","sr-Latn-RS":"D.M.YYYY","si-LK":"YYYY-MM-DD","sr-Cyrl-RS":"D.M.YYYY",
			"lo-LA":"DD/MM/YYYY","km-KH":"YYYY-MM-DD","cy-GB":"DD/MM/YYYY","bo-CN":"YYYY/M/D","sms-FI":"D.M.YYYY","as-IN":"DD-MM-YYYY","ml-IN":"DD-MM-YY","en-IN":"DD-MM-YYYY","or-IN":"DD-MM-YY","bn-IN":"DD-MM-YY","tk-TM":"DD.MM.YY","bs-Latn-BA":"D.M.YYYY","mt-MT":"DD/MM/YYYY",
			"sr-Cyrl-ME":"D.M.YYYY","se-FI":"D.M.YYYY","zu-ZA":"YYYY/MM/DD","xh-ZA":"YYYY/MM/DD","tn-ZA":"YYYY/MM/DD","hsb-DE":"D. M. YYYY","bs-Cyrl-BA":"d	.M.YYYY","tg-Cyrl-TJ":"DD.MM.YY","sr-Latn-BA":"D.M.YYYY","smj-NO":"DD.MM.YYYY","rm-CH":"DD/MM/YYYY","smj-SE":"YYYY-MM-DD",
			"quz-EC":"DD/MM/YYYY","quz-PE":"DD/MM/YYYY","hr-BA":"D.M.YYYY.","sr-Latn-ME":"D.M.YYYY","sma-SE":"YYYY-MM-DD","en-SG":"D/M/YYYY","ug-CN":"YYYY-M-d","sr-Cyrl-BA":"D.M.YYYY","es-US":"M/D/YYYY", "ko": "YYYY-MM-DD"};

	var format = "MM/DD/YYYY";

	if(DATE_FORMAT_LIST.hasOwnProperty(window.server.locale)) {
		format = DATE_FORMAT_LIST[window.server.locale];
	}
	
	return format; 
};

Date.getLongDateFormat = function() {
	return this.getShortDateFormat() + " HH:mm";
};

Date.getLongDateWithSecFormat = function() {
    return this.getLongDateFormat() + ":ss";
};

//var DATE_FORMAT_LIST = {"ar-SA":"dd/MM/yy","bg-BG":"dd.M.yyyy","ca-ES":"dd/MM/yyyy","zh-TW":"yyyy/M/d","cs-CZ":"d.M.yyyy","da-DK":"dd-MM-yyyy","de-DE":"dd.MM.yyyy","el-GR":"d/M/yyyy","en-US":"M/d/yyyy","fi-FI":"d.M.yyyy","fr-FR":"dd/MM/yyyy","he-IL":"dd/MM/yyyy","hu-HU":"yyyy. MM. dd.","is-IS":"d.M.yyyy","it-IT":"dd/MM/yyyy","ja-JP":"yyyy/MM/dd","ko-KR":"yyyy-MM-dd","nl-NL":"d-M-yyyy","nb-NO":"dd.MM.yyyy","pl-PL":"yyyy-MM-dd","pt-BR":"d/M/yyyy","ro-RO":"dd.MM.yyyy","ru-RU":"dd.MM.yyyy","hr-HR":"d.M.yyyy","sk-SK":"d. M. yyyy","sq-AL":"yyyy-MM-dd","sv-SE":"yyyy-MM-dd","th-TH":"d/M/yyyy","tr-TR":"dd.MM.yyyy","ur-PK":"dd/MM/yyyy","id-ID":"dd/MM/yyyy","uk-UA":"dd.MM.yyyy","be-BY":"dd.MM.yyyy","sl-SI":"d.M.yyyy","et-EE":"d.MM.yyyy","lv-LV":"yyyy.MM.dd.","lt-LT":"yyyy.MM.dd","fa-IR":"MM/dd/yyyy","vi-VN":"dd/MM/yyyy","hy-AM":"dd.MM.yyyy","az-Latn-AZ":"dd.MM.yyyy","eu-ES":"yyyy/MM/dd","mk-MK":"dd.MM.yyyy","af-ZA":"yyyy/MM/dd","ka-GE":"dd.MM.yyyy","fo-FO":"dd-MM-yyyy","hi-IN":"dd-MM-yyyy","ms-MY":"dd/MM/yyyy","kk-KZ":"dd.MM.yyyy","	ky-KG":"dd.MM.yy","sw-KE":"M/d/yyyy","uz-Latn-UZ":"dd/MM yyyy","tt-RU":"dd.MM.yyyy","pa-IN":"dd-MM-yy","gu-IN":"dd-MM-yy","ta-IN":"dd-MM-yyyy","te-IN":"dd-MM-yy","kn-IN":"dd-MM-yy","mr-IN":"dd-MM-yyyy","sa-IN":"dd-MM-yyyy","mn-MN":"yy.MM.dd","gl-ES":"dd/MM/yy","kok-IN":"dd-MM-yyyy","syr-SY":"dd/MM/yyyy","dv-MV":"dd/MM/yy","ar-IQ":"dd/MM/yyyy","zh-CN":"yyyy/M/d","de-CH":"dd.MM.yyyy","en-GB":"dd/MM/yyyy","es-MX":"dd/MM/yyyy","fr-BE":"d/MM/yyyy","it-CH":"dd.MM.yyyy","nl-BE":"d/MM/yyyy","nn-NO":"dd.MM.yyyy","pt-PT":"dd-MM-yyyy","sr-Latn-CS":"d.M.yyyy","sv-FI":"d.M.yyyy","az-Cyrl-AZ":"dd.MM.yyyy","ms-BN":"dd/MM/yyyy","uz-Cyrl-UZ":"dd.MM.yyyy","ar-EG":"dd/MM/yyyy","zh-HK":"d/M/yyyy","de-AT":"dd.MM.yyyy","en-AU":"d/MM/yyyy","es-ES":"dd/MM/yyyy","fr-CA":"yyyy-MM-dd","sr-Cyrl-CS":"d.M.yyyy","ar-LY":"dd/MM/yyyy","zh-SG":"d/M/yyyy","de-LU":"dd.MM.yyyy","en-CA":"dd/MM/yyyy","es-GT":"dd/MM/yyyy","fr-CH":"dd.MM.yyyy","ar-DZ":"dd-MM-yyyy","zh-MO":"d/M/yyyy","de-LI":"dd.MM.yyyy","en-NZ":"d/MM/yyyy","es-CR":"dd/MM/yyyy","fr-	LU":"dd/MM/yyyy","ar-MA":"dd-MM-yyyy","en-IE":"dd/MM/yyyy","es-PA":"MM/dd/yyyy","fr-MC":"dd/MM/yyyy","ar-TN":"dd-MM-yyyy","en-ZA":"yyyy/MM/dd","es-DO":"dd/MM/yyyy","ar-OM":"dd/MM/yyyy","en-JM":"dd/MM/yyyy","es-VE":"dd/MM/yyyy","ar-YE":"dd/MM/yyyy","en-029":"MM/dd/yyyy","es-CO":"dd/MM/yyyy","ar-SY":"dd/MM/yyyy","en-BZ":"dd/MM/yyyy","es-PE":"dd/MM/yyyy","ar-JO":"dd/MM/yyyy","en-TT":"dd/MM/yyyy","es-AR":"dd/MM/yyyy","ar-LB":"dd/MM/yyyy","en-ZW":"M/d/yyyy","es-EC":"dd/MM/yyyy","ar-KW":"dd/MM/yyyy","en-PH":"M/d/yyyy","es-CL":"dd-MM-yyyy","ar-AE":"dd/MM/yyyy","es-UY":"dd/MM/yyyy","ar-BH":"dd/MM/yyyy","es-PY":"dd/MM/yyyy","ar-QA":"dd/MM/yyyy","es-BO":"dd/MM/yyyy","es-SV":"dd/MM/yyyy","es-HN":"dd/MM/yyyy","es-NI":"dd/MM/yyyy","es-PR":"dd/MM/yyyy","am-ET":"d/M/yyyy","tzm-Latn-DZ":"dd-MM-yyyy","iu-Latn-CA":"d/MM/yyyy","sma-NO":"dd.MM.yyyy","mn-Mong-CN":"yyyy/M/d","gd-GB":"dd/MM/yyyy","en-MY":"d/M/yyyy","prs-AF":"dd/MM/yy","bn-BD":"dd-MM-yy","wo-SN":"dd/MM/yyyy","rw-RW":"M/d/yyyy","qut-GT":"dd/MM/yyyy","sah-RU":"MM.dd.	yyyy","gsw-FR":"dd/MM/yyyy","co-FR":"dd/MM/yyyy","oc-FR":"dd/MM/yyyy","mi-NZ":"dd/MM/yyyy","ga-IE":"dd/MM/yyyy","se-SE":"yyyy-MM-dd","br-FR":"dd/MM/yyyy","smn-FI":"d.M.yyyy","moh-CA":"M/d/yyyy","arn-CL":"dd-MM-yyyy","ii-CN":"yyyy/M/d","dsb-DE":"d. M. yyyy","ig-NG":"d/M/yyyy","kl-GL":"dd-MM-yyyy","lb-LU":"dd/MM/yyyy","ba-RU":"dd.MM.yy","nso-ZA":"yyyy/MM/dd","quz-BO":"dd/MM/yyyy","yo-NG":"d/M/yyyy","ha-Latn-NG":"d/M/yyyy","fil-PH":"M/d/yyyy","ps-AF":"dd/MM/yy","fy-NL":"d-M-yyyy","ne-NP":"M/d/yyyy","se-NO":"dd.MM.yyyy","iu-Cans-CA":"d/M/yyyy","sr-Latn-RS":"d.M.yyyy","si-LK":"yyyy-MM-dd","sr-Cyrl-RS":"d.M.yyyy","lo-LA":"dd/MM/yyyy","km-KH":"yyyy-MM-dd","cy-GB":"dd/MM/yyyy","bo-CN":"yyyy/M/d","sms-FI":"d.M.yyyy","as-IN":"dd-MM-yyyy","ml-IN":"dd-MM-yy","en-IN":"dd-MM-yyyy","or-IN":"dd-MM-yy","bn-IN":"dd-MM-yy","tk-TM":"dd.MM.yy","bs-Latn-BA":"d.M.yyyy","mt-MT":"dd/MM/yyyy","sr-Cyrl-ME":"d.M.yyyy","se-FI":"d.M.yyyy","zu-ZA":"yyyy/MM/dd","xh-ZA":"yyyy/MM/dd","tn-ZA":"yyyy/MM/dd","hsb-DE":"d. M. yyyy","bs-Cyrl-BA":"d	.M.yyyy","tg-Cyrl-TJ":"dd.MM.yy","sr-Latn-BA":"d.M.yyyy","smj-NO":"dd.MM.yyyy","rm-CH":"dd/MM/yyyy","smj-SE":"yyyy-MM-dd","quz-EC":"dd/MM/yyyy","quz-PE":"dd/MM/yyyy","hr-BA":"d.M.yyyy.","sr-Latn-ME":"d.M.yyyy","sma-SE":"yyyy-MM-dd","en-SG":"d/M/yyyy","ug-CN":"yyyy-M-d","sr-Cyrl-BA":"d.M.yyyy","es-US":"M/d/yyyy"};
Date.prototype.toLocaleDateShortString = function(){
	var format = Date.getShortDateFormat(), year = this.getFullYear(), month = this.getMonth()+1, day = this.getDate();
 
	function z(s){
    	s=''+s;
    	
    	return s.length>1?s:'0'+s;
    }
	
	format = format.replace(/YYYY/ ,year);
	format = format.replace(/YY/,String(year).substr(2));
	format = format.replace(/MM/,z(month));
	format = format.replace(/M/, month);
	format = format.replace(/DD/,z(day));
	format = format.replace(/D/, day);
    
    return format;
};

Date.prototype.toLocaleDateLongString = function(){
	var format = Date.getLongDateFormat(), year = this.getFullYear(), month = this.getMonth()+1, day = this.getDate(),
	hour = this.getHours(), minute = this.getMinutes();
	
	function z(s){
    	s=''+s;
    	
    	return s.length>1?s:'0'+s;
    }
	
	
	format = format.replace(/YYYY/ ,year);
	format = format.replace(/YY/,String(year).substr(2));
	format = format.replace(/MM/,z(month));
	format = format.replace(/M/, month);
	format = format.replace(/DD/,z(day));
	format = format.replace(/D/, day);
	format = format.replace(/HH/,z(hour));
	format = format.replace(/mm/,z(minute));
    
    return format;
};

Date.prototype.isToday = function() {
	var serverDate = new Date(getServerTime()); 

	if(this.getFullYear() == serverDate.getFullYear() && this.getMonth() == serverDate.getMonth() && this.getDate() == serverDate.getDate()) {
		return true;
	} 
	
	return false;
};

Date.prototype.getServerTime = function() {
	return this.getTime() + (this.getTimezoneOffset()*-1 - window.server.minuteOffset) * ClientUtilities.ONE_MINUTE;
};

Date.prototype.format = function(f) {
  var d = this;

  return f.replace(/(yyyy|mmmm|mmm|mm|dddd|ddd|dd|hh|HH|nn|ss|a|A)/gi, function($1) {
      switch ($1) {
          case 'yyyy': return d.getFullYear();
          case 'mmmm': return gsMonthNames[d.getMonth()];
          case 'mmm': return gsMonthNames[d.getMonth()].substr(0, 3);
          case 'mm': return (d.getMonth() + 1).fillZero(2);
          case 'dddd': return gsDayNames[d.getDay()];
          case 'ddd': return gsDayNames[d.getDay()].substr(0, 3);
          case 'dd': return d.getDate().fillZero(2);
          case 'hh': return ((h = d.getHours() % 12) ? h : 12).fillZero(2);
          case 'HH': return d.getHours().fillZero(2);
          case 'nn': return d.getMinutes().fillZero(2);
          case 'ss': return d.getSeconds().fillZero(2);
          case 'a': return d.getHours() < 12 ? 'am' : 'pm';
          case 'A': return d.getHours() < 12 ? 'AM' : 'PM';
      }
  });
};

//ecma 5
if(!Date.now) {
  Date.now = function () {
    return +(new Date);
  };
}
function Command() {
	this.cmds = new Map();
}

Command.prototype = {
	setType : function(type) {
		this.type = type;
	},
		
	clear : function() {
    	this.cmds.clear();
    },
    
	add : function(map) {
		var keys = map.keys(),
		    cmd = '{',
		    i = 0,
		    j = 0,
		    k = 0,
		    max = keys.length;
		
		if(max > 0 && !!map.get(['key'])) {
			for(i=0; i<max; i++) {
				if(i > 0) {
					cmd += ',';
				}
				
				cmd = cmd + keys[i] + ':' + this._arrayToJSON(map.get(keys[i]));
			}
			
			cmd += '}';
			
			this.cmds.put(map.get(['key']), cmd);
		}
	},
	
	_arrayToJSON : function(arry) {
		if(typeof(arry) == 'object') {
			var each = '[',
			    j = 0,
			    arryMax = arry.length;
			
			for(j=0; j<arryMax; j++) {
				if(j > 0)
					each += ",";
				
				if(typeof(arry[j]) == 'object') {
					each += this._arrayToJSON(arry[j]);
				} else {
					each += arry[j];
				}
			}
			
			each += ']';
			
			return each;
		} else {
			return arry;
		}
	},
	
	getJSON : function() {
		var keys = this.cmds.keys(),
		    cm = '{cmds:[',
		    i = 0,
		    max = keys.length;
		
		for(i=0; i<max; i++) {
			if(i > 0)
				cm += ",";
			cm += this.cmds.get(keys[i]);
		}

    	cm += "]}";
		
		return cm;
	}
};

//function JSONtoString(obj){
//  switch(typeof(obj)){
//    case 'string': return '"' + obj.replace(/(["\\])/g, '\\$1') + '"';
//    case 'array': return '[' + obj.map(JSONtoString).join(',') + ']';
//    case 'object':
//      if(obj instanceof Array){
//        var strArr = [];
//        var len = obj.length;
//        for(var i=0; i<len; i++){
//         strArr.push(JSONtoString(obj[i]));
//        }
//        return '[' + strArr.join(',') + ']';
//     }else if(obj==null){
//       return 'null';
//
//     }else{
//       var string = [];
//       for (var property in obj) 
//         string.push(JSONtoString(property) + ':' 
//            + JSONtoString(obj[property]));
//       return '{' + string.join(',') + '}';
//     }
//   case 'number': return obj;
//   case false: return obj;
//   }
//}

/*
function JSONtoString(object) {
    var results = [];
    for (var property in object) {
        var value = object[property];
        results.push(property.toString() + ":'" + value + "'");
    }
    
    return '{' + results.join(',') + '}';
}
*/

function JSONtoString(object) {
    var results = [];
    for (var property in object) {
        var value = object[property];
        
        if(value instanceof Object) {
        	var results2 = [];
        	for (var property2 in value) {
        		var value2 = value[property2];
        		
        		results2.push(property2.toString() + ":'" + value2 + "'");
        	}
        	
        	var values = "";
        	for (var i=0; i<results2.length; i++) {
        		values += "'" + results2[i] + "'";
        		
        		results.push(property.toString() + ":" + '{' + results2.join(',') + '}');
        	}
        } else {
        	results.push(property.toString() + ":'" + value + "'");
        }
    }
    
    return '{' + results.join(',') + '}';
}

function JSONreplacer(key, value) {
    if (typeof value === 'number' && !isFinite(value)) {
        return String(value);
    }
    return value;
}
var PixelUtilities = {
	setImageData : function(imageData, x, y, r, g, b, a){
		if(!a) {
			a = 255;
		}
		
		index = (x + y * imageData.width) * 4;
	    imageData.data[index+0] = r;
	    imageData.data[index+1] = g;
	    imageData.data[index+2] = b;
	    imageData.data[index+3] = a;
	},
	
	fillXViewAppPoint5 : function(imageData, color){
		aries.deprecated("do not use PixelUtilities.fillXViewAppPoint5");
		var r = color.getRed();
		var g = color.getGreen();
		var b = color.getBlue();
		
		this.setImageData(imageData, 0, 0, r, g, b);
		this.setImageData(imageData, 1, 0, r, g, b);
		this.setImageData(imageData, 3, 0, r, g, b);
		this.setImageData(imageData, 4, 0, r, g, b);
		
		this.setImageData(imageData, 0, 1, r, g, b);
		this.setImageData(imageData, 1, 1, r, g, b);
		this.setImageData(imageData, 2, 1, r, g, b);
		this.setImageData(imageData, 3, 1, r, g, b);
		this.setImageData(imageData, 4, 1, r, g, b);
		
		this.setImageData(imageData, 1, 2, r, g, b);
		this.setImageData(imageData, 2, 2, r, g, b);
		this.setImageData(imageData, 3, 2, r, g, b);
		
		this.setImageData(imageData, 0, 3, r, g, b);
		this.setImageData(imageData, 1, 3, r, g, b);
		this.setImageData(imageData, 2, 3, r, g, b);
		this.setImageData(imageData, 3, 3, r, g, b);
		this.setImageData(imageData, 4, 3, r, g, b);
		
		this.setImageData(imageData, 0, 4, r, g, b);
		this.setImageData(imageData, 1, 4, r, g, b);
		this.setImageData(imageData, 3, 4, r, g, b);
		this.setImageData(imageData, 4, 4, r, g, b);
	},
	
	fillXViewPoint : function(imageData, color, size) {
		aries.deprecated("do not use PixelUtilities.fillXViewPoint");
		if(size == 1) {
			this.fillXViewPoint1(imageData, color);
		} else if(size == 3) {
				this.fillXViewPoint3(imageData, color);
		} else if(size == 5) {
			this.fillXViewPoint5(imageData, color);
		}
	},
	
	fillXViewPoint5 : function(imageData, color){
		aries.deprecated("do not use PixelUtilities.fillXViewPoint5");
		var r = color.getRed();
		var g = color.getGreen();
		var b = color.getBlue();
		
		this.setImageData(imageData, 0, 0, r, g, b);
		this.setImageData(imageData, 1, 0, r, g, b);
		this.setImageData(imageData, 3, 0, r, g, b);
		this.setImageData(imageData, 4, 0, r, g, b);
		
		this.setImageData(imageData, 0, 1, r, g, b);
		this.setImageData(imageData, 1, 1, r, g, b);
		this.setImageData(imageData, 2, 1, r, g, b);
		this.setImageData(imageData, 3, 1, r, g, b);
		this.setImageData(imageData, 4, 1, r, g, b);
		
		this.setImageData(imageData, 1, 2, r, g, b);
		this.setImageData(imageData, 2, 2, r, g, b);
		this.setImageData(imageData, 3, 2, r, g, b);
		
		this.setImageData(imageData, 0, 3, r, g, b);
		this.setImageData(imageData, 1, 3, r, g, b);
		this.setImageData(imageData, 2, 3, r, g, b);
		this.setImageData(imageData, 3, 3, r, g, b);
		this.setImageData(imageData, 4, 3, r, g, b);
		
		this.setImageData(imageData, 0, 4, r, g, b);
		this.setImageData(imageData, 1, 4, r, g, b);
		this.setImageData(imageData, 3, 4, r, g, b);
		this.setImageData(imageData, 4, 4, r, g, b);
		
	},
	
	fillXViewPoint3 : function(imageData, color){
		aries.deprecated("do not use PixelUtilities.fillXViewPoint3");
		var r = color.getRed();
		var g = color.getGreen();
		var b = color.getBlue();
		
		this.setImageData(imageData, 0, 0, r, g, b);
		this.setImageData(imageData, 2, 0, r, g, b);
		
		this.setImageData(imageData, 1, 1, r, g, b);
		
		this.setImageData(imageData, 0, 2, r, g, b);
		this.setImageData(imageData, 2, 2, r, g, b);
	},
	
	fillXViewPoint1 : function(imageData, color){
		aries.deprecated("do not use PixelUtilities.fillXViewPoint1");
		var r = color.getRed();
		var g = color.getGreen();
		var b = color.getBlue();
		
		this.setImageData(imageData, 0, 0, r, g, b);

	}
};
/*
 * StringBuffer Class
 */
function StringBuffer() {
    this.buffer = [];
}

StringBuffer.prototype.append = function(string) {
    this.buffer.push(string);
    return this;
};

StringBuffer.prototype.clear = function() {
    this.buffer = [];
    
    return this;
};

StringBuffer.prototype.toString = function() {
	return this.buffer.join('');
};

StringBuffer.prototype.size = function() {
    return this.buffer.length;
};

String.prototype.toLocaleForAries = function() {
	return Number(this).toLocaleForAries();
};

// TODO: 차후 제거해야함. 혹시모를 호환성을 위해 남겨둠.
String.prototype.toLocaleForJennifer = function() {
    return this.toLocaleForAries();
};

String.format = function (format, value) {
//	if(".0f" == format) {
//		return value.toFixed(0);
//	} else if(".1f" == format) {
//		return value.toFixed(1);
//	} else if(".2f" == format) {
//		return value.toFixed(2);
//	} else {
//		return value;
//	}
	return value;
}

String.prototype.format = function (format, value) {
	return String.format(format, value);
}

//String.prototype.format = function() {
/*
 *String.format = function() {
	var expression = arguments[0];
	for(var i=1; i<arguments.length; i++) {
		expression = expression.replace("{" + (i - 1) + "}", arguments[i]);
	}
	
	return expression;
};
*/

String.prototype.startsWith = function(str) {
	return (this.match("^"+str)==str);
};

String.prototype.fillZero = function(val) {
	return '0'.string(val - this.length) + this;
};

String.prototype.string = function(val) {
	var s = '', i = 0;
	while (i++ < val) {
		s += this;
	}
	return s;
};

Array.prototype.contains = function (element) {
    for (var i = 0; i < this.length; i++) {
	    if (this[i] == element) {
	        return true;
	    }
	}
	return false;
}

var gsMonthNames = new Array(
	    'January',
	    'February',
	    'March',
	    'April',
	    'May',
	    'June',
	    'July',
	    'August',
	    'September',
	    'October',
	    'November',
	    'December'
);

var gsDayNames = new Array(
    'Sunday',
    'Monday',
    'Tuesday',
    'Wednesday',
    'Thursday',
    'Friday',
    'Saturday'
);


var AriesChartFont = {
	fontStyle : {
		"en" : "Arial",
		"ko" : "Arial",
		"ja" : "'Meiryo UI', Osaka, 'Lucida Grande', Arial",
		"zh" : "'SimSun', 'Lucida Grande', Arial"
	},

	caches : {

	},

	getFont : function(size, option) {
		var language = "en";
		if(window.ariesuser && window.ariesuser.language) {
			language = window.ariesuser.language;
		}

		var key = [language, size, option].join("-");

		if (!this.caches[key]) {
			var style = size + "px " + this.fontStyle[language];

			if(!_.isUndefined(option)) {
				style = option + " " + style;
			}

			this.caches[key] = style;
		}

		return this.caches[key];
	}

};
var AriesIconPath = {
	//SVG 크기 26 X 26 기준(w,h) 기준의 path들의 모음.
	size : 26,

	model : {
		"instance" : "M15.3,24.1c0.5,0.4,1.1,0.8,1.7,1.1c-0.3,0.2-0.6,0.3-0.9,0.3H5.4c-0.9,0-1.7-0.8-1.7-1.8V2.5c0-1,0.8-1.8,1.7-1.8h10.7c0.9,0,1.7,0.8,1.7,1.8v9.4c-0.5,0.1-0.9,0.3-1.4,0.6v-10c0-0.2-0.1-0.4-0.3-0.4H5.4C5.2,2.1,5,2.3,5,2.5v21.2c0,0.2,0.1,0.4,0.3,0.4H15.3z M12.6,19.5c0,1-0.8,1.9-1.9,1.9s-1.9-0.8-1.9-1.9c0-1,0.8-1.9,1.9-1.9S12.6,18.5,12.6,19.5zM11.6,19.5c0-0.4-0.4-0.8-0.8-0.8S10,19.1,10,19.5s0.4,0.8,0.8,0.8S11.6,20,11.6,19.5z M7.2,5.5h7.2v-1H7.2V5.5z M7.2,8.4h7.2V7.3H7.2V8.4z",

		"domain" : "M17.2,20.4v2.3c-1.3,0.6-2.7,1-4.2,1c-1.5,0-2.9-0.3-4.2-1v-2.3c1.2,0.8,2.7,1.2,4.2,1.2S16,21.2,17.2,20.4z M5.2,13.9c0-2.4,1.1-4.6,2.9-6.1V5.4c-2.9,1.7-4.9,4.9-4.9,8.5c0,0.4,0,0.7,0.1,1.1h2C5.2,14.6,5.2,14.2,5.2,13.9z M20.8,13.9c0,0.4,0,0.7-0.1,1.1h2c0-0.4,0.1-0.7,0.1-1.1c0-3.6-2-6.8-4.9-8.5v2.4C19.7,9.2,20.8,11.4,20.8,13.9z M9.8,2.1L9.8,2.1v6.4l0,0h6.4l0,0V2.1l0,0H9.8z M18.9,16.7V23h6.4v-6.4H18.9z M0.7,16.7V23H7v-6.4H0.7z",

		"db" : "M11.3,14.3l-6,5.7v-3.4H0.5v-4.3h4.8V8.8L11.3,14.3z M24.7,5.5v15.3c0,1.3-1.1,2.5-3.1,3.3c-1.8,0.7-4.1,1.1-6.5,1.1s-4.8-0.4-6.6-1.1c-1.4-0.6-2.5-1.3-3-2.2l1.3-1.4v0.3c0,0.4,0.7,1.1,2.2,1.7c1.6,0.6,3.8,1,6,1s4.5-0.3,6.1-1	c1.5-0.6,2.1-1.3,2.1-1.7v-2.3c-0.8,0.3-0.9,0.5-1.5,0.7c-1.8,0.7-4.2,1.1-6.6,1.1s-4.8-0.4-6.6-1.1h0l1.4-1.4c1.5,0.5,3.2,0.7,5.2,0.7c2.2,0,4.5-0.3,6-1c1.5-0.6,2.1-1.3,2.1-1.7v-2.6c-0.8,0.3-0.9,0.5-1.5,0.7c-1.8,0.7-4.1,1.1-6.6,1.1c-0.8,0-1.6,0-2.3-0.1c0.3-0.5,0.3-1.2,0-1.7c0.7,0.1,1.4,0.1,2.2,0.1c2.2,0,4.4-0.3,6-1c1.5-0.6,2.1-1.3,2.1-1.7V8c-0.8,0.3-0.9,0.5-1.5,0.7c-1.8,0.7-4.1,1.1-6.6,1.1s-4.9-0.4-6.6-1.1C8.2,8.6,7.8,8.4,7.4,8.2C6.2,7.5,5.6,6.8,5.3,6.6V5.4c0-1.3,1.2-2.5,3.2-3.3c1.8-0.7,4.1-1.1,6.6-1.1s4.8,0.4,6.5,1.1C23.6,3,24.7,4.2,24.7,5.5z M23,5.5c0-0.4-0.5-1.1-2-1.7c-1.6-0.6-3.7-1-5.9-1s-4.4,0.4-5.9,1c-1.5,0.6-2,1.3-2,1.7c0,0.4,0.5,1.1,2,1.7c1.6,0.6,3.7,1,5.9,1s4.4-0.3,5.9-1C22.5,6.6,23,5.9,23,5.5z",

		"externalcall" : "M21,2.4v21.5c0,1-0.8,1.6-1.8,1.6H8.4c-0.9,0-1.8-0.6-1.8-1.6v-3.5l1.3-1.2v4.7c0,0.2,0.3,0.3,0.5,0.3h10.9c0.2,0,0.4-0.1,0.4-0.3V2.4c0-0.2-0.3-0.3-0.4-0.3H8.4c-0.2,0-0.5,0.1-0.5,0.3V7L6.6,5.7V2.4c0-1,0.9-1.7,1.8-1.7h10.9C20.2,0.8,21,1.4,21,2.4z M15.7,19.7c0,1.1-0.9,1.9-1.9,1.9s-1.9-0.9-1.9-1.9c0-1.1,0.9-1.9,1.9-1.9S15.7,18.6,15.7,19.7zM14.6,19.7c0-0.4-0.4-0.8-0.8-0.8c-0.4,0-0.8,0.4-0.8,0.8c0,0.4,0.4,0.8,0.8,0.8C14.3,20.5,14.6,20.1,14.6,19.7z M17.3,7.3h-7.1v1.1h7.1V7.3z M17.3,4.7h-7.1v1.1h7.1V4.7z M2.1,11.3V15h4.6v3.2l5.5-5.1L6.7,8.1v3.2H2.1L2.1,11.3z",

		"business" : "M21.3,3h-1.7h-1H7.4h-1H4.7l-3,11v9.6h22.6v-9.4L21.3,3z M19.6,14.3h-2.3l-1.9,2.9h-4.7l-1.9-2.9H6.4v-1.9h13.1V14.3L19.6,14.3z M20.5,14.3v-1.9v-1h-1H6.4h-1v2.9H3.6l2.5-9.4h0.2h1h11.3h1h0.2l2.5,9.4H20.5z M18.6,8.6h1v1v1h-1v-1H7.4v1h-1v-1v-1h1H18.6z M8.3,7.7h-1V5.9h1h9.4h1v1v1h-1v-1H8.3V7.7z"
	},

	icon : {

		"noAuth" : "M19.1,10.9v-4c0-3.3-2.7-6-6-6s-6,2.7-6,6v4h-3v14h18v-14H19.1z M15,20.8L13.1,19l-1.8,1.9l-1.1-1.1l1.8-1.9L10.1,16l1.1-1.1l1.9,1.8l1.8-1.9l1.1,1.1l-1.8,1.9l1.9,1.8C16.1,19.7,15,20.8,15,20.8z M9.1,10.9v-4c0-2.2,1.8-4,4-4s4,1.8,4,4v4C17.1,10.9,9.1,10.9,9.1,10.9z",

		"www" : "M19.8,24.7c-3.2,0-6-2.6-6-6s2.7-6,6-6s6,2.6,6,6S23,24.7,19.8,24.7z M15.8,16c-0.4,0.6-0.7,1.4-0.8,2.2h1.7c0-0.6,0.1-1.2,0.2-1.7C16.6,16.4,16.2,16.2,15.8,16z M15,19.1c0.1,0.8,0.4,1.6,0.8,2.2c0.4-0.2,0.8-0.3,1.2-0.4c-0.1-0.6-0.2-1.1-0.2-1.7H15V19.1z M16.4,22.1c0.4,0.4,0.8,0.7,1.4,0.9c-0.2-0.4-0.4-0.8-0.6-1.2C16.9,21.9,16.7,21.9,16.4,22.1z	M21.7,20.7c0.1-0.5,0.2-1,0.2-1.5h-1.7v1.4C20.8,20.5,21.3,20.6,21.7,20.7z M20.3,21.4v1.9c0.6-0.3,1-1.2,1.2-1.8C21.1,21.5,20.7,21.4,20.3,21.4z M20.3,18.2H22c0-0.5-0.1-1-0.2-1.5c-0.5,0.1-1,0.1-1.5,0.2V18.2L20.3,18.2z M21.5,15.8c-0.2-0.7-0.6-1.5-1.3-1.9v2C20.7,15.9,21.1,15.9,21.5,15.8z M18.1,15.8c0.4,0.1,0.8,0.1,1.2,0.1v-2C18.7,14.3,18.3,15.1,18.1,15.8zM17.9,16.7c-0.1,0.5-0.2,1-0.2,1.5h1.7v-1.4C18.8,16.8,18.3,16.8,17.9,16.7z M19.3,20.5v-1.4h-1.7c0,0.5,0.1,1.1,0.2,1.5C18.3,20.6,18.8,20.5,19.3,20.5z M18.1,21.6c0.2,0.6,0.6,1.5,1.2,1.8v-1.9C18.9,21.4,18.5,21.5,18.1,21.6z M21.8,23c0.5-0.2,1-0.6,1.3-0.9c-0.2-0.1-0.5-0.2-0.8-0.3C22.2,22.2,22.1,22.6,21.8,23z M23.8,21.3c0.4-0.6,0.7-1.4,0.8-2.2h-1.7c0,0.6-0.1,1.2-0.2,1.7C23,21,23.4,21.1,23.8,21.3z M22.6,16.5c0.1,0.5,0.2,1.1,0.2,1.7h1.7c-0.1-0.8-0.4-1.5-0.8-2.2	C23.4,16.2,23,16.4,22.6,16.5z M21.9,14.4c0.2,0.4,0.4,0.8,0.5,1.2c0.3-0.1,0.5-0.2,0.8-0.3C22.8,14.9,22.4,14.6,21.9,14.4zM16.4,15.3c0.2,0.1,0.5,0.2,0.8,0.3c0.1-0.4,0.3-0.8,0.5-1.2C17.2,14.6,16.8,14.9,16.4,15.3z",
		"licensed" : "M19.7,15.3c-0.8,0-1.4,0.6-1.4,1.4v1.4h2.8v-1.4C21.1,15.9,20.5,15.3,19.7,15.3z M19.7,12.7c-3.3,0-6,2.7-6,6s2.7,6,6,6s6-2.7,6-6S23,12.7,19.7,12.7z M22.5,22.2h-5.6V18h0.7v-1.4c0-1.2,0.9-2.1,2.1-2.1s2.1,0.9,2.1,2.1V18h0.7C22.5,18,22.5,22.2,22.5,22.2z",

		"stopped" : "M19.8,12.7c-3.2,0-6,2.6-6,6s2.8,6,6,6s6-2.6,6-6S23.1,12.7,19.8,12.7z M23.2,19c0,0.3-0.3,0.6-0.6,0.6h-5.8c-0.3,0-0.6-0.3-0.6-0.6v-0.7c0-0.3,0.3-0.6,0.6-0.6h5.8c0.3,0,0.6,0.3,0.6,0.6C23.2,18.3,23.2,19,23.2,19z"

	},

	etc : {
		"recovery" : "M6.8,16.5l5.3-5.3c0,0,0.1,0,0.1-0.1c-0.1-0.4-0.2-0.8-0.1-1.2c0.1-0.5,0.2-1,0.4-1.5c0.2-0.4,0.6-0.8,0.9-1.1c0.4-0.3,0.8-0.6,1.3-0.7c0.6-0.2,1.2-0.2,1.9-0.2C17,6.4,17,6.9,16.8,7l-1.6,1.6c-0.6,0.7-0.7,1.7,0,2.4c0.3,0.3,0.7,0.5,1.2,0.5s0.8-0.2,1.1-0.5l1.6-1.6c0.1-0.1,0.2-0.1,0.2-0.1c0.2,0,0.4,0.2,0.4,0.3c0,0.2,0,0.3,0,0.6c0.1,2-1.6,3.8-3.5,3.9c-0.1,0-0.2,0-0.4,0c-0.3,0-0.7,0-1-0.1c0,0-0.1,0-0.2,0l-5.2,5.2c-0.7,0.7-2,0.9-2.8,0.2C6,18.7,6,17.4,6.8,16.5z M25.7,13.1c0-7-5.7-12.7-12.7-12.7C6,0.4,0.3,6.1,0.3,13.1c0,7,5.7,12.7,12.7,12.7C20,25.9,25.7,20.2,25.7,13.1z M24.7,13.1c0,6.5-5.3,11.7-11.7,11.7S1.3,19.6,1.3,13.1S6.5,1.4,13,1.4S24.7,6.7,24.7,13.1z",

		"smile" : "M13,25c5.5,0,9.8-3.9,12-6.6L23.9,17c-3,1.9-6.5,3.1-10.9,3.1S5.1,19,2.1,17L1,18.4C3.2,21.1,7.5,25,13,25z M4.7,0.8c-2,0-3.5,1.6-3.5,3.5s1.6,3.5,3.5,3.5s3.5-1.6,3.5-3.5S6.7,0.8,4.7,0.8z M21.3,0.8c-2,0-3.5,1.6-3.5,3.5s1.6,3.5,3.5,3.5s3.5-1.6,3.5-3.5S23.2,0.8,21.3,0.8z",

		"edit" : "M14.9,4.2L3.1,16l-1.3,6.3l6.5-1.2L20,9.3L14.9,4.2z M4.4,17.3L14.9,6.8l0.7,0.7L5,17.9L4.4,17.3z M6.9,19.8l-0.7-0.7L16.7,8.7l0.7,0.7L6.9,19.8z M23.5,5.8l-2.3,2.3L16,3l2.3-2.3L23.5,5.8z M23.5,25H1.6v-1.3h21.9L23.5,25L23.5,25z",

        "caution": "M13,3c5.5,0,10,4.5,10,10s-4.5,10-10,10S3,18.5,3,13S7.5,3,13,3z M13,1C6.4,1,1,6.4,1,13s5.4,12,12,12s12-5.4,12-12S19.6,1,13,1z M11.7,8.5C11.6,7.7,12.3,7,13.1,7s1.4,0.6,1.3,1.4l-0.7,6.1c0,0.3-0.2,0.5-0.6,0.5c-0.3,0-0.6-0.2-0.6-0.5C12.4,14.5,11.7,8.5,11.7,8.5z M13,19.2c-0.7,0-1.3-0.6-1.3-1.3s0.6-1.3,1.3-1.3c0.7,0,1.3,0.6,1.3,1.3S13.7,19.2,13,19.2z"
	},

    isEdge : navigator.userAgent.indexOf('Edge/') > 0,

	getImageIcon : function(pathString, iconSize, color) {
		if (this.isEdge) {
            return this.getImageSVGIcon(pathString, iconSize, color);
		}


		var devicePixelRatio = window.devicePixelRatio || 1;
		var ratioForIconSize = iconSize / AriesIconPath.size;

		var iconContext = document.createElement('canvas').getContext('2d');
		var iconPath2d = new Path2D(pathString);

		iconContext.canvas.width = iconSize * devicePixelRatio;
		iconContext.canvas.height = iconSize * devicePixelRatio;

		iconContext.scale(ratioForIconSize * devicePixelRatio, ratioForIconSize * devicePixelRatio);

		iconContext.fillStyle = color;
		iconContext.fill(iconPath2d);

		return iconContext.canvas;
	},

	getSVGTemplate : function (pathString, iconSize, color, callback) {
        var devicePixelRatio = window.devicePixelRatio || 1;
        var ratioForIconSize = AriesIconPath.size * devicePixelRatio ;

		color = color || '#FFFFFF';


		var svgString = '<?xml version="1.0" encoding="utf-8" ?>\r\n<svg xmlns="http://www.w3.org/2000/svg" width="'+(ratioForIconSize*2)+'" height="'+(ratioForIconSize*2)+'" viewBox="0 0 ' + ratioForIconSize + ' ' + ratioForIconSize + '"><path d="'+pathString+'" fill="'+color+'" /></svg>';

        var svg = btoa(svgString);
        var base64 = 'data:image/svg+xml;base64,' + svg;

        var img = new Image();
        img.onload = function () {
            callback & callback(img);
        };
        img.src = base64;

        return img;

	},

    getImageSVGIcon : function(pathString, iconSize, color, callback) {
        return this.getSVGTemplate(pathString, iconSize, color, function (iconPath2d) {
            callback && callback (iconPath2d);
		});
    },

	/**
	 * 토폴로지와 이벤트차트에서 사용할 아이콘들을 path로 조합해서 이미지를 생성한다.
	 * @param iconSize
	 * @returns {{}}
	 */
	getIconGroup : function(iconSize) {
		if(this.isEdge) {
            return this.getIconSVGGroup(iconSize);
		}

		var devicePixelRatio = window.devicePixelRatio || 1;
		var ratioForIconSize = iconSize / AriesIconPath.size;

		var iconGroup = {};
		var modelTypes = _.keys(AriesIconPath.model);

		var instanceTypes = ["www", "stopped", "licensed"];
		var etcTypes = ["alone", "child"];

		//기본 모델들.
		for(var i=0; i<modelTypes.length; i++) {
			var path2d = new Path2D(AriesIconPath.model[modelTypes[i]]);
			if(modelTypes[i] === "instance") {
				//instance는 www, stopped, licensed 3개가 추가로 포함된다.
				for(var j=0; j<instanceTypes.length; j++) {
					var context = document.createElement('canvas').getContext('2d');
					context.canvas.width = iconSize * devicePixelRatio;
					context.canvas.height = iconSize * devicePixelRatio;

					context.scale(ratioForIconSize * devicePixelRatio, ratioForIconSize * devicePixelRatio);

					context.fillStyle = "#ffffff";
					context.fill(path2d);

					if(instanceTypes[j] != "www") {
						//stop, license 아이콘 표시 전에 배경 그려주기.
						context.beginPath();
						context.arc(19.8, 18.7, 6, 0, ClientUtilities.PI2, false);
						context.fill();

						if(instanceTypes[j] == "stopped") {
							context.fillStyle = "#ff263c";

						} else if(instanceTypes[j] == "licensed") {
							context.fillStyle = "#835acc";
						}
					}

					var iconPath2d = new Path2D(AriesIconPath.icon[instanceTypes[j]]);
					context.fill(iconPath2d);

					iconGroup["instance_" + instanceTypes[j]] = context.canvas;
				}
			} else {
				if(modelTypes[i] === "db" || modelTypes[i] === "externalcall") {
					for(var j=0; j<etcTypes.length; j++) {
						var context = document.createElement('canvas').getContext('2d');
						context.canvas.width = iconSize * devicePixelRatio;
						context.canvas.height = iconSize * devicePixelRatio;

						context.scale(ratioForIconSize * devicePixelRatio, ratioForIconSize * devicePixelRatio);

						//DB와 ExternalCall은 블루계열의 색상이 필요하다.
						if(etcTypes[j] === "alone") {
							context.fillStyle = "#4798e1";
						} else {
                            context.fillStyle = "#4798e1";
						}

						context.fill(path2d);

						iconGroup[modelTypes[i]+"_"+etcTypes[j]] = context.canvas;
					}
				} else {
					var context = document.createElement('canvas').getContext('2d');
					context.canvas.width = iconSize * devicePixelRatio;
					context.canvas.height = iconSize * devicePixelRatio;

					context.scale(ratioForIconSize * devicePixelRatio, ratioForIconSize * devicePixelRatio);


					context.fillStyle = "#ffffff";


					context.fill(path2d);

					iconGroup[modelTypes[i]] = context.canvas;
				}


			}
		}

		//icon noAuth
		var iconContext = document.createElement('canvas').getContext('2d');
		iconContext.canvas.width = iconSize * devicePixelRatio;
		iconContext.canvas.height = iconSize * devicePixelRatio;

		iconContext.scale(ratioForIconSize * devicePixelRatio, ratioForIconSize * devicePixelRatio);

		var iconPath2d = new Path2D(AriesIconPath.icon.noAuth);

		iconContext.fillStyle = "#101010";
		iconContext.fill(iconPath2d);

		iconGroup["icon_noauth"] = iconContext.canvas;

		return iconGroup;
	},
    /**
     * 토폴로지와 이벤트차트에서 사용할 아이콘들을 path로 조합해서 이미지를 생성한다.
     * @param iconSize
     * @returns {{}}
     */
    getIconSVGGroup : function(iconSize) {
        var devicePixelRatio = window.devicePixelRatio || 1;
        var ratioForIconSize = iconSize / AriesIconPath.size;

        var iconGroup = {};
        var modelTypes = _.keys(AriesIconPath.model);

        var instanceTypes = ["www", "stopped", "licensed"];
        var etcTypes = ["alone", "child"];

        //기본 모델들.
        for(var i=0; i<modelTypes.length; i++) {

            //var path2d = new Path2D(AriesIconPath.model[modelTypes[i]]);
            if(modelTypes[i] === "instance") {
                //instance는 www, stopped, licensed 3개가 추가로 포함된다.
                for(var j=0; j<instanceTypes.length; j++) {

                    var context = document.createElement('canvas').getContext('2d');
                    context.canvas.width = iconSize * devicePixelRatio;
                    context.canvas.height = iconSize * devicePixelRatio;

                    context.scale(ratioForIconSize * devicePixelRatio, ratioForIconSize * devicePixelRatio);

					(function (context, self, instanceTypes, j) {
						context.fillStyle = "#FFFFFF";
                        self.getImageSVGIcon(AriesIconPath.model[modelTypes[i]], iconSize, context.fillStyle, function (img) {

                            context.drawImage(img, 0, 0, AriesIconPath.size, AriesIconPath.size);

                            if(instanceTypes[j] != "www") {

                                //stop, license 아이콘 표시 전에 배경 그려주기.
                                context.beginPath();
                                context.arc(19.8, 18.7, 6, 0, ClientUtilities.PI2, false);
                                context.fill();

                                if(instanceTypes[j] == "stopped") {
                                    context.fillStyle = "#ff263c";

                                } else if(instanceTypes[j] == "licensed") {
                                    context.fillStyle = "#835acc";
                                }
                            } else {
                                context.fillStyle = "#ffffff";
                            }

                            self.getImageSVGIcon(AriesIconPath.icon[instanceTypes[j]], iconSize, context.fillStyle, function (img2) {
                                context.drawImage(img2, 0, 0, AriesIconPath.size, AriesIconPath.size);
                            });

                        });
                    })(context, this, instanceTypes, j);

                    iconGroup["instance_" + instanceTypes[j]] = context.canvas;
                }
            } else {
                if(modelTypes[i] === "db" || modelTypes[i] === "externalcall") {
                    for(var j=0; j<etcTypes.length; j++) {
                        var context = document.createElement('canvas').getContext('2d');
                        context.canvas.width = iconSize * devicePixelRatio;
                        context.canvas.height = iconSize * devicePixelRatio;

                        context.scale(ratioForIconSize * devicePixelRatio, ratioForIconSize * devicePixelRatio);
                        //DB와 ExternalCall은 블루계열의 색상이 필요하다.
                        if(etcTypes[j] === "alone") {
                            context.fillStyle = "#4798e1";
                        } else {
                            context.fillStyle = "#ffffff";
                        }

						(function (context, self) {
                            self.getImageSVGIcon(AriesIconPath.model[modelTypes[i]], iconSize, context.fillStyle, function (img) {
								context.drawImage(img, 0, 0, AriesIconPath.size, AriesIconPath.size);
                            });
						})(context, this);

                        iconGroup[modelTypes[i]+"_"+etcTypes[j]] = context.canvas;
                    }
                } else {
                    var context = document.createElement('canvas').getContext('2d');
                    context.canvas.width = iconSize * devicePixelRatio;
                    context.canvas.height = iconSize * devicePixelRatio;

                    context.scale(ratioForIconSize * devicePixelRatio, ratioForIconSize * devicePixelRatio);


                    context.fillStyle = "#ffffff";

                    (function (context, self) {
                        self.getImageSVGIcon(AriesIconPath.model[modelTypes[i]], iconSize, context.fillStyle, function (img) {
                            context.drawImage(img, 0, 0, AriesIconPath.size, AriesIconPath.size);
                        });
                    })(context, this);


                    iconGroup[modelTypes[i]] = context.canvas;
                }


            }
        }

        //icon noAuth
        var iconContext = document.createElement('canvas').getContext('2d');
        iconContext.canvas.width = iconSize * devicePixelRatio;
        iconContext.canvas.height = iconSize * devicePixelRatio;

        iconContext.scale(ratioForIconSize * devicePixelRatio, ratioForIconSize * devicePixelRatio);
        iconContext.fillStyle = "#101010";

        (function (context, self) {
            self.getImageSVGIcon(AriesIconPath.icon.noAuth, iconSize, context.fillStyle, function (img) {
                context.drawImage(img, 0, 0, AriesIconPath.size, AriesIconPath.size);
                iconGroup["icon_noauth"] = context.canvas;
            });
        })(iconContext, this);

        return iconGroup;
    }
};

var ChartStyle = {
	//window.user.language
	"chart_background_color" : "rgb(255,255,255)",
	"chart_title_color" : "rgb(0,0,0)",
	"chart_title_font" : "bold 12px Arial",
	"chart_legend_font" : "11px Arial",
	"chart_axis_color" : "rgb(191,191,191)",
	"chart_axis_font" : "11px Arial",
	"chart_value_font" : "bold 11px Arial",
	"chart_bubble_value_font" : "bold 24px Arial",
	"chart_bubble_vertical_value_font" : "bold 18px Arial",
	"chart_axis_font_color" : "rgb(167, 167, 167)",
	"chart_axis_circle_color" : "rgb(217, 217, 217)",
	"chart_dashedline_color" : "rgb(234, 234, 234)",
	"chart_dashedfill_color" : "rgb(247, 247, 247)",
	"chart_area_yesterday_color" : "rgb(146, 146, 146)",
	"chart_area_today_color" : "rgb(255, 120, 0)"
};


var EqualizerASColor = [["#8cc9f3","#69acdc"], ["#bde160","#a7ca4e"], ["#FFB750","#F2923C"], ["#F75E70","#D74959"]];
var EqualizerCPUColor = [["#72C7C2","#65B6B0"], ["#FF9742","#FE7A0D"], ["#FFDE01","#FFC600"], ["#B8C7DE","#A1B0C7"]];

//var EqualizerASColor = { first:["#8cc9f3","#69acdc"], second:["#bde160","#a7ca4e"], third:["#FFB750","#F2923C"], forth:["#F75E70","#D74959"]};
//var EqualizerCPUColor = { first:["#72C7C2","#65B6B0"], second:["#FF9742","#FE7A0D"], third:["#FFDE01","#FFC600"], forth:["#B8C7DE","#A1B0C7"]};
var RespTimeColor = { sql:["#73C6BC", "#6AB1B3"], tx:["#7293C9", "#6684BA"], service:["#917CCB", "#826AC0"]};
window.xSocket = function(url, passcheckKeepAlive) {
    this.url = url;


	this.reconnectCount = 0;
    this.socket;

	//send와 callback받을시에 다 체크하여 lastAccessTime을 갱신한다.
	this.lastAccessTime;

	//서버의 keepAliveTime은 5분이지만 화면에서는 아래값으로 정한다.
	//10초
	//this.keepAliveTime = 10 * 1000;
	//60초로 변경함.
	//this.keepAliveTime = 60 * 1000;
	//keepAliveTime을 체크하지 않기 위해 -1로 지정한다.
	this.keepAliveTime = -1;
	//패스라면 -1 세팅
	if(passcheckKeepAlive) {
		this.keepAliveTime = -1;
	}

	this.intervalId;
	this.onOpenCallback;
	this.onCloseCallback;
	this.onMessageCallback;


	//의도적으로 소켓을 끊은 경우에 사용함.
	this.NORMAL_CASE_CLOSECODE = 3200;

	this.RECONNECT_CASE_CLOSECODE = 3300;

	this.wsProtocol = (location.protocol === "https:") ? "wss://" : "ws://";

	this.lastCloseCode;

};

xSocket.prototype = {
	init : function() {
		var that = this;

		that.reconnectCount++;

		if ("WebSocket" in window) {
			this.socket = new WebSocket(that.wsProtocol + window.location.host + this.url);
		} else if (window.MozWebSocket) {
			this.socket = new MozWebSocket(that.wsProtocol + window.location.host + this.url);
		}

		this.socket.onopen = function(event) {
			if(!_.isUndefined(that.onOpenCallback)) {
				that.onOpenCallback();
			}

			console.log("websocket create "+this.url);

		};

		this.socket.onerror = function(errorEvent) {

		};

		this.socket.onclose = function(closeEvent) {
			//CloseEvent code
			//https://developer.mozilla.org/en-US/docs/Web/API/CloseEvent?redirectlocale=en-US&redirectslug=WebSockets%2FWebSockets_reference%2FCloseEvent#Status_codes

			//현재 화면에서 소켓을 사용하고 있는 경우만 생성해서 써야 timeout 을 잡을수 있다.

			//의도적으로 소켓을 끊은경우는 재성성하지 않는다.
			if ( closeEvent.code == that.RECONNECT_CASE_CLOSECODE) {
				if(!_.isUndefined(that.onCloseCallback)) {
					that.onCloseCallback(/*done*/function() {
                        that.init();
					});
				} else {
					that.init();
				}

			} else if(closeEvent.code !== that.NORMAL_CASE_CLOSECODE) {
				if(!_.isUndefined(that.onCloseCallback)) {
					that.onCloseCallback(/*done*/function() {
                        setTimeout(function (){
                            that.init();
                        }, 10 * 1000);
					});
				} else {
                    setTimeout(function (){
                        that.init();
                    }, 10 * 1000);
				}



                //1006인 경우는 크게 2가지가 있다.
                //1. 뷰서버가 다운된 경우, 네트워크 연결이 끊긴 경우
                //2. 외부(Proxy, 보안, 방화벽)때문에 차단된 경우...
                if(closeEvent.code === 1006) {
                    $.ajax({
						url: "/heartbeat/ping",
						success: function() {
							AriesServerConnectCheck.requestCannotConnect(AriesServerConnectCheckStatusCode.EXTERNAL_PROBLEM);
						},
						error: function() {
							AriesServerConnectCheck.requestCannotConnect(AriesServerConnectCheckStatusCode.SERVERDOWN_OR_NETWORKFAIL);
						}
					})

                }
			}


			console.log("websocket close "+this.url);
			console.log("websocket close code " + closeEvent.code);


			that.lastCloseCode = closeEvent.code;

		};


		this.socket.onmessage = function(message) {
			that.lastAccessTime = Date.now();

			if(!_.isUndefined(that.onMessageCallback)) {
				that.onMessageCallback(message);
			}
		};
    },

    /**
	 * TODO socket.readyState 값이 0(CONNECTING)일때 close 하면 closeCode가 1006으로 떨어진다.
	 *
     * @param msg
     */
	reconnect : function (msg) {

		// 4000 : restart
		this.socket.close(this.RECONNECT_CASE_CLOSECODE, msg);

		// 연결 종료 후 close 이벤트가 발생하면 socket 을 다시 연결한다.
	},

    send : function(param) {
    	try {
			this.lastAccessTime = Date.now();
	    	this.socket.send(param);
    	} catch (e){
    		console.log('xSocket send error');
			console.log(e);
    	}
    },

    getJSON : function(e) {
    	var data;

    	if(e && e.data) {
    		data = JSON.parse(e.data);
    	}

    	return data;
    }
};

// domain, agent, business 를 관리하기 위한  ID 클래스
var ID = function (sid, otype, oid) {
	if (arguments.length == 1) {
		this.sid = +(sid || 0);
		this.otype = OTypeDef.SYSTEM;
		this.oid = 0;
	} else if (arguments.length == 3) {
		this.sid = +(sid || 0);
		this.otype = +(otype || 0);
		this.oid = +(oid || 0);
	}

	this.sid = this.sid || 0;
	this.otype = this.otype || 0;
	this.oid = this.oid || 0;
}

ID.prototype.getSid = function () {
	return this.sid;
}

ID.prototype.getOtype = function () {
	return this.otype;
}

ID.prototype.getOid = function () {
	return this.oid;
}

ID.prototype.toString = function () {
	return ['', this.sid, this.otype, this.oid ].join('/');
}

ID.domain = function (sid) {
	return new ID(sid).toString();
}

ID.agent = function (sid, oid) {
	if (ID.hasStringId(oid)) return oid;

	return new ID(sid, OTypeDef.SYSTEM, oid).toString();
}

ID.business = function (sid, oid) {
    if (ID.hasStringId(oid)) return oid;

	return new ID(sid, OTypeDef.BUSINESS, oid).toString();
}

ID.parse = function (id) {
	var arr = id.split("/");
	return new ID(arr[1], arr[2], arr[3]);
}
// 도메인 인지 체크하기
ID.isDomain = function (id) {
	var obj = ID.parse(id);

	return obj.sid && obj.otype == OTypeDef.SYSTEM && obj.oid == 0;
}

ID.hasStringId = function (id) {
	return typeof id == 'string' && id.indexOf("/") == 0;
}

function CallAnimation(timestamp) {
    aries.emit("requestAniFrame", [timestamp]);
    window.globalRequestAniFrameStatus = window.requestAniFrame(CallAnimation_1);
}
function CallAnimation_1(timestamp) {
    aries.emit("requestAniFrame", [timestamp]);
    window.globalRequestAniFrameStatus = window.requestAniFrame(CallAnimation_2);
}
function CallAnimation_2(timestamp) {
    aries.emit("requestAniFrame", [timestamp]);
    window.globalRequestAniFrameStatus = window.requestAniFrame(CallAnimation_3);
}
function CallAnimation_3(timestamp) {
    aries.emit("requestAniFrame", [timestamp]);
    window.globalRequestAniFrameStatus = window.requestAniFrame(CallAnimation_4);
}
function CallAnimation_4(timestamp) {
    aries.emit("requestAniFrame", [timestamp]);
    window.globalRequestAniFrameStatus = window.requestAniFrame(CallAnimation);
}

// request animation frame 을 단독으로 이벤트 정의해서 돌림
window.globalRequestAniFrameStatus = window.requestAniFrame(CallAnimation);

////////////////////////////////////////////////////////////


var aries = window.aries = aries || {};

// TODO: 호환성 체크를 위한 글로벌 변수 참조 설정
//window.jennifer = aries;

// aries cache
aries.cache = {
	store : {},
	emptyString : "",
	emptyArray : [],
	zero : (0 | 0),
	zeroString : "0",
	image : { 	},
	txid : []
}

aries.init = function () {
	this.cache.txid = [];
	this.cache.txid2 = [];
}

aries.setTxid = function (str) {
	var index = this.cache.txid.length;

    var a = Number.parseLong(str);

	this.cache.txid[index]= a.h;
	this.cache.txid2[index]= a.l;

	return index;
}

aries.getTxid = function (index) {
	return this.cache.txid[index] + '' + ('000000' + this.cache.txid2[index]).substr(-6);
}

aries.set = function (name, value) {
	aries.cache.store[name] = value;
	aries.emit('set.' + name);
}

aries.get = function (name) {
	return aries.cache.store[name];
}

aries.hasCache = function (name) {
	return (typeof aries.cache.store[name] != undefined);
}

aries.deprecated = function (msg) {
	console.warn("Do not use it anymoore.", msg);
}

// custom 이벤트 로직 구현
// handler 를 등록하지 않는다.
// 모든 것은 이벤트로 제어한다.
// 핸들러 관리하는 개념이 여러개로 흩어지면 안된다.
// 이벤트 이름은  각각의   class.method  명으로 한다.
// 예를 들어   aries.manager.element 클래스의 select method 는
// aries.emit("aries.manager.element:select")  이벤트를 발생시킨다.
aries.events = {};
aries.on = function (name, func, context, options) {
	var handlers = aries.events[name] || (aries.events[name] = []);
	handlers.push({ callback : func, context : context, options : options || { once : false } });
	return func;
};

aries.has = function (name) {
	return !!aries.events[name];
}

aries.once = function (name, func, context) {
	return aries.on(name, func, context, { once : true });
};



aries.off = function (name, func) {
	if (arguments.length == 0) {
		aries.events = {};
	} else if (arguments.length == 1) {
		aries.events[name] = [];
	} else if (arguments.length == 2) {
		var handlers = aries.events[name] || [];

		var newHandlers = [];
		for(var i = 0, len = handlers.length; i < len; i++) {
			if (handlers[i].callback == func) {
				continue;
			}

			newHandlers.push(handlers[i]);
		}

		aries.events[name] = newHandlers;
	}
}

aries.emit = function (name, args) {
	var handlers = aries.events[name] || [];

	if (handlers.length == 0) {
		return; 
	}
	args = args || [];
	var onceList = [];
	for(var i = 0, len = handlers.length; i < len; i++) {
		var h = handlers[i];
		h.callback.apply(h.context, args);

		if (h.options.once) {
			onceList.push(i);
		}
	}

	for(var i = 0, len = onceList.length; i < len; i++) {
		aries.off(name, handlers[onceList[i]].callback);
	}
};

aries.chart = { gcount : 0 };

aries.chart.builder = aries.chart.builder || {};

aries.chart.builder.table = aries.chart.builder.table || {};
aries.chart.builder.tree = aries.chart.builder.tree || {};

aries.chart.table = aries.chart.table || {};
aries.chart.tree = aries.chart.tree || {};

aries.loader = function (ns) {
    var parts = ns.split('.'),
        parent = aries,
        i;

    if (parts[0] === 'aries') {
        parts = parts.slice(1);
    }
    
    for (i = 0; i < parts.length; i += 1) {
        if (typeof parent[parts[i]] === 'undefined') {
            parent[parts[i]] = {};
        }
        
        parent = parent[parts[i]];
    }

    return parent;
};

aries.chart.builder.loader = function (charttype) {
    var builder = aries.loader('chart.builder.' + charttype);
    
    return builder;
};

aries.chart.builder.update = function (chart) {
	if(!chart.intervalId) {
		var builder = aries.loader('chart.builder.' + chart.chartType); 
		
		builder.update(chart);
	}
};

aries.chart.call = (function(ctx) {

    var _$C = ctx.chart;
	var currentSid = null,
    outer_realtime_callback_list = [],
    bigdata_other_callback = null,
    bigdata_other_msgCallback,
	realtimeWS,
	bigdataWS,
	topologyWS;
	

	var realtimeSocketInit = function() {
		if(_.isUndefined(realtimeWS)) {
			realtimeWS = new xSocket('/ws/realtime');
			realtimeWS.onOpenCallback = function() {
				var domainBarSyncSid = aries.manager.element.getSelectedDomainSidList();

				//domainAgentList, (domainList, agentList)
				var domainRequestInfos = aries.chart.loader.domainRequestInfo();
				for(var i=0, max=domainRequestInfos.length; i<max; i++) {
					aries.chart.call.realtimeSend(JSON.stringify(domainRequestInfos[i]));
				}

				var realtimeCharts = aries.chart.loader.realtimeCharts();
				for(var i=0, max=realtimeCharts.length; i<max; i++) {
					var chart = realtimeCharts[i],
						model = chart.getModel();

					if(model) {
						sendByRealtimeChart(model, domainBarSyncSid);
					}
				}

                // 공유 객체에 대해서 socket 이 재연결 되었을 때  다시 데이타 요청을 할 수 있도록 구조를 맞춘다.
                //aries.chart.model.equalizer.shared.setDataTrans(false);
                //aries.chart.model.ratebysectionshared.setDataTrans(false);

				checkRealtimeSharedModelAfterSends();
			};

			realtimeWS.onCloseCallback = function(done) {
				var realtimeCharts = aries.chart.loader.realtimeCharts();
				for(var i=0, max=realtimeCharts.length; i<max; i++) {
					var chart = realtimeCharts[i],
						model = chart.getModel();

					if(model && model.initDataIfSnapShot) {
						model.initDataIfSnapShot();
					}
				}

				//액티브서비스 데이터 초기화.
				aries.chart.model.equalizer.shared.initAllData();
				aries.chart.model.ratebysectionshared.initAllData();

				// 이전에 날린 요청이 있으면 모두 삭제한다.
                aries.chart.model.equalizer.shared.clearRequestTimer();
                aries.chart.model.ratebysectionshared.clearRequestTimer();

                // 공유 객체에 대해서 socket 이 재연결 되었을 때  다시 데이타 요청을 할 수 있도록 구조를 맞춘다.
                aries.chart.model.equalizer.shared.setDataTrans(false);
                aries.chart.model.ratebysectionshared.setDataTrans(false);

                // 완료 시점 callback
                done && done();
            };


			realtimeWS.onMessageCallback = realtimeWS_callback;
			realtimeWS.init();

			return true;
		}

		return false;
	};

	var bigdataSocketInit = function(paramBigdataOpenCallback) {
		if(_.isUndefined(bigdataWS)) {
			bigdataWS = new xSocket('/ws/bigdata');
			bigdataWS.onOpenCallback = function() {
				this.socket.binaryType = "arraybuffer";

				var multiSid = aries.manager.element.getSelectedDomainSidList();

				aries.emit("bigdataSocketInit:send");

				var bigdataCharts = aries.chart.loader.bigdataCharts();
				for (var i = 0, max = bigdataCharts.length; i < max; i++) {
					var cmdMap = bigdataCharts[i].getModel().cmdMap;

					//토폴로지에 들어가있는 xview 초기 요청이 없다.
					if (bigdataCharts[i].includeTopology) {
						continue;
					}

					if(cmdMap.domainBarSync) {
						for (var j = 0, len = multiSid.length; j < len; j++) {
							var sid = multiSid[j];

							bigdataCharts[i].model.send(sid);
						}
					} else {
						if(cmdMap.sid && cmdMap.sid.length > 0) {
							for(var sidIndex = 0, len = cmdMap.sid.length; sidIndex < len; sidIndex++) {
								var sid = cmdMap.sid[sidIndex];
								bigdataCharts[i].model.send(sid);
							}
						}
					}
				}

				//xview분석의 조회 때문에 추가함.
				//aries.chart.xviewanalysis.js에서 사용한다.
				if(!_.isUndefined(paramBigdataOpenCallback)) {
					paramBigdataOpenCallback();
				}
			};

			bigdataWS.onCloseCallback = function(done) {
				//console.log("bigdata websocket close");
                // 완료 시점 callback
                done && done();
			};
			bigdataWS.onMessageCallback = bigdataWS_callback;
			bigdataWS.init();

			return true;
		}

		return false;
	};

	var topologySocketInit = function() {
		if(_.isUndefined(topologyWS)) {
			topologyWS = new xSocket('/ws/topology');
			topologyWS.onOpenCallback = function() {
				var _topologyCharts = aries.chart.loader.topologyCharts();

				for(var i=0, max=_topologyCharts.length; i<max; i++) {
					_topologyCharts[i].model.send(aries.manager.element.getSelectedDomainSidList());
				}
			};

			topologyWS.onMessageCallback = topologyWS_callback;
			topologyWS.init();

			return true;
		}

		return false;
	};

	var sendByRealtimeChart = function(model, domainBarSyncSid) {
		//제외되야 하는 모델들.
		//아래쪽에 스피드바, 스피드미터가 존재한다면 공통으로 요청하는 코드가 있다.
		if(model instanceof AriesChartFlowModel){
			//continue;
			return;
		}

		//구간 액티브서비스 데이터도 공통으로 요청한다.
		if(model instanceof AriesChartEqModel){
			var pkey = model.cmdMap.pkey;
			if(pkey === "active_service" || pkey === "active_sql") {
				//continue;
				return;
			}
		}


		if(model.cmdMap.domainBarSync) {
			aries.chart.loader.sendCalc(domainBarSyncSid, model);
		} else {
			aries.chart.loader.sendCalc(model.cmdMap.sid, model);
		}
	};

	var getDomainIdList = function () {
		var realtimeCharts = aries.chart.loader.realtimeCharts();
		// 리얼타임 차트에 들어있는 모든 모델에 대해서 sid  리스트를 구한다.
		var sids = [];
		for(var i = 0, len = realtimeCharts.length; i < len; i++) {
			var chart = realtimeCharts[i];
			var cmdMap = chart.getModel().cmdMap;
			if (!cmdMap.domainBarSync) {
				sids = sids.concat(cmdMap.sid);
			} else {
				sids = sids.concat(aries.manager.element.getSelectedDomainSidList());
			}
		}

		// 도메인 개수를 unique 하게 맞춘다.
		sids = _.uniq(sids);

		return sids;
	}

	var getDomainIdListForRateSectionSharedModel = function () {
		var realtimeCharts = aries.chart.loader.realtimeCharts();
		// speedmeeter, speedbar 에 대한 sid 만 수집한다. 
		var sids = [];
		for(var i = 0, len = realtimeCharts.length; i < len; i++) {
			var chart = realtimeCharts[i];
			var cmdMap = chart.getModel().cmdMap;
			var charttype = chart.chartType;

			if (charttype == 'speedvertical' || charttype == 'speedhorizon') {
				if (!cmdMap.domainBarSync) {
					sids = sids.concat(cmdMap.sid);
				} else {
					sids = sids.concat(aries.manager.element.getSelectedDomainSidList());
				}
			}
		}

		// 도메인 개수를 unique 하게 맞춘다.
		sids = _.uniq(sids);

		return sids;
	}

	var checkRealtimeSharedModelAfterSends = function() {

		//
		// 현재는 모든 도메인에 대한 데이타를 다 요청하는 데
		// 도메인 그룹이 되면 선택되어진 도메인 그룹과
		// 개별 차트별로 사용되는 sid 를 수집해서 보내야한다.
		// 아니면 너무 많은 도메인에 데이타를 조회해야한다.

		var _sharedEqActiveServiceModel = aries.chart.model.equalizer.shared,
			_sharedRateByModel = aries.chart.model.ratebysectionshared;

		// INFO: 여기서는 무조건 sid 리스트를 기준으로 날린다.

		//구간 액티브서비스 데이터를 공통으로 요청하는 코드(active_service, active_sql)
		if(_sharedEqActiveServiceModel.exist() && !_sharedEqActiveServiceModel.isDataTrans()) {
			_sharedEqActiveServiceModel.requestData();
		}

		//스피드바, 스피드미터가 존재한다면 공통으로 요청하는 코드
		//arrivalRate,rejectRate,serviceRate(0,1,3,8)
		if(_sharedRateByModel.exist() && !_sharedRateByModel.isDataTrans()) {
			_sharedRateByModel.requestData();
		}
	};

	var realtimeSend = function(cmd) {
		if(realtimeWS && realtimeWS.socket.readyState == 1) {
			realtimeWS.send(cmd);
		} else {
			/*
			setTimeout(function(){
				realtimeSend(cmd);
			}, 1000);
			return;
			*/
		}
	};

	//토폴로지에서 사용하는 xview 소켓의 경우는 close체크를 하지 말아야한다.
	var bigdataSend = function(cmd) {
		if(bigdataWS && bigdataWS.socket.readyState == 1) {
			bigdataWS.send(cmd);
		} else {
			//주석 처리가 되면 xview조회시 호출순서를 바꿔야 한다.
			/*
			setTimeout(function(){
				bigdataSend(cmd);
			}, 1000);
			return;
			*/
		}
	};

	var topologySend = function(cmd) {
		if(topologyWS && topologyWS.socket.readyState == 1) {
			topologyWS.send(cmd);
		} else {
			/*
			setTimeout(function(){
				topologySend(cmd);
			}, 1000);
			return;
			*/
		}
	};


	var realtimeWSClose = function() {
		if(!_.isUndefined(realtimeWS)) {
			//close code 1000은 무시함.
			realtimeWS.socket.close(realtimeWS.NORMAL_CASE_CLOSECODE);
			realtimeWS = undefined;
		}
	};

	//XView 분석에서 조회후 소켓을 닫을때 필요하다.
	var bigdataWSClose = function() {
		if(!_.isUndefined(bigdataWS)) {
			//close code 1000은 무시함.
			bigdataWS.socket.close(bigdataWS.NORMAL_CASE_CLOSECODE);
			bigdataWS = undefined;
		}
	},

    
    process = function(list, _callback, _done) {
        if(list) {
        	if(_.isArray(list)) {
				for (var i=0, max = list.length; i<max; i++) {
                    var data = list[i].data;
                    
                    _callback(data, i);
                }
        	} else {
        		_callback(list, i);
        	}

			_done && _done();

        }
    },
    
    
    realtimeWS_callback = function(e) {
    	var json = realtimeWS.getJSON(e);

		if(json) {
			// 데이타가 오면 무조건 domain handler 를 업데이트 시킨다.

			for(var i=0, max=outer_realtime_callback_list.length; i<max; i++) {
				(function (model, json) {
					model.callback(json);
				})(outer_realtime_callback_list[i], json);
			}


			if (_.isArray(json)) {
				for (var i=0; i<json.length; i++) {
					var data = json[i];
					if(data) {
						var _charts = _$C.loader.realtimeCharts();
						for(var j = 0, max = _charts.length; j < max; j++) {
							var chart = _charts[j],
								model = chart.getModel();

							if(model.callback)	{
								model.callback(data);
							}
						}
					}
				}
			} else {
				var dataKey = Object.keys(json)[0];

				if (dataKey) {
					aries.emit("load." + dataKey, [json]);
				}
			}

		}
	},
	bigdataWS_callback = function(e) {

	 	if(e.data instanceof ArrayBuffer) {
			var buffer = e.data,
		  	dataView = new DataView(buffer),
			chartKeyLength = dataView.getInt16(0),
			chartKey = dataView.getString(2, chartKeyLength),
			offset = 2 + chartKeyLength;

			aries.emit('chart.data.' + chartKey, [ dataView, offset ] );

		  	if(bigdata_other_callback) {
			  	bigdata_other_callback(dataView, offset);
		  	}

	  	} else {
            //과거에 x-vie 150만건 제한 같은 msg 전달용도로 사용했었음..
            //지금은 쓰지 않는다.
		  	var msgObj = JSON.parse(e.data);

		  	if(bigdata_other_msgCallback) {
			  	bigdata_other_msgCallback(msgObj);
		  	}
	  	}
    },
    
    topologyWS_callback = function(e) {
    	var json = topologyWS.getJSON(e);

        if(json) {
        	var _charts = _$C.loader.topologyCharts();
        	for(var i = 0, max = _charts.length; i < max; i++) {
			  var chart = _charts[i];
	        	
			  if(chart.getModel().callback)	{
				  chart.getModel().callback(json);
			  }
        	}
        	
        }
    },
    
    bigdata_callback_handler = function(handler) {
    	bigdata_other_callback = handler;
    },
    
    bigdata_msgCallback_handler = function(handler) {
    	bigdata_other_msgCallback = handler;
    },
    
    add_outer_realtime_callback_list = function(callback) {
    	outer_realtime_callback_list.push(callback);
    },
    
    command = function(_domain, _cmdMap, cmd) {
    	if(_domain) {
    		if(_domain.selectedList().length > 0) {
    			if(_domain.selectedList().length === 1){
    				if(currentSid && currentSid !== 'default' && currentSid !== _domain.selectedList()[0]) {
    					_clearData();
    				}
    				
    				currentSid = _domain.selectedList()[0];
    			}
    			
    		    _cmdMap.sid = _domain.selectedList();
    		    
    		    _$C.loader.set(_domain.selectedList());
    		} else {
    			if(_domain.defaultDomain().length === 1){
    				if(currentSid && currentSid !== _domain.defaultDomain()[0]) {
    					_clearData();
    				}
    				
    				currentSid = _domain.defaultDomain()[0];
    			}
    			
    			_cmdMap.sid = _domain.defaultDomain();
    			
    			_$C.loader.set(_domain.defaultDomain());
    		}
    	}
    	
    	if(cmd) {
	    	if(cmd.mxid) _cmdMap.mxid = cmd.mxid;
	    	if(cmd.oid) _cmdMap.oid = cmd.oid;
	    	if(cmd.ptype) _cmdMap.ptype = cmd.ptype;
    	}
    	
    	return _cmdMap;
    },

	reconnect = function (msg) {

		//console.log('reconnect when domain tree has selected');

		// 1. 모델을 지우고 (모델을 클리어 할 때 기존에 남아있던 send callback 을 모두 삭제한다. ) 
		aries.chart.loader.clear();

		// 다시 연결한다.
		if (realtimeWS) realtimeWS.reconnect(msg);
		if (bigdataWS) bigdataWS.reconnect(msg);
		if (topologyWS) topologyWS.reconnect(msg);
	},

    
    _clearData = function() {
        var _loaded = _$C.loader.loaded();
        for(var i = 0, max = _loaded.length; i < max; i++) {
        	_loaded[i].clear();
        }
    };
    
    return {
        process: process,
		realtimeSocketInit: realtimeSocketInit,
		bigdataSocketInit: bigdataSocketInit,
		topologySocketInit: topologySocketInit,
		sendByRealtimeChart: sendByRealtimeChart,
		checkRealtimeSharedModelAfterSends: checkRealtimeSharedModelAfterSends,
		realtimeSend: realtimeSend,
        bigdataSend: bigdataSend,
        topologySend: topologySend,
		realtimeWSClose: realtimeWSClose,
		bigdataWSClose: bigdataWSClose,
		getDomainIdList : getDomainIdList,
		getDomainIdListForRateSectionSharedModel: getDomainIdListForRateSectionSharedModel,
		command: command,
		reconnect : reconnect,
		bigdata_callback_handler: bigdata_callback_handler,
		bigdata_msgCallback_handler: bigdata_msgCallback_handler,
		add_outer_realtime_callback_list: add_outer_realtime_callback_list
	};
}(aries));

aries.chart.loader = (function(ctx) {
    var _$C = ctx.chart,
    	_$C_BUILDER = ctx.chart.builder,
    	_domainHander,
        _animationId,
        _isMultiDomain = false,
        _isSendBigdata = false,
        _mapInfo = [],
		_dashboardChartsProp,
		_dashboardType,
		_activeService = {},
        _realtimeCharts = {},
        _bigdataCharts = {},
        _topologyCharts = [];
    
    init = function(dom, isAutoCloseLoading) {
    	_domainHander = aries.manager.domain;
    	
    	if(dom) {
    		_scan(dom);
    	}

		socketUseCheckInit();

    	aries.ui.showLoading();
    	
    	if(!isAutoCloseLoading) {
    		setTimeout(function(){ 
            	aries.ui.closeLoading();
            }, 2000);
    	}
        
        
        return this;
    },

	redefineStringToVariable = function(dashboardProp) {
		var domainBarProp = dashboardProp.domainBar,
			charts = dashboardProp.charts;

		if(!_.isUndefined(domainBarProp) && typeof domainBarProp.batchjobMode === 'string') {
			var classNProp = domainBarProp.batchjobMode.split(".");

			if(classNProp[0] === "DomainBarBatchjobModeDef") {
				dashboardProp.domainBar.batchjobMode = DomainBarBatchjobModeDef[classNProp[1]];
			}
		}

		for(var i=0, len = charts.length; i<len; i++) {
			var chart = charts[i];

			if(!_.isUndefined(chart.metrics) && typeof chart.metrics === 'string') {
				var classNProp = chart.metrics.split(".");

				if(classNProp[0] === "MxDef") {
					chart.metrics = MxDef[classNProp[1]];
				}
			}

			if(!_.isUndefined(chart.metricsmax) && typeof chart.metricsmax === 'string') {
				var classNProp = chart.metricsmax.split(".");

				if(classNProp[0] === "MxDef") {
					chart.metricsmax = MxDef[classNProp[1]];
				}
			}



			if(!_.isUndefined(chart.otype) && typeof chart.otype === 'string') {
				var classNProp = chart.otype.split(".");

				if(classNProp[0] === "OTypeDef") {
					chart.otype = OTypeDef[classNProp[1]];
				}

			}

			if(!_.isUndefined(chart.ptype) && typeof chart.ptype === 'string') {
				var classNProp = chart.ptype.split(".");

				if(classNProp[0] === "PTypeDef") {
					chart.ptype = PTypeDef[classNProp[1]];
				}

			}

			//차트 타이틀 (코드->이름)
			if(!_.isUndefined(chart.i18nTitle)) {

				chart.title = i18n.get(chart.i18nTitle);
			}
		}

		return dashboardProp;
	}

	//domainBar를 생성한 후에 인스턴스개수에 따라 타입을 정한다.
	initDomainBar = function(domainBarProp, domains) {
		//http://issue.ariessoft.com/browse/ARIES-5851
		//해당 이슈에 배치잡에 해당하는 고민이 담겨있음.

		if(_.isUndefined(domainBarProp.batchjobMode) || domainBarProp.batchjobMode === "") {
			domainBarProp.batchjobMode = DomainBarBatchjobModeDef.BATCHJOB_EXCLUDE;
		}

		var defaultSid;

		if(domainBarProp.paramDomainId) defaultSid = Number(domainBarProp.paramDomainId);
		else {
			var domainIdSessionKey = (domainBarProp.batchjobMode === 1) ? "batchjobSid" : "sid";
			defaultSid = validCheckSid(domains, getSessionKeys(domainIdSessionKey), domainBarProp.batchjobMode);
		}

		//아래 메소드는 domain.tag에 있는걸 사용함. 나중에 리펙토링 해야함.
		initDomainBar(domains, domainBarProp.type, domainBarProp.multi, domainBarProp.batchjobMode, defaultSid, "");

		var uri = location.pathname;
		if(uri.indexOf("realtimeAdmin") > -1 || uri.indexOf("multiDomain") > -1) {
			var count = aries.manager.domain.list().length;
			if(count > 9) {
				_dashboardType = "extend";
			} else {
				_dashboardType = "origin";
			}
		} else {
			//개수에 따라 레이아웃 변경없는 대시보드는 무조건 origin이다.
			_dashboardType = "origin";
		}

	},

	//domainBar를 생성한 후에 인스턴스개수에 따라 타입을 정한다.
	initMultiDomainBar = function(domainBarProp) {

			// domainbar 기본 리스트는  aries.get("domains") 를 사용한다.

			if(_.isUndefined(domainBarProp.batchjobMode) || domainBarProp.batchjobMode === "") {
				domainBarProp.batchjobMode = DomainBarBatchjobModeDef.BATCHJOB_EXCLUDE;
			}

			initDomainBar(domainBarProp.type, domainBarProp.multidomain, domainBarProp.multiinstance, domainBarProp.batchjobMode, domainBarProp.sid, domainBarProp.oid, domainBarProp.userHeight || 0, domainBarProp.hide || false);


			_dashboardType = "origin";
	},

	initByProp = function(chartsProp) {
		_dashboardChartsProp = chartsProp;

		if (!chartsProp) return;

		var $defineContentArea = $("#defineContentArea");
		var $chartTpl = _.template($("#tpl_canvas_chart").html());

		for(var i=0; i<chartsProp.length; i++) {
			var chartOption = chartsProp[i];
			var dataKey = GenerateKey.makeLongKeyByTime();
			chartOption.dataKey = dataKey;
			if(chartOption.i18nTitle)
				chartOption.title = i18n.get(chartOption.i18nTitle);

			//차트 타이틀은 i18n.get으로 얻어와야함.
			$defineContentArea.append($chartTpl({ chart: chartOption}));

			//위에 initDomainBar가 호출되서 생성되어진 값.
			if(_.isUndefined(_dashboardType)) {
				//extend 전환이 없는 대시보드

			}

			var $chartDom = jQuery(".ariesChart[data-key='"+chartOption.dataKey+"']");
			var position = chartOption[_dashboardType];
			if(!_.isUndefined(position)) {
				$chartDom.attr("startx" , position.startx);
				$chartDom.attr("starty" , position.starty);
				$chartDom.attr("endx" , position.endx);
				$chartDom.attr("endy" , position.endy);
				fixedPositionAndSize($defineContentArea, $chartDom);
				initChart($chartDom);
			} else {
				$chartDom.css('display' , 'none');
				var chart = initChart($chartDom);
				chart.stopPaint();
			}
		}

		socketUseCheckInit();
	},

	changeDashboardLayout = function(newType) {
		if(_dashboardType !== newType) {
			_dashboardType = newType;

			var $defineContentArea = $("#defineContentArea");
			var chartsOption = _dashboardChartsProp || [];
			for(var i=0; i<chartsOption.length; i++) {
				var chartOption = chartsOption[i];

				var position = chartOption[newType],
					$chartDom = $(".ariesChart[data-key='"+chartOption.dataKey+"']"),
					chart = getChart(chartOption.dataKey);

				if(_.isUndefined(position)) {
					//차트 렌더링 중지
					chart.stopPaint();
					$chartDom.css("display", 'none');

				} else {
					//차트 렌더링 시작
					$chartDom.css("display", '');
					$chartDom.attr("startx" , position.startx);
					$chartDom.attr("starty" , position.starty);
					$chartDom.attr("endx" , position.endx);
					$chartDom.attr("endy" , position.endy);

					fixedPositionAndSize($defineContentArea, $chartDom);

					if(!chart.isPaint()) {
						chart.paint();
					}
				}

			}
		}
	},

	socketUseCheckInit = function() {
		var $JENNIFER_CHART_CALL = aries.chart.call;

		//상단바도 같이 체크..
		if(_.keys(_realtimeCharts).length > 0 || aries.manager.element.getSelectedDomainSidList().length > 0) {
			$JENNIFER_CHART_CALL.realtimeSocketInit();
		}

		if(_.keys(_bigdataCharts).length > 0) {
			$JENNIFER_CHART_CALL.bigdataSocketInit();
		}

		if(_topologyCharts.length > 0) {
			$JENNIFER_CHART_CALL.topologySocketInit();
		}

		aries.on('domain.tree.select', function () {
			// 모든 모델을 지우고
			aries.chart.loader.clear();

			// 연결을 끊는다.
			aries.chart.call.reconnect("domain.tree.select");
		})
	},
    
    multiDomain = function() {
    	_isMultiDomain = true;
    },
    
    initChart = function($chartDom) {
		/**
		 * $chartDom.attr() 의 마크업에서 뽑아 내는값이 특정 차트에서만 사용하는 것이라면 해당 buillder에서 처리함.
		 * ex) aries.chart.builder.scoreboard
		 */
    	var chart,
	    type,
	    charttype, mxid, mxidmax, otype, oid, ptype, pkey,
	    datatype, hosttype, legend, fixedmax, defaultmax, maxtype, timeunit, realtimeview, autorender, viewpoint, includetopology, disabledRangeChange,
		domainBarSync, optimized;
    	
    	type = $chartDom.attr('type');
		
		charttype = $chartDom.attr('charttype');
		mxid = $chartDom.attr('mxid');
		mxidmax = $chartDom.attr('mxidmax');
		otype = $chartDom.attr('otype');
		oid = $chartDom.attr('oid');
		ptype = $chartDom.attr('ptype');
		pkey = $chartDom.attr('pkey'); /* realtime handler 전용 키  */
		
		datatype = $chartDom.attr('datatype');
		hosttype = $chartDom.attr('hosttype');
		legend = $chartDom.attr('legend');
		fixedmax = $chartDom.attr('fixedmax');
		defaultmax = $chartDom.attr('defaultmax');
		maxtype = $chartDom.attr('maxtype');
		timeunit = $chartDom.attr('timeunit');
		realtimeview = $chartDom.attr('realtimeview');
		includetopology = $chartDom.attr('includetopology');
		disabledRangeChange = $chartDom.attr('disabledRangeChange');
		autorender = $chartDom.attr('autorender');
		viewpoint = $chartDom.attr('viewpoint');
		domainBarSync = $chartDom.attr('domainBarSync');  // domain 바 동기화
		optimized = $chartDom.attr('optimized');


		var	dataKey = $chartDom.attr('data-key');
		if(_.isUndefined(dataKey)) {
			dataKey = GenerateKey.makeLongKeyByTime();
			$chartDom.attr('data-key', dataKey);
		}

		//하나의 차트에 metrics이 다수가 포함되는 경우는 분기하여 처리해야한다. (스피드미터, 스피드바)
		var cmdMap = {};
		cmdMap.key = dataKey;
		cmdMap.mxid = mxid;
		cmdMap.mxidmax = mxidmax;
		cmdMap.otype = otype || OType.SYSTEM;

		if(domainBarSync === "true") {  // 도메인바 동기화 할 때 이렇게 들어감 .
			cmdMap.domainBarSync = true;
			if(aries.get('domainbar') && aries.get('domainbar').getType()  === "domain" && datatype == 'domain') {		// domain 일 때는 전체로
				cmdMap.oid = [OIDDef.TOT];
			} else {																					// 그렇지 않은 경우는 instance 전체 리스트로
				if (otype == OType.BUSINESS) {
					cmdMap.oid = [OIDDef.ALL_BIZ ];
				} else {
					cmdMap.oid = [OIDDef.ALL_INST ];
				}

			}

		} else {						// 도메인바 동기화 하지 않을 때  직접 oid, 랑 sid 를 설정해줌.
			cmdMap.domainBarSync = false;

			cmdMap.sid = $chartDom.attr('sid').split(',');

			if(oid !== "") cmdMap.oid = oid.split(',');

			// @Deprecated  dataKeys  말고 ids 로 변수를 통일한다.
			if(datatype === "domain") cmdMap.dataKeys = cmdMap.sid;
			else cmdMap.dataKeys = cmdMap.oid;
		}

		////////////////////////////////////////////////////////////////////////////
		//
		// 모든 cmdMap 은  ids 를 가진다.
		// 기존과 호환성을 유지하기 위해서  sid, oid 를 기준으로 ids 로 변환한다.
		//
		////////////////////////////////////////////////////////////////////////////

		if (domainBarSync == "true") {
			// domain bar와 동기화 일때는 ids 를 cmdMap 을 날리기 전에 만든다.
		}  else {

			if ($chartDom.attr('ids') ) {
				cmdMap.ids = $chartDom.attr('ids').split(',');
			} else {
				cmdMap.ids = [];
				// 도메인바와 동기화 하지 않은 상태일 때
				if (datatype == 'domain' ) {		// 도메인만 있는 경우
					var sidList = cmdMap.sid;

					for(var i = 0, len = sidList.length; i < len; i++) {
						cmdMap.ids.push(aries.manager.element.id(sidList[i]));
					}

				} else {
					// TODO: agent 만 있는 경우, 현재는 sid 하나인것만 들어오기 때문에 따로 배열 처리 하지 않는다.
					// TODO: 전체 마이그레이션 된 이후  무조건 변수로 ids 를 받도록 한다.
					var sid = cmdMap.sid[0];
					var oidList = cmdMap.oid;

					if (oidList) {
						for(var i = 0, len = oidList.length; i < len; i++) {
							cmdMap.ids.push(aries.manager.element.id(sid, oidList[i]));
						}
					}
				}
			}

		}

		cmdMap.ptype = ptype;
		if(pkey !== '') {
			cmdMap.pkey = pkey;
		}

		var optionMap = {};
		optionMap.datatype = datatype;
		optionMap.hosttype = hosttype;
		optionMap.legend = legend;
		optionMap.fixedmax = fixedmax;
		optionMap.defaultmax = defaultmax;
		optionMap.maxtype = maxtype;
		optionMap.timeunit = timeunit;
		optionMap.realtimeview = realtimeview;
		optionMap.autorender = autorender;
		optionMap.viewpoint = viewpoint;
		optionMap.includetopology = includetopology;
		optionMap.disabledRangeChange = disabledRangeChange;
		optionMap.optimized = optimized;

		var bulider = _$C_BUILDER.loader(charttype);
    	var chart = bulider.build($chartDom, cmdMap, optionMap);


		//차트를 생성할때 해당 소켓이 필요하다면 생성한다.
		//이미 생성되 있다면 생성하지 않는다.

		//@david
		//FIXME XView 차트를 클래스로 변경하고 아래 코드를 심플하게 해야함.
    	if(chart instanceof aries.chart.xview || chart instanceof aries.chart.xview.topology || chart instanceof aries.chart.xview.dashboard || chart instanceof aries.chart.xview.realtime) {
    		_bigdataCharts[dataKey] = chart;

    	} else if(chart instanceof aries.chart.topology) {
    		_topologyCharts.push(chart);
    	} else {
			_realtimeCharts[dataKey] = chart;
    	}
    	
    	
    	return chart;
    },

	fixedPositionAndSize = function($defineContentArea, $chartDom) {
		var startx = Number($chartDom.attr("startx")),
			starty = Number($chartDom.attr("starty")),
			endx = Number($chartDom.attr("endx")),
			endy = Number($chartDom.attr("endy"));

		var contentWidth = $defineContentArea.innerWidth(),
			contentHeight = $defineContentArea.innerHeight();

		var position = $defineContentArea.position();

		//기본 상단바는 margin 10px이지만 extend는 더 커질수 있다.
		position.top += parseInt($defineContentArea.css("marginTop"));

		var left = parseInt(position.left+contentWidth*startx*0.01),
			top = parseInt(position.top+contentHeight*starty*0.01);

		$chartDom.css("left", left);
		$chartDom.css("top", top);

		var padding = 4;
		$chartDom.css("width", parseInt(position.left+contentWidth*endx*0.01) - left - padding*2);
		$chartDom.css("height", parseInt(position.top+contentHeight*endy*0.01) - top - padding*2);
	},
    
    removeChart = function(charttype, dataKey) {
    	if(charttype === "xview") {
    		delete _bigdataCharts[dataKey];
    	} else {
    		delete _realtimeCharts[dataKey];
    	}
    },
    
    realtimeChartProp = function() {
    	return _realtimeCharts;
    },
    
    realtimeCharts = function() {
    	return _.values(_realtimeCharts);
    },
    
    realtimeChart = function(key) {
    	return _realtimeCharts[key];
    },
    
    bigdataChartProp = function() {
    	return _bigdataCharts;
    },
    
    bigdataCharts = function() {
    	return _.values(_bigdataCharts);
    },
    
    bigdataChart = function(key) {
    	return _bigdataCharts[key];
    },
    
    topologyCharts = function() {
    	return _topologyCharts;
    },

	getChart = function(key) {
		var chart = realtimeChart(key);

		if(_.isUndefined(chart)) {
			chart = bigdataChart(key);
		}

		return chart;
	},

	domainRequestInfo = function() {
		if(_mapInfo.length === 0) {
			var domainCmd = {};
			domainCmd.key = 'domainAgentList';
			domainCmd.sid = aries.manager.element.getSelectedDomainSidList();
			domainCmd.mxid = CMD.domain_agent_list;
			domainCmd.otype = OType.SYSTEM;
			domainCmd.oid = [OIDs.ALL_INST];
			domainCmd.ptype = PType.MISC;
			domainCmd.pkey = 'domain_agent_list';
			_mapInfo.push(domainCmd);
		}

		return _mapInfo;
	},

	multidomainRequestInfo = function() {
		// batchjob 인 도메인도 고려해야하나?
		if(_mapInfo.length === 0) {

			var domainCmd = {};
			domainCmd.key = 'multidomainAgentList';
			domainCmd.sid = aries.manager.element.getSelectedDomainSidList();
			domainCmd.mxid = CMD.domain_agent_list;
			domainCmd.otype = OType.SYSTEM;
			domainCmd.oid = [OIDs.ALL_INST];
			domainCmd.ptype = PType.MISC;
			domainCmd.pkey = 'multidomain_agent_list';
			_mapInfo.push(domainCmd);
		}

		return _mapInfo;
	},

	_scan = function(dom){
    	jQuery(dom).find('.chart').each(function(idx, chartDom) {
			initChart(jQuery(chartDom));
    	});
    },
    
    
    set = function(sids) {
    	var bigdataCharts = this.bigdataCharts();
        for(var i=0, max=bigdataCharts.length; i<max; i++) {
			if(bigdataCharts[i].getModel()) {
				bigdataCharts[i].getModel().sid(sids[0]);
			}
		}
    },
    
    clear = function() { 
    	var realtimeCharts = this.realtimeCharts();
    	for(var i=0, max=realtimeCharts.length; i<max; i++) {
    		if(realtimeCharts[i].getModel()) {
    			realtimeCharts[i].getModel().clear();
    		}
    	}
    
    	var bigdataCharts = this.bigdataCharts();
	    for(var i=0, max=bigdataCharts.length; i<max; i++) {
			if(bigdataCharts[i].getModel()) {
				bigdataCharts[i].getModel().clear();
			}
		}
    },

	/*
	 * @Deprecated 사용하지 않음
    deleteAll = function() {
    	var realtimeCharts = this.realtimeCharts();
    	for(var i=0, max=realtimeCharts.length; i<max; i++) {
    		clearInterval(realtimeCharts[i].intervalId);
    	}
    	
    	var bigdataCharts = this.bigdataCharts();
    	for(var i=0, max=bigdataCharts.length; i<max; i++) {
    		clearInterval(bigdataCharts[i].intervalId);
    	}
    	
    	_realtimeCharts = {};
    	_bigdataCharts = {};
    }, */
    
    stopCharts = function() {

		aries.emit("stopCharts");   // 차트 렌더링 종료
		/*
    	var realtimeCharts = this.realtimeCharts();
    	for(var i=0, max=realtimeCharts.length; i<max; i++) {
    		if(realtimeCharts[i].stopPaint) {
    			realtimeCharts[i].stopPaint();
    		}
    	}
    	
    	var bigdataCharts = this.bigdataCharts();
    	for(var i=0, max=bigdataCharts.length; i<max; i++) {
    		if(bigdataCharts[i].stopPaint) {
    			bigdataCharts[i].stopPaint();
    		}
    	}*/
    },
    
    startCharts = function() {
		aries.emit("startCharts");		// 차트를 시작함.
		/*
    	var realtimeCharts = this.realtimeCharts();
    	for(var i=0, max=realtimeCharts.length; i<max; i++) {
    		realtimeCharts[i].paint();
    	}
    	
    	var bigdataCharts = this.bigdataCharts();
    	for(var i=0, max=bigdataCharts.length; i<max; i++) {
    		bigdataCharts[i].paint();
    	}
    	*/
    },
    
    topologySend = function() {
    	for(var i=0, max=_topologyCharts.length; i<max; i++) {
    		_topologyCharts[i].model.send(_domainHander.currentSid());
    	}
    },

	sendCalc = function(sid, model) {
		var cmdMap = model.cmdMap;
		if(cmdMap) {
			if(cmdMap.pkey === "recent_heap_detail_usage" || cmdMap.pkey == 'recent_gc_time_detail') {
				//cpu는 현재 사용하지 않는다.
				if (cmdMap.oid.length == 0 || (cmdMap.oid.length && cmdMap.oid[0] == OIDDef.ALL_INST )) {
					cmdMap.oid = aries.manager.element.instanceKeys();
				}

				//상단바에서 인스턴스 선택이 1개 있을때까지 요청을 지연시킴
				if(cmdMap.oid.length > 1) {
					window.setTimeout(function() {aries.chart.loader.sendCalc(sid, model);}, 500);
					return;
				}
			}

			cmdMap.sid = sid;
			_$C.call.realtimeSend(JSON.stringify(cmdMap));
		}

    };
    
    return {
        init: init,
		initByProp: initByProp,
		initDomainBar: initDomainBar,
		initMultiDomainBar: initMultiDomainBar,
		redefineStringToVariable: redefineStringToVariable,
		changeDashboardLayout: changeDashboardLayout,
		socketUseCheckInit: socketUseCheckInit,
		multidomainRequestInfo: multidomainRequestInfo,
		domainRequestInfo: domainRequestInfo,
		multiDomain : multiDomain,
		initChart: initChart,
		removeChart: removeChart,
		sendCalc: sendCalc,
		realtimeChartProp: realtimeChartProp,
		realtimeCharts: realtimeCharts,
		realtimeChart: realtimeChart,
		bigdataChartProp: bigdataChartProp,
		bigdataCharts: bigdataCharts,
		bigdataChart: bigdataChart,
		topologyCharts: topologyCharts,
		getChart: getChart,
		fixedPositionAndSize: fixedPositionAndSize,
        //deleteAll: deleteAll,
        stopCharts: stopCharts,
        startCharts: startCharts,
        set: set,
//        sid: sid,
        clearInterval: clearInterval,
        clear: clear
    };
}(aries));

aries.loader('chart.call');
aries.loader('chart.domain');
aries.loader('chart.color');
aries.loader('chart.xviewanalysis');
aries.ui = (function(ctx) {
	var _ctx = ctx,
	currentLoading = false,
	
	update = function(url, id, callback) {
		jQuery.get(url, function(data) {
			if(!id) {
				jQuery('#main').html(data);
			} else {
				jQuery(id).html(data);
			}
			
			if(callback) {
				callback();
			}
			
			// FIXME
			//jQuery(id).jsScrollbar();
		});
	},
	
	get = function(url, data, callback) {
		if(callback) {
			jQuery.get(url, data, callback);
		} else {
			jQuery.get(url, data);
		}
	},
	
	getJSON = function(url, data, callback) {
		if(data) {
		    data += '&format=json';
		} else {
			data = 'format=json';
		}

		if(callback) {
			jQuery.getJSON(url, data, callback);
		} else {
			jQuery.getJSON(url, data);
		}
	},
	
	post = function(url, data, callback) {
		if(callback) {
			jQuery.post(url, data, callback);
		} else {
			jQuery.post(url, data);
		}
	},

	redirectPost = function(url, params) {
		var _frm = document.frm;
		_frm.target = "";
		_frm.method = 'post';
		_frm.action = url;

		var keys = _.keys(params);
		jQuery('#frm').empty();

		for(var i=0; i<keys.length; i++) {
			var key = keys[i];

			jQuery('#frm').append("<input type='hidden' name='"+key+"' value='"+params[key]+"' />");
		}

		_frm.submit();

	},
	
	management = function(url, title) {
		if(title && title != "") { // 타이틀이 있을 경우, iframe 모드
			mng.title = title;
			mng.width = 800;
			mng.height = 500;
			mng.scroll = false;
		}

		$.ajax({
			url: url,
			method: "GET",
			success: function(d) {
                if(mng.ui) {
                    if ($.trim(d) == "") {
                    	mng.ui.hide();
                        alert(i18n.get("M0095"));
                    } else {
                        mng.ui.update("");

                        var $help = $(mng.ui.root).find(".head > .right > .icon-help"),
                            $foot = $(mng.ui.root).find(".foot"),
                            $body = $(mng.ui.root).find(".body")

                        // 헬프 링크 처리
                        $help.unbind("click").on("click", function(e) {
                            linkManual(mng.help);
                        });

                        mng.ui.update(d);
                        mng.ui.setTitle(mng.title);

                        // 페이지 클래스 추가
                        var paths = url.split("/");
                        if(paths[2] && paths[2]) {
                            $body.attr("class", "body " + paths[2].split("?")[0]);
                        }

                        if(mng.footer) {
                            $foot.outerHeight(47).show().html(mng.footer());
                        } else {
                            $foot.outerHeight(0).hide();
                        }

                        if(mng.scroll) $body.css("overflow", "auto");
                        else $body.css("overflow", "hidden");

                        mng.ui.setSize(mng.width, mng.height);
                        mng.ui.resizeModal();
                    }
                }
			}
		});
	},
	
	isLoading = function() {
		return currentLoading;
	},
	
	showLoading = function(text, marginLeft) {
		currentLoading = true;
		setTimeout(function() {
			if(loading)	{
				if (text) {
					$(loading.root).find(".clearfix").html(text || "").css({
						'font-size' : '3em',
						'width' : '800px',
						'text-align':'center',
						'color' : 'white',
						'margin-top' : '150px',
						'margin-left' : marginLeft || "-230px",
						'padding-top' : '30px'
					});					
				} else {
					$(loading.root).find(".clearfix").html('');
				}

				loading.show();
			}
			else aries.ui.showLoading();
		}, 10);
	},
	
	closeLoading = function() {
		currentLoading = false;
		setTimeout(function() {
			if(loading) loading.hide();
			else aries.ui.closeLoading();
		}, 10);
	},
	

	checkbox = function(name, checked, value, readonly) {
		var sb = new StringBuffer();
		
		sb.append('<input type="checkbox" name="').append(name).append('"');
		
		if(readonly) {
		    sb.append('readonly="readonly"');
		}
		
		sb.append((checked) ? 'checked="checked"' : '');
		sb.append('value="').append(value).append('" />'); 
		
		return sb.toString();
	},
	
	getXViewPointForAjax = function(sid, txid, stime, etime) {
		var pop = window.open('', 'xviewPointForAjax', "width=1100,height=800,location='no',history='no',resizable='no',status='no',scrollbars='no',toolbar='no',menubar='no'"),
		_frm = document.frm;
		
		if(pop) pop.focus();
		
		jQuery('#frm').empty().append("<input type='hidden' name='txids' value='" + txid + "' />");
		jQuery('#frm').append("<input type='hidden' name='sid' value='" + sid + "' />");
		jQuery('#frm').append("<input type='hidden' name='stime' value='" + stime + "' />");
		jQuery('#frm').append("<input type='hidden' name='etime' value='" + etime + "' />");
		jQuery('#frm').append("<input type='hidden' name='isPopup' value='true' />");
		
		_frm.method =  'post';
		_frm.action = '/popup/xviewPointList';
		_frm.target = 'xviewPointForAjax';
		_frm.submit();
	},

	getXViewPointListForFilter = function(oidsBySid, otype, stime, etime, isFailed, applicationName, sqlName, externalCallName) {
		var target = 'xviewPointList';
		var pop = window.open('/popup/xviewPointList', target, "width=1100,height=800,location='no',history='no',resizable='no',status='no',scrollbars='no',toolbar='no',menubar='no'"),
			_frm = document.frm;

		if(pop) pop.focus();

		jQuery('#frm').empty().append("<input type='hidden' name='oidsBySid' value='" + oidsBySid + "' />");
		jQuery('#frm').append("<input type='hidden' name='otype' value='" + otype + "' />");
		jQuery('#frm').append("<input type='hidden' name='stime' value='" + stime + "' />");
		jQuery('#frm').append("<input type='hidden' name='etime' value='" + etime + "' />");
		jQuery('#frm').append("<input type='hidden' name='isFailed' value='" + isFailed + "' />");

		if(applicationName != null) {
            jQuery('#frm').append("<input type='hidden' name='applicationName' value='" + applicationName + "' />");
        }
        if(sqlName != null) {
            jQuery('#frm').append("<input type='hidden' name='sqlName' value='" + sqlName + "' />");
        }
        if(externalCallName != null) {
            jQuery('#frm').append("<input type='hidden' name='externalCallName' value='" + externalCallName + "' />");
        }

		jQuery('#frm').append("<input type='hidden' name='isPopup' value='true' />");

		_frm.method =  'post';
		_frm.action = '/popup/xviewPointList';
		_frm.target = target;
		_frm.submit();
	},
	
	getXivewPointList = function(sid, txids, stime, etime, txid, filterCondition, chartDataKey) {
		if(txids.length == 0) return;
		
		var target = (!isNaN(txid)) ? 'xviewPointList' : 'xviewPointListSub';
		var pop = window.open('/popup/xviewPointList', target, "width=1100,height=800,location='no',history='no',resizable='no',status='no',scrollbars='no',toolbar='no',menubar='no'"),
		_frm = document.frm;
		
		if(pop) pop.focus();
		
		jQuery('#frm').empty().append("<input type='hidden' name='txids' value='" + txids.join(',') + "' />");
		jQuery('#frm').append("<input type='hidden' name='sid' value='" + sid + "' />");
		jQuery('#frm').append("<input type='hidden' name='stime' value='" + stime + "' />");
		jQuery('#frm').append("<input type='hidden' name='etime' value='" + etime + "' />");
		jQuery('#frm').append("<input type='hidden' name='txid' value='" + txid + "' />");
		jQuery('#frm').append("<input type='hidden' name='isPopup' value='true' />");
		jQuery('#frm').append("<input type='hidden' name='chartDataKey' value='" + chartDataKey + "' />");

		if(filterCondition) {
			if(filterCondition.serviceName) {
				jQuery('#frm').append("<input type='hidden' name='popupFilterCondition' value='serviceName' />");
			} else if(filterCondition.wmonId) {
				jQuery('#frm').append("<input type='hidden' name='popupFilterCondition' value='wmonId' />");
			} else if(filterCondition.ip) {
				jQuery('#frm').append("<input type='hidden' name='popupFilterCondition' value='ip' />");
			} else if(filterCondition.userId) {
				jQuery('#frm').append("<input type='hidden' name='popupFilterCondition' value='userId' />");
			}
		}
		
		
		_frm.method =  'post';
		_frm.action = '/popup/xviewPointList';
		_frm.target = target;
		_frm.submit();
	},
	
	getXivewPointListForMultiDomain = function(txidsBySid, stime, etime, filterCondition, chartDataKey) {
		var target = 'xviewPointList';
		var pop = window.open('', target, "width=1100,height=800,location='no',history='no',resizable='no',status='no',scrollbars='no',toolbar='no',menubar='no'"),
		_frm = document.frm;
		
		if(pop) pop.focus();
		
		jQuery('#frm').empty().append("<input type='hidden' name='txidsBySid' value='" +JSON.stringify(txidsBySid) + "' />");
		jQuery('#frm').append("<input type='hidden' name='stime' value='" + stime + "' />");
		jQuery('#frm').append("<input type='hidden' name='etime' value='" + etime + "' />");
		jQuery('#frm').append("<input type='hidden' name='isMultiDomain' value='true' />");
		jQuery('#frm').append("<input type='hidden' name='isPopup' value='true' />");
		jQuery('#frm').append("<input type='hidden' name='chartDataKey' value='" + chartDataKey + "' />");
		
		if(filterCondition) {
			if(filterCondition.serviceName) {
				jQuery('#frm').append("<input type='hidden' name='popupFilterCondition' value='serviceName' />");
			} else if(filterCondition.wmonId) {
				jQuery('#frm').append("<input type='hidden' name='popupFilterCondition' value='wmonId' />");
			} else if(filterCondition.ip) {
				jQuery('#frm').append("<input type='hidden' name='popupFilterCondition' value='ip' />");
			} else if(filterCondition.userId) {
				jQuery('#frm').append("<input type='hidden' name='popupFilterCondition' value='userId' />");
			}
		}
		
//		/find/pointList/multiDomain
		
		_frm.method =  'post';
		_frm.action = '/popup/xviewPointList';
		_frm.target = target;
		_frm.submit();
	},
	
	
	getXivewAppPointList = function(serviceHashList, serviceNameList, txidsList, avgResTimes, recentResTimes, maxResTimes, startTimes, lastTimes, sqlTimes, cpuTimes, fetchTimes, errorCounts, stime, etime, target) {
		if(serviceHashList.length == 0) return;
		
		var pop = window.open('', 'xviewPointList', "width=1100,height=800,location='no',history='no',resizable='no',status='no',scrollbars='no',toolbar='no',menubar='no'"),
		_frm = document.frm;
		
		if(pop) pop.focus();
		
		jQuery('#frm').empty().append("<input type='hidden' name='serviceHashList' value='" + serviceHashList.join(',') + "' />");
		jQuery('#frm').append("<input type='hidden' name='serviceNameList' value='" + serviceNameList.join(',') + "' />");
		jQuery('#frm').append("<input type='hidden' name='txidsList' value='" + JSON.stringify(txidsList) + "' />");
		jQuery('#frm').append("<input type='hidden' name='avgResTimes' value='" + avgResTimes.join(',') + "' />");
		jQuery('#frm').append("<input type='hidden' name='recentResTimes' value='" + recentResTimes.join(',') + "' />");
		jQuery('#frm').append("<input type='hidden' name='maxResTimes' value='" + maxResTimes.join(',') + "' />");
		jQuery('#frm').append("<input type='hidden' name='startTimes' value='" + startTimes.join(',') + "' />");
		jQuery('#frm').append("<input type='hidden' name='lastTimes' value='" + lastTimes.join(',') + "' />");
		jQuery('#frm').append("<input type='hidden' name='sqlTimes' value='" + sqlTimes.join(',') + "' />");
		jQuery('#frm').append("<input type='hidden' name='cpuTimes' value='" + cpuTimes.join(',') + "' />");
		jQuery('#frm').append("<input type='hidden' name='fetchTimes' value='" + fetchTimes.join(',') + "' />");
		jQuery('#frm').append("<input type='hidden' name='errorCounts' value='" + errorCounts.join(',') + "' />");
		jQuery('#frm').append("<input type='hidden' name='stime' value='" + stime + "' />");
		jQuery('#frm').append("<input type='hidden' name='etime' value='" + etime + "' />");
		jQuery('#frm').append("<input type='hidden' name='isPopup' value='true' />");
		
		_frm.method =  'post';
		_frm.action = '/popup/xviewPointList';
		_frm.target = 'xviewPointList';
		_frm.submit();
	},
	
	getXivewUserPointList = function(userIds, txidsList, startTimes, lastTimes, stime, etime, target) {
		if(userIds.length == 0) return;
		
		var pop = window.open('', 'xviewPointList', "width=1100,height=800,location='no',history='no',resizable='no',status='no',scrollbars='no',toolbar='no',menubar='no'"),
		_frm = document.frm;
		
		if(pop) pop.focus();

		//TODO txidsList 를 txidsBySid 로 변경해야 한다.

		jQuery('#frm').empty().append("<input type='hidden' name='userIds' value='" + userIds.join(',') + "' />");
		jQuery('#frm').append("<input type='hidden' name='txidsList' value='" + JSON.stringify(txidsList) + "' />");
		jQuery('#frm').append("<input type='hidden' name='startTimes' value='" + startTimes.join(',') + "' />");
		jQuery('#frm').append("<input type='hidden' name='lastTimes' value='" + lastTimes.join(',') + "' />");
		jQuery('#frm').append("<input type='hidden' name='stime' value='" + stime + "' />");
		jQuery('#frm').append("<input type='hidden' name='etime' value='" + etime + "' />");
		jQuery('#frm').append("<input type='hidden' name='isPopup' value='true' />");
		
		_frm.method =  'post';
		_frm.action = '/popup/xviewPointList';
		_frm.target = 'xviewPointList';
		_frm.submit();
	},
	
	getXivewGUIDPointList = function(guids, txidsList, avgResTimes, recentResTimes, maxResTimes, startTimes, lastTimes, stime, etime, target) {
		if(guids.length == 0) return;
		
		var pop = window.open('', 'xviewPointList', "width=1100,height=800,location='no',history='no',resizable='no',status='no',scrollbars='no',toolbar='no',menubar='no'"),
		_frm = document.frm;
		
		if(pop) pop.focus();
		
		jQuery('#frm').empty().append("<input type='hidden' name='guids' value='" + guids.join(',') + "' />");
		jQuery('#frm').append("<input type='hidden' name='txidsList' value='" + JSON.stringify(txidsList) + "' />");
		jQuery('#frm').append("<input type='hidden' name='avgResTimes' value='" + avgResTimes.join(',') + "' />");
		jQuery('#frm').append("<input type='hidden' name='recentResTimes' value='" + recentResTimes.join(',') + "' />");
		jQuery('#frm').append("<input type='hidden' name='maxResTimes' value='" + maxResTimes.join(',') + "' />");
		jQuery('#frm').append("<input type='hidden' name='startTimes' value='" + startTimes.join(',') + "' />");
		jQuery('#frm').append("<input type='hidden' name='lastTimes' value='" + lastTimes.join(',') + "' />");
		jQuery('#frm').append("<input type='hidden' name='stime' value='" + stime + "' />");
		jQuery('#frm').append("<input type='hidden' name='etime' value='" + etime + "' />");
		jQuery('#frm').append("<input type='hidden' name='isPopup' value='true' />");
		
		_frm.method =  'post';
		_frm.action = '/popup/xviewPointList';
		_frm.target = 'xviewPointList';
		_frm.submit();
	},

	getXivewCLIENTIDPointList = function(sid, userIds, txidsList, avgResTimes, recentResTimes, maxResTimes, startTimes, lastTimes, stime, etime, target) {
		if(userIds.length == 0) return;

		var pop = window.open('', 'xviewPointList', "width=1100,height=800,location='no',history='no',resizable='no',status='no',scrollbars='no',toolbar='no',menubar='no'"),
			_frm = document.frm;

		if(pop) pop.focus();

		jQuery('#frm').empty().append("<input type='hidden' name='userIds' value='" + userIds.join(',') + "' />");
		jQuery('#frm').append("<input type='hidden' name='txidsList' value='" + JSON.stringify(txidsList) + "' />");
		jQuery('#frm').append("<input type='hidden' name='avgResTimes' value='" + avgResTimes.join(',') + "' />");
		jQuery('#frm').append("<input type='hidden' name='recentResTimes' value='" + recentResTimes.join(',') + "' />");
		jQuery('#frm').append("<input type='hidden' name='maxResTimes' value='" + maxResTimes.join(',') + "' />");
		jQuery('#frm').append("<input type='hidden' name='startTimes' value='" + startTimes.join(',') + "' />");
		jQuery('#frm').append("<input type='hidden' name='lastTimes' value='" + lastTimes.join(',') + "' />");
		jQuery('#frm').append("<input type='hidden' name='sid' value='" + sid + "' />");
		jQuery('#frm').append("<input type='hidden' name='stime' value='" + stime + "' />");
		jQuery('#frm').append("<input type='hidden' name='etime' value='" + etime + "' />");
		jQuery('#frm').append("<input type='hidden' name='isPopup' value='true' />");

		_frm.method =  'post';
		_frm.action = '/popup/xviewPointList';
		_frm.target = 'xviewPointList';
		_frm.submit();
	},

	getXivewCLIENTIPPointList = function(sid, ips, txidsList, avgResTimes, recentResTimes, maxResTimes, startTimes, lastTimes, stime, etime, target) {
		if(ips.length == 0) return;

		var pop = window.open('', 'xviewPointList', "width=1100,height=800,location='no',history='no',resizable='no',status='no',scrollbars='no',toolbar='no',menubar='no'"),
			_frm = document.frm;

		if(pop) pop.focus();

		jQuery('#frm').empty().append("<input type='hidden' name='ips' value='" + ips.join(',') + "' />");
            jQuery('#frm').append("<input type='hidden' name='txidsList' value='" + JSON.stringify(txidsList) + "' />");
            jQuery('#frm').append("<input type='hidden' name='avgResTimes' value='" + avgResTimes.join(',') + "' />");
            jQuery('#frm').append("<input type='hidden' name='recentResTimes' value='" + recentResTimes.join(',') + "' />");
            jQuery('#frm').append("<input type='hidden' name='maxResTimes' value='" + maxResTimes.join(',') + "' />");
            jQuery('#frm').append("<input type='hidden' name='startTimes' value='" + startTimes.join(',') + "' />");
            jQuery('#frm').append("<input type='hidden' name='lastTimes' value='" + lastTimes.join(',') + "' />");
            jQuery('#frm').append("<input type='hidden' name='sid' value='" + sid + "' />");
            jQuery('#frm').append("<input type='hidden' name='stime' value='" + stime + "' />");
            jQuery('#frm').append("<input type='hidden' name='etime' value='" + etime + "' />");
            jQuery('#frm').append("<input type='hidden' name='isPopup' value='true' />");

            _frm.method =  'post';
            _frm.action = '/popup/xviewPointList';
            _frm.target = 'xviewPointList';
            _frm.submit();
        },
	
	getDeltaPointList = function(url, sid, txids, stime, etime, target) {
		if(txids.length == 0) return;
		
		var pop = window.open('', 'deltaPointList', 'width=1010,height=765,history=no,resizable=no,status=no,scrollbars=yes,menubar=no'),
		_frm = document.frm;
		
		if(pop) pop.focus();
		
		jQuery('#frm').empty().append("<input type='hidden' name='txids' value='" + txids.join(',') + "' />");
		jQuery('#frm').append("<input type='hidden' name='sid' value='" + sid + "' />");
		jQuery('#frm').append("<input type='hidden' name='stime' value='" + stime + "' />");
		jQuery('#frm').append("<input type='hidden' name='etime' value='" + etime + "' />");
		jQuery('#frm').append("<input type='hidden' name='isPopup' value='true' />");
		
		_frm.method="post";
		_frm.action= url;
		_frm.target="deltaPointList";
		_frm.submit();
	},

	/* @Deprecated
	getDeployList = function(sid, stime, etime, keys, oids) {
		keys  = keys || [];
		oids = oids || [];

		var pop = window.open("/popup/applicationHistory", "applicationHistory", "width=1024,height=768,history=no,resizable=no,status=no,scrollbars=yes,menubar=no"),
			_frm = document.frm;

		if(pop) pop.focus();

		jQuery('#frm').empty();
		jQuery('#frm').append("<input type='hidden' name='sid' value='" + sid + "' />");
		jQuery('#frm').append("<input type='hidden' name='stime' value='" + stime + "' />");
		jQuery('#frm').append("<input type='hidden' name='etime' value='" + etime + "' />");
		jQuery('#frm').append("<input type='hidden' name='keys' value='" + keys.join(",") + "' />");
		jQuery('#frm').append("<input type='hidden' name='oids' value='" + oids.join(",") + "' />");
		jQuery('#frm').append("<input type='hidden' name='isPopup' value='true' />");

		_frm.method="post";
		_frm.action= "/popup/applicationHistory";
		_frm.target="applicationHistory";
		_frm.submit();
	},
	*/
	getDeployListForMultiDomain = function(stime, etime, list) {

		var pop = window.open("/popup/applicationHistory", "applicationHistory", "width=1024,height=768,history=no,resizable=no,status=no,scrollbars=yes,menubar=no"),
			_frm = document.frm;

		if(pop) pop.focus();

		jQuery('#frm').empty();
		jQuery('#frm').append("<input type='hidden' name='stime' value='" + stime + "' />");
		jQuery('#frm').append("<input type='hidden' name='etime' value='" + etime + "' />");
		jQuery('#frm').append("<input type='hidden' name='list' value='" + JSON.stringify(list) + "' />");
		jQuery('#frm').append("<input type='hidden' name='isPopup' value='true' />");

		_frm.method="post";
		_frm.action= "/popup/applicationHistory";
		_frm.target="applicationHistory";
		_frm.submit();
	},
	
	getEventList = function(url, sid, otype, oid, name) {
		var pop = window.open('', 'eventList', 'width=1024,height=768,history=no,resizable=no,status=no,scrollbars=yes,menubar=no'),
		_frm = document.frm;
		
		if(pop) pop.focus();
		
		jQuery('#frm').empty();
		jQuery('#frm').append("<input type='hidden' name='sid' value='" + sid + "' />");
		jQuery('#frm').append("<input type='hidden' name='otype' value='" + otype + "' />");
		jQuery('#frm').append("<input type='hidden' name='oid' value='" + oid + "' />");
		jQuery('#frm').append("<input type='hidden' name='name' value='" + name + "' />");
		jQuery('#frm').append("<input type='hidden' name='isPopup' value='true' />");
		
		_frm.method= 'post';
		_frm.action= url;
		_frm.target= 'eventList';
		_frm.submit();
	},

	getEventListV2 = function(iconDomOrChart) {
		var chart;

		if(iconDomOrChart instanceof aries.chart.event) {
			chart = iconDomOrChart;
		} else {
			var $chartDom = jQuery(iconDom).parent().parent(),
				key = $chartDom.attr('data-key');

			chart = aries.chart.loader.realtimeChart(key);
		}

		var visibleTargetHirachy = chart.getVisibleTargetHirachy();

        var pop = window.open('', 'eventList', 'width=1024,height=768,history=no,resizable=no,status=no,scrollbars=yes,menubar=no'),
            _frm = document.frm;

        if(pop) pop.focus();

        jQuery('#frm').empty();
        jQuery('#frm').append("<input type='hidden' name='isPopup' value='true' />");
        jQuery('#frm').append("<input type='hidden' name='domainJson' value='" + JSON.stringify(visibleTargetHirachy) + "' />");

        _frm.method= 'post';
        _frm.action= '/popup/eventList';
        _frm.target= 'eventList';
        _frm.submit();
	},
	
	getEventNoticeList = function(url) {
		var pop = window.open('', 'eventList', 'width=1024,height=768,history=no,resizable=no,status=no,scrollbars=yes,menubar=no'),
		_frm = document.frm;
		
		if(pop) pop.focus();
		
		jQuery('#frm').empty().append("<input type='hidden' name='isPopup' value='true' />");
		
		_frm.method = 'post';
		_frm.action = url;
		_frm.target = 'eventList';
		_frm.submit();
	},
	
	activeServiceList = function(url, sid, oid) {
		var pop = window.open(url, 'activeServiceList', 'width=1024,height=768,history=no,resizable=no,status=no,scrollbars=yes,menubar=no'),
		_frm = document.frm;
		
		if(pop) pop.focus();
		
		jQuery('#frm').empty();
		if(oid) {
			jQuery('#frm').append("<input type='hidden' name='agent' value='" + oid + "' />");
		}
		
		jQuery('#frm').append("<input type='hidden' name='sid' value='" + sid + "' />");
		jQuery('#frm').append("<input type='hidden' name='isSql' value='false' />");
		jQuery('#frm').append("<input type='hidden' name='isPopup' value='true' />");
		
		_frm.method= 'post';
		_frm.action= url;
		_frm.target= 'activeServiceList';
		_frm.submit();
	},

	activeServiceListForBatchjob = function(url, sid) {
		var pop = window.open(url, 'activeServiceList', 'width=1024,height=768,history=no,resizable=no,status=no,scrollbars=yes,menubar=no'),
			_frm = document.frm;

		if(pop) pop.focus();

		jQuery('#frm').empty();

		jQuery('#frm').append("<input type='hidden' name='sid' value='" + sid + "' />");
		jQuery('#frm').append("<input type='hidden' name='isFromBatchjobDomain' value='true' />");
		jQuery('#frm').append("<input type='hidden' name='isPopup' value='true' />");

		_frm.method= 'post';
		_frm.action= url;
		_frm.target= 'activeServiceList';
		_frm.submit();
	},
	
	activeServiceListForIncoming = function(url, sourceSid, sourceOid, targetSid, targetOid, existReverse) {
		var pop = window.open('', 'activeServiceList', 'width=1024,height=768,history=no,resizable=no,status=no,scrollbars=yes,menubar=no'),
		_frm = document.frm;
		
		if(pop) pop.focus();
		
		jQuery('#frm').empty();
		
		jQuery('#frm').append("<input type='hidden' name='sourceSid' value='" + sourceSid + "' />");
		jQuery('#frm').append("<input type='hidden' name='sourceOid' value='" + sourceOid + "' />");
		jQuery('#frm').append("<input type='hidden' name='targetSid' value='" + targetSid + "' />");
		jQuery('#frm').append("<input type='hidden' name='targetOid' value='" + targetOid + "' />");
		jQuery('#frm').append("<input type='hidden' name='isIncoming' value='true' />");
		jQuery('#frm').append("<input type='hidden' name='isPopup' value='true' />");

		if(existReverse) jQuery('#frm').append("<input type='hidden' name='existReverse' value='true' />");
		else jQuery('#frm').append("<input type='hidden' name='existReverse' value='false' />");
		
		_frm.method= 'post';
		_frm.action= url;
		_frm.target= 'activeServiceList';
		_frm.submit();
	},
	
	activeServiceListForOutgoing = function(url, sourceSid, sourceOid, targetRemoteCallType, targetCustomMethodDescHashOrZero, targetIpAddressOrEmpty, targetPortOrZero) {
		var pop = window.open('', 'activeServiceList', 'width=1024,height=768,history=no,resizable=no,status=no,scrollbars=yes,menubar=no'),
		_frm = document.frm;
		
		if(pop) pop.focus();
		
		jQuery('#frm').empty();
		
		jQuery('#frm').append("<input type='hidden' name='sourceSid' value='" + sourceSid + "' />");
		jQuery('#frm').append("<input type='hidden' name='sourceOid' value='" + sourceOid + "' />");
		jQuery('#frm').append("<input type='hidden' name='targetRemoteCallType' value='" + targetRemoteCallType + "' />");
		jQuery('#frm').append("<input type='hidden' name='targetCustomMethodDescHashOrZero' value='" + targetCustomMethodDescHashOrZero + "' />");
		jQuery('#frm').append("<input type='hidden' name='targetIpAddressOrEmpty' value='" + targetIpAddressOrEmpty + "' />");
		jQuery('#frm').append("<input type='hidden' name='targetPortOrZero' value='" + targetPortOrZero + "' />");
		jQuery('#frm').append("<input type='hidden' name='isOutgoing' value='true' />");
		jQuery('#frm').append("<input type='hidden' name='isPopup' value='true' />");
		
		_frm.method= 'post';
		_frm.action= url;
		_frm.target= 'activeServiceList';
		_frm.submit();
	}, 
	
	activeServiceListForGroupNode = function(url, sourceInfoList, targetInfoList) {
		var pop = window.open('', 'activeServiceList', 'width=1024,height=768,history=no,resizable=no,status=no,scrollbars=yes,menubar=no'),
		_frm = document.frm;
		
		if(pop) pop.focus();
		
		jQuery('#frm').empty();
		
		jQuery('#frm').append("<input type='hidden' name='sourceInfoList' value='" + JSON.stringify(sourceInfoList) + "' />");
		jQuery('#frm').append("<input type='hidden' name='targetInfoList' value='" + JSON.stringify(targetInfoList) + "' />");
		jQuery('#frm').append("<input type='hidden' name='isGroupNode' value='true' />");
		jQuery('#frm').append("<input type='hidden' name='isPopup' value='true' />");
		
		_frm.method= 'post';
		_frm.action= url;
		_frm.target= 'activeServiceList';
		_frm.submit();
	},

	
	activeServiceListForBusiness = function(url, sid, oid) {
		var pop = window.open('', 'activeServiceList', 'width=1024,height=768,history=no,resizable=no,status=no,scrollbars=yes,menubar=no'),
		_frm = document.frm;
		
		if(pop) pop.focus();
		
		jQuery('#frm').empty();
		if(oid) {
			jQuery('#frm').append("<input type='hidden' name='agent' value='" + oid + "' />");
		}
		
		jQuery('#frm').append("<input type='hidden' name='sid' value='" + sid + "' />");
		jQuery('#frm').append("<input type='hidden' name='otype' value='" + OType.BUSINESS + "' />");
		jQuery('#frm').append("<input type='hidden' name='isSql' value='false' />");
		jQuery('#frm').append("<input type='hidden' name='isPopup' value='true' />");
		
		_frm.method= 'post';
		_frm.action= url;
		_frm.target= 'activeServiceList';
		_frm.submit();
	},


	activeServiceListInSql = function(url, sid, oid, dataSourceName) {
		var pop = window.open('', 'activeServiceList', 'width=1024,height=768,history=no,resizable=no,status=no,scrollbars=yes,menubar=no'),
		_frm = document.frm;
		
		if(pop) pop.focus();
		
		jQuery('#frm').empty();
		if(oid) {
			jQuery('#frm').append("<input type='hidden' name='agent' value='" + oid + "' />");
		}

		if(dataSourceName) {
			jQuery('#frm').append("<input type='hidden' name='dataSourceName' value='" + dataSourceName + "' />");
		}
		
		jQuery('#frm').append("<input type='hidden' name='sid' value='" + sid + "' />");
		//jQuery('#frm').append("<input type='hidden' name='isSql' value='true' />");
        jQuery('#frm').append("<input type='hidden' name='defaultTab' value='SQL' />");
		jQuery('#frm').append("<input type='hidden' name='isPopup' value='true' />");
		
		_frm.method= 'post';
		_frm.action= url;
		_frm.target= 'activeServiceList';
		_frm.submit();
	},

	activeServiceListInExternalcall = function(url, sid, oid, dataSourceName) {
		var pop = window.open('', 'activeServiceList', 'width=1024,height=768,history=no,resizable=no,status=no,scrollbars=yes,menubar=no'),
			_frm = document.frm;

		if(pop) pop.focus();

		jQuery('#frm').empty();
		if(oid) {
			jQuery('#frm').append("<input type='hidden' name='agent' value='" + oid + "' />");
		}

		if(dataSourceName) {
			jQuery('#frm').append("<input type='hidden' name='dataSourceName' value='" + dataSourceName + "' />");
		}

		jQuery('#frm').append("<input type='hidden' name='sid' value='" + sid + "' />");

		jQuery('#frm').append("<input type='hidden' name='defaultTab' value='EXTERNALCALL' />");
		jQuery('#frm').append("<input type='hidden' name='isPopup' value='true' />");

		_frm.method= 'post';
		_frm.action= url;
		_frm.target= 'activeServiceList';
		_frm.submit();
	},

	
	activeServiceDetail = function(url, session, threadHash, sid) {
		var pop = window.open('', 'activeServiceDetail', 'width=1024,height=768,history=no,resizable=no,status=no,scrollbars=yes,menubar=no'),
		_frm = document.frm;
		
		if(pop) pop.focus();
		
		jQuery('#frm').empty().append("<input type='hidden' name='session' value='" + session + "' />");
		jQuery('#frm').append("<input type='hidden' name='threadHash' value='" + threadHash + "' />");
		jQuery('#frm').append("<input type='hidden' name='isPopup' value='true' />");
		jQuery('#frm').append("<input type='hidden' name='sid' value='" + sid + "' />");		
		
		_frm.method= 'post';
		_frm.action= url;
		_frm.target= 'activeServiceDetail';
		_frm.submit();
	},
	


	methodStacktraceDetail = function(url, data) {
		var pop = window.open('', 'methodStacktraceDetail', 'width=1024,height=768,history=no,resizable=no,status=no,scrollbars=no,menubar=no');

		_frm = document.frm;
		if(pop) pop.focus();

		$('#frm').empty().append("<input type='hidden' name='key' value='" + data.key + "' />");
		$('#frm').append("<input type='hidden' name='name' value='" + data.name + "' />");
		$('#frm').append("<input type='hidden' name='isPopup' value='true' />");

		_frm.method= 'post';
		_frm.action= url;
		_frm.target= 'methodStacktraceDetail';
		_frm.submit();
	},

	socketDetail = function(url, data) {
		var pop = window.open('', 'socketDetail', 'width=1024,height=768,history=no,resizable=no,status=no,scrollbars=no,menubar=no');
		
		_frm = document.frm;
		if(pop) pop.focus();
		
		$('#frm').empty().append("<input type='hidden' name='key' value='" + data.key + "' />");
		$('#frm').append("<input type='hidden' name='localport' value='" + data.localport + "' />");
		$('#frm').append("<input type='hidden' name='host' value='" + data.host + "' />");
		$('#frm').append("<input type='hidden' name='port' value='" + data.port + "' />");
		$('#frm').append("<input type='hidden' name='time' value='" + data.time + "' />");
		$('#frm').append("<input type='hidden' name='isPopup' value='true' />");
		
		_frm.method= 'post';
		_frm.action= url;
		_frm.target= 'socketDetail';
		_frm.submit();
	},
	
	serviceDetail = function(url, type, name, hash, sid, otype, oids, stime, etime) {
		var pop = window.open('', 'serviceDetail', 'width=1024,height=768,history=no,resizable=no,status=no,scrollbars=yes,menubar=no'),
		_frm = document.frm;
		
		if(pop) pop.focus();
		
		jQuery('#frm').empty().append("<input type='hidden' name='sid' value='" + sid + "' />");
		jQuery('#frm').append("<input type='hidden' name='name' value='" + name + "' />");		
		jQuery('#frm').append("<input type='hidden' name='hash' value='" + hash + "' />");		
		jQuery('#frm').append("<input type='hidden' name='otype' value='" + otype + "' />");
		jQuery('#frm').append("<input type='hidden' name='oids' value='" + oids + "' />");		
		jQuery('#frm').append("<input type='hidden' name='stime' value='" + stime + "' />");
		jQuery('#frm').append("<input type='hidden' name='etime' value='" + etime + "' />");
		jQuery('#frm').append("<input type='hidden' name='isPopup' value='true' />");
		jQuery('#frm').append("<input type='hidden' name='type' value='" + type + "' />");
		
		_frm.method= 'post';
		_frm.action= url;
		_frm.target= 'serviceDetail';
		_frm.submit();
	},
	
	serviceDumpDetail = function(url, sid, oid, fname) {
		var pop = window.open('', 'serviceDumpDetail', 'width=1024,height=768,history=no,resizable=no,status=no,scrollbars=yes,menubar=no'),
		_frm = document.frm;
		
		if(pop) pop.focus();
		jQuery('#frm').empty().append("<input type='hidden' name='sid' value='" + sid + "' />");
		jQuery('#frm').append("<input type='hidden' name='oid' value='" + oid + "' />");
		jQuery('#frm').append("<input type='hidden' name='fname' value='" + fname + "' />");
		jQuery('#frm').append("<input type='hidden' name='isPopup' value='true' />");
		
		_frm.method= 'post';
		_frm.action= url;
		_frm.target= 'serviceDumpDetail';
		_frm.submit();
	},
	
	popup = function(url, width, height) {
		var pop = window.open(url, url, 'width=' + width + ',height=' + height + ',history=no,resizable=no,status=no,scrollbars=no,menubar=no');
		
		if(pop) pop.focus();
	},
	
	realtimePopup = function(url, width, height) {
		var pop = window.open('', url, 'width=' + width + ',height=' + height + ',history=no,resizable=yes,status=no,scrollbars=no,menubar=no,location=no');
		_frm = document.frm;
		
		if(pop) pop.focus();
		
		jQuery('#frm').empty();
		jQuery('#frm').append("<input type='hidden' name='isPopup' value='true' />");
		
		_frm.method= 'post';
		_frm.action= url;
		_frm.target= url;
		_frm.submit();
		
	},

		/**
		 * @deprecated   use multidomainChartPopup instead of this function
 		 */
	chartPopup = function(iconDom) {
		aries.deprecated("don't use chartPopup. use multidomainChartPopup instead of.");
		var $chartDom = jQuery(iconDom).parent().parent(),
		width = $chartDom.width(),
		height = $chartDom.height(),
		left = $chartDom.offset().left + window.screenX,
		top = $chartDom.offset().top + window.screenY,
		key = $chartDom.attr('data-key'),
		charttype = $chartDom.attr('charttype'),
		mxid = $chartDom.attr('mxid'),
		mxidmax = $chartDom.attr('mxidmax'),
		otype = $chartDom.attr('otype'),
		ptype = $chartDom.attr('ptype'),
		pkey =  $chartDom.attr('pkey'),
		datatype =  $chartDom.attr('datatype'),
		viewpoint = $chartDom.attr('viewpoint'),
		defaultmax = $chartDom.attr('defaultmax'),
		fixedmax = $chartDom.attr('fixedmax'),

		title = $chartDom.find('#Canvas').attr('ctitle');
		
		var chart, sid,	oid;
		
		if(charttype === 'xview') {
			chart = aries.chart.loader.bigdataChart(key);
		} else {
			chart = aries.chart.loader.realtimeChart(key);
		}
		
		sid = chart.getDataKeys().sid;
		oid = chart.getDataKeys().oid;

		//RuntimeLineChart의 특정 매트릭이라면 상단바가 선택되지 않았을때 도메인단위로 표시함.
		var _domainHandler = aries.manager.domain;
		if(chart instanceof aries.chart.line.runtime && chart.getModel().cmdMap.domainBarSync && _domainHandler.type() === "domain_agent" && _domainHandler.selectedInstanceOids().length === 0 && chart.mxidArrayForDrawDomain.indexOf(Number(mxid)) > -1 && !(chart.agentHandler && chart.agentHandler.selectedAgent())) {
			oid = OIDDef.TOT;
			datatype = 'domain';
		}


		
		url = '/popup/chartPlay';
		
		var pop = window.open('', key, 'width=' + width + ',height=' + height + ',left=' + left + ',top=' + top + ',history=no,resizable=yes,status=no,scrollbars=no,menubar=no,location=no');
		_frm = document.frm;
		
		if(pop) pop.focus();
		
		jQuery('#frm').empty();
		jQuery('#frm').append("<input type='hidden' name='charttype' value='"+charttype+"' />");
		jQuery('#frm').append("<input type='hidden' name='mxid' value='"+mxid+"' />");
		jQuery('#frm').append("<input type='hidden' name='mxidmax' value='"+mxidmax+"' />");

		jQuery('#frm').append("<input type='hidden' name='otype' value='"+otype+"' />");
		jQuery('#frm').append("<input type='hidden' name='ptype' value='"+ptype+"' />");
		jQuery('#frm').append("<input type='hidden' name='pkey' value='"+pkey+"' />");
		jQuery('#frm').append("<input type='hidden' name='datatype' value='"+datatype+"' />");
		if(!_.isUndefined(viewpoint)) {
			jQuery('#frm').append("<input type='hidden' name='viewpoint' value='"+viewpoint+"' />");
		}
		
		jQuery('#frm').append("<input type='hidden' name='sid' value='"+sid+"' />");
		jQuery('#frm').append("<input type='hidden' name='oid' value='"+oid+"' />");
		jQuery('#frm').append("<input type='hidden' name='title' value='"+title+"' />");

		jQuery('#frm').append("<input type='hidden' name='defaultmax' value='"+defaultmax+"' />");
		jQuery('#frm').append("<input type='hidden' name='fixedmax' value='"+fixedmax+"' />");
		jQuery('#frm').append("<input type='hidden' name='chartDataKey' value='"+key+"' />");
		
		_frm.method= 'get';
		_frm.action= url;
		_frm.target= key;
		_frm.submit();
		
	},

	// 멀티 도메인 형태를 위한 차트 팝업
	multidomainChartPopup = function(iconDom) {
		var $chartDom = jQuery(iconDom).parent().parent(),
			width = $chartDom.width(),
			height = $chartDom.height(),
			left = $chartDom.offset().left + window.screenX,
			top = $chartDom.offset().top + window.screenY,
			key = $chartDom.attr('data-key'),
			charttype = $chartDom.attr('charttype'),
			mxid = $chartDom.attr('mxid'),
			mxidmax = $chartDom.attr('mxidmax'),
			otype = $chartDom.attr('otype'),
			ptype = $chartDom.attr('ptype'),
			pkey =  $chartDom.attr('pkey'),
			datatype =  $chartDom.attr('datatype'),
			viewpoint = $chartDom.attr('viewpoint'),
			defaultmax = $chartDom.attr('defaultmax'),
			fixedmax = $chartDom.attr('fixedmax'),
			title = $chartDom.find('#Canvas').attr('ctitle');

		var chart, sid, oid;

		if(charttype === 'xview' || charttype === 'xview.dashboard' || charttype === 'xview.realtime' || charttype === 'xview.topology') {
			chart = aries.chart.loader.bigdataChart(key);
		} else {
			chart = aries.chart.loader.realtimeChart(key);
		}

		var sid = chart.getDataIds().sid;
		var oid = chart.getDataIds().oid;


		if ((chart.getModel().isDomainType() || chart.getModel().isAgentType()) && aries.manager.element.getCache().hasSelectedInstance) {
			var obj = aries.manager.element.getSelectedInstanceIdListWithSid();

			sid = obj.domainList;
			oid = obj.instanceList;
		}

        //TODO 아래 코드가 차트 팝업을 띄울때 로직이 꼬인다. 아마도 "/realtime/business" 에서 사용하는 화면일 것이다.
		if(charttype === "tree.servicestatus" && chart.getModel().isBusinessType()) {
            if (aries.manager.business.getCache().hasSelectedBusiness) {
                var obj = aries.manager.business.getSelectedBusinessListWithSid();

                sid = obj.domainList;
                oid = obj.businessList;
            }
		}

		//RuntimeLineChart의 특정 매트릭이라면 상단바가 선택되지 않았을때 도메인단위로 표시함.
		var _domainHandler = aries.manager.element;
		if(chart instanceof aries.chart.line.runtime
			&& chart.getModel().cmdMap.domainBarSync
			&& (chart.getModel().isDomainType() || chart.getModel().isAgentType())		// businessType 은 제외
			//&& aries.get('domainbar').getType() === "agent"  http://issue.jennifersoft.com/browse/ARIES-6958
			&& _domainHandler.getCache().hasSelectedInstance == false 		// 선택되어진게 하나도 없을 경우
			&& chart.mxidArrayForDrawDomain.indexOf(Number(mxid)) > -1
			&& !(chart.agentHandler && chart.agentHandler.selectedAgent())
		) {
			oid = [OIDDef.TOT];
			datatype = 'domain';
			//console.debug('무조건 domain type 형태로만 데이타 조회하도록 함. ');
		}

		url = '/popup/multidomainChartPlay';

		var pop = window.open('', key, 'width=' + width + ',height=' + height + ',left=' + left + ',top=' + top + ',history=no,resizable=yes,status=no,scrollbars=no,menubar=no,location=no');

		if (pop) {
			if (pop.screenY + pop.outerHeight  > window.screen.height) {
				pop.moveTo(pop.screenX, window.screen.height - pop.outerHeight);
			}
		}
		_frm = document.frm;

		if(pop) pop.focus();

		jQuery('#frm').empty();
		jQuery('#frm').append("<input type='hidden' name='charttype' value='"+charttype+"' />");
		jQuery('#frm').append("<input type='hidden' name='mxid' value='"+mxid+"' />");
		jQuery('#frm').append("<input type='hidden' name='mxidmax' value='"+mxidmax+"' />");

		jQuery('#frm').append("<input type='hidden' name='otype' value='"+otype+"' />");
		jQuery('#frm').append("<input type='hidden' name='ptype' value='"+ptype+"' />");
		jQuery('#frm').append("<input type='hidden' name='pkey' value='"+pkey+"' />");
		jQuery('#frm').append("<input type='hidden' name='datatype' value='"+datatype+"' />");
		if(!_.isUndefined(viewpoint)) {
			jQuery('#frm').append("<input type='hidden' name='viewpoint' value='"+viewpoint+"' />");
		}

		jQuery('#frm').append("<input type='hidden' name='sid' value='"+sid+"' />");
		jQuery('#frm').append("<input type='hidden' name='oid' value='"+oid+"' />");
		jQuery('#frm').append("<input type='hidden' name='title' value='"+title+"' />");

		jQuery('#frm').append("<input type='hidden' name='defaultmax' value='"+defaultmax+"' />");
		jQuery('#frm').append("<input type='hidden' name='fixedmax' value='"+fixedmax+"' />");
		jQuery('#frm').append("<input type='hidden' name='chartDataKey' value='"+key+"' />");


		/**
		 * 차트에 따라서 추가 param 이 있을수 있다.
		 */
		if(chart instanceof aries.chart.scoreboard) {
			var rowcount = $chartDom.attr('rowcount'),
				columncount = $chartDom.attr('columncount'),
				configureCellArray = chart.modelGroup.cmdMap.configureCellArray;

			jQuery('#frm').append("<input type='hidden' name='rowcount' value='"+rowcount+"' />");
			jQuery('#frm').append("<input type='hidden' name='columncount' value='"+columncount+"' />");
			jQuery('#frm').append("<input type='hidden' name='configureCellArray' value='"+JSON.stringify(configureCellArray).replace(/\'/g, "&#39;")+"' />");
		} else if(chart instanceof aries.chart.line.runtime) {
			var isMergedLineMode = chart.isMergedLineMode;

			jQuery('#frm').append("<input type='hidden' name='ismergedlinemode' value='"+isMergedLineMode.toString()+"' />");
		} else if(chart instanceof aries.chart.line.compare) {
            var dateconditionlist = $chartDom.attr('dateconditionlist'),
                labeldateconditionlist = $chartDom.attr('labeldateconditionlist');

            jQuery('#frm').append("<input type='hidden' name='dateconditionlist' value='"+dateconditionlist+"' />");
            jQuery('#frm').append("<input type='hidden' name='labeldateconditionlist' value='"+labeldateconditionlist+"' />");
        } else if(chart instanceof aries.chart.event) {
            var isListRenderModeForEvent = chart.isListRenderMode;

            jQuery('#frm').append("<input type='hidden' name='isListRenderModeForEvent' value='"+isListRenderModeForEvent.toString()+"' />");
        } else if(chart instanceof aries.chart.list.activeservice ) {
            //액티브서비스 리스트
            var columns = $chartDom.attr('columns'),
                perspective = $chartDom.attr('perspective');

            jQuery('#frm').append("<input type='hidden' name='columns' value='"+columns+"' />");
            jQuery('#frm').append("<input type='hidden' name='perspective' value='"+perspective+"' />");
        }

		_frm.method= 'get';
		_frm.action= url;
		_frm.target= key;
		_frm.submit();

	},

	dbconDetailChart = function(url, sid, oid, instanceName, isJMX) {
		var pop = window.open('', 'dbconDetailChart', 'width=1024,height=768,history=no,resizable=no,status=no,scrollbars=yes,menubar=no'),
			_frm = document.frm;

		if(pop) pop.focus();

		jQuery('#frm').empty();
		jQuery('#frm').append("<input type='hidden' name='sid' value='" + sid + "' />");
		jQuery('#frm').append("<input type='hidden' name='oid' value='" + oid + "' />");
		jQuery('#frm').append("<input type='hidden' name='instanceName' value='" + instanceName + "' />");
		jQuery('#frm').append("<input type='hidden' name='isJMX' value='" + isJMX + "' />");


		jQuery('#frm').append("<input type='hidden' name='title' value='ui.label.dbconnection' />");
		jQuery('#frm').append("<input type='hidden' name='charttype' value='equalizer.dbcon' />");
		jQuery('#frm').append("<input type='hidden' name='mxid' value='0' />");
		jQuery('#frm').append("<input type='hidden' name='pkey' value='db_connection_detail' />");



		_frm.method= 'post';
		_frm.action= url;
		_frm.target= 'dbconDetailChart';
		_frm.submit();
	},

	getDomainSelectString = function ($chart) {
		$chart = $($chart);

		var domainBarSync = $chart.attr('domainbarsync') == 'true';
		var isBusiness = $chart.attr('datatype') == 'business';

		if (domainBarSync) {
			if (isBusiness) {
				return aries.manager.business.names();
			} else {
				return aries.manager.element.names();
			}

		} else {
			return "";
		}
	},

	exportCanvas = function(el) {
		var $jenniferChart = $(el).closest('.ariesChart');

		var width = $jenniferChart.width();
		var height = $jenniferChart.height();

		var $canvas = $jenniferChart.find("#Canvas");

		var canvasTitle = $canvas.attr('ctitle');
		var time = getServerMoment().format("YYYY-MM-DD HH:mm:ss");
		var pageTitle = $(".pageTitle").text().trim();
		var title = "[chart.png] " + canvasTitle + " on " + pageTitle ;

		var description  = [
			"<div>" + i18n.get('ui.label.export.chartName') + " : " + canvasTitle + "</div>",
			"<div>" + i18n.get('ui.label.export.pageName') + " : " + pageTitle + "</div>",
			"<div>" + i18n.get('ui.label.export.captureTime') + " : " + time + "</div>",
			"<div>" + i18n.get('ui.label.export.selectedDomain') + " : " + getDomainSelectString($jenniferChart) + "</div>"

		].join('');

		var detail = "";

		Exporter.canvas($canvas[0], {
			title : title,
			fileName: 'chart.png',
			description : description,
			width : width,
			height: height
		}, function () {
			window.errorNotify.add({
				color : 'success',
				type : '',
				level : '',
				name : i18n.get('ui.button.export'),
				subject : title,
				detail : detail,
				time : time
			}, 2000);
		});

	},

	/**
	 *  실시간 라인차트이면서 TPS, 동시사용자 매트릭을 보여주고 있다면 라인합치기 기능이 들어간다.
	 *	http://issue.jennifersoft.com/browse/ARIES-5360
	 */
	changeRuntimeLineChartRenderModeAfterPaintChart = function(iconDom) {
		var $chartDom = jQuery(iconDom).parent().parent(),
			key = $chartDom.attr('data-key');

		var chart = aries.chart.loader.realtimeChart(key);

		if(chart) {
			chart.changeRuntimeLineChartRenderModeAfterPaintChart();

            if(chart.isMergedLineMode) {
                $chartDom.find(".icon-line-separate").show();
                $chartDom.find(".icon-line-merge").hide();
            } else {
                $chartDom.find(".icon-line-separate").hide();
                $chartDom.find(".icon-line-merge").show();
            }

            aries.localStorage.saveDashboardRuntimeLineChartMode(chart);
        }
	},


	/**
	 * 이벤트차트의 모드 변경 아이콘 (리스트형, 아이콘형)
	 */
	changeEventChartRenderModeAfterPaintChart = function(iconDom) {
		var $chartDom = jQuery(iconDom).parent().parent(),
			key = $chartDom.attr('data-key');

		var chart = aries.chart.loader.realtimeChart(key);

		if(chart) {
			chart.changeEventChartRenderModeAfterPaintChart();

            if(chart.isListRenderMode) {
                $chartDom.find(".icon-unorderedlist").hide();
                $chartDom.find(".icon-list1").show();
            } else {
                $chartDom.find(".icon-unorderedlist").show();
                $chartDom.find(".icon-list1").hide();
            }

            //모드 값 저장.
            aries.localStorage.saveDashboardEventChartMode(chart);
        }
	},

	submit = function(form, target, showProgress) {
		if(form) {
			jQuery(form).bind('submit', function(event) {
				event.preventDefault(); 
				
				var $form = jQuery(this),
				url = $form.attr('action');
				
				jQuery.post(url, jQuery(form).serialize() , function(data) {
					jQuery(target).html(data);
				});
				//if(showProgress) progress();
			});
			
			jQuery(form).submit();
			jQuery(form).unbind('submit');
		}
	};
	
	return {
    	update: update,
    	post: post,
        get: get,
        getJSON: getJSON,
        management: management,
        isLoading: isLoading,
        showLoading: showLoading,
        closeLoading: closeLoading,
        checkbox: checkbox,
        popup: popup,
        realtimePopup: realtimePopup,
        chartPopup: chartPopup,
		multidomainChartPopup: multidomainChartPopup,
        getXViewPointListForFilter: getXViewPointListForFilter,
        getXViewPointForAjax: getXViewPointForAjax,
        getXivewPointList: getXivewPointList,
        getXivewPointListForMultiDomain: getXivewPointListForMultiDomain,
        getXivewAppPointList: getXivewAppPointList,
        getXivewUserPointList: getXivewUserPointList,
        getXivewGUIDPointList: getXivewGUIDPointList,
        getXivewCLIENTIDPointList: getXivewCLIENTIDPointList,
        getXivewCLIENTIPPointList: getXivewCLIENTIPPointList,
        getDeltaPointList: getDeltaPointList,
		//getDeployList : getDeployList,
		getDeployListForMultiDomain : getDeployListForMultiDomain,
        getEventList: getEventList,
        getEventListV2: getEventListV2,
        getEventNoticeList: getEventNoticeList,
        getActiveServiceList: activeServiceList,
        getActiveServiceListInSql: activeServiceListInSql,
        getActiveServiceListInExternalcall: activeServiceListInExternalcall,
		activeServiceListForBatchjob: activeServiceListForBatchjob,
        activeServiceListForGroupNode: activeServiceListForGroupNode,
        activeServiceListForIncoming: activeServiceListForIncoming,
        activeServiceListForOutgoing: activeServiceListForOutgoing,
        getActiveServiceListForBusiness: activeServiceListForBusiness,
        getDbconDetailChart: dbconDetailChart,
        activeServiceDetail: activeServiceDetail,
        socketDetail: socketDetail,
		methodStacktraceDetail: methodStacktraceDetail,
        serviceDetail: serviceDetail,
        serviceDumpDetail: serviceDumpDetail,
        submit: submit,
		redirectPost: redirectPost,
		changeEventChartRenderModeAfterPaintChart: changeEventChartRenderModeAfterPaintChart,
		changeRuntimeLineChartRenderModeAfterPaintChart: changeRuntimeLineChartRenderModeAfterPaintChart,
		exportCanvas : exportCanvas
    };
}(aries));
/**
 * Created by kimhakjin on 2017. 3. 27..
 */
aries.localStorage = (function() {
    //localStorage.setItem('myCat', 'Tom');

    saveJSON = function(path, jsonData) {
        localStorage.setItem(path, JSON.stringify(jsonData));
    },

    readJSON = function(path) {
        var jsonData;
        var jsonString = localStorage.getItem(path);

        if(jsonString) {
            jsonData = JSON.parse(jsonString);
        } else {
            jsonData = {};
        }

        return jsonData;
    },

    getDashboardRuntimeLineChartKey = function(runtimeLineChart) {
        var pathname = document.location.pathname;
        var chartKey;
        if(pathname === "/userdefine/dashboard") {
            chartKey = runtimeLineChart.getModel().cmdMap.key;
        } else {
            chartKey = runtimeLineChart.getModel().cmdMap.mxid;
        }

        return pathname + "/" + chartKey;
    },

    saveDashboardRuntimeLineChartMode = function(runtimeLineChart) {
        var propertyKey = getDashboardRuntimeLineChartKey(runtimeLineChart);
        var jsonData = readJSON("RuntimeLineChartMergedLineMode");

        jsonData[propertyKey] = runtimeLineChart.isMergedLineMode;

        saveJSON("RuntimeLineChartMergedLineMode", jsonData);
    },

    readDashboardRuntimeLineChartMode = function(eventChart) {
        var propertyKey = getDashboardRuntimeLineChartKey(eventChart);
        var jsonData = readJSON("RuntimeLineChartMergedLineMode");

        var mode = (jsonData[propertyKey])? jsonData[propertyKey] : undefined;

        return mode;
    },

    getDashboardEventChartKey = function(eventChart) {
        var pathname = document.location.pathname;
        var chartKey;
        if(pathname === "/userdefine/dashboard") {
            chartKey = eventChart.getModel().cmdMap.key;
        } else {
            chartKey = eventChart.getModel().cmdMap.pkey;
        }

        return pathname + "/" + chartKey;
    }

    saveDashboardEventChartMode = function(eventChart) {
        var propertyKey = getDashboardEventChartKey(eventChart);
        var jsonData = readJSON("EventChartListRenderMode");

        jsonData[propertyKey] = eventChart.isListRenderMode;

        saveJSON("EventChartListRenderMode", jsonData);
    },

    readDashboardEventChartMode = function(eventChart) {
        var propertyKey = getDashboardEventChartKey(eventChart);
        var jsonData = readJSON("EventChartListRenderMode");

        var mode = (jsonData[propertyKey])? jsonData[propertyKey] : undefined;

        return mode;
    }

    return {
        save : saveJSON,
        read : readJSON,
        saveDashboardRuntimeLineChartMode : saveDashboardRuntimeLineChartMode,
        readDashboardRuntimeLineChartMode : readDashboardRuntimeLineChartMode,
        saveDashboardEventChartMode : saveDashboardEventChartMode,
        readDashboardEventChartMode : readDashboardEventChartMode
    };
}());
//캐쉬해놓고 dom이벤트에 바인딩하여 내부 데이터 값을 수정하게 한다.
aries.manager = {};
aries.manager.domain = (function() {
		var _data = [],
		_originData = [],
		_type,
		_instanceInfo,
		_multi,
		_domain,
		_cachedSelectedInstanceList = [],
		_cachedSelectedInstanceKeys = [],
		_cachedInstanceKeys = [],
		_cachedSelectedDomainList = [],
		_moreHeightSizeHandler = 0,
		_domainBarPadding = 45,
		//구버젼 핸들러, 1개밖에 등록하지 못하고 (인스턴스, 도메인) 양쪽다 사용했다. 사용코드를 다 제거하면 제거해야함.
		_handler,
		//인스턴스, 도메인 핸들러를 따로 관리, array로 다수를 등록하게 처리.
		_instanceSelectHandlers = [],
		_domainSelectHandlers = [],

		$domain_template = _.template($('#tpl_domain').html()),
		$div_domain = $('#domain_bar > div:nth-child(1) > div:nth-child(1) > div:nth-child(1)');
		
		function _domainInit(domain, i) {
			aries.deprecated("use aries.manager.element");
			domain.__proto__  = {
					key : function() {
						return this.sid;
					},
					
					oid : function() {
						return this.sid;
					},
					
					isActive : function() {
						return true;
					},
					
					isUnlicensed : function() {
				    	return false;
				    },
				    
				    isStopped : function() {
				        return false;
				    },

					isBusiness : function () {
						return false;
					},
				    
					name : function() {
						return this.shortName;
					},
					
					color : function(color) {
				        if(color) {
				        	this._color = color;
				        }
				        
				        return this._color;
				    }
				};
			domain.color(aries.chart.color.newColor(i));

			//도메인 단위의 인스턴스 카운트 정보.
			//인스턴스의 색상을 정의하는데 사용한다.
			domain.insCount = 0;

			return domain;
		}
		
		
		
		function _instanceInit(instance, i) {
			//aries.deprecated("use aries.manager.element");
			delete instance.name;
			instance.__proto__  = {
				key : function() {
					return this.agent;
				},
				
				oid : function() {
			        return this.agent;    
			    },
			    
			    host : function() {
			        return this.hostId;
			    },
			    
			    selected : function(selected) {
			        if(selected == true) {
			        	this.selected = true;
			        } else if(selected == false) {
			        	this.selected = false;
			        }
			        
			        return this.selected;
			    },
			    
			    name : function() {
			        return this.shortName;
			    },

			    
			    isHost : function() {
			        return this.instId == 0;
			    },

			    isActive : function() {
			    	if(!this.isStopped() && !this.isUnlicensed()) {
			    		return true;
			    	} else {
			    		return false;
			    	}
			    },

			    isUnlicensed : function() {
			    	if(this.license_status === LicenseStatusDef.STOPPED_RECENTLY_LICENSE_PROBLEM_OCCURS){
			    		return true;
			    	}
			    	
			    	return false;
			    },
			    
			    isStopped : function() {
			    	if(this.isHost()) {
			    		if(this.status === AgentStatusDef.NONE){
			    			return true;
			    		}
			    	} else {
			    		if(this.license_status === LicenseStatusDef.STOPPED){
			        		return true;
			        	}
			    	}
			    	
			        return false;
			    },
			    
			    isAgent : function() {
			        return true;
			    },

                isBusiness : function () {
                    return false;
                },
			    
			    color : function(color) {
			        if(color) {
			        	this._color = color;
			        }
			        
			        return this._color;
			    }
			};
			instance.color(aries.chart.color.newColor(i));
		}
		
		function selectSingleDomain(sid) {
			//sid에 해당값이 없을수도 있다. 없으면 안되는데.
			aries.deprecated("use aries.manager.element");

			//선택된 값을 날려준다.
			if(_domain && _domain.sid !== sid) {
				$.each(_domain.agent, function(i, instance) {
					instance.selected = false;
				});
				_cachedSelectedInstanceList = [];
				_cachedSelectedInstanceKeys = [];
			}
			
			for(var i=0; count=_data.length, i<count; i++) {
				if(_data[i].sid === sid) {
					_domain = _data[i];
					_domain.selected = !_domain.selected;

					_cachedInstanceKeys = [];
					for(var j= 0, max = _domain.agent.length; j<max; j++) {
						_cachedInstanceKeys.push(_domain.agent[j].key());
					}


				} else {
					_data[i].selected = false;
				}
			}
		}
		
		function filterInstance(data) {
			aries.deprecated("use aries.manager.element");
			//더이상 호스트 데이터를 받지 않기 때문에 체크하지 않는다.
			/*
			var instanceList = [];
			$.each(data, function(index, instance) {
				if(instance.instId > 0) {
					instanceList.push(instance);
				}
			});
			*/
			
			return data;
		}
		
		function filterHost(data) {
			aries.deprecated("use aries.manager.element");
			var hostList = [];
			$.each(data, function(index, host) {
				if(host.instId === 0) {
					hostList.push(host);
				}
			});
			
			return hostList;
		}
		
		function _instanceInDomain(domain, oid) {
			aries.deprecated("use aries.manager.element");
			for(var i=0; i<domain.agent.length; i++) {
				if(domain.agent[i].agent === oid) {
					return domain.agent[i];
				}
			}
			
			return undefined;
		}
		
		function _properTopListBarWidth() {
			aries.deprecated("use aries.manager.element");
			//type이 domain, domain_agent 로 구분될수 있다.
			var $top_bar = $("#domain_bar"),
				width = $top_bar.width(),
				domainBarWidth = width;
				//domainBarWidth = width < 892 ? 892 : width;

			if ($top_bar.attr("type") === "domain") {
				return domainBarWidth;
			} else {
				//아래 영역은 domain_agent 타입만 존재하는 영역.
				//135px 도메인 selectbox영역
				//12px 선택 초기화
				//23px 툴팁 영역

				return domainBarWidth - 135 - 12 - 23;
			}
		}

		
		function _dataInit(data) {
			aries.deprecated("use aries.manager.element");
			//_originData는 원본, _data는 배치잡에 의해 필터링 된 데이터.
			_originData = data;

			var batchjobMode = Number($("#domain_bar").attr("batchjobmode"));
			_data = filterDomainsForBatchjobMode(data, batchjobMode);

			$.each(_data, function(i, domain) {
				_domainInit(domain, i);
				$.each(domain.agent, function(j, instance) {
					_instanceInit(instance, domain.insCount++);
				});

			});

		}

		/**
		 * @david
		 * 마크업에서는 모두표시 하지만 (값에 따라 disable 상태의 스타일로 표현)
		 * aries.manager.domain 에서 데이터를 캐싱할때는 DomainBarBatchjobModeDef 상태에 따라 필터링한다.
		 */
		function filterDomainsForBatchjobMode(domains, mode) {
			aries.deprecated("use aries.manager.element");
			var resultDomains = [];

			for(var i= 0, max=domains.length; i<max; i++) {
				if(_isValidDomainByBatchjobMode(domains[i], mode)) resultDomains.push(domains[i]);
			}

			return resultDomains;
		}

		function _isValidDomainByBatchjobMode(domain, mode) {
			aries.deprecated("use aries.manager.element");
			if(mode === DomainBarBatchjobModeDef.BATCHJOB_EXCLUDE) {
				return (!domain.batchjob)? true : false;

			} else if(mode === DomainBarBatchjobModeDef.BATCHJOB_ONLY) {
				return (domain.batchjob)? true : false;
			}

			return true;
		}
		
		this.init = function(data, type, multi, sid) {
			aries.deprecated("use aries.manager.element");
			_dataInit(data);
			
			_type = type;
			_multi = multi;
			if(sid) {
				if(type === "domain" && multi) {
					$.each(_data, function(index, domain) {
						if(_.indexOf(sid, domain.sid) > -1) {
							domain.selected = true;
						}

					});
				} else {
					selectSingleDomain(sid);
					
					_instanceInfo = _searchInstanceListInfo();
				}
			}

		}
		
		this.callback = function(json) {
			aries.deprecated("use aries.manager.element");
			if(!json.domainAgentList || !json.domainAgentList.data) {
				return;
			}
			
			var data = json.domainAgentList.data;

			var batchjobmode = Number($("#domain_bar").attr("batchjobmode"));
			for(var i=0; i<data.length; i++) {
				if(batchjobmode === DomainBarBatchjobModeDef.BATCHJOB_EXCLUDE) {
					if(data[i].batchjob) continue;
				} else if(batchjobmode === DomainBarBatchjobModeDef.BATCHJOB_ONLY) {
					if(!data[i].batchjob) continue;
				}

				var domain = this.domain(data[i].sid);
				
				if(domain) {
					if(_type === "domain") {
						//도메인의 인스턴스 개수가 달라진다면 인스턴스를 새로 구성한다.
						if(domain.agent.length !== data[i].agent.length) {
							domain.insCount = 0;

							domain.agent = [];


							$.each(data[i].agent, function(i, instance) {
								_instanceInit(instance, domain.insCount++);

								domain.agent.push(instance);
							});
						}

					}

					if(_type === "domain_agent") {
						//멅티인스턴스 상단바일때 현재 바라보고있는 도메인이라면 아래 로직으로 업데이트함.
						if(_domain && _domain.sid === data[i].sid ) {
							var agents = data[i].agent;

							//기존것들 중에 삭제가 되는게 있는지 체크하자.
							for(var j=0, max=_domain.agent.length; j<max; j++) {
								var agent = _domain.agent[j];
								var findedAgents = _.where(agents, { 'agent': agent.agent });

								//새로 받은 인스턴스 리스트중에 기존것을 체크 하여 없다면 지워준다.
								if(findedAgents.length === 0) {
									//삭제 해야함

									var oid = agent.agent;
									_domain.agent.splice(j, 1);
									j--;
									max--;

									// 도메인바 & 도메인확장 인스턴스 삭제
									$("#domain_bar div[oid='"+oid+"']").remove();
									$("#domain_bar_expand div[oid='"+oid+"']").remove();
								}
							}

							//캐싱된 인스턴스 oid 리스트도 동일하게 체크하자.
							for(var j=0, max=_cachedInstanceKeys.length; j<max; j++) {
								var oid = _cachedInstanceKeys[j];
								var findedAgents = _.where(agents, { 'agent': oid });

								//새로 받은 인스턴스 리스트중에 기존것을 체크 하여 없다면 지워준다.
								if(findedAgents.length === 0) {
									_cachedInstanceKeys.splice(j, 1);
									j--;
									max--;

								}
							}

							//캐싱된 선택된 인스턴스 리스트도 동일하게 체크하자.
							for(var j=0, max=_cachedSelectedInstanceList.length; j<max; j++) {
								var agent = _cachedSelectedInstanceList[j];
								var findedAgents = _.where(agents, { 'agent': agent.agent });

								//새로 받은 인스턴스 리스트중에 기존것을 체크 하여 없다면 지워준다.
								if(findedAgents.length === 0) {

									_cachedSelectedInstanceList.splice(j, 1);
									j--;
									max--;

								}
							}

							//캐싱된 선택된 인스턴스 oid 리스트도 동일하게 체크하자.
							for(var j=0, max=_cachedSelectedInstanceKeys.length; j<max; j++) {
								var oid = _cachedSelectedInstanceKeys[j];
								var findedAgents = _.where(agents, { 'agent': oid });

								//새로 받은 인스턴스 리스트중에 기존것을 체크 하여 없다면 지워준다.
								if(findedAgents.length === 0) {
									_cachedSelectedInstanceKeys.splice(j, 1);
									j--;
									max--;

								}
							}

							for(var j=0; j<agents.length; j++) {
								var self = this,
									instance = _instanceInDomain(_domain, agents[j].agent);

								if(!instance) {
									instance = agents[j];

									// instance 추가.
									_instanceInit(instance, _domain.insCount++);
									_domain.agent.push(instance);

									_cachedInstanceKeys.push(instance.agent);

									if(j > 0) {
										this.makeInstanceBar(Number(agents[j-1].agent), function() {
											self.makeInstanceExpand(Number(agents[j].agent));
										});
									} else {
										this.makeInstanceBar(undefined, function() {
											self.makeInstanceExpand();
										});
									}

								} else {
									// 아무일도 없을대도 변경사항이 있다고 고려한다. 문제가 있을수 있다...;;;
									// 데이터 변경
									instance.status = agents[j].status;
									instance.license_status = agents[j].license_status;
									instance.shortName = agents[j].shortName;


									// 도메인바 인스턴스 상태 변경
									var $instance = $("#domain_bar div[oid='"+instance.agent+"']");
									$instance.attr("status", instance.status);
									$instance.attr("license_status", instance.license_status);
									$instance.text(agents[j].shortName);

									// 도메인확장 인스턴스 상태 변경
									var $instance_expand = $("#domain_bar_expand div[oid='"+instance.agent+"']");
									$instance_expand.attr("status", instance.status);
									$instance_expand.attr("license_status", instance.license_status);
									$instance_expand.text(agents[j].shortName);

								}
							}
						}
					}




				} else {
					//호출될일이 없는듯함...
					//--> 도메인 추가 시작
					domain = _domainInit(data[i], _data.length);

					$.each(domain.agent, function(i, instance) {
						_instanceInit(instance, domain.insCount++);
					});
					_data.push(domain);

					$div_domain.append($domain_template({ domain: domain }));
					//--> 도메인 추가 종료
				}
			}
			
			if(_type === "domain_agent") {
				_instanceInfo = _searchInstanceListInfo();
			}
			
			var info = aries.chart.loader.domainRequestInfo();
			if(info.length > 0) {
				window.setTimeout(function() {aries.chart.call.realtimeSend(JSON.stringify(info[0]));}, 2 * 1000);
			}
		}
		
		this.list = function(){
			aries.deprecated("use aries.manager.element");
			//instance or domain
			//선택된게 없다면 전체
			if(_type === "domain_agent") {
				return this.instanceList();
			} else if(_type === "domain") {
				if(_multi) {
					return this.domainList();
				} else {
					return this.instanceList();
				}
			}
		}

		this.instanceKeys = function() {
			aries.deprecated("use aries.manager.element");
			if(_cachedSelectedInstanceKeys.length > 0) return _cachedSelectedInstanceKeys;
			else return _cachedInstanceKeys;
		}

		this.domainKeys = function() {
			aries.deprecated("use aries.manager.element");
			var keys = [];

			if(_multi) {
				var list = this.domainList();

				for(var i=0, max=list.length; i<max; i++) {
					keys.push(list[i].key());
				}
			} else {
				keys.push(_domain.sid);
			}

			return keys;
		}

		/*
		@deprecate
		keys가 될 요소는 최종으로 차트에서 판단하는게 맞다.
		 */
		this.keys = function() {
			aries.deprecated("use aries.manager.element");
			if(_type === "domain_agent") {
				if(_cachedSelectedInstanceKeys.length > 0) return _cachedSelectedInstanceKeys;
				else return _cachedInstanceKeys;
			} else if(_type === "domain") {
				if(_multi) {
					var list = this.domainList(),
						keys = [];

					for(var i=0, max=list.length; i<max; i++) {
						keys.push(list[i].key());
					}

					return keys;
				} else {
					if(_cachedSelectedInstanceKeys.length > 0) return _cachedSelectedInstanceKeys;
					else return _cachedInstanceKeys;
				}
			}


		}
		

		this.instance = function(oid) {
			aries.deprecated("use aries.manager.element");
			return _instanceInDomain(_domain, oid);
		}
		
		this.domain = function(sid) {
			aries.deprecated("use aries.manager.element");
			if(_.isUndefined(_data)) {
				return undefined;
			}

			if(_.isUndefined(sid)) {
				return _domain;
			}

			for(var i=0; i<_data.length; i++) {
				if(_data[i].sid === sid) {
					return _data[i];
				}
			}
			
			return undefined;
		}
		
		//파라메터로 sid를 입력받아야할듯???
		this.findAgentByHost = function(hostId) {
			aries.deprecated("use aries.manager.element");
			var instanceList = [],
			list = this.instanceList();
			
			$.each(list, function(index, instance){
				if(hostId == instance.host() && !instance.isHost()) {
					instanceList.push(instance);
            	}
			});
	    	
	    	return instanceList;
		}

		this.currentSid = function() {
			aries.deprecated("use aries.manager.element");
			var sidArr = []; 
			if(_type === "domain_agent") {
				if (!_domain) {
					return [];
				}
				sidArr.push(_domain.sid);
			} else if(_type === "domain") {
				if(_multi) {
					$.each(_data, function(index, domain) {
						sidArr.push(domain.sid);
					});
				} else {
					sidArr.push(_domain.sid);
				}
			}
			
			return sidArr;
		}
		
		this.multiSid = function() {
			aries.deprecated("use aries.manager.element");
			var sidArr = [];

			if(_.isUndefined(_data)) {
				return [];
			}

			$.each(_data, function(index, domain) {
				sidArr.push(domain.sid);
			});
			
			return sidArr;
		}

		this.instanceList = function(){
			aries.deprecated("use aries.manager.element");
			//instance or domain
			//선택된게 없다면 전체
			if(_domain && _domain.agent) {
				if(_cachedSelectedInstanceList.length > 0) return _cachedSelectedInstanceList;
				else return _domain.agent;
			} else {
				var selectedList = [];
				$.each(_data, function(i, domain) {
					if(domain.selected) {
						$.each(domain.agent, function(index, obj) {
							obj.sid = domain.sid;
							selectedList.push(obj);
						});
					}
				});

				return selectedList;
			}
			

			if(_domain) {
				return _domain.agent;
			} else {
				var selectedList = [];
				$.each(_data, function(i, domain) {
					$.each(domain.agent, function(index, obj) {
						obj.sid = domain.sid;
						selectedList.push(obj);
					});
				});
				return selectedList;
			}
		}

		//인스턴스를 선택했을때 oids를 가져와서 session에 저장할때 사용한다.
		this.selectedInstanceOids = function() {
			aries.deprecated("use aries.manager.element");
			return _cachedSelectedInstanceKeys;
		}

		// 화면에 보이지 않는 도메인 목록
		this.remainDomainList = function() {
			aries.deprecated("use aries.manager.element");
			var result = [];

			if(_data) {
				var bar_sids = [];

				$('#domain_bar .listBar > div.domain').each(function(i) {
					bar_sids.push(parseInt($(this).attr("sid")));
				});


				for(var i = 0, len = _data.length; i < len; i++) {
					if($.inArray(_data[i].sid, bar_sids) == -1) {
						result.push(_data[i]);
					}
				}
			}

			return result;
		}

		// 화면에 보이지 않는 인스턴스 목록
		this.remainInstanceList = function() {
			aries.deprecated("use aries.manager.element");
			var result = [];
			
			if(_domain && _domain.sid) {
				var bar_oids = [];

				$('#domain_bar .listBar > div.agent').each(function(i) {
					bar_oids.push(parseInt($(this).attr("oid")));
				});

				var currentDomain = _.findWhere(_data, { sid: _domain.sid }),
					agents = currentDomain.agent;
				
				for(var i = 0, len = agents.length; i < len; i++) {
					if($.inArray(agents[i].oid(), bar_oids) == -1) {
						result.push(agents[i]);
					}
				}
			}
			
			return result;
		}
		
		this.fixedInstanceList = function(domain) {
			aries.deprecated("use aries.manager.element");
			if(domain) {
				return filterInstance(domain.agent);
			} else {
				return (!_domain || !_domain.agent) ? [] : filterInstance(_domain.agent);
			}
		}
		
		this.firstLiveInstance = function(domain) {
			aries.deprecated("use aries.manager.element");
			var list = this.fixedInstanceList(domain);
			for(var i=0; i<list.length; i++) {
				if(list[i].isActive()){
					return list[i];
				}
			}
		}
		
		this.isSelectedInstance = function() {
			aries.deprecated("use aries.manager.element");
			if(!_domain) {
				return false;
			}
			
			var agents = _domain.agent;
			for(var i=0; i<agents.length; i++) {
				if(agents[i].selected && agents[i].instId > 0) {
					return true;
				}
			}
			
			
			return false;
		}
		
		this.selectedInstanceCount = function() {
			aries.deprecated("use aries.manager.element");
			if(!_domain) {
				return false;
			}
			var count = 0;
			$.each(_domain.agent, function(index, obj) {
				if(obj.selected && obj.instId > 0) {
					count++;
				}
			});
			
			return count;
		}
		
		this.domainList = function() {
			aries.deprecated("use aries.manager.element");
			var selectedList = [];
			
			if(_.isUndefined(_data)) {
				return [];
			}
			
			$.each(_data, function(index, domain) {
				if(domain.selected) {
					selectedList.push(domain);
				}
			});
			
			if(selectedList.length > 0) {
				return selectedList;
			} else {
				return _data;
			}
		}
		
		this.selectedDomainList = function() {
			aries.deprecated("use aries.manager.element");
			var selectedList = [];
			$.each(_data, function(index, domain) {
				if(domain.selected) {
					selectedList.push(domain);
				}
			});
			
			return selectedList;
		}
		
		this.selectedSids = function() {
			aries.deprecated("use aries.manager.element");
			var selectedSids = [];
			$.each(_data, function(index, domain) {
				if(domain.selected) {
					selectedSids.push(domain.sid);
				}
			});
			
			return selectedSids;
		}

		/**
		 * @david
		 * 호스트 단위로 가져오는것이 없어져서 사용안하는듯
		 */

		this.hostList = function() {
			aries.deprecated("use aries.manager.element");
			if(_type === "domain" && _multi) {
				var list = [], domainList = this.domainList();
				$.each(domainList, function(index, domain) {
					list = list.concat(filterHost(domain.agent));
				});
				return list;
			} else {
				return filterHost(_domain.agent);
			}
		}


		/**
		 * @david
		 * 호스트 단위로 가져오는것이 없어져서 사용안하는듯
		 */
		this.hostMap = function() {
			aries.deprecated("use aries.manager.element");
			var list = this.hostList(),
			obj = {};
			
			$.each(list, function(index, data){
				obj[data.key()] = data;
			});
			
			return obj;
		}
		
		this.type = function() {
			aries.deprecated("use aries.manager.element");
			return _type;
		}
		
		this.isMultiDomain = function() {
			aries.deprecated("use aries.manager.element");
			if(_type === "domain" && _multi) {
				return true;
			}
			
			return false;
		}
		
		this.emitInstanceSelect = function(oid) {
			aries.deprecated("use aries.manager.element");
			if(!_domain || !_domain.agent) return;

			//캐싱된 인스턴스 리스트에 적용하기.
			_cachedSelectedInstanceList = [];
			_cachedSelectedInstanceKeys = [];
			if(_multi) {
				$.each(_domain.agent, function(index, obj) {
					if(obj.oid() === oid) {
						obj.selected = !obj.selected;
					}

					if(obj.selected) {
						_cachedSelectedInstanceList.push(obj);
						_cachedSelectedInstanceKeys.push(obj.key());
					}
				});
			} else {
				$.each(_domain.agent, function(index, obj) {
					if(obj.oid() === oid) {
						obj.selected = true;
					} else {
						obj.selected = false;
					}

					if(obj.selected) {
						_cachedSelectedInstanceList.push(obj);
						_cachedSelectedInstanceKeys.push(obj.key());
					}
				});
			}


			if(_handler) {
	            _handler();
	        }

			instanceSelectHandlers();

			
			aries.chart.xview.clear();

		}
		
		this.emitDomainSelect = function(sid) {
			aries.deprecated("use aries.manager.element");
			if(_type === "domain" && _multi) {
				var domain = this.domain(sid);
				domain.selected = !domain.selected;
			} else {
				selectSingleDomain(sid);
				if(_handler) {
		            _handler();
		        }

				aries.chart.xview.clear();
			}

			domainSelectHandlers();
		}
		
		this.createInstance = function(obj, i) {
			_instanceInit(obj, i);
			return obj;
		}
		
		//토플로지에서 사용.
		//false라면 권한이 없다고 표시함.
		this.existInstance = function(sid, oid) {
			aries.deprecated("use aries.manager.element");
			var exist = false;
			$.each(_data, function(index, domain) {
				if(domain.sid === sid) {
					$.each(domain.agent, function(index, instance) {
						if(instance.oid() === oid) {
							exist = true;
						}
					});
				}
			});
			
			return exist;
		}

		//
		/**
		 * instanceSelectHandlers or domainSelectHandlers 로 변경해야함.
		 * 호출되는곳을 모두 변경하면 제거해야함.
		 * @deprecated
		 * @param handler
		 * @returns {*}
		 */
		this.handler = function(handler) {
			aries.deprecated("use aries.manager.element");
			if(handler) {
	    		_handler = handler;
	    	}
	    	
	    	return this;
		}

		this.instanceSelectHandlers = function(handler) {
			aries.deprecated("use aries.manager.element");
			if(handler) {
				_instanceSelectHandlers.push(handler);
			} else {
				for(var i=0, max=_instanceSelectHandlers.length; i<max; i++) {
					_instanceSelectHandlers[i]();
				}
			}
		}

		this.domainSelectHandlers = function(handler) {
			aries.deprecated("use aries.manager.element");
			if(handler) {
				_domainSelectHandlers.push(handler);
			} else {
				for(var i=0, max=_domainSelectHandlers.length; i<max; i++) {
					_domainSelectHandlers[i]();
				}
			}
		}
		
		//For domain-multiInstance
		function _searchInstanceListInfo() {
			aries.deprecated("use aries.manager.element");
			var info = {};
			
			var totalCount = 0, 
			liveCount = 0,
			stopCount = 0,
			licenseCount = 0;
			
			if(!_.isUndefined(_domain)) {
				$.each(_domain.agent, function(index, obj) {
					if(obj.isActive()) {
						liveCount++;
					} else if(obj.isUnlicensed()) {
						licenseCount++;
					} else if(obj.isStopped()) {
						stopCount++;
					} 
				});
				
				totalCount = _domain.agent.length;
			}
			
			
			
			info.total = totalCount;
			info.live = liveCount;
			info.stop = stopCount;
			info.license = licenseCount;
			
			return info;
		}
		
		this.getInstanceListInfo = function() {
			aries.deprecated("use aries.manager.element");
			_instanceInfo = _searchInstanceListInfo();
			
			return _instanceInfo;
		}

		this.makeDomainElement = function(sid, callback) {
			aries.deprecated("use aries.manager.element");
			var $list_bar = $('#domain_bar .listBar'),
			$domain_element_template = _.template($('#tpl_domain_element').html());

			$(".navi .instanceAll").addClass("disabled");

			var index = -1;

			$.each(_originData, function(i, domain) {
				if(domain.sid === sid) {
					index = i;
					return false;
				}
			});


			var findIndex = index+1;
			if(findIndex > _originData.length-1) {
				return;
			}


			var domain = _originData[findIndex];

			if($list_bar.find('div.domain[sid='+domain.sid+']').length === 0) {
				//mode, message를 넣어주자.
				var batchjobMode = Number($("#domain_bar").attr("batchjobmode"));
				var onlyBatchjobMessage = i18n.get("M0402"), excludeBatchjobMessage = i18n.get("M0403");
				var message = "";
				if(batchjobMode === DomainBarBatchjobModeDef.BATCHJOB_EXCLUDE && domain.batchjob) message = excludeBatchjobMessage;
				if(batchjobMode === DomainBarBatchjobModeDef.BATCHJOB_ONLY && !domain.batchjob) message = onlyBatchjobMessage;

				$list_bar.append($domain_element_template(
					{'domain': domain, 'batchjobMode': batchjobMode, 'message': message}));
				$("#domain_bar_expand div.domain[sid="+domain.sid+"]").remove();
			}

			if(_properTopListBarWidth() - _domainBarPadding <= $list_bar.width()) {
				//오른쪽 화살표 표시하자
				$(".navi .instanceAll").removeClass("disabled");
				$("#domain_bar .listBar > div.domain[sid="+domain.sid+"]").remove();

				//공간이 부족하니 다시 extend에 넣야함.M402
				$("#domain_bar_expand").prepend($domain_element_template({ domain: domain }));

				this.moreHeightSizeHandler();

				//모든 에이젼트가 렌더링 되지 않을수 있다(개수가 많으면)
				//그 경우는 여기서 callback을 수행한다.
				if(typeof(callback) == "function") {
					callback();
				}

			} else {
				var lastSid = domain.sid;

				window.setTimeout(function(handler, previousSid) {
					handler.makeDomainElement(Number(previousSid), callback);
				}, 30, this, lastSid);
			}

		}

		this.makeDomainElementExpand = function(sid) {
			aries.deprecated("use aries.manager.element");
			var domains = this.remainDomainList();

			var $domain_bar_expand = $("#domain_bar_expand"),
				$domain_template = _.template($('#tpl_domain_element').html());

			for(var i = 0; i < domains.length; i++) {
				if( (typeof(sid) == "number" && sid == domains[i].sid) ||
					(typeof(sid) == "undefined") ) {
					$domain_bar_expand.append($domain_template({ domain: domains[i] }));
				}
			}
		}

		/**
		 * @david
		 * 에이젼트바가 초기에 스타일이 입혀지지 않아 width계산이 꼬여 100ms에 하나씩 추가되도록 함.
		 */
		this.makeInstanceBar = function(oid, callback) {
			aries.deprecated("use aries.manager.element");
			var $instance_bar = $('#domain_bar .listBar'),
			$instance_template = _.template($('#tpl_instance_element').html());
			
			$(".navi .instanceAll").addClass("disabled");
			
			var index = -1;
			if(_.isUndefined(_domain)) {
				return;
			}
			
			var currentDomain = _.findWhere(_data, {sid: _domain.sid});
			var agents = currentDomain.agent;
			if(!_.isUndefined(oid)) {
				for(var i=0, max=agents.length; i<max; i++) {
					if(agents[i].oid() === oid) {
						index = i;
						break;
					}
				}
				
				if(index === -1){
					return;
				}
			}
			
			var findIndex = index+1;
			if(findIndex > agents.length-1) {
				return;
			}
			
			var instance = currentDomain.agent[findIndex];
			if(instance.instId !== 0) {
				if($instance_bar.find('div.agent[oid='+instance.oid()+']').length === 0) {
					$instance_bar.append($instance_template({'instance': instance}));
					$("#domain_bar_expand div.agent[oid="+instance.oid()+"]").remove();
				}
				
				if(_properTopListBarWidth() - _domainBarPadding <= $('#domain_bar .listBar').width()) {

					//오른쪽 화살표 표시하자
					$(".navi .instanceAll").removeClass("disabled");
					$('#domain_bar .listBar > div:last-child').remove();
					//공간이 부족하니 다시 extend에 넣야함.
					$("#domain_bar_expand").prepend($instance_template({ instance: instance }));

					this.moreHeightSizeHandler();

					//모든 에이젼트가 렌더링 되지 않을수 있다(개수가 많으면)
					//그 경우는 여기서 callback을 수행한다.
					if(typeof(callback) == "function") {
						callback();
					}
					
				} else {
					var lastOid = instance.oid();
					
					window.setTimeout(function(handler, previousOid) {
						handler.makeInstanceBar(Number(previousOid), callback);
					}, 30, this, lastOid);
				}
			}
			
			// 도메인바 마지막 에이전트 렌더링 이후에 콜백 호출
			if(typeof(callback) == "function") { 
				if(findIndex == agents.length - 1) {
					callback();
				}
			}
		}
		
		this.makeInstanceExpand = function(oid) {
			aries.deprecated("use aries.manager.element");
			var agents = this.remainInstanceList();
			
			var $domain_bar_expand = $("#domain_bar_expand"),
				$instance_template = _.template($('#tpl_instance_element').html());

			//기존에 없어야만 추가한다.
			if($domain_bar_expand.find('div.agent[oid='+oid+']').length === 0) {
				for(var i = 0; i < agents.length; i++) {
					if( (typeof(oid) == "number" && oid == agents[i].oid()) ||
						(typeof(oid) == "undefined") ) {
						$domain_bar_expand.append($instance_template({ instance: agents[i] }));
					}
				}
			}

		}

		this.moreHeightSizeHandler = function(callback) {
			aries.deprecated("use aries.manager.element");
			var $domain_bar_expand = $("#domain_bar_expand");

			if(callback) {
				_moreHeightSizeHandler = callback;
			} else {
				var height = 0;
				if($domain_bar_expand.filter(":visible").length > 0) height = $domain_bar_expand.outerHeight();

				_moreHeightSizeHandler(height);

				fixPosNSizeDefineContentCharts();
			}
		}
		
		this.unSelectedAllDomainsWithCss = function() {
			aries.deprecated("use aries.manager.element");
			$.each(_data, function(index, domain) {
				if(domain.selected) {
					domain.selected = false;
				}
			});
			
			$('#domain_bar').find('.selectedDomain').removeClass('selectedDomain');
		}
		
		this.changeInstanceBar = function(callback) {
			aries.deprecated("use aries.manager.element");
			var $list_bar = $('#domain_bar .listBar');
			
			// 인스턴스 삭제
			if(_properTopListBarWidth() -_domainBarPadding <= $list_bar.width()) {
				_removeLastInstance();
				if(typeof(callback) == "function") callback();
				

			} else {
				// 인스턴스 추가거나 도메인 추가해야함.

				var type = $('#domain_bar').attr("type");

				if($('#domain_bar').attr("type") === "domain") {
					var lastSid = $('#domain_bar .listBar > div.domain:last-child').attr("sid");
					this.makeDomainElement(Number(lastSid), callback);
				} else {
					var lastOid = $('#domain_bar .listBar > div.agent:last-child').attr("oid");
					this.makeInstanceBar(Number(lastOid), callback);
				}

			}


			// 로드시 콜백 실행
			if(typeof(callback) == "function") callback();
		}
		
		function _removeLastInstance() {
			aries.deprecated("use aries.manager.element");
			var $list_bar = $('#domain_bar .listBar'),
				$domain_bar_expand = $("#domain_bar_expand");

			if($('#domain_bar').attr("type") === "domain") {
				var lastSid = $('#domain_bar .listBar > div.domain:last-child').attr("sid");
				//이걸 extend에 추가해야함.

				var $domain_template = _.template($('#tpl_domain_element').html());

				var domain = aries.manager.domain.domain(Number(lastSid));
				if(domain) $domain_bar_expand.prepend($domain_template({ domain: domain }));

			} else {
				var lastOid = $('#domain_bar .listBar > div.agent:last-child').attr("oid");
				//이걸 extend에 추가해야함.

				var $instance_template = _.template($('#tpl_instance_element').html());

				var agent = aries.manager.domain.instance(Number(lastOid));
				if(agent)	$domain_bar_expand.prepend($instance_template({ instance: agent }));
			}

			$(".navi .instanceAll").removeClass("disabled");
			$('#domain_bar .listBar > div:last-child').remove();

			//_removeLastInstance()를 여러번 재귀호출 되도록 수정함. 전체 <-> 창모드 전환시에 발생가능함.
			if(_properTopListBarWidth() -_domainBarPadding <= $list_bar.width()) {
				window.setTimeout(function() {
					_removeLastInstance();
				}, 30);
			} else {
				//제거 끝.
				//사이즈 변경 콜백 해야함.
				this.moreHeightSizeHandler();
			}
		}
		
		return {
			init: init,
			currentSid: currentSid,
			multiSid: multiSid,
			hostList: hostList,
			domain: domain,
			instance: instance,
			instanceKeys: instanceKeys,
			domainKeys: domainKeys,
			list: list,
			keys: keys,
			filterDomainsForBatchjobMode: filterDomainsForBatchjobMode,
			domainList: domainList,
			remainDomainList: remainDomainList,
			remainInstanceList: remainInstanceList,
			selectedDomainList: selectedDomainList,
			selectedSids: selectedSids,
			instanceList: instanceList,
			selectedInstanceOids: selectedInstanceOids,
			getInstanceListInfo: getInstanceListInfo,
			callback: callback,
			type: type,
			isMultiDomain: isMultiDomain,
			findAgentByHost: findAgentByHost,
			isSelectedInstance: isSelectedInstance,
			hostMap: hostMap,
			fixedInstanceList: fixedInstanceList,
			emitInstanceSelect: emitInstanceSelect,
			emitDomainSelect: emitDomainSelect,
			createInstance: createInstance,
			existInstance: existInstance,
			firstLiveInstance: firstLiveInstance,
			selectedInstanceCount: selectedInstanceCount,
			makeInstanceBar: makeInstanceBar,
			makeInstanceExpand: makeInstanceExpand,
			makeDomainElement: makeDomainElement,
			makeDomainElementExpand: makeDomainElementExpand,
			moreHeightSizeHandler: moreHeightSizeHandler,
			changeInstanceBar: changeInstanceBar,
			handler: handler,
			instanceSelectHandlers: instanceSelectHandlers,
			domainSelectHandlers: domainSelectHandlers,
			unSelectedAllDomainsWithCss: unSelectedAllDomainsWithCss
		};
}());
//사용자 정의 대시보드에서 모든 도메인 데이터와 인스턴스를 캐싱하기 위해 사용함.
aries.manager = aries.manager || {};
aries.manager.domaincache = (function() {
		var _data = [],
		_instanceInfo,
		_handler;
		
		function _domainInit(domain, i) {
			aries.deprecated("use aries.manager.element");
			domain.__proto__  = {
					key : function() {
						return this.sid;
					},
					
					oid : function() {
						return this.sid;
					},
					
					isActive : function() {
						return true;
					},
					
					isUnlicensed : function() {
				    	return false;
				    },
				    
				    isStopped : function() {
				        return false;
				    },

					isBusiness : function () {
						return false;
					},

					name : function() {
						return this.shortName;
					},
					
					color : function(color) {
				        if(color) {
				        	this._color = color;
				        }
				        
				        return this._color;
				    }
				};
			domain.color(aries.chart.color.newColor(i));
		}
		
		
		
		function _instanceInit(instance, i) {
			aries.deprecated("use aries.manager.element");
			delete instance.name;
			instance.__proto__  = {
				key : function() {
					return this.agent;
				},
				
				oid : function() {
			        return this.agent;    
			    },
			    
			    host : function() {
			        return this.hostId;
			    },
			    
			    selected : function(selected) {
			        if(selected == true) {
			        	this.selected = true;
			        } else if(selected == false) {
			        	this.selected = false;
			        }
			        
			        return this.selected;
			    },
			    
			    name : function() {
			        return this.shortName;
			    },

			    
			    isHost : function() {
			        return this.instId == 0;
			    },

			    isActive : function() {
			    	if(!this.isStopped() && !this.isUnlicensed()) {
			    		return true;
			    	} else {
			    		return false;
			    	}
			    },

				isUnlicensed : function() {
					if(this.license_status === LicenseStatusDef.STOPPED_RECENTLY_LICENSE_PROBLEM_OCCURS){
						return true;
					}

					return false;
				},

				isStopped : function() {
					if(this.isHost()) {
						if(this.status === AgentStatusDef.NONE){
							return true;
						}
					} else {
						if(this.license_status === LicenseStatusDef.STOPPED){
							return true;
						}
					}

					return false;
				},
			    
			    isAgent : function() {
			        return true;
			    },

                isBusiness : function () {
                    return false;
                },
			    
			    color : function(color) {
			        if(color) {
			        	this._color = color;
			        }
			        
			        return this._color;
			    }
			};
			instance.color(aries.chart.color.newColor(i));
		}
		
		
		function _instanceInDomain(domain, oid) {
			aries.deprecated("use aries.manager.element");
			for(var i=0; i<domain.agent.length; i++) {
				if(domain.agent[i].agent === oid) {
					return domain.agent[i];
				}
			}
			
			return undefined;
		}
		
		function _dataInit(data) {
			aries.deprecated("use aries.manager.element");
			_data = data;
			
			$.each(_data, function(i, domain) {
				_domainInit(domain, i);
				$.each(domain.agent, function(j, instance) {
					_instanceInit(instance, j);
				});
				
			});
			
		}
		
		this.init = function(data) {
			aries.deprecated("use aries.manager.element");
			_dataInit(data);
			
			this.domainCmd = {};
			this.domainCmd.key = 'domainAgentListForUserDefine';
			this.domainCmd.sid = this.multiSid();
			this.domainCmd.mxid = CMD.domain_agent_list;
	    	this.domainCmd.otype = OType.SYSTEM;
	    	this.domainCmd.oid = [OIDs.ALL_INST];
	    	this.domainCmd.ptype = PType.MISC;
	    	this.domainCmd.pkey = 'domain_agent_list';
		}
		
		this.getDomainCmd = function() {
			aries.deprecated("use aries.manager.element");
			return this.domainCmd;
		}
		
		this.callback = function(json) {
			aries.deprecated("use aries.manager.element");
			if(!json.domainAgentListForUserDefine || !json.domainAgentListForUserDefine.data) {
				return;
			}
			
			var data = json.domainAgentListForUserDefine.data;
			//비교해서 상태변경, 삭제, 추가만 하자.
			
			for(var i=0; i<data.length; i++) {
				var domain = this.domain(data[i].sid);
				if(!domain) {
					domain = data[i];
					_domainInit(data[i], _data.length);

					$.each(domain.agent, function(i, instance) {
						_instanceInit(instance, i);
					});
					
					_data.push(domain);
				} else {
					if(domain.sid === data[i].sid) {
						
						var agents = data[i].agent;
						//기존것들 중에 삭제가 되는게 있는지 체크하자.
						for(var j=0, max=domain.agent.length; j<max; j++) {
							var agent = domain.agent[j];
							
							var findedAgents = _.where(agents, { 'agent': agent.agent });
							if(findedAgents.length === 0) {
								//삭제 해야함
							
								var oid = agent.agent;
								domain.agent.splice(j, 1);
								j--;
								max--;
								
							}
						}
						
						for(var j=0; j<agents.length; j++) {
							var instance = _instanceInDomain(domain, agents[j].agent);
							if(!instance) {
								instance = agents[j];
								//instance 추가.
								_instanceInit(instance, j);
								domain.agent.push(instance);
								
							} else {
								//아무일도 없을대도 변경사항이 있다고 고려한다. 문제가 있을수 있다...;;;
								//데이터 변경
								instance.status = agents[j].status;
								instance.license_status = agents[j].license_status;
								instance.shortName = agents[j].shortName;
							}
							
						}
					}
				}
			}
			var domainCmd = this.domainCmd;
				
			window.setTimeout(function() {aries.chart.call.realtimeSend(JSON.stringify(domainCmd));}, 2 * 1000);
			
		}
		
		
		this.domain = function(sid) {
			aries.deprecated("use aries.manager.element");
			for(var i=0; i<_data.length; i++) {
				if(_data[i].sid === sid) {
					return _data[i];
				}
			}
			
			return undefined;
		}
		
		this.instance = function(sid, oid) {
			aries.deprecated("use aries.manager.element");
			var domain = this.domain(sid); 
			
			if(!_.isUndefined(domain)) {
				for(var i=0, max=domain.agent.length; i<max; i++) {
					var instance = domain.agent[i];
					if(instance.oid() === oid) {
						return instance;
					}
				}
			}
			
			
			return undefined;
		}
		
		
		this.multiSid = function() {
			aries.deprecated("use aries.manager.element");
			var sidArr = []; 
			
			$.each(_data, function(index, domain) {
				sidArr.push(domain.sid);
			});
			
			return sidArr;
		}
		
		
		this.domainList = function() {
			aries.deprecated("use aries.manager.element");
			var selectedList = [];
			
			if(_.isUndefined(_data)) {
				return [];
			}
			
			$.each(_data, function(index, domain) {
				if(domain.selected) {
					selectedList.push(domain);
				}
			});
			
			if(selectedList.length > 0) {
				return selectedList;
			} else {
				return _data;
			}
		}
		

		
		this.createInstance = function(obj, i) {
			aries.deprecated("use aries.manager.element");
			_instanceInit(obj, i);
			return obj;
		}
		
		//토플로지에서 사용.
		//false라면 권한이 없다고 표시함.
		this.existInstance = function(sid, oid) {
			aries.deprecated("use aries.manager.element");
			var exist = false;
			$.each(_data, function(index, domain) {
				if(domain.sid === sid) {
					$.each(domain.agent, function(index, instance) {
						if(instance.oid() === oid) {
							exist = true;
						}
					});
				}
			});
			
			return exist;
		}
		
		this.handler = function(handler) {
			aries.deprecated("use aries.manager.element");
			if(handler) {
	    		_handler = handler;
	    	}
	    	
	    	return this;
		}
		
		
		
		
		return {
			init: init,
			getDomainCmd: getDomainCmd,
			multiSid: multiSid,
			domain: domain,
			instance: instance,
			domainList: domainList,
			callback: callback,
			createInstance: createInstance,
			existInstance: existInstance,
			handler: handler
		};
}());
/**
 * 기존에 사용하던  aries.manager.domain 을 대체합니다.
 *
 *  1. 타입을 가지지 않고  순수 data 만 보관합니다.
 *  2. selected 상태를 캐쉬로 항상 가지고 있습니다.
 *  3. data 는 계층 구조가 아니라  list 형태로 보관되고
 *  4. domain, instance 모두 유일한 id 를 가집니다.
 *  5. select 가 변경되면  무조건 cache 를 생성합니다.
 *  6. handler 라는 개념을 쓰지 않고 jennifer.core.js 에 있는 event 를 사용합니다. (Observer pattern)
 *  7.  즉, 이코드에는 외부와 연결되는 코드가 있으면 안됩니다. 순수한 데이타 덩어리입니다.
 *  ps. 어떠한 외부 코드도 넣지 마세요.
 *
 *  // 중요
 *  8. 타입을 가지지 않는 이유는 selected 된 상태만 가지기 때문입니다. selected 된 리스트를 어떻게 쓰던, domainbar 나 chart 에서 제어합니다.
 *     즉, chart 에서 자기가 처리할 데이타 타입을 이미 다 가지고 있어야합니다.
 *
 *  몇가지 이벤트를 가집니다.
 *
 *  aries.manager.element:select  -  select 상태가 변경될때 일어납니다. 다른 컴포넌트에서 해당 이벤트를 받아서 사용하세요.
 *
 */
aries.manager.element = (function() {

		var _data = [], _batchjobMode, _objectList = {}, _domainList = [],  _cache = { domainList : [], instanceList : [], selectedDomainList : [], selectedInstanceList : [] }, _info = { totalCount : 0, live : 0, stop : 0, license : 0};

		// group 전체 정보 설정, 그룹은 고정된 데이타이기 때문에 최초 로드할때 domain id 리스트를 가질 수 있는 구조로 만든다.
		var _group = [], _selectedGroup = -1;

		var _colorManager = [], _colorManagerKeys = {}, _colorCodeManager = {};
		var _colorDomainManager = [], _colorDomainManagerKeys = {}, _colorDomainCodeManager = {};

		//////////////////////////////////////////
		////
		////  Private Functions
		////
		////////////////////////////////////////////

		function each (arr, callback, context) {
			for(var i = 0, len = arr.length; i < len; i++) {
				var ret = callback.call(context, i, arr[i]);

				// 루프를 돌다가 나오고 싶으면 return false; 를 하면 된다.
				if (ret === false) {
					break;
				}
			}
		}

		function filter (arr, callback) {
			var list = [];
			each(arr, function (i, element) {
				if (callback(element)) {
					list.push(element);
				}
			})

			return list;
		}

		function filterOne(arr, callback) {
			return filter(arr, callback)[0];
		}

		function map (arr, callback) {
			var list = [];
			each(arr, function (i, element) {
				list.push(callback(element));
			});

			return list;
		}

		// 각 id 별로 유일한 색상을 만든다.
		function createColor(id) {
			if (_colorManagerKeys[id]) {
				return _colorManagerKeys[id];
			}

			// 색상코드가 없으면 새로 지정한다.
			_colorManagerKeys[id] = aries.chart.color.newColor(_colorManager.length);
			_colorCodeManager[_colorManagerKeys[id].getRGB() + ""] = id;
			_colorManager.push(_colorManagerKeys[id]);

			return _colorManagerKeys[id];

		}

		// 각 id 별로 유일한 색상을 만든다.
		function createDomainColor(id) {
			if (_colorDomainManagerKeys[id]) {
				return _colorDomainManagerKeys[id];
			}

			// 색상코드가 없으면 새로 지정한다.
			_colorDomainManagerKeys[id] = aries.chart.color.newColor(_colorDomainManager.length);
			_colorDomainCodeManager[_colorDomainManagerKeys[id].getRGB() + ""] = id;
			_colorDomainManager.push(_colorDomainManagerKeys[id]);

			return _colorDomainManagerKeys[id];

		}

		// domain 객체 생성
		function _domainInit(domain, i) {
			domain.__proto__  = {
					key : function() {
						return this.id;
					},

					oid : function() {
						return this.sid;
					},

					isActive : function() {
						return true;
					},

					isUnlicensed : function() {
				    	return false;
				    },

					isDomain : function () {
						return true;
					},

					isAgent : function () {
						return false;
					},

				    isStopped : function() {
				        return false;
				    },

					isBusiness : function () {
						return false;
					},

					name : function() {
						return this.shortName;
					},

					color : function(color) {
				        if(color) {
				        	this._color = color;
				        }

				        return this._color;
				    }
				};
			domain.color(createDomainColor(domain.id));

			//도메인 단위의 인스턴스 카운트 정보.
			//인스턴스의 색상을 정의하는데 사용한다.
			domain.insCount = 0;

			// 아이디 설정
			domain.hash = "#" + domain.id;

			return domain;
		}


		// instance 객체 생성
		function _instanceInit(instance, i) {
			delete instance.name;
			instance.__proto__  = {
				key : function() {
					return this.id;
				},

				keys : function () {
					return { sid : this.sid, agent : this.agent};
				},

				oid : function() {
			        return this.agent;
			    },

			    host : function() {
			        return this.hostId;
			    },

			    selected : function(selected) {
			        if(selected == true) {
			        	this.selected = true;
			        } else if(selected == false) {
			        	this.selected = false;
			        }

			        return this.selected;
			    },

			    name : function() {
			        return this.shortName;
			    },


			    isHost : function() {
			        return this.instId == 0;
			    },

			    isActive : function() {
			    	if(!this.isStopped() && !this.isUnlicensed()) {
			    		return true;
			    	} else {
			    		return false;
			    	}
			    },

			    isUnlicensed : function() {
			    	if(this.license_status === LicenseStatusDef.STOPPED_RECENTLY_LICENSE_PROBLEM_OCCURS){
			    		return true;
			    	}

			    	return false;
			    },

			    isStopped : function() {
			    	if(this.isHost()) {
			    		if(this.status === AgentStatusDef.NONE){
			    			return true;
			    		}
			    	} else {
			    		if(this.license_status === LicenseStatusDef.STOPPED){
			        		return true;
			        	}
			    	}

			        return false;
			    },

				isDomain: function () {
					return false;
				},

			    isAgent : function() {
			        return true;
			    },

                isBusiness : function () {
                    return false;
                },

			    color : function(color) {
			        if(color) {
			        	this._color = color;
			        }

			        return this._color;
			    }
			};
			instance.color(createColor(instance.id));
			instance.hash = "#" + instance.id;
		}

		// 현재 선택된 리스트에 대한 캐쉬를 만든다.
		function generateCache () {

			// 가지고 있는 도메인 전체 리스트 호출
			var domainList = getDomainList();

			// 그 중에 실제로 사용되는 , domain group 에 속한 리스트만 추출
			var domainGroupList = map(aries.manager.domaingroup.getSelectedDomainList(), function (it) {
				return ID.domain(it);
			});

			if (domainGroupList.length) {
				// _domainList 로 현재 실행되고 있는 domain 만 출력
				_domainList = map(domainGroupList, function (domainId) {
						return domainId;
					}
				);
			} else {
				// 없으면 없는  상태로 보여줌
				_domainList = [];			// 아무것도 없을 때는  비어있는 목록으로 가지고 있는다.
			}

			// 캐쉬는 _domainList 를 기준으로 만들어준다. 

			// 전체 instance 리스트를 가지고 있음.
			_cache = getSelectedInstance(true);

			// 순수하게 선택된 것들만 가지고 있음 .
			_cache.selectedDomainList = filter(_cache.domainList, function (id) {
				return _objectList[id].selected;
			});

			_cache.selectedInstanceList = filter(_cache.instanceList, function (id) {
				return _objectList[id].selected;
			});

			_cache.hasSelectedDomain = !!_cache.selectedDomainList.length;
			_cache.hasSelectedInstance = !!_cache.selectedInstanceList.length;


			// instance 카운트를 세어보자.
			var totalCount = 0, liveCount = 0, stopCount = 0, licenseCount = 0;
			each(_cache.instanceList, function (i, id) {
				var obj = _objectList[id];

				if(obj.isActive()) {			// 살아있는것
					liveCount++;
				} else if(obj.isUnlicensed()) {	// 라이센스가 없는 것
					licenseCount++;
				} else if(obj.isStopped()) {		// 죽어있는 것
					stopCount++;
				}
				totalCount++;				// 전체 개수
			});

			_info = {
				totalCount : totalCount,
				live : liveCount,
				stop : stopCount,
				license : licenseCount
			}

			// 캐쉬가 생성되었다는 것은  select 정보가 변경되었다는 증거.
			aries.emit("aries.manager.element:generateCache");

		}

		// 데이타 설정하기
		// 정확히는 data 를 설정하면서  domain , instance 객체에 대한 function 도 같이 초기화 해준다.
		function _dataInit(data, hasCaching) {
			_data = data;
			_objectList = {};

			var time = Date.now();

			var domainCount = 0;
			each(_data, function (i, element) {
				element.time = time;
				if (element.parent) {	// instance 의 경우
					_instanceInit(element, _objectList[element.parent].insCount++);
				} else {				// domain 의 경우
					element.insCount = 0;
					_domainInit(element, domainCount++);
				}

				_objectList[element.id] = element;
			});

			if (hasCaching) {
				generateCache();
			}

		}

		function getDomainAllList  () {
			return _domainList;
		}

		function getDomainList() {
			// 전체 도메인 리스트를 구한다.

			var filteredList = filter(_data, function (element) {
				return element.isDomain();
			});

			return filteredList;
		}

		function getSelectedInstance(isAll) {
			var domainList = getSelectedDomain();

			// 선택된  도메인에 대한 전체 instance 리스트를 구한다.
			var instanceList = filter(_data , function (element) {
				return _.indexOf(domainList.domainList, element.parent) > -1;
			});

			// 그 중에 selected 되어진 instance 리스트를 구한다.
			var selectedInstanceList = filter(instanceList, function (element) {
				return element.selected;
			});

			var instanceIdList = [];

			// selected 리스트가 있다면
			if (selectedInstanceList.length && isAll !== true ) {
				// selected 되어진 리스트 중에 id 만 추출
				instanceIdList = map(selectedInstanceList, function (element) {
					return element.id;
				})
			} else {
				// 아니면 전체 instance 리스트 중에 id 만 추출
				instanceIdList = map(instanceList, function (element) {
					return element.id;
				})
			}

			return { domainList : domainList.domainList, instanceList : instanceIdList };
		}

		function getSelectedDomain(isAll) {

			var filteredList = filter(map(_domainList, function (id) {
					return _objectList[id];
			}), function (element) {		// 살아있는 리스트만 조회 
				return !!element;
			});

			// 그 중에 selected 되어진 리스트를 구한다.
			var selectedDomainList = filter(filteredList, function (element) {
				// batchjob 모드 일때는 batch mode 인 애들만 selected 체크함
				if (DomainBarBatchjobModeDef.BATCHJOB_ONLY == _batchjobMode) {
					if (element.batchjob) {
						return element.selected;
					}

					return false;
				} else {
					// batchjob 모드가 아닐때는 batchjob 인 도메인은 제외시키고 selected 체크 
					if (element.batchjob) {
						return false;
					}
				}

				return element.selected;
			});

			var domainIdList = [];
			// selected 리스트가 있다면
			if (selectedDomainList.length && isAll !== true ) {
				// selected 리스트에서 아이디 리스트를 구한다.

				if (DomainBarBatchjobModeDef.BATCHJOB_ONLY == _batchjobMode) {
					// batchjob only mode 에서는 batchjob 인 도메인만
					var filteredSelectDomainList = filter(selectedDomainList, function (element) {
						return element.batchjob;
					});
				} else {
					var filteredSelectDomainList = filter(selectedDomainList, function (element) {
						return !element.batchjob;
					});
				}

				domainIdList = map(filteredSelectDomainList, function (element) {
					return element.id;
				});
			} else {
				// 그렇지 않다면 전체 리스트에서 id 리스트를 구한다.
				if (DomainBarBatchjobModeDef.BATCHJOB_ONLY == _batchjobMode) {
					// batchjob only mode 에서는 batchjob 인 도메인만
					var filteredDomainList = filter(filteredList, function (element) {
						return element.batchjob;
					});
				} else {
					var filteredDomainList = filter(filteredList, function (element) {
						return !element.batchjob;
					});
				}

				domainIdList = map(filteredDomainList, function (element) {
					return element.id;
				});
			}

			return { domainList : domainIdList, instanceList: [] }
		}

		function getSelectedDomainSidList () {
			var domainList = getSelectedDomain().domainList;

			var sids = map(domainList, function (id) {
				return _objectList[id].sid;
			});

			return sids;
		}

		/**
		 * 모든 도메인 sid 리스트
		 * @returns {*}
		 */
		function getAllDomainSidList () {
			var domainList = getDomainList();

			var sids = map(domainList, function (element) {
				return element.sid;
			});

			return sids;
		}

		function toggle(id, notGenerateCache) {
			if (!id) return;

			if (_objectList[id]) {
				_objectList[id].selected = !_objectList[id].selected;
				if (!notGenerateCache) {
					generateCache();
				}

			} else {
				console.debug(id, 'is invalid domain or instance, it is no right. ');
			}

		}

		function select(id) {

			each(arguments, function (i, tempId) {
				toggle(tempId, false);
			});

			generateCache();

			//aries.emit("aries.manager.element:select");

			// 이걸 여기서 하는건 말이 안되니  원래 대로 돌려라.
			// FIXME: xview 쪽에 다시 올려놓자.
			//aries.chart.xview.clear();

		}

		///////////////////////////////////////////////////////
		/////
		///// Public Functions
		/////
		//////////////////////////////////////////////////////

		var obj = {};

		// domainbar 초기화 , 옵션 설정, 타입 설정,
		/*this.init = */
		obj.init = function init(data, batchjobMode, sid, oid) {
			_dataInit(data, false);

			if (typeof batchjobMode != 'undefined') {
				_batchjobMode= batchjobMode;
			}

			if (typeof sid != 'undefined') {

				if (!(sid instanceof Array)) {
					sid = [sid];
				}

				for(var i = 0, len = sid.length; i < len; i++) {
					var domainId  = ID.domain(sid[i]);

					if (_objectList[domainId]) {
						_objectList[domainId].selected = true;
					}
				}
			}

			if (typeof oid != 'undefined') {
				if (!(oid instanceof Array)) {
					oid = [oid];
				}

				for(var i = 0, len = oid.length; i < len; i++) {
					var instanceId  = oid[i];

					if (_objectList[instanceId]) {
						_objectList[instanceId].selected = true;
					}
				}
			}


			generateCache();
		};

		obj.generateCache = generateCache;

		obj.getValueByColor = function getValueByColor(colorCode) {
			return obj.getValue(_colorDomainCodeManager[colorCode+""] || _colorCodeManager[colorCode+""] );
		}

		// 생성된 캐쉬를 리턴한다.
		obj.getCache = function getCache() {
			return _cache;
		}

		// 가지고 있는 전체 (domain, instance 정보)를 리턴한다.
		obj.getData = function getData () {
			return _data;
		}

		obj.id = function (sid, oid) {
			if (arguments.length == 1) {
				return obj.domain(sid);
			} else {
				return obj.agent(sid, oid);
			}
		}

		obj.domain = function (sid) {
			return ID.domain(sid);
		}

		obj.agent = function (sid, oid) {
			return ID.agent(sid, oid);
		}

		// domain 동기화 이벤트
		aries.on('load.domainAgentList', function (json) {
			obj.callback(json);
		});

		// websocket 으로 데이타 동기화
		obj.callback = function callback (json) {
			if(!json.domainAgentList || !json.domainAgentList.data) {
				return;
			}

			var data = json.domainAgentList.data;

			if (!data.length) return; 

			// 데이타 받은 이후에  기존 리스트를 업데이트 한다.
			// 1. callback 받은 시점의 time 을 생성한다.
			var time = Date.now();
			// 2. 각각의 data 의  id 를 검색해보고  없으면 추가하고 있다면  해당 필드 값을 모두 거기 있는 값으로 변경한다.
			//  if (_objectList[element.id]) { }  else { }
			var domainCount = 0;
			var instanceCount = {};

			var list = [];
			// 데이타를 일렬로 만듦
			each(data, function (i, d) {
				var agent_list = d.agent;

				delete d.agent;

				list.push(d);
				each(agent_list, function (j, a) {
					list.push(a);
				});
			});

			each(list, function (i, d) {

				// 3. insCount 와 agentCount 의 각각 통계를 낸다.
				//  sidCount[sid]++;

				d.time = time;
				if (_objectList[d.id]) {		// 기존에 가지고 있는 아이디가 있다면  정보를 업데이트

					if (d.parent) {		// agent 일 경우 상태를 변경한다.
						instanceCount[d.parent] = instanceCount[d.parent] || 0;

						_objectList[d.id].color(createColor(d.id));
						_objectList[d.id].status = d.status;
						_objectList[d.id].license_status = d.license_status;
						_objectList[d.id].shortName = d.shortName;
					} else {			// domain 일 경우 상태 변경

						_objectList[d.id].color(createDomainColor(d.id));
						_objectList[d.id].agentCount = d.agentCount;
					}
					_objectList[d.id].time = d.time;
				} else {						// 기존에 가지고 있는 아이디가 없다면 추가
					if (d.parent) {
						instanceCount[d.parent] = instanceCount[d.parent] || 0;

						_instanceInit(d, instanceCount[d.parent]++);
					} else {
						_domainInit(d, domainCount++);
					}
					_data.push(d);
					_objectList[d.id] = d;
				}
			});

			// agentCount 업데이트
			each(Object.keys(instanceCount), function (i ,  domainId) {
				_objectList[domainId].agentCount = instanceCount[domainId];
			});

			// 4. time 이 현재 시점보다 작은건  모두 지운다.
			//   if (element.time < time) { continue;  }
			//
			_data = filter(_data, function (element) {
				if (element.time ==  time) {
					return true;
				}   else {
					delete _objectList[element.id];			// 제외된 객체는 지운다.
					//aries.get('domainbar').removeAllInstance(element.id);	// dom 에서 지운다.
					return false;
				}
			});

			// 5. cache 를 다시 생성한다.
			generateCache();

			// 6. 모두 완료되면  makeInstanceBar 를 시작한다.
			// makeInstanceBar ()

			// aries.manager.element 는  domain bar 생성에 관여하지 않는다.
			// 모든 것은 domain 바에서 처리할 뿐이다.
			aries.emit("aries.manager.element:callback");
			//aries.get('domainbar').make();

			// 7. makeInstanceBar 를 할 때 기존에 있으면 그대로 사용하고 모든 리스트 다 업데이트한 이후에 도 time이 이전날짜이면 모두 지운다.

			// 정보를 다시 요청한다.
			this.callDomainAgentListInfo();
		}

		obj.callDomainAgentListInfo = function () {
			// FIXME: 다시 조회를 한다.
			// TODO: 조회를 할 때 현재 선택된  domain 에 대해서만 한다.
			// group 이랑 엮일 수도 있다.
			var info = aries.chart.loader.domainRequestInfo();
			if(info.length > 0) {
				window.setTimeout(function() {aries.chart.call.realtimeSend(JSON.stringify(info[0]));}, 5 * 1000);
			}
		}

		// all data
		// id 가 있으면 특정 아이디에 대한 것만 리턴,
		// 아니면 전체 리스트 리턴
		obj.getValue = function getValue(id) {
            if (_objectList[id]) return _objectList[id];

            // 전체 리스트 볼일이 없으므로 null 을 리턴한다.
            return null;
        }

		/**
		 *
		 * instance id 리스트를 oid 리스트로 변환하기
		 *
		 * @param sid
		 * @param instanceIdList
		 * @returns {*}
		 */
		obj.getOids = function getOids (sid, instanceIdList) {
			return map(filter(_data, function (element) {
				return element.sid == sid && instanceIdList.indexOf(element.instId + "") > -1;
        	}), function (element) {
				return element.oid();
			});
        };

		obj.getInstanceIdList = function getInstanceIdList (sid, oids) {
			return map(filter(_data, function (element) {
				return element.sid == sid && oids.indexOf(element.oid()) > -1;
			}), function (element) {
				return element.instId;
			});
		};


		obj.getDomainAllList = getDomainAllList;

		obj.getDomainList = getDomainList;

		/**
		 * 선택된 도메인 리스트를 준다.
		 *
		 * instanceList 는 비어있는 배열.
		 *
		 * @returns {{domainList: *, instanceList: Array}}
		 */
		obj.getSelectedDomain = getSelectedDomain;
		obj.getSelectedDomainSidList = getSelectedDomainSidList;
		obj.getAllDomainSidList = getAllDomainSidList;

		/**
		 * 선택된 Instance 리스트를 준다.
		 *
		 * @returns {{domainList: *, instanceList: Array}}
		 */
		obj.getSelectedInstance = getSelectedInstance;

		// 캐쉬된 개수 리턴
		obj.getInfo = function getInfo() {
			return _info;
		}

		// 선택된 애를 토글 시켜보자.
		obj.toggle = toggle;

		// 아이디 기반으로 unselect 를 결정한다.
		// this.unselect()  // 모든 것을 선택 이전 상태로
		// this.unselect(id, id, id) // 정해진 id 만 selected 를 false 로 설정
		// 그런 이후에 generateCache() 로 캐쉬 재생성
		obj.unselect = function unselect() {
			var len = arguments.length;

			if (len == 0) {
				each(_data, function (i, element) {
					if (element.selected) {
						element.selected = false;
					}
				})
			} else {
				each(arguments, function (i, id) {
					_objectList[id].selected  = !!_objectList[id].selected;
				});
			}

			generateCache();
		}

		obj.refreshDomainSelect = function () {
			// 캐쉬에 있는 리스트 지우기
			each(_cache.selectedDomainList, function (i, id) {
				_objectList[id].selected = false;
			});

			generateCache();
		}

		obj.refreshInstanceSelect = function () {
			// 캐쉬에 있는 리스트 지우기
			each(_cache.selectedInstanceList, function (i, id) {
				_objectList[id].selected = false;
			});

			generateCache();
		}

		// 모든 것을 selected 를 하지 않고 하나만 선택합니다.
		// 분석에서 많이 쓰이겠네요.
		obj.selectInstanceOne = function selectInstanceOne (id) {
			each(_cache.instanceList, function (i, id) {
				var instance = _objectList[id];
				// 선택된 instance 를 모두 selected 로 만들고
				instance.selected = false;
			});

			// 하나만 선택한다. 당연 캐쉬는 다시 만들고
			select(id);
		}

		// 도메인을 하나만 선택해보자. 
		obj.selectDomainOne = function selectDomainOne (id) {
			each(_cache.domainList, function (i, domainId) {
				var domain = _objectList[domainId];
				// 선택된 instance 를 모두 selected 로 만들고
				domain.selected = false;
			});

			// 하나만 선택한다. 당연 캐쉬는 다시 만들고
			select(id);
		}

		// 선택된 상태를 변경시켜보자.
		obj.select = select;

		// 선택되어있는지 알아보자.
		obj.isSelected  = function isSelected(id) {
			return !!_objectList[id].selected;
		}

		// selected 된 instance 가 있는지 , 실제로 클릭한 상태의 instance 가 있는지 
		obj.hasSelectedInstance = function hasSelectedInstance () {

			return _cache.selectedInstanceList.length > 0;
		}

		// 캐쉬에 있는 instance 개수는 ?
		obj.selectedInstanceCount = function selectedInstanceCount() {
			return _cache.instanceList.length;
		}

		obj.setSelectedData = function setSelectedData (data) {
			data = data || { selectedDomainList : [], selectedInstanceList : []};

			each(data.selectedDomainList || [], function (i, id) {
				if (_objectList[id]) {
					_objectList[id].selected = true;
				}
			});

			each(data.selectedInstanceList || [], function (i, id) {
				if (_objectList[id]) {
					_objectList[id].selected = true;
				}
			});

			// selected 된 정보가 업데이트 되면  cache 를 재생성한다. 
			generateCache();
		}

		obj.getHirachyList = function getHirachyList(externalList) {
			var result = {};
			var list = externalList || _cache.instanceList;

			each(list, function (i, id) {

				var obj = _objectList[id];

				if (obj) {
					// domain id 기준
					if (!result[obj.sid]) {
						result[obj.sid] = [];
					}

					result[obj.sid].push(obj.oid());
				}

			});

			return result;
		}

		obj.getSelectedInstanceIdListWithSid = function getSelectedInstanceIdListWithSid() {


			var domainList = {};

			each(_cache.selectedInstanceList, function (i, id) {
				domainList[_objectList[id].sid] = true;
			});
			var domainList = Object.keys(domainList);
			var instanceList = _cache.selectedInstanceList;

			return {
				domainList : domainList,
				instanceList : instanceList
			}
		}

		//토플로지에서 사용.
		//false라면 권한이 없다고 표시함.
		obj.exist = function exist(id) {
			return !!_objectList[id];
		};

		obj.createInstance = function (instance, i) {
			_instanceInit(instance, i);

			return instance;
		};

		obj.instanceKeys = function (sid) {
			var instanceList = [];

			if (_cache.hasSelectedInstance) {
				instanceList = _cache.selectedInstanceList;

			} else {
				instanceList = _cache.instanceList;
			}

			if (typeof sid !== 'undefined') {
				instanceList = filter(instanceList, function (id) {
					return _objectList[id].sid == sid;
				})
			}

			return map(instanceList, function (id) {
				return _objectList[id].oid();
			})
		}

		obj.instanceList = function () {
			return map(_cache.instanceList, function (id) {
				return _objectList[id];
			});
		}

		obj.convertInstanceId = function (instanceList) {
			return map(instanceList, function (id) {
				return _objectList[id].oid();
			});
		}

		obj.isDomain = function (id) {
			if (_objectList[id]) {
				return _objectList[id].isDomain();
			}

			return false;
		}

		obj.isInstance = function (id) {
			if (_objectList[id]) {
				return _objectList[id].isAgent();
			}

			return false;
		}

		obj.name = function (sid, oid) {
			return nameList[ID.agent(sid, oid)] || ((oid > 0) ? oid : sid);
		}

		obj.names = function () {
			var instanceList = [];

			if (_cache.hasSelectedInstance) {
				instanceList = _cache.selectedInstanceList;

			} else {
				instanceList = _cache.instanceList;
			}

			var obj = this.getHirachyList(instanceList);

			var total = [];

			for(var sid in obj) {
				var oids = obj[sid];

				var arr = [];

				arr.push("[");
				arr.push(_objectList[this.id(sid)].shortName);
				arr.push(" >  ");

				var instanceNames = [];
				for(var i = 0, len = oids.length; i < len; i++) {
					instanceNames.push(_objectList[this.id(sid, oids[i])].shortName);
				}


				arr.push(instanceNames.join(","));
				arr.push("]");

				total.push(arr.join(""));
			}

			return total.join(", ");
		}
		// handler 는 모두 jennifer.core.js  에 있는 aries.on 을 사용한다.

		return obj;
}());
/**
 * DomainGroup 에 대한 Tree 를 관리한다. 
 *
 * domain group 사용 여부   aries.get('isDomainGroupUsage')
 * domain group 관련 tree list aries.get("domainGroupListJson")
 *
 */

aries.manager.domaingroup = (function() {
	// group 전체 정보 설정, 그룹은 고정된 데이타이기 때문에 최초 로드할때 domain id 리스트를 가질 수 있는 구조로 만든다.
	var _group = [], _selectedItem = null, _selectedDomainList = [], _selectedAllDomainList = [], _isOnlyOne = false, _isMultiDomain = false;

	//////////////////////////////////////////
	////
	////  Private Functions
	////
	////////////////////////////////////////////

	function each (arr, callback, context) {
		for(var i = 0, len = arr.length; i < len; i++) {
			var ret = callback.call(context, i, arr[i]);

			// 루프를 돌다가 나오고 싶으면 return false; 를 하면 된다.
			if (ret === false) {
				break;
			}
		}
	}

	function filter (arr, callback) {
		var list = [];
		each(arr, function (i, element) {
			if (callback(element)) {
				list.push(element);
			}
		})

		return list;
	}

	function filterOne(arr, callback) {
		return filter(arr, callback)[0];
	}

	function map (arr, callback) {
		var list = [];
		each(arr, function (i, element) {
			list.push(callback(element));
		});

		return list;
	}

	function getSessionObj(key) {
		var string = sessionStorage.getItem(key);

		var result;

		try {
			result = JSON.parse(string);
		} catch (e){
			console.log("call getSessionObj parse problem ");
			console.log(string);
			return {};
		}

		return result;
	}

	function setSessionObj(key, obj) {
		sessionStorage.setItem(key, JSON.stringify(obj));
	}


	///////////////////////////////////////////////////////
	/////
	///// Public Functions
	/////
	//////////////////////////////////////////////////////

	var obj = {};

	aries.on('set.domainGroups', function () {
		obj.init (aries.get('domainGroups') || []);
	});

	// group 초기화
	obj.init = function (data) {

		each(data, function (i, item) {
			item.depth = item.index.split('.').length;
			if (item.sid == -1) {
				var filterIndex = item.index + '.';
				var sidList = map(
					filter(data, function (it) {
						return it.index.indexOf(filterIndex) == 0 && it.sid > 0;		// 하위에 있고  sid 가 0보다 큰 애들
					}),
					function (it) {
						return it.sid;
					}
				);

				item.sidList = sidList;
			} else {
				item.sidList = [ item.sid ]    //  그룹이 아니고 도메인이면 하나의 리스트만 배열로 가진다.
			}
		});

		// normalize , group 에 하위 노드가 없으면 그룹을 지운다.
		data = filter(data, function (item) {
			return item.sidList.length > 0 ;
		});

		// redefine index for tree
		var numbers = [0, 0, 0, 0];
		each(data, function (i, item) {
			var prev = (i - 1 < 0) ? null : data[i-1];

			if (!prev) {
				item.index = [numbers[0]++].join('.');
			} else {
				if (prev.depth == item.depth ) {
					var arr  = prev.index.split('.');

					arr[arr.length-1] = Number(arr[arr.length-1]) + 1;
					item.index = arr.join('.');
				} else if (prev.depth < item.depth ) {
					item.index = prev.index + ".0";
				} else if (prev.depth > item.depth) {

					var arr  = prev.index.split('.');

					var dist = prev.depth - item.depth;

					for(var j = 0; j < dist; j++) {
						arr.pop();
					}

					arr[arr.length-1] = Number(arr[arr.length-1]) + 1;
					item.index = arr.join('.');
				}
			}
		})

		_group = data;

		if (aries.get("isDomainGroupUsage")) {
			// 그룹을 쓰고 있다면
			if (!_selectedItem) {
				_selectedItem = _group[0];		// 선택되어진게 없으면 가장 처음에 있는 그룹으로 선택한다.
			}

			if (_selectedItem) {
				_selectedDomainList = _selectedItem.sidList;
			}
		} else {
			// domain group 을 사용하지 않을때는 도메인 중에 첫번째 것을 선택한다.
			obj.setOnlyOne(true);
			// domain 중에 첫번째 것을 선택해준다. 그룹 제외
			obj.setFirstDomain();
		}

	};

	/**
	 * 현재 index 를 가리키는 객체를 가지고 온다.
	 *
	 * var item = aries.manager.domaingroup.item(index);
	 *
	 * item.title			// 제목
	 * item.index			// 트리 노드의 위치
	 * item.sidList 		// 하위 sid 리스트, 도메인이라면 자신을 리턴
	 *
	 * @param index
	 * @returns {*}
     */
	obj.item = function (index) {
		return filterOne(_group, function (item) {
			return item.index == index;
		});
	};

	/**
	 * sid 로 tree item 얻어오기 
	 *
	 * @param sid
	 * @returns {*}
     */
	obj.itemBySid = function (sid) {
		return filterOne(_group, function (item) {
			return item.sid == sid;
		});
	}

	/**
	 * 정해진 depth 에서 list 가지고 오기
	 *
	 * depth 가 없으면 전체 리스트 모두 가지고 오기 
	 *
	 * @param depth
	 * @returns {*}
     */
	obj.list = function (depth) {
		depth = depth || 100;
		return filter(_group, function (it) {
			return it.depth <= depth;
		});
	};

	/**
	 * 순수하게 도메인 리스트만 구함.
	 *
	 * domain group 이 아닐 때 전체 도메인을 나태내기 위해서 사용
	 *
	 * @param depth
	 * @returns {*}
     */
	obj.domainList =  function (depth) {
		depth = depth || 100;
		return map(filter(_group, function (it) {
			return it.depth <= depth && it.sid > 0;
		}), function (it) {
			return it.sid;
		});
	};

	/**
	 * 자식 노드 조회하기
	 *
	 * aries.manager.domaingroup.children('0.1');			// 0.1 인덱스를 가진 node 에서 바로 밑 자식 가지고 오기
	 * aries.manager.domaingroup.children('0.1', true);		// 0.1 인덱스를 가진 node 에서  하위에 속한 모든 자식 리스트 가지고 오기  
	 *
	 * @param parentIndex
	 * @param isAll
	 * @returns {*}
     */
	obj.children = function (parentIndex, isAll) {
		isAll = (isAll === true);

		var parentDepth = parentIndex.split('.').length;

		if (isAll) {
			return filter(_group, function (it) {
				return it.index.indexOf(parentIndex + '.') > -1;		// 하위에 있고  sid 가 0보다 큰 애들
			});
		} else {
			return filter(_group, function (it) {
				return it.index.indexOf(parentIndex + '.') > -1 &&  it.depth  == (parentDepth+1);		// 하위에 있고  sid 가 0보다 큰 애들
			});
		}
	};

	/**
	 * parentIndex 에 속한 sid 리스트 구하기 
	 * 
	 * aries.manager.domaingroup.getSidList();
	 * 
	 * 
	 * @param parentIndex
	 * @param isAll
	 * @returns {Array}
     */
	obj.getSidList = function (parentIndex, isAll) {
		var sidList = [];
		each(obj.children(parentIndex, isAll), function (i, item) {
			sidList = sidList.concat(item.sidList);
		});

		return sidList;
	};

	obj.setSelectedItem = function setSelectedItem (index) {
		_selectedItem = obj.item(index);

		if (_selectedItem) {
			_selectedDomainList = _selectedItem.sidList;
		}

		//aries.localStorage.save("selectedDomainGroupIndex", index);

		aries.emit("aries.manager.domaingroup:setSelectedItem");
	}

	// 그룹을 선택해도 처음 sid 하나만 나오기 때문에 only one 을 설정
	// only one 을 설정하게 되면  getSelectedDomainList 에서 [ sid ] 배열 하나만 리턴 	
	obj.getSelectedDomainList = function () {

		// multi domain 셋팅이 항상 우선순위 1 순위
		if (_isMultiDomain) return _selectedAllDomainList;

		// 그 다음에 한개짜리 선택이 2순위 
		if (_isOnlyOne) return [_selectedDomainList[0]];

		return _selectedDomainList;
	}

	// 선택된 도메인 리스트를 직접 설정한다.
	// aries.manager.domaingroup.setSelectedDomainList([ sid, sid, sid] );
	obj.setSelectedDomainList = function (sid) {
		_selectedDomainList = sid;
	}

	obj.getSelectedItem = function () {
		return _selectedItem;
	}

	obj.setOnlyOne = function (onlyOne) {
		_isOnlyOne = onlyOne || false;
	}

	obj.setMultiDomain = function (isMultiDomain) {
		_isMultiDomain = isMultiDomain;
		if (_isMultiDomain) {
			_selectedAllDomainList = this.domainList();
		} else {
			_selectedAllDomainList = [];
		}

	}

	obj.setFirstDomain = function () {
		var item = filterOne(_group, function (item) {
			return item.sid > 0;
		});

		if (item) {
			this.setSelectedItem(item.index);
		}

	}

	obj.setFirstGroup = function () {
		// 그룹을 쓰고 있다면
		_selectedItem = _group[0];		// 선택되어진게 없으면 가장 처음에 있는 그룹으로 선택한다.

		if (_selectedItem) {
			_selectedDomainList = _selectedItem.sidList;
		}

	}
	
	obj.isOnlyOne = function () {
		return _isOnlyOne;
	}

	obj.getSelectedIndexForDomain = function (selectedIndex) {
		var item = this.item(selectedIndex);

		if (!item) return "0";

		if (item.sid == -1) {  // group 이라면
			// sidList 중에 첫번째것을 선택한 node 로 한다.
			var childItem  = this.itemBySid(item.sidList[0]);

			selectedIndex = childItem.index;
		}

		return selectedIndex;
	}

    /**
	 * sid를 이용해서 depth=1 인 도메인그룹 index를 알기 위해서 만듬.
	 * 사용자 정의 대시보드에서 차트 수정시에 필요하다.
	 *
     * @param sid
     */
	obj.getHighestDepthIndexBySid = function(sid) {

        return filterOne(_group, function (item) {
            return (item.depth === 1 && item.sidList.indexOf(sid) > -1);
        }).index;


	}

	return obj;
}());
/**
 * aries.manager.business
 *
 *  1. business 리스트를 관리합니다.
 *  2. business 도 domain ,instance 와 같이 id 를 가집니다.
 *  3. 형태는 /domain@business 로 됩니다.
 *  4. /domain@0 은 도메인을 표시하고 0 이상은 비지니스를 표시합니다.
 *  5. 비지니스는 특수 데이타이기 때문에 전체 데이타를 관리하지 않고 필요한 도메인에 대한 데이타만 관리합니다.
 *  6. business 선택된 상태를 관리합니다.
 *
 */
aries.manager.business = (function() {

		var _data = [], _objectList = {}, _cache = { domainList : [], businessList : [], selectedDomainList : [], selectedBusinessList : [] };

		// group 전체 정보 설정, 그룹은 고정된 데이타이기 때문에 최초 로드할때 domain id 리스트를 가질 수 있는 구조로 만든다.
		var _group = [], _selectedGroup = -1;

		var _colorManager = [];
		var _colorManagerKeys = {};
		var _colorCodeManager = {};

		//////////////////////////////////////////
		////
		////  Private Functions
		////
		////////////////////////////////////////////

		function each (arr, callback, context) {
			for(var i = 0, len = arr.length; i < len; i++) {
				var ret = callback.call(context, i, arr[i]);

				// 루프를 돌다가 나오고 싶으면 return false; 를 하면 된다.
				if (ret === false) {
					break;
				}
			}
		}

		function filter (arr, callback) {
			var list = [];
			each(arr, function (i, element) {
				if (callback(element)) {
					list.push(element);
				}
			})

			return list;
		}

		function filterOne(arr, callback) {
			return filter(arr, callback)[0];
		}

		function map (arr, callback) {
			var list = [];
			each(arr, function (i, element) {
				list.push(callback(element));
			});

			return list;
		}

		// 각 id 별로 유일한 색상을 만든다.
		function createColor(id) {
			if (_colorManagerKeys[id]) {
				return _colorManagerKeys[id];
			}

			// 색상코드가 없으면 새로 지정한다.
			_colorManagerKeys[id] = aries.chart.color.newColor(_colorManager.length);
			_colorCodeManager[_colorManagerKeys[id].getRGB() + ""] = id;
			_colorManager.push(_colorManagerKeys[id]);

			return _colorManagerKeys[id];

		}

		// business 객체 생성
		function _businessInit(business, i) {
			delete business.name;
			business.__proto__  = {
				key : function() {
					return this.id;
				},

				oid : function() {
			        return +this.bizId;
			    },

			    selected : function(selected) {
			        if(selected == true) {
			        	this.selected = true;
			        } else if(selected == false) {
			        	this.selected = false;
			        }

			        return this.selected;
			    },

			    name : function() {
			        return this.shortName;
			    },

			    isActive : function() {		// business 는 언제나 Active 상태이다. 
			    	return true;
			    },

                isStopped: function() {
					return false;
				},

                isUnlicensed: function() {
                    return false;
				},

				isDomain: function () {
					return false;
				},

			    isAgent : function() {
			        return false;
			    },

				isBusiness : function () {
					return true;
				},

			    color : function(color) {
			        if(color) {
			        	this._color = color;
			        }

			        return this._color;
			    }
			};
			business.color(createColor(business.id));
		}

		// 현재 선택된 리스트에 대한 캐쉬를 만든다.
		function generateCache () {

			var domainCache = aries.manager.element.getCache();

			// 전체 instance 리스트를 가지고 있음.
			_cache = {};

			_cache.businessList = map(_data, function (obj) {
				return obj.id;
			});  // 비지니스 데이타를 어떻게 관리할지 부터 정해야할 듯 하다.

			_cache.domainList = domainCache.domainList;

			_cache.selectedDomainList = domainCache.selectedDomainList;

			_cache.selectedBusinessList = filter(_cache.businessList, function (id) {
				return (typeof(_objectList[id].bizId) != "undefined") && _objectList[id].selected;
			});

			_cache.hasSelectedBusiness = !!_cache.selectedBusinessList.length;

			// 캐쉬가 생성되었다는 것은  select 정보가 변경되었다는 증거.
			aries.emit("aries.manager.business:generateCache");

		}

		// 데이타 설정하기
		// 정확히는 data 를 설정하면서  domain , instance 객체에 대한 function 도 같이 초기화 해준다.
		function _dataInit(data, hasCaching) {
			_data = data || [];
			_objectList = {};

			var time = Date.now();

			each(_data, function (i, element) {
				element.time = time;
				//element.sid = sid;
				element.id = obj.id(element.sid, element.oid);
				element.depth = element.treeIndex.split(".").length;
				delete element.oid; 
				_businessInit(element);
				_objectList[element.id] = element;
			});

			if (hasCaching) {
				generateCache();
			}

		}

		function toggle(id, notGenerateCache) {
			if (!id) return;

			if (_objectList[id]) {
				_objectList[id].selected = !_objectList[id].selected;
				if (!notGenerateCache) {
					generateCache();
				}

			} else {
				console.debug(id, 'is invalid domain or instance, it is no right. ');
			}

		}

		function select(id) {

			each(arguments, function (i, tempId) {
				toggle(tempId, false);
			});

			generateCache();
		}

		///////////////////////////////////////////////////////
		/////
		///// Public Functions
		/////
		//////////////////////////////////////////////////////

		var obj = {};
	
		obj.load = function (sids, done) {
			sids = sids || [];
			var that = this;

            $.ajax({
                url: "/biz/group/treeList/tree",
                data: {
                    sids: sids,
                    format: "json"
                },
                success: function(data) {
                    that.init(data);
                    if (typeof done == 'function') done();
                }
            })
		}


		obj.loadCheckedOids = function (sids, done) {
			sids = sids || [];
			var that = this;

			if (sids.length == 0) {
				return;
			}

			$.getJSON("/manager/realtime/business/list", "sids="+sids+"&format=json", function(dataList) {

				var keys = Object.keys(dataList);
				for(var i = 0, len = keys.length; i <len; i++) {
					var key = keys[i];
					var value = dataList[key];

					// 만약에 아예 객체가 없는 경우는 최초 설정이 되지 않은 것이기 때문에 그대로 둔다. 
					if (!value) continue;

					that.unselectOids(+key);			// sid 에 해당하는 모든 요소의 selected 를 지우고
					that.selectOids(+key, value);		// 다시 설정한다.
				}

				if (typeof done == 'function') done();
			});

		}

		// 선택된 개수를 maxCount 로 조정
		obj.initSelect = function (maxCount) {
			var selectedBusinessList = _cache.selectedBusinessList;
			if (maxCount >= selectedBusinessList.length) return;

			var dist = selectedBusinessList.length - maxCount;
			while(dist) {
				_objectList[selectedBusinessList[maxCount + dist -1]].selected = false;
				dist--;
			}
			generateCache();
		};

		// domainbar 초기화 , 옵션 설정, 타입 설정,
		/*this.init = */
		obj.init = function init(data) {
			_dataInit(data, false);

			generateCache();
		};

		obj.generateCache = generateCache;

		obj.getValueByColor = function getValueByColor(colorCode) {
			return obj.getValue(_colorCodeManager[colorCode+""]);
		}

		// 생성된 캐쉬를 리턴한다.
		obj.getCache = function getCache() {
			return _cache;
		}

		// 가지고 있는 전체 (domain, instance 정보)를 리턴한다.
		obj.getData = function getData () {
			return _data;
		}

		obj.list = function () {
			return obj.getData();
		}

		obj.id = function (sid, oid) {
			return obj.business(sid, oid);
		}

		obj.domain = function (sid) {
			return ID.domain(sid);
		}

		obj.business = function (sid, oid) {

			if (ID.hasStringId(oid)) {
				return oid;
			}
			
			if (oid == 0 || oid == undefined) {
				return ID.domain(sid);
			}

			return ID.business(sid, oid);
		}

		obj.getDepth = function (sid, oid) {

			var obj = this.getValue(this.id(sid, oid));

			if (obj) {
				return obj.depth;
			}

			return 0;
		}

		// all data
		// id 가 있으면 특정 아이디에 대한 것만 리턴,
		// 아니면 전체 리스트 리턴
		obj.getValue = function getValue(id) {
			if (_objectList[id]) return _objectList[id];

			// 전체 리스트 볼일이 없으므로 null 을 리턴한다.
			return null;
		}

		// 선택된 애를 토글 시켜보자.
		obj.toggle = toggle;

		// 아이디 기반으로 unselect 를 결정한다.
		// this.unselect()  // 모든 것을 선택 이전 상태로
		// this.unselect(id, id, id) // 정해진 id 만 selected 를 false 로 설정
		// 그런 이후에 generateCache() 로 캐쉬 재생성
		obj.unselect = function unselect() {
			var len = arguments.length;

			if (len == 0) {
				each(_data, function (i, element) {
					if (element.selected) {
						element.selected = false;
					}
				})
			} else {
				each(arguments, function (i, id) {
					_objectList[id].selected  = !!_objectList[id].selected;
				});
			}

			generateCache();
		}

		obj.refreshBusinessSelect = function () {
			// 캐쉬에 있는 리스트 지우기
			each(_cache.selectedBusinessList, function (i, id) {
				_objectList[id].selected = false;
			});

			generateCache();
		}

		// 선택된 상태를 변경시켜보자.
		obj.select = select;

		obj.unselectOids = function (sid, oids) {
			var that = this;
			if (oids) {
				each(oids, function (i, oid) {
					var obj = _objectList[that.id(sid, oid)];

					if (obj) {
						obj.selected = false;
					}
				});
			} else {
				// oids 가 없으면 sid 에 해당하는 business 전체를 selected = false 로 지정
				each(_data, function (i, d) {
					if (sid == d.sid) {
						d.selected = false;
					}
				});
			}


			generateCache();
		}

		/**
		 * 특정 비지니스 아이디를 선택할 때 사용한다.
		 *
		 * @param sid
		 * @param oids
		 */
		obj.selectOids = function (sid, oids) {
			var that = this;
			if (oids) {
				each(oids, function (i, oid) {
					var obj = _objectList[that.id(sid, oid)];

					if (obj) {
						obj.selected = true;
					}
				});
			} else {
				// oids 가 없으면 sid 에 해당하는 business 전체를 selected = false 로 지정
				each(_data, function (i, d) {
					if (sid == d.sid) {
						d.selected = true;
					}
				});
			}

			generateCache();
		}

		// 선택되어있는지 알아보자.
		obj.isSelected  = function isSelected(id) {
			return !!_objectList[id].selected;
		}

		// selected 된 instance 가 있는지 , 실제로 클릭한 상태의 instance 가 있는지 
		obj.hasSelectedBusiness = function hasSelectedBusiness () {

			return _cache.selectedBusinessList.length > 0;
		}

		// 캐쉬에 있는 instance 개수는 ?
		obj.selectedBusinessCount = function selectedBusinessCount() {
			return _cache.selectedBusinessList.length;
		}

		//토플로지에서 사용.
		//false라면 권한이 없다고 표시함.
		obj.exist = function exist(id) {
			return !!_objectList[id];
		};

		obj.createBusiness = function (instance, i) {
			_businessInit(instance, i);

			return instance;
		};

		obj.getSortKeys = function (sid) {
			var businessList = [];

			if (_cache.hasSelectedBusiness) {
				businessList = _cache.selectedBusinessList;
			} else {
				businessList = _cache.businessList;
			}

			if (typeof sid !== 'undefined') {
				businessList = filter(businessList, function (id) {
					return _objectList[id].sid == sid;
				})
			}

			var sortKeys = {};

			each(businessList, function (i, id) {
				sortKeys[id] = i;
			});

			return sortKeys;
		};

		obj.businessKeys = function (sid, isSelectedBusinessList) {
			var businessList = [];

			if (_cache.hasSelectedBusiness || isSelectedBusinessList) {
				businessList = _cache.selectedBusinessList;
			} else {
				businessList = _cache.businessList;
			}

			if (typeof sid !== 'undefined') {
				businessList = filter(businessList, function (id) {
					return _objectList[id].sid == sid;
				})
			}

			return map(businessList, function (id) {
				return _objectList[id].oid();
			})
		}

		obj.businessList = function () {
			return map(_cache.businessList, function (id) {
				return _objectList[id];
			});
		}

		obj.convertBusinessId = function (businessList) {
			return map(businessList, function (id) {
				return _objectList[id].oid();
			});
		}

		obj.isDomain = function (id) {
			if (_objectList[id]) {
				return _objectList[id].isDomain();
			}

			return false;
		}

		obj.isBusiness = function (id) {
			if (_objectList[id]) {
				return _objectList[id].isBusiness();
			}

			return false;
		}

		obj.getSelectedBusinessListWithSid = function getSelectedBusinessListWithSid() {
	
	
			var domainList = {};
	
			each(_cache.selectedBusinessList, function (i, id) {
				domainList[_objectList[id].sid] = true;
			});
			var domainList = Object.keys(domainList);
			var businessList = _cache.selectedBusinessList;
	
			return {
				domainList : domainList,
				businessList : businessList
			}
		}

		obj.getHirachyList = function getHirachyList(externalList) {
			var result = {};
			var list = externalList || _cache.businessList;

			each(list, function (i, id) {

				var obj = _objectList[id];

				if (obj) {
					// domain id 기준
					if (!result[obj.sid]) {
						result[obj.sid] = [];
					}

					result[obj.sid].push(obj.oid());
				}

			});

			return result;
		};

		obj.names = function () {
			var businessList = [];

			if (_cache.hasSelectedBusiness) {
				businessList = _cache.selectedBusinessList;

			} else {
				businessList = _cache.businessList;
			}

			var obj = this.getHirachyList(businessList);

			var total = [];

			for(var sid in obj) {
				var oids = obj[sid];

				var arr = [];

				arr.push("[");
				arr.push(aries.manager.element.getValue(this.domain(sid)).shortName);
				arr.push(" >  ");

				var businessNames = [];
				for(var i = 0, len = oids.length; i < len; i++) {
					businessNames.push(_objectList[this.id(sid, oids[i])].shortName);
				}

				arr.push(businessNames.join(","));
				arr.push("]");

				total.push(arr.join(""));
			}

			return total.join(", ");
		}

		return obj;
}());
aries.chart.color = (function() {
	var color = new Color(),
	
	newColor = function(size) {
		var m = (size % 20),
			addition = parseInt(size / 20)|0;
		switch(m) {
			case 0:
			color = new Color(121, 119-addition, 194); //dark thema : 143, 122, 222
			break;
		case 1:
			color = new Color(123, 186-addition, 231);
			break;
		case 2:
			color = new Color(255, 192-addition, 0);
			break;
		case 3:
			color = new Color(255, 120-addition, 0);
			break;
		case 4:
			color = new Color(135, 187-addition, 102);
			break;
		case 5:
			color = new Color(29, 168-addition, 160);
			break;
		case 6:
			color = new Color(146,146-addition,146);
			break;
			case 7:
			color = new Color(85,93-addition,105); //dark thema : 102, 108, 139
			break;
		case 8:
			color = new Color(2, 152-addition, 213);
			break;
		case 9:
			color = new Color(250, 85-addition, 89);
			break;
		case 10:
			color = new Color(245, 163-addition, 151);
			break;
		case 11:
			color = new Color(6, 217-addition, 182);
			break;
		case 12:
			color = new Color(168, 169-addition, 217);
			break;	
		case 13:
			color = new Color(110, 106-addition, 252);
			break;
		case 14:
			color = new Color(227, 231-addition, 104);	
			break;
		case 15:
			color = new Color(197, 123-addition, 195);	
			break;
		case 16:
			color = new Color(223, 50-addition, 139);	
			break;
		case 17:
			color = new Color(150, 215-addition, 235);	
			break;
		case 18:
			color = new Color(131, 156-addition, 181);	
			break;
		case 19:
			color = new Color(146, 40-addition, 228);	
			break;
		}
		
        return color;
	};
	
	return {
		newColor: newColor
	}
	
}(aries));


aries.vector = function(x, y) {
	this.x = x;
	this.y = y;
};

aries.vector.random = function() {
	return new aries.vector(10.0 * (Math.random() - 0.5), 10.0 * (Math.random() - 0.5));
};

aries.vector.prototype = {
	
	add : function(v2) {
		return new aries.vector(this.x + v2.x, this.y + v2.y);
	},

	subtract : function(v2) {
		return new aries.vector(this.x - v2.x, this.y - v2.y);
	},

	multiply : function(n) {
		return new aries.vector(this.x * n, this.y * n);
	},

	divide : function(n) {
		return new aries.vector((this.x / n) || 0, (this.y / n) || 0); // Avoid divide by zero errors..
	},

	magnitude : function() {
		return Math.sqrt(this.x*this.x + this.y*this.y);
	},

	normal : function() {
		return new aries.vector(-this.y, this.x);
	},

	normalise : function() {
		return this.divide(this.magnitude());
	}
};


aries.console = (function() {
	logForWebsocketException = function(callObj, errorCode) {

		switch(errorCode){
			case WebSocketExceptionCode.dataServerCallFail:
				console.log("Can not receive Data. Dataserver Call Fail");
				break;
			case WebSocketExceptionCode.dataServerDown:
				console.log("Can not receive Data. Dataserver Down");
				break;
			case WebSocketExceptionCode.runtime:
				console.log("Can not receive Data. Viewserver have runtime exception");
				break;
			case WebSocketExceptionCode.json:
				console.log("Can not receive Data. Viewserver have json exception");
				break;
			default:
				console.log("Can not receive Data. Do not know why");
		}

	}
    
    return {
		logForWebsocketException: logForWebsocketException
    };
}());
