var aries = window.aries = aries || {};

aries.extension = {
    setup: function(opts) {
        if(!aries.extension.options) {
            aries.extension.options = {
                hostName: "http://127.0.0.1:7900",
                apiToken: ""
            };
        }

        if(!opts.hostName || typeof(opts.hostName) != "string") {
            throw new Error("In a stand-alone development environment, you must enter the 'hostName'");
        }

        if(!/(http(s?))\:\/\//gi.test(opts.hostName)) {
            console.warn("'hostName' must start with 'http://' or 'https://'");
            opts.hostName = "http://" + opts.hostName;
        }

        if(opts.hostName.endsWith("/")) {
            opts.hostName = opts.hostName.substr(0, opts.hostName.length - 1);
        }

        aries.extension.options.hostName = opts.hostName;
        aries.extension.options.apiToken = opts.apiToken;
    },
    popup: function(type, opts) {
        if(!aries.extension.options || typeof(aries.extension.options) != "object") {
            alert("Use the 'aries.extension.setup' function to set the default options.");
            return;
        }

        function createForm(url, target) {
            var form = document.createElement("form");
            form.setAttribute("method", "post");
            form.setAttribute("action", url);
            form.setAttribute("target", target);
            return form;
        }

        function createInput(name, value) {
            var input = document.createElement("input");

            if(value != null) {
                input.setAttribute("type", "hidden");
                input.setAttribute("name", name);
                input.setAttribute("value", value);
            }

            return input;
        }

        function submitForm(form, inputs) {
            for(var i = 0; i < inputs.length; i++) {
                form.appendChild(inputs[i]);
            }

            var parent = document.getElementsByTagName('body')[0];
            parent.appendChild(form);
            form.submit();
            parent.removeChild(form);
        }

        var popup = {
            xview: function(domainId, txIds, startTime, endTime, hostName) {
                var url = (hostName || "") + "/popup/xviewPointList",
                    target = "xviewPointList",
                    popup = window.open(url, target, "width=1100,height=800,location='no',history='no',resizable='no',status='no',scrollbars='no',toolbar='no',menubar='no'");

                if(popup) popup.focus();

                var form = createForm(url, target),
                    input1 = createInput("txids", txIds.join(',')),
                    input2 = createInput("sid", domainId),
                    input3 = createInput("stime", startTime),
                    input4 = createInput("etime", endTime),
                    input5 = createInput("isPopup", "true");

                submitForm(form, [ input1, input2, input3, input4, input5 ]);
            },
            activeService: function(domainId, instanceOid, hostName) {
                var url = (hostName || "") + "/popup/activeService",
                    target = "activeServiceList",
                    popup = window.open(url, target, "width=1024,height=768,location='no',history='no',resizable='no',status='no',scrollbars='no',toolbar='no',menubar='no'");

                if(popup) popup.focus();

                var form = createForm(url, target),
                    input1 = createInput("sid", domainId),
                    input2 = createInput("agent", instanceOid),
                    input3 = createInput("isPopup", "true");

                submitForm(form, [ input1, input2, input3 ]);
            }
        }

        if(typeof(type) != "string" || !popup[type]) {
            alert("Popup-page type is not valid");
            return;
        }

        if(typeof(opts) != "object") {
            alert("The option can only be used as an object");
            return;
        }

        if(type == "xview") {
            if(!opts.domainId || typeof(opts.domainId) != "number") {
                alert("Please enter your 'domainId' correctly");
                return;
            }

            if(!opts.txIds || typeof(opts.txIds) != "object") {
                alert("Please enter your 'txIds' correctly (Only array)");
                return;
            }

            if(!opts.startTime || typeof(opts.startTime) != "number") {
                alert("Please enter your 'startTime' correctly");
                return;
            }

            if(!opts.endTime || typeof(opts.endTime) != "number") {
                alert("Please enter your 'endTime' correctly");
                return;
            }

            popup[type](opts.domainId, opts.txIds, opts.startTime, opts.endTime, aries.extension.options.hostName);
        } else if(type == "activeService") {
            if(!opts.domainId || typeof(opts.domainId) != "number") {
                alert("Please enter your 'domainId' correctly");
                return;
            }

            popup[type](opts.domainId, opts.instanceOid, aries.extension.options.hostName);
        }
    },
    api: function() {
        if(!aries.extension.options || typeof(aries.extension.options) != "object") {
            alert("Use the 'aries.extension.setup' function to set the default options.");
            return;
        }

        var type = arguments[0];
        if(!type.startsWith("/")) type = "/" + type;
        if(type.endsWith("/")) type = type.substr(0, type.length - 1);

        var opts = typeof(arguments[1]) == "function" ? {} : arguments[1];
        var callback = typeof(arguments[1]) == "function" ? arguments[1] : arguments[2];
        var url = aries.extension.options.hostName + "/api" + type;
        var params = "?token=" + aries.extension.options.apiToken;
        var xhr = null;

        if(typeof(type) != "string") {
            alert("Open API type is not valid");
            return;
        }

        if(typeof(opts) != "object") {
            alert("The option can only be used as an object");
            return;
        }

        if (window.XMLHttpRequest) {
            xhr = new XMLHttpRequest();
        } else if (window.ActiveXObject) {
            try {
                xhr = new ActiveXObject("Msxml2.XMLHTTP");
            } catch (e) {
                try {
                    xhr = new ActiveXObject("Microsoft.XMLHTTP");
                } catch (e) {}
            }
        }

        if(xhr != null) {
            // 매개변수 생성하기
            for(var key in opts) {
                params += "&" + key + "=" + opts[key];
            }

            xhr.open('GET', url + params);
            xhr.setRequestHeader("Content-Type", "application/x-www-form-urlencoded");
            xhr.onreadystatechange = function() {
                if(xhr.readyState === 4 && xhr.status === 200) {
                    if(typeof(callback) == "function") {
                        if(type == "/transaction/profile.txt") {
                            if(xhr.responseText.indexOf("{\"exception\":{\"message\":\"") != -1) {
                                var json = JSON.parse(xhr.responseText);
                                throw new Error(json.exception.message);
                            } else {
                                callback(xhr.responseText);
                            }
                        } else {
                            var json = JSON.parse(xhr.responseText);
                            if(typeof(json.exception) == "object") {
                                throw new Error(json.exception.message);
                            } else {
                                callback(json.result);
                            }
                        }
                    }
                }
            };
            xhr.send();
        }
    }
};