let validCheckEmail = (email) => {
    if(email == "" || email == null) return false;

    const regx = /^([\w-]+(?:\.[\w-]+)*)@((?:[\w-]+\.)*\w[\w-]{0,66})\.([a-z]{2,6}(?:\.[a-z]{2})?)$/i;
    return regx.test(email);
}

let validCheckCellphone = (number) => {
    if(number == "" || number == null) return false;

    const regx = /^[0-9\+\-\s]+$/i;
    return regx.test(number);
}

let validCheckName = (keyword) => {
    if(keyword == "" || keyword == null) return false;

    const regx = /[`~!@#$%^&*|\\\'\";:\/?]/gi;
    return regx.test(keyword);
}

let validCheckIp = (ip) => {
    if(ip == "" || ip == null) return false;

    return /^(([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])\.){3}([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])$|^(([a-zA-Z]|[a-zA-Z][a-zA-Z0-9\-]*[a-zA-Z0-9])\.)*([A-Za-z]|[A-Za-z][A-Za-z0-9\-]*[A-Za-z0-9])$|^\s*((([0-9A-Fa-f]{1,4}:){7}([0-9A-Fa-f]{1,4}|:))|(([0-9A-Fa-f]{1,4}:){6}(:[0-9A-Fa-f]{1,4}|((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3})|:))|(([0-9A-Fa-f]{1,4}:){5}(((:[0-9A-Fa-f]{1,4}){1,2})|:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3})|:))|(([0-9A-Fa-f]{1,4}:){4}(((:[0-9A-Fa-f]{1,4}){1,3})|((:[0-9A-Fa-f]{1,4})?:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){3}(((:[0-9A-Fa-f]{1,4}){1,4})|((:[0-9A-Fa-f]{1,4}){0,2}:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){2}(((:[0-9A-Fa-f]{1,4}){1,5})|((:[0-9A-Fa-f]{1,4}){0,3}:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){1}(((:[0-9A-Fa-f]{1,4}){1,6})|((:[0-9A-Fa-f]{1,4}){0,4}:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(:(((:[0-9A-Fa-f]{1,4}){1,7})|((:[0-9A-Fa-f]{1,4}){0,5}:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:)))(%.+)?\s*$/.test(ip);
}

let printCsvText = (text) => {
    text = text.replace(/\"/g, "\"\"");
    text = text.replace(/[\r|\n]/g, ' ');

    return text;
}

let printEscape = (method) => {
    let res = _.escape(method),
        len = res.length,
        max = 1000;

    res = res.replace(/\\/g, '\\\\');
    res = res.replace(/[\r|\n]/g, ' ');

    if(len > max) {
        return res.substr(0, max) + "...";
    }

    return res;
}

let printOidNames = (sid, oids) => {
    if(oids.length > 0) {
        let newOids = [];

        for(let i = 0; i < oids.length; i++) {
            if(!isNaN(oids[i])) {
                newOids.push(oids[i]);
            }
        }

        if(newOids.length > 0) {
            let names = [];

            $.ajax({
                url: "/agent/names/oids",
                method: "GET",
                async: false,
                data: {
                    format: "json",
                    sid: sid,
                    oids: newOids
                },
                success: function(list) {
                    names = list;
                }
            });

            return names.join(",");
        }
    }

    return "";
}

let getChartTarget = (value) => {
    if(value > 10) {
        let preDigits = ("" + value).split(""),
            digits = ("" + Math.ceil(value * 1.2)).split("");

        for (let i = 1; i < digits.length; i++) {
            if (preDigits[i - 1] == digits[i - 1]) {
                digits[i] = "5";
            } else {
                digits[i] = "0";
            }
        }

        return parseInt(digits.join(""));
    } else if(value == 0) {
        return 1;
    }

    return value * 1.2;
}

let setSortEff = (column, e, isBlack, isMulti) => {
    $(column.element).parent().find("i").remove();

    let color = (!isBlack) ? " icon-white" : "";
    let $icon = $("<i class='icon-arrow3" + color + "'></i>");

    if(column.order == "desc") {
        $icon = $("<i class='icon-arrow1" + color + "'></i>");
    }

    if(!isMulti) {
        $icon.css({ "position": "static", "float": "right", "margin-left": "-20px" });
    } else {
        $icon.css({ "margin-left": "3px" });
    }

    $(column.element).find("i").remove();
    $(column.element).append($icon);
}

let setMultiSortEff = (column, isMulti) => {
    $(column.element).find("i").remove();

    let $icon = null;

    if(column.order == "desc") {
        $icon = $("<i class='icon-arrow1'></i>");
    } else if(column.order == "asc") {
        $icon = $("<i class='icon-arrow3'></i>");
    }

    if($icon != null) {
        if(!isMulti) {
            $icon.css({ "position": "static", "float": "right", "margin-left": "-20px" });
        } else {
            $icon.css({ "margin-left": "3px" });
        }

        $(column.element).append($icon);
    }
}

let setExpandEff = (row) => {
    if(!row) return;
    $(row.list[0]).html("<i class='icon-right'></i>");
}

let setExpandEndEff = (row) => {
    if(!row) return;
    $(row.list[0]).html("<i class='icon-left'></i>");
}

let printBrText = (text) => {
    text = text.replace(/\</g, '&lt;');
    text = text.replace(/\>/g, '&gt;');
    text = text.replace(/\n/g, '<br>');

    return (text == "null") ? "" : text;
}

let printTimeRange = (time, range, maxTime) => {
    let sdate = getServerMoment(time),
        sdateStr = sdate.format(Date.getLongDateFormat());

    if(range == "1440" || range == "all")
        return sdateStr;

    let edate = sdate.add(parseInt(range) * 1000 * 60, "milliseconds");
    let etime = edate.valueOf();

    if(maxTime && etime > maxTime) {
        return sdateStr + " ~ " + getServerMoment(maxTime).format("HH:mm");
    }

    let edateFormat = edate.format("HH:mm");

    if (edateFormat == "00:00" && sdateStr.indexOf(edateFormat) > -1) {
        return sdateStr.replace(edateFormat, "");
    }

    return sdateStr + " ~ " + edateFormat;
}

let onDragPrevent = () => {
    $("body").bind("selectstart", function(e) {
        e.preventDefault();
    }).bind("contextmenu", function(e) {
        e.preventDefault();
    });
}

let offDragPrevent = () => {
    $("body").unbind("selectstart").unbind("contextmenu");
}

let setBookmark = (elem) => {
    if($(elem).hasClass("active")) {
        $.get("/user/bookmark/remove", {
            uri: location.pathname
        }, function(res) {
            if(res) {
                $(elem).removeClass("active");
            }
        });
    } else {
        let uri = location.pathname,
            params = "";

        // 사용자정의 대시보드일 때, 예외사항
        if(uri == "/userdefine/dashboard") {
            params = "?" + location.href.split("?")[1];
        }

        $.get("/user/bookmark/add" + params, {
            uri: uri
        }, function(res) {
            if(res) {
                $(elem).addClass("active");
            } else {
                alert(i18n.get("M0483"));
            }
        });
    }
}

let linkManual = () => {
    let width = 1024, height = 768,
        url = `/manual/${ariesuser.language}/index.html`;

    let ajaxManualUrl = (sessionStorage) ? sessionStorage.getItem("ajaxManualUrl") : "",
        popupUrl = (mng.ui.type == "hide") ? location.pathname : ajaxManualUrl;

    url += "#" + popupUrl.split("/").join("_").substr(1);

    let popup = window.open(url, "manual", 'width=' + width + ',height=' + height + ',history=no,resizable=no,status=no,scrollbars=no,menubar=no');
    popup.focus();
}

let hashManual = (hash) => {
    let url = `/manual/${ariesuser.language}/index.html#${hash}`;
    let width = 1024, height = 768;
    let popup = window.open(url, "manual", 'width=' + width + ',height=' + height + ',history=no,resizable=no,status=no,scrollbars=no,menubar=no');

    popup.focus();
}

let setSessionKeys = (key, items) => {
    sessionStorage.removeItem(key);
    sessionStorage.setItem(key, items.join(","));
}

let getSessionKeys = (key) => {
    let result = [],
        items = sessionStorage.getItem(key);

    if(items != null) {
        result = items.split(",");
    }

    for(let i = 0; i < result.length; i++) {
        result[i] = parseInt(result[i]);
    }

    return result;
}

//@david
//array 만을 집어넣는 위 메소드를 보완하기 위해 생성한 메소드
//json-string을 저장, 불러온다.
let getSessionObj = (key) => {
    let string = sessionStorage.getItem(key);

    let result;

    try {
        result = JSON.parse(string);
    } catch (e){
        console.log("call getSessionObj parse problem ");
        console.log(string);
        return {};
    }

    return result;
}

let setSessionObj = (key, obj) => {
    sessionStorage.setItem(key, JSON.stringify(obj));
}

let showDBPlanPopup = (sid, stime, etime, key, params, bindParams) => {
    let pop = window.open('', 'dbplanPopup', "width=1050,height=780,location='no',history='no',resizable='no',status='no',scrollbars='no',toolbar='no',menubar='no'");

    if(!_.isUndefined(pop)) pop.focus();

    // TODO: [JJC-1627] backslash는 _.escape 함수로 완벽하게 처리되지 않음
    if(typeof(params) == "object") {
        for (let i = 0; i < params.length; i++) {
            params[i].value = printEscape(params[i].value);
        }
    }
    if(typeof(bindParams) == "object") {
        for (let i = 0; i < bindParams.length; i++) {
            bindParams[i].value = printEscape(bindParams[i].value);
        }
    }

    let $form = $(
        '<form id="popup_frm" method="post" action="/popup/dbplan" target="dbplanPopup">' +
        '<input name="sid" type="hidden" />' +
        '<input name="key" type="hidden" />' +
        '<input name="stime" type="hidden" />' +
        '<input name="etime" type="hidden" />' +
        '<input name="params" type="hidden" />' +
        '<input name="bindParams" type="hidden" /></form>');

    $("#popup_frm").remove();
    $("body").append($form);

    $form.find("input[name=sid]").val(sid);
    $form.find("input[name=key]").val(key);
    $form.find("input[name=stime]").val(stime);
    $form.find("input[name=etime]").val(etime);
    $form.find("input[name=params]").val(JSON.stringify(params));
    $form.find("input[name=bindParams]").val(JSON.stringify(bindParams));
    $form.submit();
}

let showSherpaOraclePopup = (url) => {
    let pop = window.open(url, 'sherpaOraclePopup', "width=1280,height=768,location='no',history='no',resizable='no',status='no',scrollbars='yes',toolbar='no',menubar='no'");
    if(!_.isUndefined(pop)) pop.focus();
}

let copyClipboard = (text) => {
    if(window.clipboardData) {
        window.clipboardData.setData("Text", text);
        alert(i18n.get("M0127"));
    } else {
        prompt(i18n.get("M0128"), text);
        $(alertModal[2].root).find(".body > .input").select();

        try {
            document.execCommand("copy");
        } catch(e) {
            console.log(e);
        }
    }
}

let checkPermission = (type) =>  {
    let perList = [],
        tmpList = server.permission.split(",");

    for(let i = 0; i < tmpList.length; i++) {
        perList.push(parseInt(tmpList[i]));
    }

    return $.inArray(type, perList) != -1;
}

let getLanguageType = (langType) => {
    let key = ((server.platform == "net") ? "dot_net" : server.platform).toUpperCase();
    return (langType == 0 || !langType) ? LanguageTypeDef[key] : langType;
}

let updateAgentStatusMessage = (sid, oid, code, callback) => {
    $.ajax({
        method: "GET",
        url: "/agent/feature",
        data: {
            format: "json",
            sid: sid,
            oid: oid,
            code: code
        },
        success: function(res) {
            callback(res);
        }
    });
}

let showThemeTool = () => {
    let pop = window.open('', 'themeTool', "width=1024,height=768,location='no',history='no',resizable='no',status='no',scrollbars='no',toolbar='no',menubar='no'"),
        _frm = document.frm;

    if(!_.isUndefined(pop)) pop.focus();
    $('#frm').empty().append("<input type='hidden' name='layout' value='" + $("body").attr("class") + "' />");

    _frm.method =  'post';
    _frm.action = '/popup/themeTool';
    _frm.target = 'themeTool';
    _frm.submit();
}

let ajaxGroup = (params, before, progress, after, ui_layer) => {
    let data = [];

    let p = $.extend({
        method: "POST",
        sessionUrl: null,
        sessionParams: null,
        dataUrl: null,
        dataKey: "sessionKey"
    }, params);

    $.ajax({
        method: p.method,
        url: p.sessionUrl,
        data: p.sessionParams,
        success: function(key) {
            if(typeof(before) == "function") {
                before(key);
            }

            startPollingData(key);
        },
        error: function(e) {
            if(typeof(after) == "function") {
                after(data);
            }
        }
    });

    var startPollingData = (key) => {
        if(typeof(ui_layer) == "object" && ui_layer.type == "hide") {
            return;
        }

        let dataParams = {};
        dataParams[p.dataKey] = key;

        $.ajax({
            method: p.method,
            url: p.dataUrl,
            data: dataParams,
            success: function(json) {
                for(let i = 0; i < json.partialData.length; i++) {
                    data.push(json.partialData[i]);
                }

                if(!json.hasNext) {
                    if(typeof(after) == "function") {
                        after(data);
                    }
                } else {
                    if(typeof(progress) == "function") {
                        progress(data, json.progress);
                    }

                    startPollingData(key);
                }
            },
            error: function(e) {
                if(typeof(after) == "function") {
                    after(data);
                }
            }
        });
    }
}

/**
 * realtime과 dashboard 화면인지 체크하는 함수
 * batch 모드일 경우, 도메인그룹 박스와 트리에서 비활성화 유무를 체크할 때 사용함
 *
 * @returns {boolean}
 */
let isRealtimePage = () => {
    let path = location.pathname;

    if(path.startsWith("/analysis") || path.startsWith("/statistics") || path.startsWith("/report")) {
        return false;
    }

    return true;
}

let downloadCsv = (fileName, options) => {
    let _ = jui.include("util.base");
    let $form = $('<form id="form_csv" method="post" action="/file/download/csv"><input name="name" type="hidden" /><input name="csv" type="hidden" /></form>');

    $("body").append($form);
    $form.find("input[name=name]").val(fileName + ".csv");
    $form.find("input[name=csv]").val(_.dataToCsv2(options));
    $form.submit();
    $("#form_csv").remove();
}

let downloadText = (fileName, text) => {
    let $form = $('<form id="form_csv" method="post" action="/file/download/csv"><input name="name" type="hidden" /><input name="csv" type="hidden" /></form>');

    $("body").append($form);
    $form.find("input[name=name]").val(fileName + ".txt");
    $form.find("input[name=csv]").val(text);
    $form.submit();
    $("#form_csv").remove();
}

let getByteLength = (s,b,i,c) => {
    for(b=i=0;c=s.charCodeAt(i++);b+=c>>11?3:c>>7?2:1);
    return b;
}

let getTimeRangeBasedOnDayOfWeek = (c, s, e) => {
    var current = getServerMoment(c);
    current.set("hour", 0);
    current.set("minute", 0);
    current.set("second", 0);
    current.set("millisecond", 0);

    // 오늘 요일과 마지막 요일이 같을 경우, 하루를 빼준다.
    var isSameDay = false;
    if(current.day() == e) {
        current.add(-7, "day");
        isSameDay = true;
    }

    var endTime = (isSameDay == true) ? current : getPrevTime(current, e);
    var startTime = getPrevTime(endTime, s);

    function getPrevTime(current, day) {
        var nc = current.clone();

        while(true) {
            if(day != nc.day()) {
                nc.add(-1, "day");
            } else {
                break;
            }
        }

        return nc;
    }

    return [ startTime.valueOf(), endTime.valueOf() ];
}
/**
 * 전과후의 시간을 체크하는것이라 서버타임을 사용하지 않고 Date.now()를 사용했다.
 *
 * https://medium.com/@davidrhyswhite/private-members-in-es6-db1ccd6128a5
 * TODO Class 안에서 private 메소드를 구현하기 위해 Symbol을 사용했다.
 *
 * 차후에 webpack를 통해 빌드시스템을 갖추게 되면 Symbol은 export 하지 않는다.
 */

const ifHasReqInLast10SecAfterShowLayer = Symbol("ifHasReqInLast10SecAfterShowLayer");
const ifCanConnectAfterHideLayer = Symbol("ifCanConnectAfterHideLayer");
const clearServerConnect = Symbol("clearServerConnect");

const showCannotConnect = Symbol("showCannotConnect");
const hideCannotConnect = Symbol("hideCannotConnect");

const AriesServerConnectCheckStatusCode = {SERVERDOWN_OR_NETWORKFAIL: 0, EXTERNAL_PROBLEM: 1};
class AriesServerConnectCheck {

    static requestCannotConnect(statusCode) {
        this.lastRequestTime = Date.now();
        this.lastStatusCode = statusCode;

        if(this.prevRequestTimerId === undefined) {
            this.prevRequestTimerId = setTimeout(() => {
                this[ifHasReqInLast10SecAfterShowLayer]();
            }, 15 * 1000);
        }
    }

    static [ifHasReqInLast10SecAfterShowLayer] () {
        if(this.lastRequestTime > Date.now() - 10 * 1000)
            this[showCannotConnect]();


        this.prevRequestTimerId = undefined;
    }

    static [ifCanConnectAfterHideLayer]() {
        if(this.lastRequestTime < Date.now() - 20 * 1000) {
            this[hideCannotConnect]();

            this[clearServerConnect]();

            window.clearInterval(this.checkCanConnectIntervalId);
        }
    }

    static [showCannotConnect]() {
        console.log("cannot server-connect code = "+this.lastStatusCode);

        if(this.isShowConnectFailLayer) {
            return;
        }


        aries.chart.loader.stopCharts();
        offDragPrevent();

        let message = "";
        if(this.lastStatusCode === AriesServerConnectCheckStatusCode.SERVERDOWN_OR_NETWORKFAIL) {
            message = i18n.get("M0517");
        } else if(this.lastStatusCode === AriesServerConnectCheckStatusCode.EXTERNAL_PROBLEM) {
            message = i18n.get("M0518");
        }


        $("#serverCannotConnectLayer .message").html(message);
        $("#serverCannotConnectLayer").show();


        this.isShowConnectFailLayer = true;
        this.checkCanConnectIntervalId = setInterval(() => { this[ifCanConnectAfterHideLayer](); }, 2 * 1000);
    }


    static [hideCannotConnect]() {
        aries.chart.loader.startCharts();
        onDragPrevent();

        $("#serverCannotConnectLayer").hide();
        this.isShowConnectFailLayer = false;
    }

    static [clearServerConnect]() {
        this.prevRequestTimerId = undefined;

        this.lastRequestTime = undefined;
        this.lastStatusCode = undefined;
    }
}