/*
 * Decompiled with CFR 0.152.
 */
package io.kotlintest.runner.jvm;

import arrow.Kind;
import arrow.core.Try;
import io.kotlintest.Description;
import io.kotlintest.Project;
import io.kotlintest.Spec;
import io.kotlintest.runner.jvm.InstancePerTestSpecRunner;
import io.kotlintest.runner.jvm.JvmKt;
import io.kotlintest.runner.jvm.SharedInstanceSpecRunner;
import io.kotlintest.runner.jvm.SpecRunner;
import io.kotlintest.runner.jvm.TestEngine;
import io.kotlintest.runner.jvm.TestEngineListener;
import io.kotlintest.runner.jvm.TryfuncsKt;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlin.reflect.jvm.KClassesJvm;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u0003\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B+\u0012\u0014\u0010\u0002\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00050\u00040\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u000e\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018H\u0002J\u001e\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00050\u00182\u000e\u0010\u001b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00050\u0004H\u0002J\u0018\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\b\u0010\u001d\u001a\u0004\u0018\u00010\u000fH\u0002J\u0006\u0010\u001e\u001a\u00020\u0019J\u0016\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\u0006\u0010 \u001a\u00020\u0005H\u0002J\u0010\u0010!\u001a\u00020\"2\u0006\u0010 \u001a\u00020\u0005H\u0002J\u000e\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018H\u0002J\u000e\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018H\u0002J\u0018\u0010%\u001a\u00020\u00192\u000e\u0010\u001b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00050\u0004H\u0002R\u001f\u0010\u0002\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00050\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0016\u0010\r\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0010\u001a\n \u0012*\u0004\u0018\u00010\u00110\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0016\u0010\u0015\u001a\n \u0012*\u0004\u0018\u00010\u00160\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lio/kotlintest/runner/jvm/TestEngine;", "", "classes", "", "Lkotlin/reflect/KClass;", "Lio/kotlintest/Spec;", "parallelism", "", "listener", "Lio/kotlintest/runner/jvm/TestEngineListener;", "(Ljava/util/List;ILio/kotlintest/runner/jvm/TestEngineListener;)V", "getClasses", "()Ljava/util/List;", "error", "Ljava/util/concurrent/atomic/AtomicReference;", "", "executor", "Ljava/util/concurrent/ExecutorService;", "kotlin.jvm.PlatformType", "getListener", "()Lio/kotlintest/runner/jvm/TestEngineListener;", "logger", "Lorg/slf4j/Logger;", "afterAll", "Larrow/core/Try;", "", "createSpec", "klass", "end", "t", "execute", "executeSpec", "spec", "runner", "Lio/kotlintest/runner/jvm/SpecRunner;", "start", "submitAll", "submitSpec", "kotlintest-runner-jvm"})
public final class TestEngine {
    private final Logger logger;
    private final ExecutorService executor;
    private final AtomicReference<Throwable> error;
    @NotNull
    private final List<KClass<? extends Spec>> classes;
    @NotNull
    private final TestEngineListener listener;

    private final Try<Unit> afterAll() {
        Try try_;
        Try.Companion this_$iv = Try.Companion;
        try {
            Try.Success success;
            Try.Success success2 = success;
            Try.Success success3 = success;
            Project.INSTANCE.afterAll();
            Unit unit = Unit.INSTANCE;
            success2((Object)unit);
            try_ = (Try)success3;
        }
        catch (Throwable e$iv) {
            try_ = (Try)new Try.Failure(e$iv);
        }
        return try_;
    }

    private final Try<Unit> start() {
        Try try_;
        Try.Companion this_$iv = Try.Companion;
        try {
            Try.Success success;
            Try.Success success2 = success;
            Try.Success success3 = success;
            this.listener.engineStarted(this.classes);
            Project.INSTANCE.beforeAll();
            Unit unit = Unit.INSTANCE;
            success2((Object)unit);
            try_ = (Try)success3;
        }
        catch (Throwable e$iv) {
            try_ = (Try)new Try.Failure(e$iv);
        }
        return try_;
    }

    private final Try<Unit> submitAll() {
        Try try_;
        Try.Companion this_$iv = Try.Companion;
        try {
            Try.Success success;
            Try.Success success2 = success;
            Try.Success success3 = success;
            this.logger.debug("Submitting " + this.classes.size() + " specs");
            Iterable $receiver$iv = this.classes;
            for (Object element$iv : $receiver$iv) {
                KClass it = (KClass)element$iv;
                this.submitSpec((KClass<? extends Spec>)it);
            }
            this.executor.shutdown();
            this.logger.debug("Waiting for spec execution service to terminate");
            try {
                this.executor.awaitTermination(1L, TimeUnit.DAYS);
            }
            catch (InterruptedException t) {
                this.error.compareAndSet(null, t);
            }
            Throwable t = this.error.get();
            if (t != null) {
                throw t;
            }
            Unit unit = Unit.INSTANCE;
            success2((Object)unit);
            try_ = (Try)success3;
        }
        catch (Throwable e$iv) {
            try_ = (Try)new Try.Failure(e$iv);
        }
        return try_;
    }

    private final Try<Unit> end(Throwable t) {
        Try try_;
        Try.Companion this_$iv = Try.Companion;
        try {
            Try.Success success;
            Try.Success success2 = success;
            Try.Success success3 = success;
            if (t != null) {
                this.logger.error("Error during test engine run", t);
                t.printStackTrace();
            }
            this.listener.engineFinished(t);
            Unit unit = Unit.INSTANCE;
            success2((Object)unit);
            try_ = (Try)success3;
        }
        catch (Throwable e$iv) {
            try_ = (Try)new Try.Failure(e$iv);
        }
        return try_;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void execute() {
        Try<Unit> try_;
        Throwable it;
        Try try_2;
        Object it$iv;
        Try this_$iv = this.start();
        Try this_$iv$iv = this_$iv;
        Try try_3 = this_$iv$iv;
        if (try_3 instanceof Try.Failure) {
            it$iv = ((Try.Failure)this_$iv$iv).getException();
            try_2 = Try.Companion.raise((Throwable)it$iv);
        } else {
            Kind $receiver$iv$iv;
            if (!(try_3 instanceof Try.Success)) throw new NoWhenBranchMatchedException();
            it$iv = ((Try.Success)this_$iv$iv).getValue();
            Unit it2 = (Unit)it$iv;
            Kind kind = $receiver$iv$iv = (Kind)this.submitAll();
            if (kind == null) {
                throw new TypeCastException("null cannot be cast to non-null type arrow.core.Try<A>");
            }
            try_2 = (Try)kind;
        }
        this_$iv = try_2;
        Try try_4 = this_$iv;
        if (try_4 instanceof Try.Failure) {
            it = ((Try.Failure)this_$iv).getException();
            this.afterAll();
            try_ = this.end(it);
            return;
        } else {
            if (!(try_4 instanceof Try.Success)) throw new NoWhenBranchMatchedException();
            it = (Unit)((Try.Success)this_$iv).getValue();
            Try<Unit> this_$iv2 = this.afterAll();
            Try<Unit> try_5 = this_$iv2;
            if (try_5 instanceof Try.Failure) {
                Throwable it3 = ((Try.Failure)this_$iv2).getException();
                try_ = this.end(it3);
                return;
            } else {
                if (!(try_5 instanceof Try.Success)) throw new NoWhenBranchMatchedException();
                Unit it4 = (Unit)((Try.Success)this_$iv2).getValue();
                try_ = this.end(null);
            }
        }
    }

    private final void submitSpec(KClass<? extends Spec> klass) {
        this.executor.submit(new Runnable(this, klass){
            final /* synthetic */ TestEngine this$0;
            final /* synthetic */ KClass $klass;

            public final void run() {
                Try this_$iv = TestEngine.access$createSpec(this.this$0, this.$klass);
                Try try_ = this_$iv;
                if (try_ instanceof Try.Failure) {
                    Throwable t = ((Try.Failure)this_$iv).getException();
                    Description desc = Description.Companion.root(KClassesJvm.getJvmName((KClass)this.$klass));
                    this.this$0.getListener().prepareSpec(desc, (KClass<? extends Spec>)this.$klass);
                    this.this$0.getListener().completeSpec(desc, (KClass<? extends Spec>)this.$klass, t);
                    TestEngine.access$getError$p(this.this$0).compareAndSet(null, t);
                    TestEngine.access$getExecutor$p(this.this$0).shutdownNow();
                } else if (try_ instanceof Try.Success) {
                    Spec spec = (Spec)((Try.Success)this_$iv).getValue();
                    TryfuncsKt.onf(TestEngine.access$executeSpec(this.this$0, spec), (Function1<? super Throwable, Unit>)((Function1)new Function1<Throwable, Unit>(this){
                        final /* synthetic */ submitSpec.1 this$0;
                        {
                            this.this$0 = var1_1;
                            super(1);
                        }

                        public final void invoke(@NotNull Throwable t) {
                            Intrinsics.checkParameterIsNotNull((Object)t, (String)"t");
                            TestEngine.access$getError$p(this.this$0.this$0).compareAndSet(null, t);
                            TestEngine.access$getExecutor$p(this.this$0.this$0).shutdownNow();
                        }
                    }));
                } else {
                    throw new NoWhenBranchMatchedException();
                }
            }
            {
                this.this$0 = testEngine;
                this.$klass = kClass;
            }
        });
    }

    private final Try<Spec> createSpec(KClass<? extends Spec> klass) {
        Try try_;
        Try<Spec> this_$iv = JvmKt.instantiateSpec(klass);
        Try<Spec> this_$iv$iv = this_$iv;
        Try<Spec> try_2 = this_$iv$iv;
        if (try_2 instanceof Try.Failure) {
            Throwable it$iv = ((Try.Failure)this_$iv$iv).getException();
            try_ = Try.Companion.raise(it$iv);
        } else if (try_2 instanceof Try.Success) {
            Try try_3;
            Object it$iv = ((Try.Success)this_$iv$iv).getValue();
            Spec it = (Spec)it$iv;
            Try.Companion this_$iv2 = Try.Companion;
            try {
                Try.Success success;
                Try.Success success2 = success;
                Try.Success success3 = success;
                this.getListener().specCreated(it);
                Spec spec = it;
                success2((Object)spec);
                try_3 = (Try)success3;
            }
            catch (Throwable e$iv) {
                try_3 = (Try)new Try.Failure(e$iv);
            }
            Kind $receiver$iv$iv = (Kind)try_3;
            try_ = (Try)$receiver$iv$iv;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return try_;
    }

    private final Try<Unit> executeSpec(Spec spec) {
        Try try_;
        Try.Companion this_$iv = Try.Companion;
        try {
            Throwable it;
            Try try_2;
            Try.Success success;
            Try.Success success2 = success;
            Try.Success success3 = success;
            this.listener.prepareSpec(spec.description(), (KClass<? extends Spec>)Reflection.getOrCreateKotlinClass(spec.getClass()));
            Try.Companion this_$iv2 = Try.Companion;
            try {
                Try.Success success4;
                Try.Success success5 = success4;
                Try.Success success6 = success4;
                this.runner(spec).execute(spec);
                Unit unit = Unit.INSTANCE;
                success5((Object)unit);
                try_2 = (Try)success6;
            }
            catch (Throwable e$iv) {
                try_2 = (Try)new Try.Failure(e$iv);
            }
            this_$iv2 = try_2;
            Try.Companion companion = this_$iv2;
            if (companion instanceof Try.Failure) {
                it = ((Try.Failure)this_$iv2).getException();
                this.listener.completeSpec(spec.description(), (KClass<? extends Spec>)JvmClassMappingKt.getKotlinClass(spec.getClass()), it);
            } else if (companion instanceof Try.Success) {
                it = (Unit)((Try.Success)this_$iv2).getValue();
                this.listener.completeSpec(spec.description(), (KClass<? extends Spec>)JvmClassMappingKt.getKotlinClass(spec.getClass()), null);
            } else {
                throw new NoWhenBranchMatchedException();
            }
            spec.closeResources();
            Unit unit = Unit.INSTANCE;
            success2((Object)unit);
            try_ = (Try)success3;
        }
        catch (Throwable e$iv) {
            try_ = (Try)new Try.Failure(e$iv);
        }
        return try_;
    }

    private final SpecRunner runner(Spec spec) {
        return spec.isInstancePerTest() ? (SpecRunner)new InstancePerTestSpecRunner(this.listener) : (SpecRunner)new SharedInstanceSpecRunner(this.listener);
    }

    @NotNull
    public final List<KClass<? extends Spec>> getClasses() {
        return this.classes;
    }

    @NotNull
    public final TestEngineListener getListener() {
        return this.listener;
    }

    public TestEngine(@NotNull List<? extends KClass<? extends Spec>> classes, int parallelism, @NotNull TestEngineListener listener) {
        Intrinsics.checkParameterIsNotNull(classes, (String)"classes");
        Intrinsics.checkParameterIsNotNull((Object)listener, (String)"listener");
        this.classes = classes;
        this.listener = listener;
        this.logger = LoggerFactory.getLogger(this.getClass());
        this.executor = Executors.newFixedThreadPool(parallelism);
        this.error = new AtomicReference<Object>(null);
    }

    @NotNull
    public static final /* synthetic */ Try access$createSpec(TestEngine $this, @NotNull KClass klass) {
        return $this.createSpec((KClass<? extends Spec>)klass);
    }

    @NotNull
    public static final /* synthetic */ AtomicReference access$getError$p(TestEngine $this) {
        return $this.error;
    }

    public static final /* synthetic */ ExecutorService access$getExecutor$p(TestEngine $this) {
        return $this.executor;
    }

    @NotNull
    public static final /* synthetic */ Try access$executeSpec(TestEngine $this, @NotNull Spec spec) {
        return $this.executeSpec(spec);
    }
}

