/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.psi2ir.generators;

import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.builders.Scope;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrVariable;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrLoop;
import org.jetbrains.kotlin.ir.expressions.IrStatementOrigin;
import org.jetbrains.kotlin.ir.expressions.impl.IrBlockImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrBreakImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrCompositeImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrContainerExpressionBase;
import org.jetbrains.kotlin.ir.expressions.impl.IrContinueImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrDoWhileLoopImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrWhileLoopImpl;
import org.jetbrains.kotlin.ir.util.SymbolTable;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtBreakExpression;
import org.jetbrains.kotlin.psi.KtContinueExpression;
import org.jetbrains.kotlin.psi.KtDestructuringDeclaration;
import org.jetbrains.kotlin.psi.KtDoWhileExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtExpressionWithLabel;
import org.jetbrains.kotlin.psi.KtForExpression;
import org.jetbrains.kotlin.psi.KtLabeledExpression;
import org.jetbrains.kotlin.psi.KtLoopExpression;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtWhileExpression;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.psi2ir.generators.ArgumentsGenerationUtilsKt;
import org.jetbrains.kotlin.psi2ir.generators.CallGenerator;
import org.jetbrains.kotlin.psi2ir.generators.CallGeneratorKt;
import org.jetbrains.kotlin.psi2ir.generators.ErrorExpressionGenerator;
import org.jetbrains.kotlin.psi2ir.generators.GeneratorKt;
import org.jetbrains.kotlin.psi2ir.generators.StatementGenerator;
import org.jetbrains.kotlin.psi2ir.generators.StatementGeneratorExtension;
import org.jetbrains.kotlin.psi2ir.intermediate.CallBuilder;
import org.jetbrains.kotlin.psi2ir.intermediate.CallBuilderKt;
import org.jetbrains.kotlin.psi2ir.intermediate.VariableLValue;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.util.slicedMap.WritableSlice;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001c\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0002J\u0012\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J\u000e\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u0013J\u000e\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u0016J\u0010\u0010\u0017\u001a\u00020\u000e2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u000e\u0010\u001a\u001a\u00020\u000e2\u0006\u0010\u001b\u001a\u00020\u001cJ\u000e\u0010\u001d\u001a\u00020\u000e2\u0006\u0010\u001e\u001a\u00020\u001fJ\u0010\u0010 \u001a\u00020\u000e2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0012\u0010!\u001a\u0004\u0018\u00010\u00062\u0006\u0010\"\u001a\u00020#H\u0002J\u0012\u0010$\u001a\u0004\u0018\u00010\n2\u0006\u0010\"\u001a\u00020#H\u0002\u00a8\u0006%"}, d2={"Lorg/jetbrains/kotlin/psi2ir/generators/LoopExpressionGenerator;", "Lorg/jetbrains/kotlin/psi2ir/generators/StatementGeneratorExtension;", "statementGenerator", "Lorg/jetbrains/kotlin/psi2ir/generators/StatementGenerator;", "(Lorg/jetbrains/kotlin/psi2ir/generators/StatementGenerator;)V", "findParentLoop", "Lorg/jetbrains/kotlin/ir/expressions/IrLoop;", "ktExpression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "targetLabel", "", "ktWithLabel", "Lorg/jetbrains/kotlin/psi/KtExpressionWithLabel;", "generateBreak", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "ktBreak", "Lorg/jetbrains/kotlin/psi/KtBreakExpression;", "generateContinue", "ktContinue", "Lorg/jetbrains/kotlin/psi/KtContinueExpression;", "generateDoWhileLoop", "ktDoWhile", "Lorg/jetbrains/kotlin/psi/KtDoWhileExpression;", "generateDoWhileLoopBody", "ktLoopBody", "Lorg/jetbrains/kotlin/psi/KtBlockExpression;", "generateForLoop", "ktFor", "Lorg/jetbrains/kotlin/psi/KtForExpression;", "generateWhileLoop", "ktWhile", "Lorg/jetbrains/kotlin/psi/KtWhileExpression;", "generateWhileLoopBody", "getLoop", "ktLoop", "Lorg/jetbrains/kotlin/psi/KtLoopExpression;", "getLoopLabel", "ir.psi2ir"})
public final class LoopExpressionGenerator
extends StatementGeneratorExtension {
    @NotNull
    public final IrExpression generateWhileLoop(@NotNull KtWhileExpression ktWhile) {
        IrExpression irExpression;
        Intrinsics.checkParameterIsNotNull((Object)ktWhile, (String)"ktWhile");
        int n = PsiUtilsKt.getStartOffset(ktWhile);
        int n2 = PsiUtilsKt.getEndOffset(ktWhile);
        SimpleType simpleType2 = this.getContext().getBuiltIns().getUnitType();
        Intrinsics.checkExpressionValueIsNotNull((Object)simpleType2, (String)"context.builtIns.unitType");
        IrWhileLoopImpl irLoop = new IrWhileLoopImpl(n, n2, simpleType2, IrStatementOrigin.WHILE_LOOP.INSTANCE);
        KtExpression ktExpression = ktWhile.getCondition();
        if (ktExpression == null) {
            Intrinsics.throwNpe();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression, (String)"ktWhile.condition!!");
        irLoop.setCondition(this.genExpr(ktExpression));
        this.getStatementGenerator().getBodyGenerator().putLoop(ktWhile, irLoop);
        IrWhileLoopImpl irWhileLoopImpl = irLoop;
        KtExpression ktExpression2 = ktWhile.getBody();
        if (ktExpression2 != null) {
            IrExpression irExpression2;
            KtExpression ktExpression3 = ktExpression2;
            IrWhileLoopImpl irWhileLoopImpl2 = irWhileLoopImpl;
            KtExpression ktLoopBody = ktExpression3;
            if (ktLoopBody instanceof KtBlockExpression) {
                irExpression2 = this.generateWhileLoopBody((KtBlockExpression)ktLoopBody);
            } else {
                KtExpression ktExpression4 = ktLoopBody;
                Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression4, (String)"ktLoopBody");
                irExpression2 = this.genExpr(ktExpression4);
            }
            IrExpression irExpression3 = irExpression2;
            irWhileLoopImpl = irWhileLoopImpl2;
            irExpression = irExpression3;
        } else {
            irExpression = null;
        }
        irWhileLoopImpl.setBody(irExpression);
        irLoop.setLabel(this.getLoopLabel(ktWhile));
        return irLoop;
    }

    @NotNull
    public final IrExpression generateDoWhileLoop(@NotNull KtDoWhileExpression ktDoWhile) {
        IrExpression irExpression;
        Object object;
        Intrinsics.checkParameterIsNotNull((Object)ktDoWhile, (String)"ktDoWhile");
        int n = PsiUtilsKt.getStartOffset(ktDoWhile);
        int n2 = PsiUtilsKt.getEndOffset(ktDoWhile);
        SimpleType simpleType2 = this.getContext().getBuiltIns().getUnitType();
        Intrinsics.checkExpressionValueIsNotNull((Object)simpleType2, (String)"context.builtIns.unitType");
        IrDoWhileLoopImpl irLoop = new IrDoWhileLoopImpl(n, n2, simpleType2, IrStatementOrigin.DO_WHILE_LOOP.INSTANCE);
        this.getStatementGenerator().getBodyGenerator().putLoop(ktDoWhile, irLoop);
        IrDoWhileLoopImpl irDoWhileLoopImpl = irLoop;
        KtExpression ktExpression = ktDoWhile.getBody();
        if (ktExpression != null) {
            IrExpression irExpression2;
            object = ktExpression;
            IrDoWhileLoopImpl irDoWhileLoopImpl2 = irDoWhileLoopImpl;
            Object ktLoopBody = object;
            if (ktLoopBody instanceof KtBlockExpression) {
                irExpression2 = this.generateDoWhileLoopBody((KtBlockExpression)ktLoopBody);
            } else {
                KtExpression ktExpression2 = ktLoopBody;
                Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression2, (String)"ktLoopBody");
                irExpression2 = this.genExpr(ktExpression2);
            }
            IrExpression irExpression3 = irExpression2;
            irDoWhileLoopImpl = irDoWhileLoopImpl2;
            irExpression = irExpression3;
        } else {
            irExpression = null;
        }
        irDoWhileLoopImpl.setBody(irExpression);
        KtExpression ktExpression3 = ktDoWhile.getCondition();
        if (ktExpression3 == null) {
            Intrinsics.throwNpe();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression3, (String)"ktDoWhile.condition!!");
        irLoop.setCondition(this.genExpr(ktExpression3));
        irLoop.setLabel(this.getLoopLabel(ktDoWhile));
        int n3 = PsiUtilsKt.getStartOffset(ktDoWhile);
        int n4 = PsiUtilsKt.getEndOffset(ktDoWhile);
        SimpleType simpleType3 = this.getContext().getBuiltIns().getUnitType();
        Intrinsics.checkExpressionValueIsNotNull((Object)simpleType3, (String)"context.builtIns.unitType");
        Object $receiver = object = new IrBlockImpl(n3, n4, simpleType3, null, 8, null);
        ((IrContainerExpressionBase)$receiver).getStatements().add(irLoop);
        return (IrExpression)object;
    }

    /*
     * WARNING - void declaration
     */
    private final IrExpression generateWhileLoopBody(KtBlockExpression ktLoopBody) {
        Collection<IrStatement> collection;
        void $receiver$iv$iv;
        void $receiver$iv;
        int n = PsiUtilsKt.getStartOffset(ktLoopBody);
        int n2 = PsiUtilsKt.getEndOffset(ktLoopBody);
        SimpleType simpleType2 = this.getContext().getBuiltIns().getUnitType();
        Intrinsics.checkExpressionValueIsNotNull((Object)simpleType2, (String)"context.builtIns.unitType");
        KotlinType kotlinType = simpleType2;
        List<KtExpression> list2 = ktLoopBody.getStatements();
        Intrinsics.checkExpressionValueIsNotNull(list2, (String)"ktLoopBody.statements");
        Iterable iterable = list2;
        IrStatementOrigin irStatementOrigin = null;
        KotlinType kotlinType2 = kotlinType;
        int n3 = n2;
        int n4 = n;
        void var3_7 = $receiver$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            KtExpression ktExpression = (KtExpression)item$iv$iv;
            collection = destination$iv$iv;
            void v5 = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)v5, (String)"it");
            IrStatement irStatement = this.genStmt((KtExpression)v5);
            collection.add(irStatement);
        }
        Collection<IrStatement> collection2 = collection = (List)destination$iv$iv;
        IrStatementOrigin irStatementOrigin2 = irStatementOrigin;
        KotlinType kotlinType3 = kotlinType2;
        int n5 = n3;
        int n6 = n4;
        return new IrBlockImpl(n6, n5, kotlinType3, irStatementOrigin2, (List<? extends IrStatement>)collection2);
    }

    /*
     * WARNING - void declaration
     */
    private final IrExpression generateDoWhileLoopBody(KtBlockExpression ktLoopBody) {
        Collection<IrStatement> collection;
        void $receiver$iv$iv;
        void $receiver$iv;
        int n = PsiUtilsKt.getStartOffset(ktLoopBody);
        int n2 = PsiUtilsKt.getEndOffset(ktLoopBody);
        SimpleType simpleType2 = this.getContext().getBuiltIns().getUnitType();
        Intrinsics.checkExpressionValueIsNotNull((Object)simpleType2, (String)"context.builtIns.unitType");
        KotlinType kotlinType = simpleType2;
        List<KtExpression> list2 = ktLoopBody.getStatements();
        Intrinsics.checkExpressionValueIsNotNull(list2, (String)"ktLoopBody.statements");
        Iterable iterable = list2;
        IrStatementOrigin irStatementOrigin = null;
        KotlinType kotlinType2 = kotlinType;
        int n3 = n2;
        int n4 = n;
        void var3_7 = $receiver$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            KtExpression ktExpression = (KtExpression)item$iv$iv;
            collection = destination$iv$iv;
            void v5 = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)v5, (String)"it");
            IrStatement irStatement = this.genStmt((KtExpression)v5);
            collection.add(irStatement);
        }
        Collection<IrStatement> collection2 = collection = (List)destination$iv$iv;
        IrStatementOrigin irStatementOrigin2 = irStatementOrigin;
        KotlinType kotlinType3 = kotlinType2;
        int n5 = n3;
        int n6 = n4;
        return new IrCompositeImpl(n6, n5, kotlinType3, irStatementOrigin2, (List<? extends IrStatement>)collection2);
    }

    @NotNull
    public final IrExpression generateBreak(@NotNull KtBreakExpression ktBreak) {
        IrBreakImpl irBreakImpl;
        Intrinsics.checkParameterIsNotNull((Object)ktBreak, (String)"ktBreak");
        IrLoop irLoop = this.findParentLoop(ktBreak);
        if (irLoop == null) {
            return new ErrorExpressionGenerator(this.getStatementGenerator()).generateErrorExpression(ktBreak, new RuntimeException("Loop not found for break expression: " + ktBreak.getText()));
        }
        IrLoop parentLoop = irLoop;
        int n = PsiUtilsKt.getStartOffset(ktBreak);
        int n2 = PsiUtilsKt.getEndOffset(ktBreak);
        SimpleType simpleType2 = this.getContext().getBuiltIns().getNothingType();
        Intrinsics.checkExpressionValueIsNotNull((Object)simpleType2, (String)"context.builtIns.nothingType");
        IrBreakImpl $receiver = irBreakImpl = new IrBreakImpl(n, n2, simpleType2, parentLoop);
        $receiver.setLabel(ktBreak.getLabelName());
        return irBreakImpl;
    }

    @NotNull
    public final IrExpression generateContinue(@NotNull KtContinueExpression ktContinue) {
        IrContinueImpl irContinueImpl;
        Intrinsics.checkParameterIsNotNull((Object)ktContinue, (String)"ktContinue");
        IrLoop irLoop = this.findParentLoop(ktContinue);
        if (irLoop == null) {
            return new ErrorExpressionGenerator(this.getStatementGenerator()).generateErrorExpression(ktContinue, new RuntimeException("Loop not found for continue expression: " + ktContinue.getText()));
        }
        IrLoop parentLoop = irLoop;
        int n = PsiUtilsKt.getStartOffset(ktContinue);
        int n2 = PsiUtilsKt.getEndOffset(ktContinue);
        SimpleType simpleType2 = this.getContext().getBuiltIns().getNothingType();
        Intrinsics.checkExpressionValueIsNotNull((Object)simpleType2, (String)"context.builtIns.nothingType");
        IrContinueImpl $receiver = irContinueImpl = new IrContinueImpl(n, n2, simpleType2, parentLoop);
        $receiver.setLabel(ktContinue.getLabelName());
        return irContinueImpl;
    }

    private final String getLoopLabel(KtLoopExpression ktLoop) {
        PsiElement psiElement = ktLoop.getParent();
        if (!(psiElement instanceof KtLabeledExpression)) {
            psiElement = null;
        }
        KtLabeledExpression ktLabeledExpression = (KtLabeledExpression)psiElement;
        return ktLabeledExpression != null ? ktLabeledExpression.getLabelName() : null;
    }

    private final IrLoop findParentLoop(KtExpressionWithLabel ktWithLabel) {
        return this.findParentLoop(ktWithLabel, ktWithLabel.getLabelName());
    }

    /*
     * WARNING - void declaration
     */
    private final IrLoop findParentLoop(KtExpression ktExpression, String targetLabel) {
        KtExpression finger = ktExpression;
        while (finger != null) {
            String label;
            void $receiver$iv;
            PsiElement psiElement = finger;
            boolean strict$iv = true;
            finger = PsiTreeUtil.getParentOfType((PsiElement)$receiver$iv, KtLoopExpression.class, strict$iv);
            if (finger == null) break;
            if (targetLabel == null) {
                IrLoop irLoop = this.getLoop((KtLoopExpression)finger);
                if (irLoop == null) {
                    continue;
                }
                return irLoop;
            }
            PsiElement parent2 = ((KtLoopExpression)finger).getParent();
            if (!(parent2 instanceof KtLabeledExpression)) continue;
            if (((KtLabeledExpression)parent2).getLabelName() == null) {
                Intrinsics.throwNpe();
            }
            if (!Intrinsics.areEqual((Object)targetLabel, (Object)label)) continue;
            IrLoop irLoop = this.getLoop((KtLoopExpression)finger);
            if (irLoop == null) {
                continue;
            }
            return irLoop;
        }
        return null;
    }

    private final IrLoop getLoop(KtLoopExpression ktLoop) {
        return this.getStatementGenerator().getBodyGenerator().getLoop(ktLoop);
    }

    @NotNull
    public final IrExpression generateForLoop(@NotNull KtForExpression ktFor) {
        IrVariable irVariable;
        Intrinsics.checkParameterIsNotNull((Object)ktFor, (String)"ktFor");
        KtParameter ktLoopParameter = ktFor.getLoopParameter();
        KtDestructuringDeclaration ktLoopDestructuringDeclaration = ktFor.getDestructuringDeclaration();
        if (ktLoopParameter == null && ktLoopDestructuringDeclaration == null) {
            throw (Throwable)((Object)new AssertionError((Object)("Either loopParameter or destructuringParameter should be present:\n" + ktFor.getText())));
        }
        KtExpression ktExpression = ktFor.getLoopRange();
        if (ktExpression == null) {
            Intrinsics.throwNpe();
        }
        KtExpression ktLoopRange = ktExpression;
        KtExpression ktForBody = ktFor.getBody();
        WritableSlice<KtExpression, ResolvedCall<FunctionDescriptor>> writableSlice = BindingContext.LOOP_RANGE_ITERATOR_RESOLVED_CALL;
        Intrinsics.checkExpressionValueIsNotNull(writableSlice, (String)"BindingContext.LOOP_RANGE_ITERATOR_RESOLVED_CALL");
        ResolvedCall iteratorResolvedCall = (ResolvedCall)GeneratorKt.getOrFail(this, writableSlice, ktLoopRange);
        WritableSlice<KtExpression, ResolvedCall<FunctionDescriptor>> writableSlice2 = BindingContext.LOOP_RANGE_HAS_NEXT_RESOLVED_CALL;
        Intrinsics.checkExpressionValueIsNotNull(writableSlice2, (String)"BindingContext.LOOP_RANGE_HAS_NEXT_RESOLVED_CALL");
        ResolvedCall hasNextResolvedCall = (ResolvedCall)GeneratorKt.getOrFail(this, writableSlice2, ktLoopRange);
        WritableSlice<KtExpression, ResolvedCall<FunctionDescriptor>> writableSlice3 = BindingContext.LOOP_RANGE_NEXT_RESOLVED_CALL;
        Intrinsics.checkExpressionValueIsNotNull(writableSlice3, (String)"BindingContext.LOOP_RANGE_NEXT_RESOLVED_CALL");
        ResolvedCall nextResolvedCall = (ResolvedCall)GeneratorKt.getOrFail(this, writableSlice3, ktLoopRange);
        CallGenerator callGenerator = new CallGenerator(this.getStatementGenerator());
        int n = PsiUtilsKt.getStartOffset(ktFor);
        int n2 = PsiUtilsKt.getEndOffset(ktFor);
        SimpleType simpleType2 = this.getContext().getBuiltIns().getUnitType();
        Intrinsics.checkExpressionValueIsNotNull((Object)simpleType2, (String)"context.builtIns.unitType");
        IrBlockImpl irForBlock = new IrBlockImpl(n, n2, simpleType2, IrStatementOrigin.FOR_LOOP.INSTANCE);
        StatementGenerator statementGenerator = this.getStatementGenerator();
        ResolvedCall resolvedCall2 = iteratorResolvedCall;
        Intrinsics.checkExpressionValueIsNotNull((Object)resolvedCall2, (String)"iteratorResolvedCall");
        CallBuilder iteratorCall = ArgumentsGenerationUtilsKt.pregenerateCall(statementGenerator, resolvedCall2);
        KtExpression ktExpression2 = ktLoopRange;
        Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression2, (String)"ktLoopRange");
        IrExpression irIteratorCall = CallGeneratorKt.generateCall(callGenerator, ktExpression2, iteratorCall, (IrStatementOrigin)IrStatementOrigin.FOR_LOOP_ITERATOR.INSTANCE);
        IrVariable irIterator = Scope.createTemporaryVariable$default(this.getScope(), irIteratorCall, "iterator", false, IrDeclarationOrigin.FOR_LOOP_ITERATOR.INSTANCE, 4, null);
        VariableLValue iteratorValue = new VariableLValue(irIterator, null, 2, null);
        irForBlock.getStatements().add(irIterator);
        int n3 = PsiUtilsKt.getStartOffset(ktFor);
        int n4 = PsiUtilsKt.getEndOffset(ktFor);
        SimpleType simpleType3 = this.getContext().getBuiltIns().getUnitType();
        Intrinsics.checkExpressionValueIsNotNull((Object)simpleType3, (String)"context.builtIns.unitType");
        IrWhileLoopImpl irInnerWhile = new IrWhileLoopImpl(n3, n4, simpleType3, IrStatementOrigin.FOR_LOOP_INNER_WHILE.INSTANCE);
        irInnerWhile.setLabel(this.getLoopLabel(ktFor));
        this.getStatementGenerator().getBodyGenerator().putLoop(ktFor, irInnerWhile);
        irForBlock.getStatements().add(irInnerWhile);
        StatementGenerator statementGenerator2 = this.getStatementGenerator();
        ResolvedCall resolvedCall3 = hasNextResolvedCall;
        Intrinsics.checkExpressionValueIsNotNull((Object)resolvedCall3, (String)"hasNextResolvedCall");
        CallBuilder hasNextCall = ArgumentsGenerationUtilsKt.pregenerateCall(statementGenerator2, resolvedCall3);
        CallBuilderKt.setExplicitReceiverValue(hasNextCall, iteratorValue);
        IrExpression irHasNextCall = CallGeneratorKt.generateCall(callGenerator, ktLoopRange, hasNextCall, (IrStatementOrigin)IrStatementOrigin.FOR_LOOP_HAS_NEXT.INSTANCE);
        irInnerWhile.setCondition(irHasNextCall);
        int n5 = PsiUtilsKt.getStartOffset(ktFor);
        int n6 = PsiUtilsKt.getEndOffset(ktFor);
        SimpleType simpleType4 = this.getContext().getBuiltIns().getUnitType();
        Intrinsics.checkExpressionValueIsNotNull((Object)simpleType4, (String)"context.builtIns.unitType");
        IrBlockImpl irInnerBody = new IrBlockImpl(n5, n6, simpleType4, IrStatementOrigin.FOR_LOOP_INNER_WHILE.INSTANCE);
        irInnerWhile.setBody(irInnerBody);
        StatementGenerator statementGenerator3 = this.getStatementGenerator();
        ResolvedCall resolvedCall4 = nextResolvedCall;
        Intrinsics.checkExpressionValueIsNotNull((Object)resolvedCall4, (String)"nextResolvedCall");
        CallBuilder nextCall = ArgumentsGenerationUtilsKt.pregenerateCall(statementGenerator3, resolvedCall4);
        CallBuilderKt.setExplicitReceiverValue(nextCall, iteratorValue);
        IrExpression irNextCall = CallGeneratorKt.generateCall(callGenerator, ktLoopRange, nextCall, (IrStatementOrigin)IrStatementOrigin.FOR_LOOP_NEXT.INSTANCE);
        if (ktLoopParameter != null && ktLoopDestructuringDeclaration == null) {
            SymbolTable symbolTable = this.getContext().getSymbolTable();
            int n7 = PsiUtilsKt.getStartOffset(ktLoopParameter);
            int n8 = PsiUtilsKt.getEndOffset(ktLoopParameter);
            IrDeclarationOrigin irDeclarationOrigin = IrDeclarationOrigin.FOR_LOOP_VARIABLE.INSTANCE;
            WritableSlice<KtParameter, VariableDescriptor> writableSlice4 = BindingContext.VALUE_PARAMETER;
            Intrinsics.checkExpressionValueIsNotNull(writableSlice4, (String)"BindingContext.VALUE_PARAMETER");
            Object v = GeneratorKt.getOrFail(this, writableSlice4, ktLoopParameter);
            Intrinsics.checkExpressionValueIsNotNull(v, (String)"getOrFail(BindingContext\u2026RAMETER, ktLoopParameter)");
            irVariable = symbolTable.declareVariable(n7, n8, irDeclarationOrigin, (VariableDescriptor)v, irNextCall);
        } else {
            irVariable = Scope.createTemporaryVariable$default(this.getScope(), irNextCall, "loop_parameter", false, IrDeclarationOrigin.FOR_LOOP_IMPLICIT_VARIABLE.INSTANCE, 4, null);
        }
        IrVariable irLoopParameter = irVariable;
        irInnerBody.getStatements().add(irLoopParameter);
        if (ktLoopDestructuringDeclaration != null) {
            this.getStatementGenerator().declareComponentVariablesInBlock(ktLoopDestructuringDeclaration, irInnerBody, new VariableLValue(irLoopParameter, null, 2, null));
        }
        if (ktForBody != null) {
            irInnerBody.getStatements().add(this.genExpr(ktForBody));
        }
        return irForBlock;
    }

    public LoopExpressionGenerator(@NotNull StatementGenerator statementGenerator) {
        Intrinsics.checkParameterIsNotNull((Object)statementGenerator, (String)"statementGenerator");
        super(statementGenerator);
    }
}

