/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.bootstrap.executors;

import io.opentelemetry.javaagent.bootstrap.InstrumentedTaskClasses;
import io.opentelemetry.javaagent.bootstrap.executors.PropagatedContext;
import io.opentelemetry.javaagent.shaded.instrumentation.api.internal.ContextPropagationDebug;
import io.opentelemetry.javaagent.shaded.instrumentation.api.util.VirtualField;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.context.Context;
import javax.annotation.Nullable;

public final class ExecutorAdviceHelper {
    private static final ThreadLocal<Boolean> propagationDisabled = new ThreadLocal();

    public static void disablePropagation() {
        propagationDisabled.set(Boolean.TRUE);
    }

    public static void enablePropagation() {
        propagationDisabled.remove();
    }

    public static boolean isPropagationDisabled() {
        return propagationDisabled.get() != null;
    }

    public static boolean shouldPropagateContext(Context context, @Nullable Object task) {
        if (task == null || ExecutorAdviceHelper.isPropagationDisabled()) {
            return false;
        }
        if (context == Context.root()) {
            return false;
        }
        return InstrumentedTaskClasses.canInstrumentTaskClass(task.getClass());
    }

    public static <T> PropagatedContext attachContextToTask(Context context, VirtualField<T, PropagatedContext> virtualField, T task) {
        PropagatedContext propagatedContext = virtualField.get(task);
        if (propagatedContext == null) {
            propagatedContext = new PropagatedContext();
            virtualField.set(task, propagatedContext);
        } else {
            Context propagated = propagatedContext.get();
            if (propagated != null && (propagated == context || ContextPropagationDebug.unwrap(propagated) == context)) {
                return null;
            }
        }
        context = ContextPropagationDebug.addDebugInfo(context, task);
        propagatedContext.setContext(context);
        return propagatedContext;
    }

    public static void cleanUpAfterSubmit(@Nullable PropagatedContext propagatedContext, @Nullable Throwable throwable) {
        if (propagatedContext != null && throwable != null) {
            propagatedContext.clear();
        }
    }

    public static <T> void cleanPropagatedContext(VirtualField<T, PropagatedContext> virtualField, T task) {
        if (ExecutorAdviceHelper.isPropagationDisabled()) {
            return;
        }
        PropagatedContext propagatedContext = virtualField.get(task);
        if (propagatedContext != null) {
            propagatedContext.clear();
        }
    }

    private ExecutorAdviceHelper() {
    }
}

