/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.instrumentation.api.incubator.builder.internal;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.opentelemetry.javaagent.shaded.instrumentation.api.incubator.config.internal.CommonConfig;
import io.opentelemetry.javaagent.shaded.instrumentation.api.incubator.semconv.http.HttpExperimentalAttributesExtractor;
import io.opentelemetry.javaagent.shaded.instrumentation.api.incubator.semconv.http.HttpServerExperimentalMetrics;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.AttributesExtractor;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.Instrumenter;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.InstrumenterBuilder;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.SpanKindExtractor;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.SpanNameExtractor;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.SpanStatusExtractor;
import io.opentelemetry.javaagent.shaded.instrumentation.api.semconv.http.HttpServerAttributesExtractor;
import io.opentelemetry.javaagent.shaded.instrumentation.api.semconv.http.HttpServerAttributesExtractorBuilder;
import io.opentelemetry.javaagent.shaded.instrumentation.api.semconv.http.HttpServerAttributesGetter;
import io.opentelemetry.javaagent.shaded.instrumentation.api.semconv.http.HttpServerMetrics;
import io.opentelemetry.javaagent.shaded.instrumentation.api.semconv.http.HttpServerRoute;
import io.opentelemetry.javaagent.shaded.instrumentation.api.semconv.http.HttpServerRouteBuilder;
import io.opentelemetry.javaagent.shaded.instrumentation.api.semconv.http.HttpSpanNameExtractor;
import io.opentelemetry.javaagent.shaded.instrumentation.api.semconv.http.HttpSpanNameExtractorBuilder;
import io.opentelemetry.javaagent.shaded.instrumentation.api.semconv.http.HttpSpanStatusExtractor;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.context.propagation.TextMapGetter;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;

public final class DefaultHttpServerInstrumenterBuilder<REQUEST, RESPONSE> {
    private final String instrumentationName;
    private final OpenTelemetry openTelemetry;
    private final List<AttributesExtractor<? super REQUEST, ? super RESPONSE>> additionalExtractors = new ArrayList<AttributesExtractor<? super REQUEST, ? super RESPONSE>>();
    private Function<SpanStatusExtractor<? super REQUEST, ? super RESPONSE>, ? extends SpanStatusExtractor<? super REQUEST, ? super RESPONSE>> statusExtractorTransformer = Function.identity();
    private final HttpServerAttributesExtractorBuilder<REQUEST, RESPONSE> httpAttributesExtractorBuilder;
    private final HttpSpanNameExtractorBuilder<REQUEST> httpSpanNameExtractorBuilder;
    @Nullable
    private TextMapGetter<REQUEST> headerGetter;
    private Function<SpanNameExtractor<? super REQUEST>, ? extends SpanNameExtractor<? super REQUEST>> spanNameExtractorTransformer = Function.identity();
    private final HttpServerRouteBuilder<REQUEST> httpServerRouteBuilder;
    private final HttpServerAttributesGetter<REQUEST, RESPONSE> attributesGetter;
    private boolean emitExperimentalHttpServerMetrics = false;

    public DefaultHttpServerInstrumenterBuilder(String instrumentationName, OpenTelemetry openTelemetry, HttpServerAttributesGetter<REQUEST, RESPONSE> attributesGetter) {
        this.instrumentationName = instrumentationName;
        this.openTelemetry = openTelemetry;
        this.httpAttributesExtractorBuilder = HttpServerAttributesExtractor.builder(attributesGetter);
        this.httpSpanNameExtractorBuilder = HttpSpanNameExtractor.builder(attributesGetter);
        this.httpServerRouteBuilder = HttpServerRoute.builder(attributesGetter);
        this.attributesGetter = attributesGetter;
    }

    @CanIgnoreReturnValue
    public DefaultHttpServerInstrumenterBuilder<REQUEST, RESPONSE> addAttributesExtractor(AttributesExtractor<? super REQUEST, ? super RESPONSE> attributesExtractor) {
        this.additionalExtractors.add(attributesExtractor);
        return this;
    }

    @CanIgnoreReturnValue
    public DefaultHttpServerInstrumenterBuilder<REQUEST, RESPONSE> setStatusExtractor(Function<SpanStatusExtractor<? super REQUEST, ? super RESPONSE>, ? extends SpanStatusExtractor<? super REQUEST, ? super RESPONSE>> statusExtractor) {
        this.statusExtractorTransformer = statusExtractor;
        return this;
    }

    @CanIgnoreReturnValue
    public DefaultHttpServerInstrumenterBuilder<REQUEST, RESPONSE> setCapturedRequestHeaders(List<String> requestHeaders) {
        this.httpAttributesExtractorBuilder.setCapturedRequestHeaders(requestHeaders);
        return this;
    }

    @CanIgnoreReturnValue
    public DefaultHttpServerInstrumenterBuilder<REQUEST, RESPONSE> setCapturedResponseHeaders(List<String> responseHeaders) {
        this.httpAttributesExtractorBuilder.setCapturedResponseHeaders(responseHeaders);
        return this;
    }

    @CanIgnoreReturnValue
    public DefaultHttpServerInstrumenterBuilder<REQUEST, RESPONSE> setKnownMethods(Set<String> knownMethods) {
        this.httpAttributesExtractorBuilder.setKnownMethods(knownMethods);
        this.httpSpanNameExtractorBuilder.setKnownMethods(knownMethods);
        this.httpServerRouteBuilder.setKnownMethods(knownMethods);
        return this;
    }

    @CanIgnoreReturnValue
    public DefaultHttpServerInstrumenterBuilder<REQUEST, RESPONSE> setHeaderGetter(@Nullable TextMapGetter<REQUEST> headerGetter) {
        this.headerGetter = headerGetter;
        return this;
    }

    @CanIgnoreReturnValue
    public DefaultHttpServerInstrumenterBuilder<REQUEST, RESPONSE> setEmitExperimentalHttpServerMetrics(boolean emitExperimentalHttpServerMetrics) {
        this.emitExperimentalHttpServerMetrics = emitExperimentalHttpServerMetrics;
        return this;
    }

    @CanIgnoreReturnValue
    public DefaultHttpServerInstrumenterBuilder<REQUEST, RESPONSE> setSpanNameExtractor(Function<SpanNameExtractor<? super REQUEST>, ? extends SpanNameExtractor<? super REQUEST>> spanNameExtractorTransformer) {
        this.spanNameExtractorTransformer = spanNameExtractorTransformer;
        return this;
    }

    public Instrumenter<REQUEST, RESPONSE> build() {
        InstrumenterBuilder builder = this.builder();
        if (this.headerGetter != null) {
            return builder.buildServerInstrumenter(this.headerGetter);
        }
        return builder.buildInstrumenter(SpanKindExtractor.alwaysServer());
    }

    private InstrumenterBuilder<REQUEST, RESPONSE> builder() {
        SpanNameExtractor<? super REQUEST> spanNameExtractor = this.spanNameExtractorTransformer.apply(this.httpSpanNameExtractorBuilder.build());
        InstrumenterBuilder<REQUEST, RESPONSE> builder = Instrumenter.builder(this.openTelemetry, this.instrumentationName, spanNameExtractor).setSpanStatusExtractor(this.statusExtractorTransformer.apply(HttpSpanStatusExtractor.create(this.attributesGetter))).addAttributesExtractor(this.httpAttributesExtractorBuilder.build()).addAttributesExtractors(this.additionalExtractors).addContextCustomizer(this.httpServerRouteBuilder.build()).addOperationMetrics(HttpServerMetrics.get());
        if (this.emitExperimentalHttpServerMetrics) {
            builder.addAttributesExtractor(HttpExperimentalAttributesExtractor.create(this.attributesGetter)).addOperationMetrics(HttpServerExperimentalMetrics.get());
        }
        return builder;
    }

    @CanIgnoreReturnValue
    public DefaultHttpServerInstrumenterBuilder<REQUEST, RESPONSE> configure(CommonConfig config) {
        DefaultHttpServerInstrumenterBuilder.set(config::getKnownHttpRequestMethods, this::setKnownMethods);
        DefaultHttpServerInstrumenterBuilder.set(config::getServerRequestHeaders, this::setCapturedRequestHeaders);
        DefaultHttpServerInstrumenterBuilder.set(config::getServerResponseHeaders, this::setCapturedResponseHeaders);
        DefaultHttpServerInstrumenterBuilder.set(config::shouldEmitExperimentalHttpServerTelemetry, this::setEmitExperimentalHttpServerMetrics);
        return this;
    }

    private static <T> void set(Supplier<T> supplier, Consumer<T> consumer) {
        T t = supplier.get();
        if (t != null) {
            consumer.accept(t);
        }
    }
}

