/*
 * Decompiled with CFR 0.152.
 */
package clover.com.atlassian.extras.core;

import clover.com.atlassian.extras.api.AtlassianLicense;
import clover.com.atlassian.extras.api.LicenseManager;
import clover.com.atlassian.extras.common.LicenseException;
import clover.com.atlassian.extras.core.AtlassianLicenseFactory;
import clover.com.atlassian.extras.decoder.api.LicenseDecoder;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class DefaultLicenseManager
implements LicenseManager {
    private final Map<String, AtlassianLicense> licenses = new ConcurrentHashMap<String, AtlassianLicense>(1);
    private final LicenseDecoder licenseDecoder;
    private final AtlassianLicenseFactory atlassianLicenseFactory;

    DefaultLicenseManager(LicenseDecoder licenseDecoder, AtlassianLicenseFactory atlassianLicenseFactory) {
        if (licenseDecoder == null) {
            throw new IllegalArgumentException("licenseDecoder must NOT be null!");
        }
        if (atlassianLicenseFactory == null) {
            throw new IllegalArgumentException("atlassianLicenseFactory must NOT be null!");
        }
        this.atlassianLicenseFactory = atlassianLicenseFactory;
        this.licenseDecoder = licenseDecoder;
    }

    @Override
    public AtlassianLicense getLicense(String licenseString) {
        if (licenseString == null) {
            throw new IllegalArgumentException("licenseString must NOT be null");
        }
        AtlassianLicense license = this.licenses.get(licenseString);
        if (license == null) {
            license = this.decodeLicense(licenseString);
            if (license == null) {
                throw new LicenseException("Could not decode license <" + licenseString + ">, " + "decoding returned a null Atlassian license object");
            }
            this.licenses.put(licenseString, license);
        }
        return license;
    }

    private AtlassianLicense decodeLicense(String licenseString) {
        return this.atlassianLicenseFactory.getLicense(this.licenseDecoder.decode(licenseString));
    }

    Map<String, AtlassianLicense> getLicenses() {
        return Collections.unmodifiableMap(this.licenses);
    }

    LicenseDecoder getLicenseDecoder() {
        return this.licenseDecoder;
    }

    AtlassianLicenseFactory getAtlassianLicenseFactory() {
        return this.atlassianLicenseFactory;
    }

    @Override
    public void clear() {
        this.licenses.clear();
    }
}

