/*
 * Decompiled with CFR 0.152.
 */
package clover.com.google.gson;

import clover.com.google.gson.ExclusionStrategy;
import clover.com.google.gson.MemoryRefStack;
import clover.com.google.gson.Preconditions;
import clover.com.google.gson.TypeInfo;
import clover.com.google.gson.TypeInfoFactory;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ObjectNavigator {
    private final ExclusionStrategy exclusionStrategy;
    private final MemoryRefStack<Object> ancestors;
    private final Object obj;
    private final Type objType;

    ObjectNavigator(Object obj, Type objType, ExclusionStrategy exclusionStrategy, MemoryRefStack<Object> ancestors) {
        Preconditions.checkNotNull(exclusionStrategy);
        Preconditions.checkNotNull(ancestors);
        this.obj = obj;
        this.objType = objType;
        this.exclusionStrategy = exclusionStrategy;
        this.ancestors = ancestors;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void accept(Visitor visitor) {
        boolean visitedWithCustomHandler = visitor.visitUsingCustomHandler(this.obj, this.objType);
        if (!visitedWithCustomHandler) {
            Object objectToVisit;
            Object object = objectToVisit = this.obj == null ? visitor.getTarget() : this.obj;
            if (objectToVisit == null) {
                return;
            }
            TypeInfo objTypeInfo = new TypeInfo(this.objType);
            if (this.exclusionStrategy.shouldSkipClass(objTypeInfo.getRawClass())) {
                return;
            }
            if (this.ancestors.contains(objectToVisit)) {
                throw new IllegalStateException("Circular reference found: " + objectToVisit);
            }
            this.ancestors.push(objectToVisit);
            try {
                if (objTypeInfo.isArray()) {
                    visitor.visitArray(objectToVisit, this.objType);
                } else {
                    visitor.startVisitingObject(objectToVisit);
                    for (Class<?> curr = objTypeInfo.getRawClass(); curr != null && !curr.equals(Object.class); curr = curr.getSuperclass()) {
                        if (curr.isSynthetic()) continue;
                        this.navigateClassFields(objectToVisit, curr, visitor);
                    }
                }
            }
            finally {
                this.ancestors.pop();
            }
        }
    }

    private void navigateClassFields(Object obj, Class<?> clazz, Visitor visitor) {
        AccessibleObject[] fields = clazz.getDeclaredFields();
        AccessibleObject.setAccessible(fields, true);
        for (AccessibleObject f : fields) {
            boolean visitedWithCustomHandler;
            TypeInfo fieldTypeInfo = TypeInfoFactory.getTypeInfoForField((Field)f, this.objType);
            Type actualTypeOfField = fieldTypeInfo.getActualType();
            if (this.exclusionStrategy.shouldSkipField((Field)f) || (visitedWithCustomHandler = visitor.visitFieldUsingCustomHandler((Field)f, actualTypeOfField, obj))) continue;
            if (fieldTypeInfo.isArray()) {
                visitor.visitArrayField((Field)f, actualTypeOfField, obj);
                continue;
            }
            visitor.visitObjectField((Field)f, actualTypeOfField, obj);
        }
    }

    public static interface Visitor {
        public void startVisitingObject(Object var1);

        public void visitArray(Object var1, Type var2);

        public void visitObjectField(Field var1, Type var2, Object var3);

        public void visitArrayField(Field var1, Type var2, Object var3);

        public boolean visitUsingCustomHandler(Object var1, Type var2);

        public boolean visitFieldUsingCustomHandler(Field var1, Type var2, Object var3);

        public Object getTarget();
    }
}

