/*
 * Decompiled with CFR 0.152.
 */
package clover.org.apache.commons.collections.functors;

import clover.org.apache.commons.collections.Closure;
import clover.org.apache.commons.collections.Predicate;
import clover.org.apache.commons.collections.Transformer;
import java.util.Collection;
import java.util.Iterator;

class FunctorUtils {
    private FunctorUtils() {
    }

    static Predicate[] copy(Predicate[] predicates) {
        if (predicates == null) {
            return null;
        }
        return (Predicate[])predicates.clone();
    }

    static void validate(Predicate[] predicates) {
        if (predicates == null) {
            throw new IllegalArgumentException("The predicate array must not be null");
        }
        for (int i = 0; i < predicates.length; ++i) {
            if (predicates[i] != null) continue;
            throw new IllegalArgumentException("The predicate array must not contain a null predicate, index " + i + " was null");
        }
    }

    static Predicate[] validate(Collection predicates) {
        if (predicates == null) {
            throw new IllegalArgumentException("The predicate collection must not be null");
        }
        Predicate[] preds = new Predicate[predicates.size()];
        int i = 0;
        Iterator it = predicates.iterator();
        while (it.hasNext()) {
            preds[i] = (Predicate)it.next();
            if (preds[i] == null) {
                throw new IllegalArgumentException("The predicate collection must not contain a null predicate, index " + i + " was null");
            }
            ++i;
        }
        return preds;
    }

    static Closure[] copy(Closure[] closures) {
        if (closures == null) {
            return null;
        }
        return (Closure[])closures.clone();
    }

    static void validate(Closure[] closures) {
        if (closures == null) {
            throw new IllegalArgumentException("The closure array must not be null");
        }
        for (int i = 0; i < closures.length; ++i) {
            if (closures[i] != null) continue;
            throw new IllegalArgumentException("The closure array must not contain a null closure, index " + i + " was null");
        }
    }

    static Transformer[] copy(Transformer[] transformers) {
        if (transformers == null) {
            return null;
        }
        return (Transformer[])transformers.clone();
    }

    static void validate(Transformer[] transformers) {
        if (transformers == null) {
            throw new IllegalArgumentException("The transformer array must not be null");
        }
        for (int i = 0; i < transformers.length; ++i) {
            if (transformers[i] != null) continue;
            throw new IllegalArgumentException("The transformer array must not contain a null transformer, index " + i + " was null");
        }
    }
}

