/*
 * Decompiled with CFR 0.152.
 */
package clover.org.apache.velocity.runtime.resource.loader;

import clover.org.apache.commons.collections.ExtendedProperties;
import clover.org.apache.commons.lang.StringUtils;
import clover.org.apache.velocity.exception.ResourceNotFoundException;
import clover.org.apache.velocity.runtime.resource.Resource;
import clover.org.apache.velocity.runtime.resource.loader.ResourceLoader;
import clover.org.apache.velocity.util.ClassUtils;
import clover.org.apache.velocity.util.ExceptionUtils;
import java.io.InputStream;

public class ClasspathResourceLoader
extends ResourceLoader {
    public void init(ExtendedProperties configuration) {
        if (this.log.isTraceEnabled()) {
            this.log.trace("ClasspathResourceLoader : initialization complete.");
        }
    }

    public InputStream getResourceStream(String name) throws ResourceNotFoundException {
        InputStream result = null;
        if (StringUtils.isEmpty(name)) {
            throw new ResourceNotFoundException("No template name provided");
        }
        try {
            result = ClassUtils.getResourceAsStream(this.getClass(), name);
        }
        catch (Exception fnfe) {
            throw (ResourceNotFoundException)ExceptionUtils.createWithCause(ResourceNotFoundException.class, "problem with template: " + name, fnfe);
        }
        if (result == null) {
            String msg = "ClasspathResourceLoader Error: cannot find resource " + name;
            throw new ResourceNotFoundException(msg);
        }
        return result;
    }

    public boolean isSourceModified(Resource resource) {
        return false;
    }

    public long getLastModified(Resource resource) {
        return 0L;
    }
}

