/*
 * Decompiled with CFR 0.152.
 */
package clover.org.jfree.chart.labels;

import clover.org.jfree.chart.HashUtilities;
import clover.org.jfree.chart.labels.CategorySeriesLabelGenerator;
import clover.org.jfree.chart.util.ParamChecks;
import clover.org.jfree.data.category.CategoryDataset;
import clover.org.jfree.util.PublicCloneable;
import java.io.Serializable;
import java.text.MessageFormat;

public class StandardCategorySeriesLabelGenerator
implements CategorySeriesLabelGenerator,
Cloneable,
PublicCloneable,
Serializable {
    private static final long serialVersionUID = 4630760091523940820L;
    public static final String DEFAULT_LABEL_FORMAT = "{0}";
    private String formatPattern;

    public StandardCategorySeriesLabelGenerator() {
        this(DEFAULT_LABEL_FORMAT);
    }

    public StandardCategorySeriesLabelGenerator(String format) {
        ParamChecks.nullNotPermitted(format, "format");
        this.formatPattern = format;
    }

    @Override
    public String generateLabel(CategoryDataset dataset, int series) {
        ParamChecks.nullNotPermitted(dataset, "dataset");
        String label = MessageFormat.format(this.formatPattern, this.createItemArray(dataset, series));
        return label;
    }

    protected Object[] createItemArray(CategoryDataset dataset, int series) {
        Object[] result = new Object[]{dataset.getRowKey(series).toString()};
        return result;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof StandardCategorySeriesLabelGenerator)) {
            return false;
        }
        StandardCategorySeriesLabelGenerator that = (StandardCategorySeriesLabelGenerator)obj;
        return this.formatPattern.equals(that.formatPattern);
    }

    public int hashCode() {
        int result = 127;
        result = HashUtilities.hashCode(result, this.formatPattern);
        return result;
    }
}

