/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover;

import com.atlassian.clover.CloverDatabaseSpec;
import com.atlassian.clover.CodeType;
import com.atlassian.clover.CoverageData;
import com.atlassian.clover.CoverageDataCollator;
import com.atlassian.clover.CoverageDataSpec;
import com.atlassian.clover.Logger;
import com.atlassian.clover.ProgressListener;
import com.atlassian.clover.api.CloverException;
import com.atlassian.clover.cfg.Interval;
import com.atlassian.clover.context.ContextSet;
import com.atlassian.clover.context.ContextStore;
import com.atlassian.clover.recorder.InMemPerTestCoverage;
import com.atlassian.clover.recorder.PerTestCoverage;
import com.atlassian.clover.recorder.PerTestCoverageStrategy;
import com.atlassian.clover.registry.Clover2Registry;
import com.atlassian.clover.registry.CoverageDataRange;
import com.atlassian.clover.registry.NoSuchRegistryException;
import com.atlassian.clover.registry.ProjectView;
import com.atlassian.clover.registry.entities.FullFileInfo;
import com.atlassian.clover.registry.entities.FullPackageInfo;
import com.atlassian.clover.registry.entities.FullProjectInfo;
import com.atlassian.clover.registry.entities.TestCaseInfo;
import com.atlassian.clover.registry.format.RegAccessMode;
import com.atlassian.clover.registry.format.RegHeader;
import com.atlassian.clover.registry.metrics.HasMetricsFilter;
import com.atlassian.clover.util.CloverUtils;
import com.atlassian.clover.util.FileUtils;
import com.atlassian.clover.util.Formatting;
import com.atlassian.clover.util.Path;
import java.io.File;
import java.io.IOException;
import java.util.BitSet;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CloverDatabase {
    private String initstring;
    private Clover2Registry registry;
    private CoverageDataCollator collator;
    private CoverageData data;
    private ProjectView testOnlyModel = ProjectView.NONE;
    private ProjectView appOnlyModel = ProjectView.NONE;

    public CloverDatabase(String initstring) throws CloverException {
        this(initstring, null, null);
    }

    public CloverDatabase(String initstring, HasMetricsFilter includeFilter, String name) throws CloverException {
        this(initstring, includeFilter, name, null);
    }

    public CloverDatabase(String initstring, HasMetricsFilter includeFilter, String name, String filterSpec) throws CloverException {
        this(initstring, includeFilter, name, filterSpec, null);
    }

    public CloverDatabase(String initstring, HasMetricsFilter includeFilter, String name, String filterSpec, ProgressListener progressListener) throws CloverException {
        this.initstring = initstring;
        this.registry = Clover2Registry.fromFile(new File(initstring), includeFilter, progressListener);
        if (this.registry == null) {
            throw new NoSuchRegistryException(initstring);
        }
        if (this.registry.isReadOnly()) {
            this.data = this.registry.getCoverageData();
        }
        if (this.data == null) {
            this.data = new CoverageData(this.registry);
        }
        this.collator = new CoverageDataCollator(this.registry);
        this.registry.getProject().setDataProvider(this.data);
        ContextSet filter = this.getContextSet(filterSpec);
        this.registry.getProject().setContextFilter(filter);
        if (name == null) {
            name = "Clover database " + Formatting.formatDate(new Date(this.registry.getVersion()));
        }
        this.registry.getProject().setName(name);
    }

    public CloverDatabase(File regFile, boolean readOnly, String name, ContextSet contextFilter, CoverageDataSpec spec) {
        this.initstring = regFile.getAbsolutePath();
        this.registry = new Clover2Registry(regFile, readOnly ? RegAccessMode.READONLY : RegAccessMode.READWRITE, name == null ? "Clover database " + Formatting.formatDate(new Date(this.registry.getVersion())) : name);
        this.data = new CoverageData(this.registry);
        this.collator = new CoverageDataCollator(this.registry, spec);
        this.registry.getProject().setDataProvider(this.data);
        this.registry.getProject().setContextFilter(contextFilter);
        this.registry.getProject().setHasTestResults(false);
        if (spec.getTestFilter() != null) {
            this.testOnlyModel = this.registry.newProjectView(spec.getTestFilter());
            this.appOnlyModel = this.registry.newProjectView(spec.getTestFilter().invert());
        } else {
            this.testOnlyModel = this.appOnlyModel = ProjectView.NONE;
        }
    }

    public CloverDatabase(Clover2Registry registry) {
        this.initstring = registry.getInitstring();
        this.registry = registry;
        this.data = registry.getCoverageData() == null ? new CoverageData(registry) : registry.getCoverageData();
        this.collator = new CoverageDataCollator(registry);
    }

    private CloverDatabase(CloverDatabase templateDb, Clover2Registry newRegistry) {
        this.registry = newRegistry;
        this.initstring = templateDb.initstring;
        this.data = templateDb.data;
        this.collator = templateDb.collator.copyWithNewRegistry(newRegistry);
    }

    public CloverDatabase copyForBackgroundCoverageDataLoad() {
        return new CloverDatabase(this, this.registry.copyForBackgroundCoverageLoad());
    }

    public CoverageData loadCoverageData() throws CloverException {
        return this.loadCoverageData(new CoverageDataSpec());
    }

    public CoverageData loadCoverageData(CoverageDataSpec spec) throws CloverException {
        return this.loadCoverageData(spec, null);
    }

    public CoverageData loadCoverageData(CoverageDataSpec spec, ProgressListener progressListener) throws CloverException {
        if (!this.registry.isReadOnly()) {
            this.data = this.collator.loadCoverageData(this.data, spec, progressListener);
        }
        this.registry.getProject().setDataProvider(this.data);
        this.registry.getProject().setHasTestResults(this.data.getTests().size() > 0);
        if (spec.isResolve()) {
            this.data.resolve(this.registry);
        }
        if (!spec.isPreserveTestCaseCache()) {
            TestCaseInfo.Factory.reset();
        }
        if (spec.getTestFilter() != null) {
            this.testOnlyModel = this.registry.newProjectView(spec.getTestFilter());
            this.appOnlyModel = this.registry.newProjectView(spec.getTestFilter().invert());
        } else {
            this.testOnlyModel = this.appOnlyModel = ProjectView.NONE;
        }
        return this.data;
    }

    public String getInitstring() {
        return this.initstring;
    }

    public String getName() {
        return this.registry.getProject().getName();
    }

    public FullProjectInfo getModel(CodeType codeType) {
        switch (codeType) {
            case APPLICATION: {
                return this.getAppOnlyModel();
            }
            case TEST: {
                return this.getTestOnlyModel();
            }
            case ALL: {
                return this.getFullModel();
            }
        }
        return this.getAppOnlyModel();
    }

    public FullProjectInfo getTestOnlyModel() {
        return this.testOnlyModel.getProject();
    }

    public FullProjectInfo getAppOnlyModel() {
        return this.appOnlyModel == ProjectView.NONE ? this.registry.getProject() : this.appOnlyModel.getProject();
    }

    public FullProjectInfo getFullModel() {
        return this.registry.getProject();
    }

    public boolean isOutOfDate() {
        return this.isRegistryOutOfDate() || this.isCoverageOutOfDate();
    }

    public boolean isRegistryOutOfDate() {
        return this.registry.isOutOfDate();
    }

    public boolean isCoverageOutOfDate() {
        return this.collator.isOutOfDate();
    }

    public boolean isRecordingInProgress() {
        return CloverDatabase.isRecordingInProgress(this.registry.getRegistryFile());
    }

    public static boolean isRecordingInProgress(File pathToRegistry) {
        return new File(pathToRegistry.getAbsolutePath() + ".liverec").exists();
    }

    public void resolve(Path sourcePath) {
        this.registry.resolve(sourcePath);
        this.appOnlyModel.resolve(sourcePath);
        this.testOnlyModel.resolve(sourcePath);
    }

    public ContextSet getContextSet(String spec) {
        return this.registry.getContextStore().createContextSetFilter(spec == null ? "" : spec);
    }

    public Set<TestCaseInfo> getTestHits(CoverageDataRange range) {
        return this.data.getTestsCovering(range);
    }

    public Map<TestCaseInfo, BitSet> mapTestsAndCoverageForFile(FullFileInfo fileInfo) {
        return this.data.mapTestsAndCoverageForFile(fileInfo);
    }

    public Clover2Registry getRegistry() {
        return this.registry;
    }

    public ContextStore getContextStore() {
        return this.registry.getContextStore();
    }

    public CoverageData getCoverageData() {
        return this.data;
    }

    public TestCaseInfo getTestCase(int id) {
        return this.data.getTestById(id);
    }

    public boolean hasCoverage() {
        return !this.data.isEmpty();
    }

    public long getRecordingTimestamp() {
        return this.data.getTimestamp();
    }

    public static CloverDatabase loadWithCoverage(String initString, CoverageDataSpec spec) throws CloverException {
        CloverDatabase database = new CloverDatabase(initString);
        database.loadCoverageData(spec);
        return database;
    }

    public static void merge(List<CloverDatabaseSpec> dbspecs, String initString) throws CloverException, IOException {
        CloverDatabase.merge(dbspecs, initString, ProgressListener.NOOP_LISTENER);
    }

    public static void merge(List<CloverDatabaseSpec> dbspecs, String initString, ProgressListener listener) throws CloverException, IOException {
        CloverDatabase.merge(dbspecs, initString, false, Interval.DEFAULT_SPAN, listener);
    }

    public static void merge(List<CloverDatabaseSpec> dbspecs, String initString, boolean update, Interval updateSpan, ProgressListener listener) throws CloverException, IOException {
        String originalInitString = null;
        File tmpDb = null;
        if (update) {
            try {
                RegHeader.readFrom(new File(initString));
            }
            catch (IOException e) {
                Logger.getInstance().verbose("No database to update at " + initString);
                update = false;
            }
            if (update) {
                originalInitString = initString;
                dbspecs.add(new CloverDatabaseSpec(originalInitString, updateSpan));
                tmpDb = File.createTempFile("clovermerge", ".db");
                tmpDb.delete();
                initString = tmpDb.getAbsolutePath();
                listener.handleProgress("updating existing database at " + originalInitString, 0.0f);
            }
        }
        if (dbspecs.size() < 1) {
            throw new CloverException("need to specify a non-zero number of databases to merge");
        }
        Clover2Registry destReg = new Clover2Registry(new File(initString), RegAccessMode.READONLY, "Merged Project");
        destReg.setVersion(System.currentTimeMillis());
        FullProjectInfo baseProject = destReg.getProject();
        LinkedHashMap<CloverDatabaseSpec, CloverDatabase> speccedDbs = new LinkedHashMap<CloverDatabaseSpec, CloverDatabase>();
        for (CloverDatabaseSpec spec : dbspecs) {
            CloverDatabase mergingDb = new CloverDatabase(spec.getInitString());
            speccedDbs.put(spec, mergingDb);
        }
        ContextStore.ContextMapper contextMapper = ContextStore.mergeContextStores(destReg, speccedDbs.values());
        int[] mergedCoverage = null;
        InMemPerTestCoverage mergedSliceHits = null;
        int projectDataLength = 0;
        float progress = 0.0f;
        float progressInc = 0.8f / (float)dbspecs.size();
        int slotsUsed = 0;
        TestCaseInfo.Factory.reset();
        Iterator speccedDbEntries = speccedDbs.entrySet().iterator();
        int i = 0;
        while (speccedDbEntries.hasNext()) {
            Map.Entry entry = speccedDbEntries.next();
            CloverDatabaseSpec spec = (CloverDatabaseSpec)entry.getKey();
            CloverDatabase mergingDb = (CloverDatabase)entry.getValue();
            listener.handleProgress("Merging database " + (i + 1) + " of " + dbspecs.size() + ": " + mergingDb.getInitstring(), progress);
            CoverageData mergingData = mergingDb.loadCoverageData(new CoverageDataSpec(null, spec.getSpan().getValueInMillis(), false, false, true, true, PerTestCoverageStrategy.IN_MEMORY));
            FullProjectInfo mergingProject = mergingDb.getFullModel();
            if (mergedCoverage == null) {
                mergedCoverage = new int[mergingProject.getDataLength()];
                mergedSliceHits = new InMemPerTestCoverage(mergingDb.getRegistry());
            }
            List mergingFiles = mergingProject.getFiles(HasMetricsFilter.ACCEPT_ALL);
            for (FullFileInfo mergeFI : mergingFiles) {
                FullFileInfo baseFI = null;
                String mergePkgName = mergeFI.getContainingPackage().getName();
                FullPackageInfo basePkg = (FullPackageInfo)baseProject.getNamedPackage(mergePkgName);
                if (basePkg != null) {
                    baseFI = (FullFileInfo)basePkg.getFile(mergeFI.getPackagePath());
                }
                int newDataIndex = baseProject.getDataLength();
                int newDataLength = mergeFI.getDataLength();
                int oldDataIndex = mergeFI.getDataIndex();
                if (baseFI != null && baseFI.getFilesize() == mergeFI.getFilesize() && baseFI.getChecksum() == mergeFI.getChecksum()) {
                    newDataIndex = baseFI.getDataIndex();
                    newDataLength = baseFI.getDataLength();
                } else {
                    if (baseFI != null && baseFI.getTimestamp() >= mergeFI.getTimestamp()) continue;
                    mergeFI.setDataIndex(newDataIndex);
                    mergeFI.resetVersions(baseProject.getVersion());
                    if (basePkg == null) {
                        basePkg = new FullPackageInfo(baseProject, mergePkgName, newDataIndex);
                        baseProject.addPackage(basePkg);
                    }
                    basePkg.addFile(mergeFI);
                    projectDataLength = Math.max(projectDataLength, mergeFI.getDataIndex() + mergeFI.getDataLength());
                    baseProject.setDataLength(projectDataLength);
                    if (baseFI != null) {
                        slotsUsed -= baseFI.getDataLength();
                    }
                    slotsUsed += mergeFI.getDataLength();
                    contextMapper.applyContextMapping(mergingDb, mergeFI);
                }
                mergedCoverage = CloverDatabase.addIntArrays(mergingData.getHitCounts(), oldDataIndex, mergedCoverage, newDataIndex, newDataLength);
                mergedSliceHits = CloverDatabase.mergePerTestCoverage(mergingData, oldDataIndex, mergedSliceHits, newDataIndex, newDataLength);
            }
            progress += progressInc;
            ++i;
        }
        int[] compactedCoverage = new int[slotsUsed];
        InMemPerTestCoverage compactedSliceHits = new InMemPerTestCoverage(slotsUsed);
        int insertPoint = 0;
        List mergedFiles = baseProject.getFiles(HasMetricsFilter.ACCEPT_ALL);
        for (FullFileInfo fileInfo : mergedFiles) {
            System.arraycopy(mergedCoverage, fileInfo.getDataIndex(), compactedCoverage, insertPoint, fileInfo.getDataLength());
            for (TestCaseInfo tci : mergedSliceHits.getTests()) {
                BitSet compactedSlice = compactedSliceHits.getHitsFor(tci);
                BitSet mergedSlice = mergedSliceHits.getHitsFor(tci);
                for (int i2 = 0; i2 < fileInfo.getDataLength(); ++i2) {
                    compactedSlice.set(insertPoint + i2, mergedSlice.get(fileInfo.getDataIndex() + i2));
                }
            }
            fileInfo.setDataIndex(insertPoint);
            insertPoint += fileInfo.getDataLength();
        }
        baseProject.setDataLength(slotsUsed);
        listener.handleProgress("Writing merged database registry", progress);
        destReg.setCoverageData(new CoverageData(System.currentTimeMillis(), compactedCoverage, compactedSliceHits));
        destReg.saveAndOverwriteFile();
        TestCaseInfo.Factory.reset();
        if (update) {
            CloverUtils.scrubCoverageData(originalInitString, true, true, false);
            FileUtils.fileCopy(tmpDb, new File(originalInitString));
            tmpDb.delete();
        }
        listener.handleProgress("Merge complete", 1.0f);
    }

    private static InMemPerTestCoverage mergePerTestCoverage(PerTestCoverage src, int spos, InMemPerTestCoverage dest, int dpos, int length) {
        if (dpos + length > dest.getCoverageSize()) {
            dest = new InMemPerTestCoverage(dest, dpos + length);
        }
        for (TestCaseInfo tci : src.getTests()) {
            BitSet srcSlots = src.getHitsFor(tci);
            BitSet destSlots = dest.getHitsFor(tci);
            for (int i = 0; i < length; ++i) {
                destSlots.set(dpos + i, srcSlots.get(spos + i));
            }
        }
        return dest;
    }

    private static int[] addIntArrays(int[] src, int spos, int[] dest, int dpos, int length) {
        if (dpos + length > dest.length) {
            int[] tmp = new int[dpos + length];
            System.arraycopy(dest, 0, tmp, 0, dest.length);
            dest = tmp;
        }
        for (int i = 0; i < length; ++i) {
            int n = dpos + i;
            dest[n] = dest[n] + src[spos + i];
        }
        return dest;
    }
}

