/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover;

import com.atlassian.clover.Logger;
import java.io.PrintStream;

public class DefaultLogger
extends Logger {
    private static String[] LOG_LEVEL_STR = new String[]{"ERROR", "WARN", "INFO", "VERBOSE", "DEBUG"};

    @Override
    public void log(int level, String msg, Throwable t) {
        PrintStream stream;
        String decoratedMsg;
        if (DefaultLogger.canIgnore(level)) {
            return;
        }
        if (level >= 2) {
            decoratedMsg = msg;
            stream = System.out;
        } else {
            decoratedMsg = LOG_LEVEL_STR[level] + ": " + msg;
            stream = System.err;
        }
        stream.print(decoratedMsg);
        if (t != null && (DefaultLogger.isVerbose() || DefaultLogger.isDebug())) {
            System.err.println(msg + " : " + t.getMessage());
            t.printStackTrace();
        } else {
            stream.println();
        }
    }
}

