/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover;

import com.atlassian.clover.Logger;
import com.atlassian.clover.api.CloverException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

public class Environment {
    private static final char PROP_START;

    public static String substituteSysPropRefs(String value) {
        block7: {
            try {
                if (value == null || value.indexOf(PROP_START) == -1) break block7;
                ArrayList<String> fragments = new ArrayList<String>();
                ArrayList<String> propertyRefs = new ArrayList<String>();
                Environment.parsePropertyString(value, fragments, propertyRefs);
                StringBuilder sb = new StringBuilder();
                Iterator i = fragments.iterator();
                Iterator j = propertyRefs.iterator();
                while (i.hasNext()) {
                    String fragment = (String)i.next();
                    if (fragment == null) {
                        final String propertyName = (String)j.next();
                        String replacement = null;
                        try {
                            replacement = AccessController.doPrivileged(new PrivilegedAction<String>(){

                                @Override
                                public String run() {
                                    return System.getProperty(propertyName);
                                }
                            });
                            if (replacement == null) {
                                Logger.getInstance().verbose("System property \"" + propertyName + "\" was null and so was not set");
                            }
                        }
                        catch (SecurityException e) {
                            Logger.getInstance().verbose("Security exception getting system property \"" + propertyName + "\" (will not be substituted)");
                        }
                        fragment = replacement == null ? PROP_START + "{" + propertyName + "}" : replacement.toString();
                    }
                    sb.append(fragment);
                }
                return sb.toString();
            }
            catch (IllegalPropertySyntax e) {
                Logger.getInstance().verbose("Value \"" + value + "\" is incorrectly specified and no property substitution has taken place", e);
            }
        }
        return value;
    }

    private static void parsePropertyString(String value, Collection<String> fragments, Collection<String> propertyRefs) throws IllegalPropertySyntax {
        int pos;
        int prev = 0;
        while ((pos = value.indexOf(PROP_START, prev)) >= 0) {
            if (pos > 0) {
                fragments.add(value.substring(prev, pos));
            }
            if (pos == value.length() - 1) {
                fragments.add(String.valueOf(PROP_START));
                prev = pos + 1;
                continue;
            }
            if (value.charAt(pos + 1) != '{') {
                if (value.charAt(pos + 1) == PROP_START) {
                    fragments.add(String.valueOf(PROP_START));
                    prev = pos + 2;
                    continue;
                }
                fragments.add(value.substring(pos, pos + 2));
                prev = pos + 2;
                continue;
            }
            int endName = value.indexOf(125, pos);
            if (endName < 0) {
                throw new IllegalPropertySyntax("Syntax error in property: " + value);
            }
            String propertyName = value.substring(pos + 2, endName);
            fragments.add(null);
            propertyRefs.add(propertyName);
            prev = endName + 1;
        }
        if (prev < value.length()) {
            fragments.add(value.substring(prev));
        }
    }

    static {
        String propStart = null;
        try {
            propStart = AccessController.doPrivileged(new PrivilegedAction<String>(){

                @Override
                public String run() {
                    return System.getProperty("clover.env.propref.startchar", "$");
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
        PROP_START = (char)(propStart == null ? 36 : (propStart.length() >= 1 ? (int)propStart.charAt(0) : 36));
    }

    private static class IllegalPropertySyntax
    extends CloverException {
        public IllegalPropertySyntax(String reason) {
            super(reason);
        }
    }
}

