/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover;

import com.atlassian.clover.Logger;
import com.atlassian.clover.api.CloverException;
import com.atlassian.clover.context.ContextSet;
import com.atlassian.clover.registry.FixedSourceRegion;
import com.atlassian.clover.registry.entities.BasicMethodInfo;
import com.atlassian.clover.registry.entities.FullClassInfo;
import com.atlassian.clover.registry.entities.FullMethodInfo;
import com.atlassian.clover.registry.entities.FullProjectInfo;
import com.atlassian.clover.registry.entities.MethodSignature;
import com.atlassian.clover.registry.entities.TestCaseInfo;
import com.atlassian.clover.util.CloverUtils;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.jetbrains.annotations.Nullable;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class TestResultProcessor {
    private FullProjectInfo model;
    private List<File> files;

    public static void addTestResultsToModel(FullProjectInfo model, List<File> files) throws CloverException {
        TestResultProcessor processor = new TestResultProcessor(model, files);
        int numTestResults = processor.scan();
        model.setHasTestResults(numTestResults > 0);
    }

    public TestResultProcessor(FullProjectInfo model, List<File> files) {
        this.model = model;
        this.files = files;
    }

    public int scan() throws CloverException {
        Logger log = Logger.getInstance();
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            SAXParser parser = factory.newSAXParser();
            TestXMLHandler handler = new TestXMLHandler(this.model);
            int fileCount = 0;
            int testCaseCount = 0;
            for (File file : this.files) {
                try {
                    log.verbose("Processing test result file " + file);
                    parser.parse((InputStream)new BufferedInputStream(new FileInputStream(file)), (DefaultHandler)handler);
                    ++fileCount;
                    testCaseCount += handler.getTestCaseCount();
                }
                catch (IOException e) {
                    log.error("IOException parsing " + file + ", skipped", e);
                }
                catch (SAXException e) {
                    log.error("SAXException parsing " + file + ", skipped", e);
                }
            }
            log.info("Processed " + testCaseCount + " test case result" + (testCaseCount != 1 ? "s" : "") + " from " + fileCount + " results file" + (fileCount != 1 ? "s" : "") + ".");
            return testCaseCount;
        }
        catch (ParserConfigurationException e) {
            throw new CloverException("ParserConfigurationException configuring XML Parser: " + e.getMessage());
        }
        catch (SAXException e) {
            throw new CloverException("SAXException obtaining XML Parser: " + e.getMessage());
        }
    }

    static class TestXMLHandler
    extends DefaultHandler {
        private FullProjectInfo model;
        private FullClassInfo currentTestClassFromTestSuite;
        private FullClassInfo currentTestClassFromTestCase;
        private TestCaseInfo currentTestCaseInfo;
        private StringBuffer message;
        private int testCaseCount;

        public TestXMLHandler(FullProjectInfo model) {
            this.model = model;
        }

        @Override
        public void startDocument() {
            this.testCaseCount = 0;
        }

        @Override
        public void startElement(String namespaceURI, String localName, String qName, Attributes atts) {
            if ("testsuite".equals(qName)) {
                String classnameAttr = atts.getValue("name");
                FullClassInfo classInfo = null;
                if (classnameAttr != null) {
                    classInfo = this.findClass(classnameAttr);
                }
                String packageAttr = atts.getValue("package");
                if (classInfo == null && packageAttr != null && classnameAttr != null) {
                    packageAttr = packageAttr.trim().length() == 0 ? "" : packageAttr + ".";
                    String fqnClassname = packageAttr + classnameAttr;
                    classInfo = this.findClass(fqnClassname);
                }
                if (classInfo != null) {
                    this.currentTestClassFromTestSuite = classInfo;
                }
            } else if ("testcase".equals(qName)) {
                FullClassInfo currentTestClass;
                String classname = atts.getValue("classname");
                String testname = atts.getValue("name");
                float time = 0.0f;
                try {
                    time = Float.parseFloat(atts.getValue("time"));
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
                if (classname != null) {
                    classname = CloverUtils.cloverizeClassName(classname);
                    this.currentTestClassFromTestCase = (FullClassInfo)this.model.findClass(classname);
                } else {
                    int lastDot;
                    this.currentTestClassFromTestCase = this.currentTestClassFromTestSuite;
                    if (testname != null && (lastDot = testname.lastIndexOf(".")) >= 0) {
                        classname = CloverUtils.cloverizeClassName(testname.substring(0, lastDot));
                        this.currentTestClassFromTestCase = (FullClassInfo)this.model.findClass(classname);
                        testname = testname.substring(lastDot + 1);
                    }
                }
                FullClassInfo fullClassInfo = currentTestClass = this.currentTestClassFromTestCase == null ? this.currentTestClassFromTestSuite : this.currentTestClassFromTestCase;
                if (currentTestClass != null) {
                    this.currentTestCaseInfo = currentTestClass.getTestCase(currentTestClass.getQualifiedName() + "." + testname);
                    if (this.currentTestCaseInfo == null) {
                        Logger.getInstance().verbose("Didn't find pre-existing test case for class from JUnit results: " + currentTestClass.getQualifiedName() + "." + testname);
                        FullMethodInfo methodDecl = currentTestClass.getTestMethodDeclaration(testname);
                        if (methodDecl == null && currentTestClass == this.currentTestClassFromTestCase && this.currentTestClassFromTestSuite != null && (methodDecl = this.currentTestClassFromTestSuite.getTestMethodDeclaration(testname)) != null) {
                            currentTestClass = this.currentTestClassFromTestSuite;
                        }
                        if (methodDecl != null) {
                            this.currentTestCaseInfo = new TestCaseInfo(-Math.abs(methodDecl.getQualifiedName().hashCode()), currentTestClass, methodDecl, methodDecl.getSimpleName());
                        } else {
                            FullMethodInfo fakeTestMethod = new FullMethodInfo(currentTestClass, (com.atlassian.clover.api.registry.ContextSet)new ContextSet(), new BasicMethodInfo(new FixedSourceRegion(0, 0), 0, 0, new MethodSignature(testname), true, testname, false));
                            this.currentTestCaseInfo = new TestCaseInfo(-Math.abs(testname.hashCode()), currentTestClass, fakeTestMethod, testname);
                        }
                        currentTestClass.addTestCase(this.currentTestCaseInfo);
                    } else {
                        Logger.getInstance().verbose("Found pre-existing test case for class from JUnit results: " + currentTestClass.getQualifiedName() + "." + testname + " ; isSuccess = " + this.currentTestCaseInfo.isSuccess());
                    }
                    if (this.currentTestCaseInfo != null) {
                        ++this.testCaseCount;
                        this.currentTestCaseInfo.setHasResult(true);
                        this.currentTestCaseInfo.setError(false);
                        this.currentTestCaseInfo.setFailure(false);
                        this.currentTestCaseInfo.setFailMessage(null);
                        this.currentTestCaseInfo.setFailFullMessage(null);
                        this.currentTestCaseInfo.setFailType(null);
                        this.currentTestCaseInfo.setDuration(time);
                    }
                } else {
                    Logger.getInstance().verbose("Couldn't find test class for <testsuite/> or <testcase/> to annotate with JUnit results: " + classname + "." + testname);
                }
            } else if (("failure".equals(qName) || "error".equals(qName)) && this.currentTestCaseInfo != null) {
                if ("error".equals(qName)) {
                    this.currentTestCaseInfo.setError(true);
                } else {
                    this.currentTestCaseInfo.setFailure(true);
                }
                this.currentTestCaseInfo.setFailMessage(atts.getValue("message"));
                this.currentTestCaseInfo.setFailType(atts.getValue("type"));
                this.message = new StringBuffer();
            }
        }

        @Nullable
        private FullClassInfo findClass(String rawName) {
            String classname = CloverUtils.cloverizeClassName(rawName);
            FullClassInfo info = (FullClassInfo)this.model.findClass(classname);
            Logger.getInstance().debug("Found class: " + info + " using name " + rawName);
            return info;
        }

        @Override
        public void characters(char[] ch, int start, int length) {
            this.collectMessage(ch, start, length);
        }

        @Override
        public void ignorableWhitespace(char[] ch, int start, int length) {
            this.collectMessage(ch, start, length);
        }

        private void collectMessage(char[] ch, int start, int length) {
            if (this.currentTestCaseInfo != null && this.message != null) {
                this.message.append(ch, start, length);
            }
        }

        @Override
        public void endElement(String namespaceURI, String localName, String qName) {
            if ("testsuite".equals(qName)) {
                this.currentTestClassFromTestSuite = null;
            } else if ("testcase".equals(qName)) {
                this.currentTestClassFromTestCase = null;
                this.currentTestCaseInfo = null;
            } else if (this.currentTestCaseInfo != null && ("failure".equals(qName) || "error".equals(qName)) && this.message != null) {
                this.currentTestCaseInfo.setFailFullMessage(this.message.toString());
                this.message = null;
            }
        }

        @Override
        public void endDocument() {
            Logger.getInstance().verbose("Processed " + this.testCaseCount + " test case result" + (this.testCaseCount != 1 ? "s" : "") + ".");
        }

        public int getTestCaseCount() {
            return this.testCaseCount;
        }
    }
}

