/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.ant;

import com.atlassian.clover.Logger;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;

public abstract class AbstractAntLogger
extends Logger {
    private static final int[] ANT_LOG_LEVELS = new int[]{0, 1, 2, 3, 4};
    protected Project proj;

    public AbstractAntLogger(Project project) {
        this.proj = project;
    }

    public abstract Task getTask();

    @Override
    public void log(int level, String message, Throwable exception) {
        this.antLog(this.proj, this.getTask(), message, exception, this.antLogLevel(level));
    }

    protected void antLog(Project proj, Task task, String message, Throwable exception, int antLogLevel) {
        if (task != null) {
            if (exception != null) {
                proj.log(task, message, exception, antLogLevel);
            } else {
                proj.log(task, message, antLogLevel);
            }
        } else if (exception != null) {
            proj.log(message, exception, antLogLevel);
        } else {
            proj.log(message, antLogLevel);
        }
    }

    protected int antLogLevel(int level) {
        return ANT_LOG_LEVELS[level];
    }
}

