/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.ant.groovy;

import clover.com.google.common.collect.Maps;
import clover.com.google.common.collect.Sets;
import com.atlassian.clover.CloverNames;
import com.atlassian.clover.Logger;
import com.atlassian.clover.ant.AntInstrUtils;
import com.atlassian.clover.ant.tasks.AntInstrumentationConfig;
import com.atlassian.clover.ant.tasks.CloverEnvTask;
import com.atlassian.clover.ant.tasks.TestSourceSet;
import com.atlassian.clover.api.CloverException;
import com.atlassian.clover.cfg.instr.InstrumentationConfig;
import com.atlassian.clover.instr.java.Instrumenter;
import com.atlassian.clover.instr.tests.DefaultTestDetector;
import com.atlassian.clover.instr.tests.FileMappedTestDetector;
import com.atlassian.clover.instr.tests.NoTestDetector;
import com.atlassian.clover.instr.tests.TestDetector;
import com.atlassian.clover.util.ClassPathUtil;
import com.atlassian.clover.util.FileUtils;
import com.atlassian.clover.util.ReflectionUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.apache.tools.ant.BuildEvent;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.RuntimeConfigurable;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.UnknownElement;
import org.apache.tools.ant.taskdefs.MatchingTask;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.util.FileNameMapper;
import org.apache.tools.ant.util.GlobPatternMapper;
import org.apache.tools.ant.util.SourceFileScanner;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GroovycSupport
implements BuildListener {
    private static final Collection<String> COMPILERS = Sets.newHashSet("org.codehaus.groovy.ant.Groovyc", "org.codehaus.groovy.grails.compiler.Grailsc", "org.codehaus.groovy.grails.compiler.GrailsCompiler", "org.codehaus.groovy.grails.test.compiler.GrailsTestCompiler", "org.codehaus.groovy.grails.test.compiler.GrailsIntegrationTestCompiler");
    private static final String GROVER = "grover";
    private static final String JAR = ".jar";
    private static final String GROVER_JAR = "grover.jar";
    private static final String EMBEDDEDJARS_CLOVER = "embeddedjars/clover4.0.6";
    private final boolean cleanupAfterBuild;
    private File workingDir;
    private Collection<String> groovycTaskNames = Sets.newHashSet();
    private int numTaskDefsLastSeen = 0;
    private File groverJar;

    public static void ensureAddedTo(@NotNull Project project) {
        for (BuildListener listener : project.getBuildListeners()) {
            if (!GroovycSupport.isOneOfMe(listener)) continue;
            return;
        }
        project.addBuildListener((BuildListener)new GroovycSupport(project));
    }

    private static boolean isOneOfMe(@NotNull BuildListener listener) {
        return listener instanceof GroovycSupport || listener.getClass().getName().equals(GroovycSupport.class.getName());
    }

    private GroovycSupport(@NotNull Project project) {
        this.cleanupAfterBuild = !Boolean.getBoolean("clover.grover.no.postbuild.cleanup") || Boolean.valueOf(project.getProperty("clover.grover.no.postbuild.cleanup")) == false;
    }

    public void buildStarted(@NotNull BuildEvent buildEvent) {
    }

    public void buildFinished(@NotNull BuildEvent buildEvent) {
    }

    public void targetStarted(@NotNull BuildEvent buildEvent) {
        this.logGroovycTasks(buildEvent.getProject());
    }

    private void logGroovycTasks(@NotNull Project project) {
        if (Logger.isDebug()) {
            Hashtable taskDefinitions = (Hashtable)project.getTaskDefinitions().clone();
            Set entries = taskDefinitions.entrySet();
            for (Map.Entry entry : entries) {
                if (!"grailsc".equals(entry.getKey()) && !"testc".equals(entry.getKey()) && !"itestc".equals(entry.getKey())) continue;
                Logger.getInstance().debug("Found compiler task " + (String)entry.getKey() + "=" + ((Class)entry.getValue()).toString());
            }
        }
    }

    public void targetFinished(@NotNull BuildEvent buildEvent) {
    }

    public void messageLogged(@NotNull BuildEvent buildEvent) {
    }

    public void taskFinished(@NotNull BuildEvent buildEvent) {
        if (this.workingDir != null) {
            if (this.workingDir.exists() && this.cleanupAfterBuild) {
                Logger.getInstance().verbose("Cleaning up Clover directory " + this.workingDir.getAbsolutePath());
                FileUtils.deltree(this.workingDir);
            }
            this.workingDir = null;
        }
    }

    public void taskStarted(@NotNull BuildEvent buildEvent) {
        this.logGroovycTasks(buildEvent.getProject());
        this.initGroovycTaskNames(buildEvent.getProject());
        Task task = buildEvent.getTask();
        if (this.isGroovyc(task)) {
            Logger.getInstance().verbose("Found groovyc task named " + task.getTaskName());
            task.maybeConfigure();
            try {
                Task groovyc = task instanceof UnknownElement ? (Task)((UnknownElement)task).getRealThing() : task;
                AntInstrumentationConfig config = AntInstrumentationConfig.getFrom(buildEvent.getProject());
                if (groovyc != null) {
                    if (config != null) {
                        if (config.isEnabled()) {
                            if (config.isSkipGroverJar()) {
                                Logger.getInstance().warn("Clover is enabled but has skipGroverJar set to true. Groovy code will not be instrumented");
                            } else {
                                Logger.getInstance().verbose("Clover is enabled in config. Reconfiguring groovyc task " + task.getTaskName());
                                this.buildTestDetector(config);
                                this.workingDir = this.ensureWorkingDirCreated(config);
                                this.groverJar = this.ensureGroverJarCreated(config);
                                if (this.workingDir != null && this.groverJar != null) {
                                    this.prepareForGroovyInstrumentation(groovyc, buildEvent.getProject(), config);
                                }
                            }
                        }
                    } else {
                        Logger.getInstance().info("Clover couldn't find its configuration in a project. Did you forget to call <ant> or <antcall> with inheritRefs=true?");
                    }
                } else {
                    Logger.getInstance().verbose("Real Groovyc task is null. Groovy code will not be instrumented");
                }
            }
            catch (Exception ex) {
                buildEvent.getProject().log("Clover failed to integrate with <" + task.getTaskName() + "/>", (Throwable)ex, 0);
            }
        }
    }

    public void prepareForGroovyInstrumentation(@NotNull Task groovyc, @NotNull Project project, @NotNull AntInstrumentationConfig config) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, CloverException, IOException {
        Path origSrcPath = this.invokeGetSrcdir(groovyc);
        File destDir = this.invokeGetDestdir(groovyc);
        Collection<ParentAndChildPath> groovySourceToCompile = this.scanForOutOfDateSource(project, groovyc, origSrcPath, destDir, "groovy");
        if (this.isJointCompilation(groovyc)) {
            Logger.getInstance().verbose("Detected joint Groovy and Java compilation.");
            Collection<ParentAndChildPath> javaSourceToCompile = this.scanForOutOfDateSource(project, groovyc, origSrcPath, destDir, "java");
            if (this.filesNeedingInstrumentation(project, origSrcPath, javaSourceToCompile)) {
                File mainInstrDir = AntInstrUtils.createInstrDir(config.getTmpDir());
                File filteredInstrDir = new File(mainInstrDir, "__CLR4_0_6");
                filteredInstrDir.mkdirs();
                Logger.getInstance().verbose("Outputting instrumented Java source to " + filteredInstrDir.getAbsolutePath());
                this.instrumentAndIgnoreOriginalJavaSource(groovyc, config, filteredInstrDir, this.applyCloverFilter(project, groovyc, origSrcPath, true, javaSourceToCompile));
                this.includeGroovySource(groovyc, groovySourceToCompile);
                this.invokeSetSrcdir(groovyc, new Path(project, mainInstrDir.getAbsolutePath()));
            }
        }
        Collection<ParentAndChildPath> groovySourceToInstrument = this.applyCloverFilter(project, groovyc, origSrcPath, false, groovySourceToCompile);
        Collection<File> includedFiles = this.toFiles(groovySourceToInstrument);
        this.logIncludedFiles(includedFiles);
        config.setIncludedFiles(includedFiles);
        this.augmentCompilationClasspath(project, groovyc, config);
    }

    private void buildTestDetector(@NotNull AntInstrumentationConfig config) {
        TestDetector testDetector;
        if (config.getTestSources() != null) {
            boolean useNoTestDetector = true;
            for (TestSourceSet testSourceSet : config.getTestSources()) {
                if (!testSourceSet.isEnabled()) continue;
                useNoTestDetector = false;
                break;
            }
            if (useNoTestDetector) {
                testDetector = new NoTestDetector();
            } else {
                FileMappedTestDetector fileMappedTestDetector = new FileMappedTestDetector();
                for (TestSourceSet testSourceSet : config.getTestSources()) {
                    testSourceSet.getIncludedFiles();
                    testSourceSet.getExcludedFiles();
                    fileMappedTestDetector.addTestSourceMatcher(testSourceSet);
                }
                testDetector = fileMappedTestDetector;
            }
        } else {
            testDetector = new DefaultTestDetector();
        }
        Logger.getInstance().verbose("Using test detector " + testDetector);
        config.setTestDetector(testDetector);
    }

    private void logIncludedFiles(@NotNull Collection<File> includedFiles) {
        if (includedFiles.size() > 0) {
            Logger.getInstance().verbose("Groovy files to be instrumented:");
            for (File includedFile : includedFiles) {
                Logger.getInstance().verbose(includedFile.getAbsolutePath());
            }
        }
    }

    @NotNull
    private Collection<File> toFiles(@NotNull Collection<ParentAndChildPath> parentAndChildPaths) {
        HashSet<File> files = Sets.newHashSet();
        for (ParentAndChildPath parentAndChildPath : parentAndChildPaths) {
            files.add(parentAndChildPath.toFile());
        }
        return files;
    }

    private void includeGroovySource(@NotNull Task groovyc, @NotNull Collection<ParentAndChildPath> groovySource) {
        MatchingTask matchingGroovyc = (MatchingTask)groovyc;
        for (ParentAndChildPath parentAndChildPath : groovySource) {
            Logger.getInstance().verbose("Adding explicit include: " + parentAndChildPath.child);
            matchingGroovyc.setIncludes(parentAndChildPath.child);
        }
    }

    private void instrumentAndIgnoreOriginalJavaSource(@NotNull Task groovyc, @NotNull AntInstrumentationConfig config, @NotNull File instrDir, @NotNull Collection<ParentAndChildPath> toInstrument) throws CloverException {
        MatchingTask matchingGroovyc = (MatchingTask)groovyc;
        Instrumenter instrumenter = new Instrumenter(Logger.getInstance(), config);
        instrumenter.startInstrumentation();
        for (ParentAndChildPath parentAndChildPath : toInstrument) {
            instrumenter.instrument(parentAndChildPath.toFile(), instrDir, config.getEncoding());
        }
        String instrumentedSrcIncludes = instrDir.getName() + "/**/*.java";
        Logger.getInstance().verbose("Adding explicit include " + instrumentedSrcIncludes);
        matchingGroovyc.setIncludes(instrumentedSrcIncludes);
        instrumenter.endInstrumentation();
    }

    @Nullable
    public static File extractGroverJar(@Nullable File groverJar, boolean deleteOnExit) {
        File jar = null;
        Throwable whyFailed = null;
        String groverResourceName = "/" + CloverNames.getRepkgPrefix() + EMBEDDEDJARS_CLOVER + "/" + GROVER_JAR;
        try {
            InputStream groverStream = CloverEnvTask.class.getResourceAsStream(groverResourceName);
            if (groverStream != null) {
                File jarFile;
                if (groverJar != null) {
                    groverJar.getParentFile().mkdirs();
                    if (!groverJar.getParentFile().isDirectory()) {
                        throw new IOException("Directory '" + groverJar.getParentFile().getAbsolutePath() + "' does not exist or couldn't be created");
                    }
                }
                File file = jarFile = groverJar != null ? groverJar : File.createTempFile(GROVER, JAR);
                if (deleteOnExit) {
                    jarFile.deleteOnExit();
                }
                FileOutputStream jarOutStream = new FileOutputStream(jarFile);
                byte[] buffer = new byte[1000];
                int read = groverStream.read(buffer);
                while (read != -1) {
                    ((OutputStream)jarOutStream).write(buffer, 0, read);
                    read = groverStream.read(buffer);
                }
                jarOutStream.flush();
                ((OutputStream)jarOutStream).close();
                Logger.getInstance().verbose("Extracted " + groverResourceName + " to " + jarFile.getAbsolutePath());
                jar = jarFile;
            }
        }
        catch (Throwable t) {
            whyFailed = t;
        }
        if (jar == null) {
            Logger.getInstance().warn("Failed to extract and copy " + groverResourceName + " to a temporary file. " + "Clover instrumentation of Groovy source will not proceed.", whyFailed);
        }
        return jar;
    }

    @Nullable
    private File ensureWorkingDirCreated(@NotNull AntInstrumentationConfig config) {
        try {
            return FileUtils.createTempDir(GROVER, config.getTmpDir());
        }
        catch (Exception e) {
            Logger.getInstance().warn("Failed to create Clover working directory in " + config.getTmpDir() + ". Clover instrumentation of Groovy source will not proceed.", e);
            return null;
        }
    }

    @Nullable
    private File ensureGroverJarCreated(@NotNull AntInstrumentationConfig config) {
        return GroovycSupport.extractGroverJar(config.getGroverJar(), this.cleanupAfterBuild);
    }

    @NotNull
    private Collection<ParentAndChildPath> scanForOutOfDateSource(@NotNull Project project, @NotNull Task groovyc, @NotNull Path origSrcDirs, @Nullable File destDir, @NotNull String extension) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        LinkedHashSet<ParentAndChildPath> toBeCompiled = Sets.newLinkedHashSet();
        for (String origSrcDirPath : origSrcDirs.list()) {
            File origSrcDir = project.resolveFile(origSrcDirPath);
            if (!origSrcDir.exists()) continue;
            Logger.getInstance().verbose("Scanning for source to compile: " + origSrcDir.getAbsolutePath());
            toBeCompiled.addAll(this.findOutOfDateSource(groovyc, origSrcDir, destDir != null ? destDir : origSrcDir, this.invokeGetDirectoryScanner(groovyc, origSrcDir).getIncludedFiles(), extension));
        }
        if (toBeCompiled.size() > 0) {
            Logger.getInstance().verbose("Out of date source found:");
            for (ParentAndChildPath parentAndChildPath : toBeCompiled) {
                Logger.getInstance().verbose(parentAndChildPath.toFile().getAbsolutePath());
            }
        } else {
            Logger.getInstance().verbose("No out of date source found");
        }
        return toBeCompiled;
    }

    private boolean filesNeedingInstrumentation(@NotNull Project project, Path srcPath, @NotNull Collection<ParentAndChildPath> sourceToCompile) {
        Map<File, ParentAndChildPath> toCompileMap = this.mapToFiles(sourceToCompile);
        HashSet<File> toCompileFiles = Sets.newHashSet(toCompileMap.keySet());
        LinkedHashSet<File> filteredOut = Sets.newLinkedHashSet();
        LinkedHashSet<File> toInstrument = Sets.newLinkedHashSet();
        AntInstrUtils.sieveSourceForInstrumentation(project, srcPath, AntInstrUtils.calcInstrPatternSet(project), AntInstrUtils.calcInstrFileSets(project), toCompileFiles, filteredOut, toInstrument);
        return toInstrument.size() > 0;
    }

    private Collection<ParentAndChildPath> applyCloverFilter(@NotNull Project project, @NotNull Task groovyc, Path srcPath, boolean commitFilterToGroovyc, @NotNull Collection<ParentAndChildPath> javaSourceToCompile) {
        Map<File, ParentAndChildPath> toCompileMap = this.mapToFiles(javaSourceToCompile);
        HashSet<File> toCompileFiles = Sets.newHashSet(toCompileMap.keySet());
        LinkedHashSet<File> filteredOut = Sets.newLinkedHashSet();
        LinkedHashSet<File> toInstrument = Sets.newLinkedHashSet();
        AntInstrUtils.sieveSourceForInstrumentation(project, srcPath, AntInstrUtils.calcInstrPatternSet(project), AntInstrUtils.calcInstrFileSets(project), toCompileFiles, filteredOut, toInstrument);
        if (commitFilterToGroovyc) {
            ParentAndChildPath parentAndChildPath;
            MatchingTask matchingGroovyc = (MatchingTask)groovyc;
            if (filteredOut.size() > 0) {
                Logger.getInstance().verbose("Adding explicit include(s) for Java source not being instrumented:");
                for (File file : filteredOut) {
                    parentAndChildPath = toCompileMap.get(file);
                    if (parentAndChildPath == null) continue;
                    Logger.getInstance().verbose(parentAndChildPath.child);
                    matchingGroovyc.setIncludes(parentAndChildPath.child);
                }
            }
            if (toInstrument.size() > 0) {
                Logger.getInstance().verbose("Adding explicit exclude(s) for Java source being instrumented:");
                for (File file : toInstrument) {
                    parentAndChildPath = toCompileMap.get(file);
                    if (parentAndChildPath == null) continue;
                    Logger.getInstance().verbose(parentAndChildPath.child);
                    matchingGroovyc.setExcludes(parentAndChildPath.child);
                }
            }
        }
        return this.grabFromFiles(toCompileMap, toInstrument);
    }

    private Collection<ParentAndChildPath> grabFromFiles(Map<File, ParentAndChildPath> toCompileMap, Collection<File> toInstrument) {
        HashSet<ParentAndChildPath> result = Sets.newHashSet();
        for (File file : toInstrument) {
            result.add(toCompileMap.get(file));
        }
        return result;
    }

    private Map<File, ParentAndChildPath> mapToFiles(Collection<ParentAndChildPath> toCompile) {
        HashMap<File, ParentAndChildPath> map = Maps.newHashMap();
        for (ParentAndChildPath parentAndChildPath : toCompile) {
            map.put(parentAndChildPath.toFile(), parentAndChildPath);
        }
        return map;
    }

    private void augmentCompilationClasspath(Project project, Task groovyc, AntInstrumentationConfig config) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, IOException {
        String[] paths;
        for (String path : paths = new String[]{GroovycSupport.newConfigDir(config, this.workingDir).getAbsolutePath(), this.groverJar.getAbsolutePath(), ClassPathUtil.getCloverJarPath()}) {
            Logger.getInstance().verbose("Adding " + path + " to Groovy compilation path");
            this.invokeSetClasspath(groovyc, new Path(project, path));
        }
    }

    public static File newConfigDir(InstrumentationConfig config, File parent) throws IOException {
        File configDir = FileUtils.createTempDir("groverconfig", parent);
        File instrPropsFile = new File(configDir, CloverNames.getGroverConfigFileName());
        config.saveToFile(instrPropsFile);
        return configDir;
    }

    private Collection<ParentAndChildPath> findOutOfDateSource(@NotNull Task groovyc, @NotNull File srcDir, @NotNull File destDir, @NotNull String[] files, @NotNull String extension) {
        LinkedHashSet<ParentAndChildPath> outOfDateFiles = Sets.newLinkedHashSet();
        GlobPatternMapper mapper = new GlobPatternMapper();
        SourceFileScanner sfs = new SourceFileScanner(groovyc);
        mapper.setFrom("*." + extension);
        mapper.setTo("*.class");
        String[] filteredFiles = sfs.restrict(files, srcDir, destDir, (FileNameMapper)mapper);
        if (filteredFiles.length > 0) {
            for (String path : filteredFiles) {
                outOfDateFiles.add(new ParentAndChildPath(srcDir, path));
            }
        }
        return outOfDateFiles;
    }

    private boolean isJointCompilation(@NotNull Task groovyc) {
        Enumeration kids = groovyc.getRuntimeConfigurableWrapper().getChildren();
        while (kids.hasMoreElements()) {
            RuntimeConfigurable child = (RuntimeConfigurable)kids.nextElement();
            if (!child.getElementTag().equals("javac")) continue;
            return true;
        }
        return false;
    }

    private DirectoryScanner invokeGetDirectoryScanner(Object task, File file) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        return (DirectoryScanner)ReflectionUtils.invokeVirtualImplicit("getDirectoryScanner", task, file);
    }

    private Path invokeGetSrcdir(Object task) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        return (Path)ReflectionUtils.invokeVirtualImplicit("getSrcdir", task);
    }

    private File invokeGetDestdir(Object task) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        return (File)ReflectionUtils.invokeVirtualImplicit("getDestdir", task);
    }

    private void invokeSetSrcdir(Object task, Path path) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        ReflectionUtils.invokeVirtualImplicit("setSrcdir", task, path);
    }

    private void invokeSetClasspath(Object task, Path path) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        ReflectionUtils.invokeVirtualImplicit("setClasspath", task, path);
    }

    protected void initGroovycTaskNames(@NotNull Project project) {
        Hashtable taskDefs = project.getTaskDefinitions();
        if (taskDefs.size() > this.numTaskDefsLastSeen) {
            this.groovycTaskNames = Sets.newHashSet();
            for (Map.Entry entry : taskDefs.entrySet()) {
                Object value = entry.getValue();
                if (!(value instanceof Class) || !COMPILERS.contains(((Class)value).getName())) continue;
                this.groovycTaskNames.add((String)entry.getKey());
                Logger.getInstance().info("Detected groovyc compiler " + entry.getKey() + "=" + ((Class)value).getCanonicalName());
            }
            this.numTaskDefsLastSeen = taskDefs.size();
        }
    }

    protected boolean isGroovyc(@NotNull Task task) {
        return this.groovycTaskNames.contains(task.getTaskName());
    }

    private static class ParentAndChildPath {
        public final File parent;
        public final String child;

        public ParentAndChildPath(File parent, String child) {
            this.parent = parent;
            this.child = child;
        }

        public File toFile() {
            return new File(this.parent, this.child);
        }
    }
}

