/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.ant.tasks;

import clover.org.apache.commons.lang3.StringUtils;
import com.atlassian.clover.ant.AntCloverProfile;
import com.atlassian.clover.ant.AntCloverProfiles;
import com.atlassian.clover.ant.tasks.AbstractCloverTask;
import com.atlassian.clover.ant.tasks.AntInstrumentationConfig;
import com.atlassian.clover.ant.tasks.TestSourceSet;
import com.atlassian.clover.api.CloverException;
import com.atlassian.clover.cfg.instr.InstrumentationLevel;
import com.atlassian.clover.cfg.instr.MethodContextDef;
import com.atlassian.clover.cfg.instr.StatementContextDef;
import com.atlassian.clover.cfg.instr.java.LambdaInstrumentation;
import com.atlassian.clover.context.ContextStore;
import com.atlassian.clover.remote.DistributedConfig;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.types.FileSet;

public abstract class AbstractInstrTask
extends AbstractCloverTask {
    protected boolean optimizationOnly = false;

    public void setReportInitErrors(boolean reportInitErrors) {
        this.config.setReportInitErrors(reportInitErrors);
    }

    public void setSource(String source) {
        this.config.setSourceLevel(source);
    }

    public void setFullyQualifyJavaLang(boolean fullyQualify) {
        this.config.setFullyQualifyJavaLang(fullyQualify);
    }

    public void setRecordTestResults(boolean record) {
        this.config.setRecordTestResults(record);
    }

    public void addConfiguredDistributedCoverage(DistributedConfig distConfig) {
        this.config.setDistributedConfig(distConfig);
    }

    public void addConfiguredProfiles(AntCloverProfiles profiles) {
        boolean found = false;
        for (AntCloverProfile p : profiles.getProfiles()) {
            if (!p.getName().equals("default")) continue;
            found = true;
        }
        if (!found) {
            throw new IllegalArgumentException("You have defined <profiles> but there is no default <profile> defined. You must have one <profile name=\"default\" .../> declared.");
        }
        for (AntCloverProfile p : profiles.getProfiles()) {
            this.config.addProfile(p);
        }
    }

    public String getRuntimeInitString() {
        try {
            return this.config.getRuntimeInitString();
        }
        catch (CloverException e) {
            throw new BuildException(e.getMessage(), (Throwable)e);
        }
    }

    public void setEncoding(String encoding) {
        this.config.setEncoding(encoding);
    }

    public void setRelative(boolean relative) {
        this.config.setRelative(relative);
    }

    public void setFlushInterval(int flushInterval) {
        this.config.setFlushInterval(flushInterval);
    }

    public void setFlushPolicy(AntInstrumentationConfig.FlushPolicy flushPolicy) {
        this.config.setFlushPolicy(flushPolicy.getIndex());
    }

    public void setInstrumentation(AntInstrumentationConfig.Instrumentation instrumentation) {
        this.config.setInstrStrategy(instrumentation.getValue());
    }

    public void setInstrumentationLevel(AntInstrumentationConfig.EnumInstrumentationLevel instrumentationLevel) {
        this.config.setInstrLevel(instrumentationLevel.getIndex());
    }

    public void setInstrumentLambda(String level) {
        try {
            this.config.setInstrumentLambda(level);
        }
        catch (IllegalArgumentException ex) {
            throw new IllegalArgumentException("You must use one of the following values for lambda instrumentation: [" + StringUtils.join((Object[])LambdaInstrumentation.values(), ", ") + "] instead of [" + level + "]");
        }
    }

    public void setOptimizationOnly(boolean optimizationOnly) {
        this.optimizationOnly = optimizationOnly;
    }

    public void addConfiguredFileSet(FileSet set) {
        this.config.addConfiguredFileSet(set);
    }

    public void addConfiguredTestSources(TestSourceSet ts) {
        this.config.addConfiguredTestSources(ts);
    }

    public void addMethodContext(MethodContextDef context) {
        this.config.addMethodContext(context);
    }

    public void addStatementContext(StatementContextDef context) {
        this.config.addStatementContext(context);
    }

    @Override
    public boolean validate() {
        if (this.config.isIntervalBasedFlushing() && this.config.getFlushInterval() == 0) {
            throw new BuildException("You must set a flushinterval > 0 when using '" + this.config.getFlushPolicyString() + "' flushpolicy.");
        }
        if (this.optimizationOnly) {
            AntInstrumentationConfig.EnumInstrumentationLevel instrumentationLevel = (AntInstrumentationConfig.EnumInstrumentationLevel)AntInstrumentationConfig.EnumInstrumentationLevel.getInstance(AntInstrumentationConfig.EnumInstrumentationLevel.class, (String)InstrumentationLevel.METHOD.name().toLowerCase());
            this.config.setInstrLevelStrategy(instrumentationLevel.getValue());
        }
        try {
            ContextStore.saveCustomContexts(this.config);
        }
        catch (CloverException e) {
            throw new BuildException(e.getMessage(), (Throwable)e);
        }
        return true;
    }
}

