/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.ant.tasks;

import clover.com.google.common.collect.Sets;
import com.atlassian.clover.Logger;
import com.atlassian.clover.ant.tasks.AbstractInstrTask;
import com.atlassian.clover.ant.tasks.TestSourceSet;
import com.atlassian.clover.instr.java.Instrumenter;
import com.atlassian.clover.instr.tests.FileMappedTestDetector;
import java.io.File;
import java.util.HashSet;
import java.util.Set;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.types.FileSet;

public class CloverInstrTask
extends AbstractInstrTask {
    private File srcDir;
    private File testSrcDir;
    private File destDir;

    public void setSrcDir(File srcDir) {
        this.srcDir = srcDir;
    }

    public void setTestSrcDir(File testSrcDir) {
        this.testSrcDir = testSrcDir;
    }

    public void setDestDir(File destDir) {
        this.destDir = destDir;
    }

    @Override
    public boolean validate() {
        if (!super.validate()) {
            return false;
        }
        if (this.destDir == null) {
            throw new BuildException("destdir is required");
        }
        if (this.srcDir != null) {
            if (!this.srcDir.isDirectory()) {
                throw new BuildException("srcdir '" + this.srcDir + "' not found or not a directory");
            }
            if (this.srcDir.equals(this.destDir)) {
                throw new BuildException("srcdir cannot be the same as destdir");
            }
            FileSet fs = new FileSet();
            fs.setDir(this.srcDir);
            fs.setIncludes("**/*.java");
            this.addConfiguredFileSet(fs);
        }
        if (this.testSrcDir != null) {
            if (!this.testSrcDir.isDirectory()) {
                throw new BuildException("testSrcDir '" + this.testSrcDir + "' not found or not a directory");
            }
            if (this.testSrcDir.equals(this.destDir)) {
                throw new BuildException("testSrcDir cannot be the same as destdir");
            }
            TestSourceSet ts = new TestSourceSet();
            ts.setDir(this.testSrcDir);
            ts.setIncludes("**/*.java");
            this.addConfiguredTestSources(ts);
        }
        if (!(this.config.getInstrFilesets() != null && this.config.getInstrFilesets().size() != 0 || this.config.getTestSources() != null && this.config.getTestSources().size() != 0)) {
            throw new BuildException("You must specify either the srcdir or one or more filesets to be instrumented");
        }
        if (this.config.getInstrFilesets() != null) {
            for (FileSet fileSet : this.config.getInstrFilesets()) {
                if (!fileSet.getDir(this.getProject()).equals(this.destDir)) continue;
                throw new BuildException("srcdir cannot be the same as destdir: " + this.destDir);
            }
        }
        if (this.config.getTestSources() != null) {
            for (TestSourceSet testSourceSet : this.config.getTestSources()) {
                if (!testSourceSet.getDir(this.getProject()).equals(this.destDir)) continue;
                throw new BuildException("test srcdir cannot be the same as destdir: " + this.destDir);
            }
        }
        return true;
    }

    @Override
    public void cloverExecute() {
        Logger log = Logger.getInstance();
        try {
            HashSet<File> instrSet = Sets.newHashSet();
            if (this.config.getInstrFilesets() != null) {
                for (FileSet fileSet : this.config.getInstrFilesets()) {
                    this.addIncludedFilesToInstrSet(instrSet, fileSet);
                }
            }
            if (this.config.getTestSources() != null) {
                FileMappedTestDetector fileMappedTestDetector = new FileMappedTestDetector();
                for (TestSourceSet testSourceSet : this.config.getTestSources()) {
                    testSourceSet.setProject(this.getProject());
                    this.addIncludedFilesToInstrSet(instrSet, testSourceSet);
                    fileMappedTestDetector.addTestSourceMatcher(testSourceSet);
                }
                this.config.setTestDetector(fileMappedTestDetector);
            }
            Instrumenter instr = new Instrumenter(log, this.config);
            instr.startInstrumentation();
            for (File file : instrSet) {
                instr.instrument(file, this.destDir, this.config.getEncoding());
            }
            instr.endInstrumentation();
        }
        catch (Exception e) {
            throw new BuildException(e.getMessage(), (Throwable)e);
        }
    }

    private void addIncludedFilesToInstrSet(Set<File> instrSet, FileSet fs) {
        DirectoryScanner ds = fs.getDirectoryScanner(this.getProject());
        File baseDir = ds.getBasedir();
        for (String fileName : ds.getIncludedFiles()) {
            instrSet.add(new File(baseDir, fileName));
        }
    }
}

