/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.ant.tasks;

import clover.com.google.common.collect.Lists;
import com.atlassian.clover.CloverDatabase;
import com.atlassian.clover.CloverStartup;
import com.atlassian.clover.CoverageDataSpec;
import com.atlassian.clover.Logger;
import com.atlassian.clover.ant.tasks.AbstractCloverTask;
import com.atlassian.clover.cfg.Interval;
import com.atlassian.clover.optimization.Snapshot;
import com.atlassian.clover.optimization.SnapshotPrinter;
import com.atlassian.clover.recorder.PerTestCoverageStrategy;
import java.io.File;
import java.util.LinkedList;
import org.apache.tools.ant.BuildException;

public class CloverSnapshotTask
extends AbstractCloverTask {
    private Interval initialSpan = Interval.DEFAULT_SPAN;
    private File file;

    public void setSpan(String initialspan) {
        this.initialSpan = new Interval(initialspan);
    }

    public void setInitialSpan(String initialspan) {
        this.initialSpan = new Interval(initialspan);
    }

    public void setFile(File file) {
        this.file = file;
    }

    @Override
    public void cloverExecute() {
        CloverStartup.permsCheck(16L);
        Snapshot.setDebug(this.debug);
        File snapshotLocation = this.file != null ? this.file : Snapshot.fileForInitString(this.config.resolveInitString());
        try {
            long start;
            Logger.getInstance().verbose("Attempting to load snapshot file from '" + snapshotLocation + "'");
            Snapshot snapshot = Snapshot.loadFromFile(snapshotLocation);
            if (snapshot == null) {
                Logger.getInstance().info("Snapshot file not found, creating new file at " + snapshotLocation.getAbsolutePath());
                start = System.currentTimeMillis();
                CloverDatabase db = CloverDatabase.loadWithCoverage(this.config.resolveInitString(), new CoverageDataSpec(null, this.initialSpan.getValueInMillis(), false, true, true, true, PerTestCoverageStrategy.IN_MEMORY));
                Logger.getInstance().verbose("Took " + (System.currentTimeMillis() - start) + "ms to load coverage data to generate the snapshot");
                snapshot = Snapshot.generateFor(db, snapshotLocation.getAbsolutePath());
            } else {
                LinkedList<Long> versions;
                if (this.debug) {
                    SnapshotPrinter.textPrint(snapshot, Logger.getInstance(), 2);
                }
                long lastVersion = (versions = Lists.newLinkedList(snapshot.getDbVersions())).size() == 0 ? this.initialSpan.getValueInMillis() : versions.getLast().longValue();
                long span = Math.max(0L, System.currentTimeMillis() - lastVersion);
                start = System.currentTimeMillis();
                CloverDatabase db = CloverDatabase.loadWithCoverage(this.config.resolveInitString(), new CoverageDataSpec(null, span, false, true, true, true, PerTestCoverageStrategy.IN_MEMORY));
                Logger.getInstance().verbose("Took " + (System.currentTimeMillis() - start) + "ms to load coverage data to update the snapshot");
                Logger.getInstance().info("Updating snapshot '" + snapshotLocation.getAbsolutePath() + "' against Clover database at '" + db.getInitstring() + "'");
                snapshot.updateFor(db);
            }
            start = System.currentTimeMillis();
            snapshot.store();
            Logger.getInstance().verbose("Took " + (System.currentTimeMillis() - start) + "ms to snapshot");
        }
        catch (Exception e) {
            Logger.getInstance().error("Failed to create or update snapshot file at " + snapshotLocation.getAbsolutePath(), e);
            throw new BuildException((Throwable)e);
        }
    }
}

