/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.ant.tasks;

import clover.com.google.common.collect.Lists;
import clover.com.google.common.collect.Sets;
import com.atlassian.clover.api.CloverException;
import com.atlassian.clover.instr.tests.NoTestDetector;
import com.atlassian.clover.instr.tests.TestDetector;
import com.atlassian.clover.instr.tests.TestSourceMatcher;
import com.atlassian.clover.spec.instr.test.AndSpec;
import com.atlassian.clover.spec.instr.test.BooleanSpec;
import com.atlassian.clover.spec.instr.test.OrSpec;
import com.atlassian.clover.spec.instr.test.TestClassSpec;
import java.io.File;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.types.FileSet;

public class TestSourceSet
extends FileSet
implements TestSourceMatcher {
    private boolean enabled = true;
    private TestDetector testDetector;
    private Set<File> includedFiles = null;
    private Set<File> excludedFiles = null;
    private BooleanSpec defaultBoolSpec = new OrSpec();
    private List<BooleanSpec> boolSpecs = null;

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void addConfiguredTestClass(TestClassSpec testClassSpec) {
        this.initBoolSpecs();
        if (!this.boolSpecs.contains(this.defaultBoolSpec)) {
            this.boolSpecs.add(this.defaultBoolSpec);
        }
        this.defaultBoolSpec.addConfiguredTestClass(testClassSpec);
    }

    public void addConfiguredOr(OrSpec or) {
        this.initBoolSpecs();
        this.boolSpecs.add(or);
    }

    public void addConfiguredOrConditions(OrSpec or) {
        this.initBoolSpecs();
        this.boolSpecs.add(or);
    }

    public void addConfiguredAnd(AndSpec and) {
        this.initBoolSpecs();
        this.boolSpecs.add(and);
    }

    public void addConfiguredAndConditions(AndSpec and) {
        this.initBoolSpecs();
        this.boolSpecs.add(and);
    }

    private void initBoolSpecs() {
        if (this.boolSpecs == null) {
            this.boolSpecs = Lists.newArrayList();
        }
    }

    public void validate() throws BuildException {
        this.buildTestDetector();
    }

    public Set<File> getIncludedFiles() {
        this.maybeBuildFileSets();
        return Sets.newHashSet(this.includedFiles);
    }

    public Set<File> getExcludedFiles() {
        this.maybeBuildFileSets();
        return Sets.newHashSet(this.excludedFiles);
    }

    @Override
    public boolean matchesFile(File f) {
        this.maybeBuildFileSets();
        return this.includedFiles.contains(f);
    }

    @Override
    public TestDetector getDetector() {
        return this.testDetector;
    }

    private void buildTestDetector() {
        try {
            this.testDetector = this.enabled ? BooleanSpec.buildTestDetectorFor(this.boolSpecs) : new NoTestDetector();
        }
        catch (CloverException e) {
            throw new BuildException(e.getMessage());
        }
    }

    private void maybeBuildFileSets() {
        if (this.includedFiles == null) {
            HashSet<File> is = Sets.newHashSet();
            HashSet<File> es = Sets.newHashSet();
            if (this.enabled) {
                String[] excluded;
                String[] included;
                DirectoryScanner ds = this.getDirectoryScanner(this.getProject());
                File baseDir = this.getDir(this.getProject());
                for (String anIncluded : included = ds.getIncludedFiles()) {
                    File testFile = new File(baseDir, anIncluded);
                    is.add(testFile);
                }
                for (String anExcluded : excluded = ds.getExcludedFiles()) {
                    File testFile = new File(baseDir, anExcluded);
                    es.add(testFile);
                }
            }
            this.includedFiles = is;
            this.excludedFiles = es;
        }
    }

    public String toString() {
        String content = "testsources(" + (this.getDir() != null ? "dir=" + this.getDir().getPath() : "") + " enabled=" + this.enabled;
        if (this.boolSpecs != null) {
            for (BooleanSpec boolSpec : this.boolSpecs) {
                content = content + "\n\t" + boolSpec.toString();
            }
        }
        content = content + ")";
        return content;
    }
}

