/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.api.ci;

import java.io.File;

public class CIOptions {
    private final boolean optimize;
    private final boolean html;
    private final boolean json;
    private final boolean pdf;
    private final boolean xml;
    private final boolean historical;
    private final String licenseCert;
    private final File license;
    private final File historyDir;
    private final boolean fullClean;

    private CIOptions(Builder builder) {
        this.optimize = builder.optimize;
        this.html = builder.html;
        this.json = builder.json;
        this.historical = builder.historical;
        this.licenseCert = builder.licenseCert;
        this.license = builder.license;
        this.historyDir = builder.historyDir;
        this.fullClean = builder.fullClean;
        this.pdf = builder.pdf;
        this.xml = builder.xml;
    }

    public boolean isOptimize() {
        return this.optimize;
    }

    public boolean isHtml() {
        return this.html;
    }

    public boolean isJson() {
        return this.json;
    }

    public String getLicenseCert() {
        return this.licenseCert;
    }

    public File getLicense() {
        return this.license;
    }

    public File getHistoryDir() {
        return this.historyDir;
    }

    public boolean isHistorical() {
        return this.historical;
    }

    public boolean isFullClean() {
        return this.fullClean;
    }

    public boolean isPdf() {
        return this.pdf;
    }

    public boolean isXml() {
        return this.xml;
    }

    public static class Builder {
        private boolean optimize = false;
        private boolean html = true;
        private boolean json = false;
        private boolean pdf = false;
        private boolean xml = true;
        private boolean historical = false;
        private String licenseCert = null;
        private File license = null;
        private File historyDir = null;
        private boolean fullClean = false;

        public Builder optimize(boolean optimize) {
            this.optimize = optimize;
            return this;
        }

        public Builder html(boolean html) {
            this.html = html;
            return this;
        }

        public Builder json(boolean json) {
            this.json = json;
            return this;
        }

        public Builder pdf(boolean pdf) {
            this.pdf = pdf;
            return this;
        }

        public Builder xml(boolean xml) {
            this.xml = xml;
            return this;
        }

        public Builder historical(boolean historical) {
            this.historical = historical;
            return this;
        }

        public Builder licenseCert(String licenseCert) {
            this.licenseCert = licenseCert;
            return this;
        }

        public Builder license(File license) {
            this.license = license;
            return this;
        }

        public Builder historyDir(File historyDir) {
            this.historyDir = historyDir;
            return this;
        }

        public Builder fullClean(boolean fullClean) {
            this.fullClean = fullClean;
            return this;
        }

        public CIOptions build() {
            return new CIOptions(this);
        }

        public String toString() {
            return "Builder{optimize=" + this.optimize + ", html=" + this.html + ", json=" + this.json + ", pdf=" + this.pdf + ", xml=" + this.xml + ", historical=" + this.historical + ", licenseCert='" + this.licenseCert + "'" + ", license='" + this.license + "'" + ", historyDir='" + this.historyDir + "'" + ", fullClean=" + this.fullClean + '}';
        }
    }
}

