/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.ci;

import clover.com.google.common.collect.Lists;
import com.atlassian.clover.Logger;
import com.atlassian.clover.ant.taskdefs.CloverCompilerAdapter;
import com.atlassian.clover.ant.tasks.AntInstrumentationConfig;
import com.atlassian.clover.ant.tasks.CloverEnvTask;
import com.atlassian.clover.api.CloverException;
import com.atlassian.clover.api.optimization.Optimizable;
import com.atlassian.clover.api.optimization.OptimizationOptions;
import com.atlassian.clover.optimization.LocalSnapshotOptimizer;
import com.atlassian.clover.optimization.Snapshot;
import com.atlassian.clover.util.ClassPathUtil;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.apache.tools.ant.BuildEvent;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.UnknownElement;
import org.apache.tools.ant.taskdefs.Java;
import org.apache.tools.ant.taskdefs.Javac;
import org.apache.tools.ant.taskdefs.Javadoc;
import org.apache.tools.ant.taskdefs.optional.junit.BatchTest;
import org.apache.tools.ant.taskdefs.optional.junit.JUnitTask;
import org.apache.tools.ant.taskdefs.optional.junit.JUnitTest;
import org.apache.tools.ant.types.Path;

public class AntIntegrationListener
implements BuildListener {
    private OptimizationOptions optimizationOptions;
    private boolean instrumentationOccured;
    private boolean executionOccured;
    private boolean importOccured;

    public void buildStarted(BuildEvent buildEvent) {
        AntInstrumentationConfig cfg = this.getConfigForProject(buildEvent.getProject());
        this.optimizationOptions = new OptimizationOptions.Builder().initStringAndSnapshotFrom(cfg.resolveInitString()).build();
    }

    public void buildFinished(BuildEvent buildEvent) {
        StringBuffer msg = new StringBuffer("[clover]");
        if (!this.instrumentationOccured && !this.executionOccured) {
            msg.append(" No Clover reports written. ");
            this.appendReason(msg);
            buildEvent.getProject().log(msg.toString());
            return;
        }
        if (this.isOptimizationEnabled()) {
            this.createSnapshot();
        }
        if (this.executionOccured && this.instrumentationOccured && this.importOccured) {
            Vector<String> targets = new Vector<String>(Arrays.asList("clover.current", "clover.json", "clover.report"));
            buildEvent.getProject().executeTargets(targets);
        } else {
            msg.append(" Clover reports not being generated.");
            this.appendReason(msg);
            buildEvent.getProject().log(msg.toString());
        }
    }

    private void appendReason(StringBuffer msg) {
        if (!this.instrumentationOccured) {
            msg.append(" No Clover instrumentation was done.");
        }
        if (!this.executionOccured) {
            msg.append(" No tests were run.");
        }
        if (!this.importOccured) {
            msg.append(" Clover targets could not be imported into this project.");
        }
    }

    private void createSnapshot() {
        try {
            Snapshot.generateFor(this.optimizationOptions.getInitString()).store();
        }
        catch (IOException e) {
            Logger.getInstance().debug("Exception when writing snapshot", e);
            Logger.getInstance().error("Problem writing snapshot file: " + e.getMessage());
        }
        catch (CloverException e) {
            Logger.getInstance().debug("Exception when writing snapshot", e);
            Logger.getInstance().error("Problem writing snapshot file: " + e.getMessage());
        }
    }

    public void targetStarted(BuildEvent buildEvent) {
    }

    public void targetFinished(BuildEvent buildEvent) {
    }

    public void taskStarted(BuildEvent buildEvent) {
        Object maybeTask;
        if (!this.importOccured) {
            this.importOccured = true;
            this.setSystemProperties(buildEvent);
            this.importCloverTargets(buildEvent);
        }
        Task task = buildEvent.getTask();
        if (Logger.isDebug()) {
            Logger.getInstance().debug("Started task: " + task.getTaskName());
        }
        if ((maybeTask = this.getConfiguredTask(task)) instanceof Task) {
            Task configuredTask = (Task)maybeTask;
            String name = configuredTask.getClass().getSimpleName();
            if (Logger.isDebug()) {
                Logger.getInstance().debug("Started task class.getSimpleName(): " + name);
            }
            if ("javac".equalsIgnoreCase(name)) {
                this.injectClover((Javac)configuredTask);
            } else if ("junittask".equalsIgnoreCase(name)) {
                this.injectClover((JUnitTask)configuredTask, this.isOptimizationEnabled());
            } else if ("java".equalsIgnoreCase(name)) {
                this.injectClover((Java)configuredTask);
            } else if ("javadoc".equalsIgnoreCase(name)) {
                this.injectClover((Javadoc)configuredTask);
            }
        }
    }

    private boolean isOptimizationEnabled() {
        return Boolean.getBoolean(this.getCloverOptimizeProperty());
    }

    public String getCloverOptimizeProperty() {
        return "clover.optimization.enabled";
    }

    private void importCloverTargets(BuildEvent buildEvent) {
        CloverEnvTask envTask = new CloverEnvTask();
        envTask.setProject(buildEvent.getProject());
        envTask.setTaskName("clover-env");
        envTask.init();
        envTask.execute();
    }

    private void setSystemProperties(BuildEvent buildEvent) {
        Hashtable cloverProps = buildEvent.getProject().getProperties();
        for (Map.Entry entry : cloverProps.entrySet()) {
            if (!((String)entry.getKey()).startsWith("clover.")) continue;
            System.setProperty((String)entry.getKey(), entry.getValue().toString());
        }
    }

    public void taskFinished(BuildEvent buildEvent) {
    }

    public void messageLogged(BuildEvent buildEvent) {
    }

    private AntInstrumentationConfig getConfigForProject(Project project) {
        AntInstrumentationConfig instrConfig = (AntInstrumentationConfig)project.getReference("clover.config");
        if (instrConfig == null) {
            instrConfig = new AntInstrumentationConfig(project);
            project.addReference("clover.config", (Object)instrConfig);
        }
        return instrConfig;
    }

    private Object getConfiguredTask(Task task) {
        Object proxy = task.getRuntimeConfigurableWrapper().getProxy();
        if (proxy instanceof UnknownElement) {
            UnknownElement ue = (UnknownElement)proxy;
            ue.maybeConfigure();
            return ue.getRealThing();
        }
        return task;
    }

    private void injectClover(Javac javac) {
        javac.setClasspath(new Path(javac.getProject(), ClassPathUtil.getCloverJarPath()));
        String origCompiler = javac.getCompiler();
        javac.setCompiler(CloverCompilerAdapter.class.getName());
        if (origCompiler != null) {
            this.getConfigForProject(javac.getProject()).setCompilerDelegate(origCompiler);
        }
        this.instrumentationOccured = true;
    }

    private void injectClover(Java java) {
        this.executionOccured = true;
        Path cloverJarPath = java.createClasspath();
        cloverJarPath.add(new Path(java.getProject(), ClassPathUtil.getCloverJarPath()));
    }

    private void injectClover(Javadoc javadoc) {
        this.executionOccured = true;
        this.addCloverToDoclets(javadoc);
        this.addCloverToTaglets(javadoc);
    }

    private void addCloverToTaglets(Javadoc javadoc) {
        try {
            Field tagsField = javadoc.getClass().getDeclaredField("tagsField");
            tagsField.setAccessible(true);
            Vector tags = (Vector)tagsField.get(javadoc);
            if (tags != null && tags.size() > 0) {
                for (int i = 0; i < tags.size(); ++i) {
                    Javadoc.ExtensionInfo tagInfo = (Javadoc.ExtensionInfo)tags.elementAt(i);
                    this.addCloverToPath(javadoc, tagInfo);
                }
            }
        }
        catch (NoSuchFieldException e) {
            Logger.getInstance().debug("Could not inject Clover onto classpath of javadoc task", e);
        }
        catch (IllegalAccessException e) {
            Logger.getInstance().debug("Could not inject Clover onto classpath of javadoc task", e);
        }
    }

    private void addCloverToDoclets(Javadoc javadoc) {
        try {
            Field docletField = javadoc.getClass().getDeclaredField("doclet");
            docletField.setAccessible(true);
            if (docletField.get(javadoc) != null) {
                Javadoc.DocletInfo doclet = javadoc.createDoclet();
                this.addCloverToPath(javadoc, (Javadoc.ExtensionInfo)doclet);
            }
        }
        catch (NoSuchFieldException e) {
            Logger.getInstance().debug("Could not inject Clover onto classpath of javadoc task", e);
        }
        catch (IllegalAccessException e) {
            Logger.getInstance().debug("Could not inject Clover onto classpath of javadoc task", e);
        }
    }

    private void addCloverToPath(Javadoc javadoc, Javadoc.ExtensionInfo tagInfo) {
        Path cloverJarPath = tagInfo.createPath();
        cloverJarPath.add(new Path(javadoc.getProject(), ClassPathUtil.getCloverJarPath()));
        javadoc.log("Injected Clover into javadoc doclet classpath: " + cloverJarPath);
    }

    private void injectClover(JUnitTask junit, boolean optimize) {
        this.executionOccured = true;
        Path cloverJarPath = junit.createClasspath();
        cloverJarPath.add(new Path(junit.getProject(), ClassPathUtil.getCloverJarPath()));
        if (optimize) {
            this.injectOptimization(junit);
        }
    }

    private void injectOptimization(JUnitTask junit) {
        Vector batchTests;
        Vector individualTests;
        try {
            Field individualTestsField = junit.getClass().getDeclaredField("tests");
            Field batchTestsField = junit.getClass().getDeclaredField("batchTests");
            individualTestsField.setAccessible(true);
            batchTestsField.setAccessible(true);
            individualTests = (Vector)individualTestsField.get(junit);
            batchTests = (Vector)batchTestsField.get(junit);
            Logger.getInstance().debug("batchTests.size() = " + batchTests.size());
            Logger.getInstance().debug("individualTests.size() = " + individualTests.size());
        }
        catch (IllegalAccessException e) {
            Logger.getInstance().debug("Unable to access JUnit test field", e);
            Logger.getInstance().warn("Unable to configure JUnit for test optimization");
            return;
        }
        catch (NoSuchFieldException e) {
            Logger.getInstance().debug("Unable to access JUnit test field", e);
            Logger.getInstance().warn("Unable to configure JUnit for test optimization");
            return;
        }
        List<OptimizableJUnitTest> wrappedTests = this.getIndividualWrappedTests(batchTests, individualTests);
        try {
            wrappedTests = LocalSnapshotOptimizer.optimize(wrappedTests, this.optimizationOptions);
        }
        catch (CloverException e) {
            Logger.getInstance().debug("Exception when optimizing tests", e);
            Logger.getInstance().error("Optimization failed. Running all specified tests.");
            return;
        }
        individualTests.clear();
        batchTests.clear();
        for (OptimizableJUnitTest test : wrappedTests) {
            individualTests.add(test.getJUnitTest());
        }
    }

    private List<OptimizableJUnitTest> getIndividualWrappedTests(Vector<BatchTest> batchTests, Vector<JUnitTest> individualTests) {
        ArrayList<OptimizableJUnitTest> wrappedTests = Lists.newArrayList();
        for (BatchTest batchTest : batchTests) {
            Enumeration test = batchTest.elements();
            while (test.hasMoreElements()) {
                wrappedTests.add(new OptimizableJUnitTest((JUnitTest)test.nextElement()));
            }
        }
        for (JUnitTest test : individualTests) {
            wrappedTests.add(new OptimizableJUnitTest(test));
        }
        return wrappedTests;
    }

    private static class OptimizableJUnitTest
    implements Optimizable {
        private JUnitTest test;

        public OptimizableJUnitTest(JUnitTest test) {
            this.test = test;
        }

        @Override
        public String getName() {
            return this.test.getName();
        }

        public JUnitTest getJUnitTest() {
            return this.test;
        }
    }
}

