/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.ci;

import com.atlassian.clover.Logger;
import com.atlassian.clover.api.ci.CIOptions;
import com.atlassian.clover.api.ci.Integrator;
import com.atlassian.clover.ci.AntIntegrationListener;
import com.atlassian.clover.util.ClassPathUtil;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.List;

public class AntIntegrator
implements Integrator {
    private static final boolean isWindows = AntIntegrator.isWindows();
    private final CIOptions options;

    public AntIntegrator(CIOptions opts) {
        this.options = opts;
    }

    @Override
    public void decorateArguments(List<String> args) {
        if (this.options.isFullClean()) {
            args.add(0, "clover.fullclean");
        }
        if (!this.options.isJson()) {
            args.add("-Dclover.skip.json=true");
        }
        if (!this.options.isHistorical()) {
            args.add("-Dclover.skip.report=true");
        }
        if (this.options.isHistorical()) {
            args.add("-Dclover.skip.current=true");
        }
        if (this.options.getHistoryDir() != null) {
            args.add("-Dclover.historydir=" + this.addQuotesIfNecessary(this.options.getHistoryDir().getAbsolutePath()));
        }
        args.add("-Dclover.optimization.enabled=" + this.options.isOptimize());
        String cloverJarLocation = ClassPathUtil.getCloverJarPath();
        if (cloverJarLocation != null) {
            args.add("-lib");
            args.add("\"" + cloverJarLocation + "\"");
        } else {
            Logger.getInstance().warn("The location of the clover jar could not be determined. Please supply '-lib /path/to/clover.jar' directly.");
        }
        args.add("-listener");
        args.add(AntIntegrationListener.class.getName());
        if (this.options.getLicenseCert() != null && !this.options.getLicenseCert().trim().equals("")) {
            args.add("-Dclover.license.cert=" + this.addQuotesIfNecessary(this.options.getLicenseCert()));
        }
        if (this.options.getLicense() != null) {
            args.add("-Dclover.license.path=" + this.addQuotesIfNecessary(this.options.getLicense().getAbsolutePath()));
        }
    }

    private String addQuotesIfNecessary(String input) {
        return isWindows ? input : '\"' + input + '\"';
    }

    private static boolean isWindows() {
        String osName = AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                try {
                    return System.getProperty("os.name");
                }
                catch (SecurityException ex) {
                    return null;
                }
            }
        });
        return osName != null && osName.toLowerCase().indexOf("windows") == 0;
    }
}

