/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.instr.java;

import clover.antlr.CommonHiddenStreamToken;
import clover.com.google.common.collect.Lists;
import com.atlassian.clover.context.NamedContext;
import com.atlassian.clover.instr.java.CloverTokenStreamFilter;
import com.atlassian.clover.instr.java.Emitter;
import com.atlassian.clover.instr.java.InstrumentationState;
import java.io.IOException;
import java.io.Writer;
import java.util.List;

public class CloverToken
extends CommonHiddenStreamToken {
    private CloverToken next;
    private CloverToken prev;
    private List<Emitter> preEmitters;
    private List<Emitter> postEmitters;
    private CloverTokenStreamFilter filter;
    private boolean emittersEnabled;

    public CloverToken() {
    }

    public CloverToken(int t, String txt) {
        super(t, txt);
    }

    public CloverToken(String s) {
        super(s);
    }

    public CloverToken getNext() {
        return this.next;
    }

    public void setNext(CloverToken next) {
        this.next = next;
    }

    public CloverToken getPrev() {
        return this.prev;
    }

    public void setPrev(CloverToken prev) {
        this.prev = prev;
    }

    public boolean isEmittersEnabled() {
        return this.emittersEnabled;
    }

    public void setEmittersEnabled(boolean emittersEnabled) {
        this.emittersEnabled = emittersEnabled;
        if (this.hasPreEmitters()) {
            for (Emitter emitter : this.preEmitters) {
                emitter.setEnabled(emittersEnabled);
            }
        }
        if (this.hasPostEmitters()) {
            for (Emitter emitter : this.postEmitters) {
                emitter.setEnabled(emittersEnabled);
            }
        }
    }

    public void addContext(NamedContext context) {
        if (this.hasPreEmitters()) {
            for (Emitter emitter : this.preEmitters) {
                emitter.addContext(context);
            }
        }
        if (this.hasPostEmitters()) {
            for (Emitter emitter : this.postEmitters) {
                emitter.addContext(context);
            }
        }
    }

    public void addPreEmitter(Emitter emitter) {
        if (this.preEmitters == null) {
            this.preEmitters = Lists.newLinkedList();
        }
        this.preEmitters.add(emitter);
    }

    public boolean hasPreEmitters() {
        return this.preEmitters != null;
    }

    public void triggerPreEmitters(Writer out) throws IOException {
        if (this.hasPreEmitters()) {
            for (Emitter emitter : this.preEmitters) {
                emitter.emit(out);
            }
        }
    }

    public boolean hasPostEmitters() {
        return this.postEmitters != null;
    }

    public void triggerPostEmitters(Writer out) throws IOException {
        if (this.hasPostEmitters()) {
            for (Emitter emitter : this.postEmitters) {
                emitter.emit(out);
            }
        }
    }

    public void addPostEmitter(Emitter emitter) {
        if (this.postEmitters == null) {
            this.postEmitters = Lists.newLinkedList();
        }
        this.postEmitters.add(emitter);
    }

    public void setFilter(CloverTokenStreamFilter filter) {
        this.filter = filter;
    }

    public CloverTokenStreamFilter getFilter() {
        return this.filter;
    }

    public boolean hasEmitters() {
        return this.hasPreEmitters() || this.hasPostEmitters();
    }

    public void initEmitters(InstrumentationState state) {
        if (this.hasPreEmitters()) {
            for (Emitter emitter : this.preEmitters) {
                emitter.initialise(state);
            }
        }
        if (this.hasPostEmitters()) {
            for (Emitter emitter : this.postEmitters) {
                emitter.initialise(state);
            }
        }
    }
}

