/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.instr.java;

import clover.com.google.common.collect.Lists;
import com.atlassian.clover.api.registry.MethodInfo;
import com.atlassian.clover.instr.java.CloverToken;
import com.atlassian.clover.instr.java.MethodEntryInstrEmitter;
import com.atlassian.clover.instr.java.TokenListUtil;
import java.io.File;
import java.util.List;

public class FileStructureInfo {
    private String packageName = "";
    private File file = null;
    private boolean suppressFallthroughWarnings = false;
    private List<Marker> statements = Lists.newLinkedList();
    private List<MethodMarker> methods = Lists.newLinkedList();

    public FileStructureInfo(File file) {
        this.file = file;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public File getFile() {
        return this.file;
    }

    public boolean isSuppressFallthroughWarnings() {
        return this.suppressFallthroughWarnings;
    }

    public void setSuppressFallthroughWarnings(boolean suppressFallthroughWarnings) {
        this.suppressFallthroughWarnings = suppressFallthroughWarnings;
    }

    public void addMethodMarker(MethodEntryInstrEmitter method, CloverToken start, CloverToken endSig, CloverToken end) {
        this.methods.add(new MethodMarker(method, start, endSig, end));
    }

    public int getNumMethodMarkers() {
        return this.methods.size();
    }

    public MethodMarker getMethodMarker(int i) {
        return this.methods.get(i);
    }

    public int getNumStatementMarkers() {
        return this.statements.size();
    }

    public Marker getStatementMarker(int i) {
        return this.statements.get(i);
    }

    public void addStatementMarker(CloverToken start, CloverToken end) {
        this.statements.add(new Marker(start, end));
    }

    public static class MethodMarker
    extends Marker {
        private CloverToken endSig;
        private String normalisedSignature;
        private MethodEntryInstrEmitter entryEmitter;

        public MethodMarker(MethodEntryInstrEmitter entryEmitter, CloverToken start, CloverToken endSig, CloverToken end) {
            super(start, end);
            this.entryEmitter = entryEmitter;
            this.endSig = endSig;
        }

        public MethodInfo getMethod() {
            return this.entryEmitter.getMethod();
        }

        public CloverToken getEndSig() {
            return this.endSig;
        }

        public void setEndSig(CloverToken endSig) {
            this.endSig = endSig;
        }

        public String getNormalisedSignature() {
            if (this.normalisedSignature == null) {
                this.normalisedSignature = TokenListUtil.getNormalisedSequence(this.getStart(), this.getEndSig());
            }
            return this.normalisedSignature;
        }
    }

    public static class Marker {
        private CloverToken start;
        private CloverToken end;
        private String normalisedString;

        public Marker(CloverToken start, CloverToken end) {
            this.start = start;
            this.end = end;
        }

        public CloverToken getStart() {
            return this.start;
        }

        public void setStart(CloverToken start) {
            this.start = start;
        }

        public CloverToken getEnd() {
            return this.end;
        }

        public void setEnd(CloverToken end) {
            this.end = end;
        }

        public String getNormalisedString() {
            if (this.normalisedString == null) {
                this.normalisedString = TokenListUtil.getNormalisedSequence(this.getStart(), this.getEnd());
            }
            return this.normalisedString;
        }
    }
}

