/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.instr.java;

import com.atlassian.clover.instr.Bindings;
import com.atlassian.clover.instr.java.Emitter;
import com.atlassian.clover.instr.java.InstrumentationState;
import com.atlassian.clover.instr.java.MethodEntryInstrEmitter;
import java.lang.reflect.Modifier;

public class MethodExitInstrEmitter
extends Emitter {
    private MethodEntryInstrEmitter entry;

    public MethodExitInstrEmitter(MethodEntryInstrEmitter entryEmitter, int endline, int endcol) {
        super(endline, endcol);
        this.entry = entryEmitter;
    }

    @Override
    public void init(InstrumentationState state) {
        state.getSession().exitMethod(this.getLine(), this.getColumn());
        StringBuilder instr = new StringBuilder();
        if (this.entry.needsFinally()) {
            instr.append("}finally{");
            if (state.isInstrEnabled()) {
                switch (state.getCfg().getFlushPolicy()) {
                    case 1: {
                        instr.append(Bindings.$CoverageRecorder$maybeFlush(state.getRecorderPrefix()));
                        instr.append(";");
                        break;
                    }
                    case 2: {
                        instr.append(Bindings.$CoverageRecorder$flushNeeded(state.getRecorderPrefix()));
                        instr.append(";");
                    }
                }
                if (this.entry.isAddTestInstr()) {
                    String typeInstr = "getClass().getName()";
                    if (Modifier.isStatic(this.entry.getSignature().getModifiersMask())) {
                        typeInstr = this.entry.getMethod().getContainingClass().getName() + ".class.getName()";
                    }
                    instr.append(Bindings.$CoverageRecorder$globalSliceEnd(state.getRecorderPrefix(), typeInstr, "\"" + this.entry.getMethod().getQualifiedName() + "\"", "__CLR4_0_6_TEST_NAME_SNIFFER.getTestName()", Integer.toString(this.entry.getMethod().getDataIndex())));
                    instr.append(";");
                }
            }
            instr.append("}");
        }
        this.setInstr(instr.toString());
    }
}

