/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.lang;

import clover.com.google.common.collect.Maps;
import clover.com.google.common.collect.Sets;
import com.atlassian.clover.Logger;
import com.atlassian.clover.services.ServiceLocator;
import com.atlassian.clover.services.ServiceNotAvailableException;
import com.atlassian.clover.spi.lang.Language;
import com.atlassian.clover.spi.lang.LanguageConstruct;
import java.util.Collections;
import java.util.Map;
import java.util.Set;

public class Languages {
    private static final Map<String, LanguageConstruct> LANGUAGE_CONSTRUCTS = Maps.newHashMap();
    private static final Set<Language> LANGUAGES = Sets.newHashSet();

    public static Set<Language> getLanguages() {
        return Collections.unmodifiableSet(LANGUAGES);
    }

    public static LanguageConstruct lookupConstruct(String id) {
        LanguageConstruct construct = LANGUAGE_CONSTRUCTS.get(id);
        if (construct == null) {
            throw new IllegalArgumentException("The language construct with id \"" + id + "\" could not be found.");
        }
        return construct;
    }

    static {
        Collections.addAll(LANGUAGES, Language.Builtin.values());
        for (LanguageConstruct.Builtin builtin : LanguageConstruct.Builtin.values()) {
            LANGUAGE_CONSTRUCTS.put(builtin.getId(), builtin);
        }
        for (Language language : ServiceLocator.load(Language.class, Languages.class.getClassLoader())) {
            try {
                LANGUAGES.add(language);
                for (LanguageConstruct languageConstruct : language.getSupportedConstructs()) {
                    LANGUAGE_CONSTRUCTS.put(languageConstruct.getId(), languageConstruct);
                }
            }
            catch (ServiceNotAvailableException e) {
                Logger.getInstance().warn("Failed to register a 3rd party language support", e);
            }
        }
    }
}

