/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.optimization;

import clover.com.google.common.collect.Lists;
import com.atlassian.clover.api.optimization.Optimizable;
import com.atlassian.clover.api.optimization.OptimizationOptions;
import com.atlassian.clover.api.optimization.TestOptimizer;
import com.atlassian.clover.optimization.TestOptimizable;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestSuite;

public class TestSuiteOptimizer {
    private final OptimizationOptions options;

    public TestSuiteOptimizer(OptimizationOptions options) {
        this.options = options;
    }

    public TestSuiteOptimizer() {
        this.options = new OptimizationOptions.Builder().build();
    }

    public TestSuite optimize(TestSuite suite) {
        TestSuite optimizedSuite = new TestSuite(suite.getName());
        List<Optimizable> optimizables = this.createOptimizables(suite.tests());
        TestOptimizer optimizer = new TestOptimizer(this.options);
        List<Optimizable> optimized = optimizer.optimize(optimizables);
        for (Optimizable optimizable : optimized) {
            TestOptimizable test = (TestOptimizable)optimizable;
            optimizedSuite.addTest(test.getTest());
        }
        return optimizedSuite;
    }

    private List<Optimizable> createOptimizables(Enumeration tests) {
        LinkedList<Optimizable> optimizableTests = Lists.newLinkedList();
        while (tests.hasMoreElements()) {
            Test test = (Test)tests.nextElement();
            if (!(test instanceof TestSuite)) continue;
            optimizableTests.add(new TestOptimizable((TestSuite)test));
        }
        return optimizableTests;
    }
}

