/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.recorder;

import clover.com.google.common.collect.Lists;
import clover.com.google.common.collect.Maps;
import clover.com.google.common.collect.Sets;
import clover.it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import clover.it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import clover.it.unimi.dsi.fastutil.ints.Int2ObjectRBTreeMap;
import clover.it.unimi.dsi.fastutil.ints.Int2ObjectSortedMap;
import clover.it.unimi.dsi.fastutil.ints.IntArrayList;
import com.atlassian.clover.CoverageDataSpec;
import com.atlassian.clover.Logger;
import com.atlassian.clover.api.registry.ClassInfo;
import com.atlassian.clover.api.registry.MethodInfo;
import com.atlassian.clover.recorder.BasePerTestCoverage;
import com.atlassian.clover.recorder.PerTestRecordingTranscript;
import com.atlassian.clover.recorder.RecordingTranscripts;
import com.atlassian.clover.registry.Clover2Registry;
import com.atlassian.clover.registry.CoverageDataRange;
import com.atlassian.clover.registry.FileInfoVisitor;
import com.atlassian.clover.registry.entities.BaseFileInfo;
import com.atlassian.clover.registry.entities.FullFileInfo;
import com.atlassian.clover.registry.entities.TestCaseInfo;
import com.atlassian.clover.util.CloverBitSet;
import com.atlassian.clover.util.SizedLRUCacheMap;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;

public class SamplingPerTestCoverage
extends BasePerTestCoverage {
    private final FileInfoSample[] fileInfoSamples;
    private final Int2ObjectSortedMap fileIdxToSamplings;
    private final Int2ObjectMap tciIdsToRecordingFiles;
    private final Int2ObjectMap tciIdToTCIMap;
    private final CoverageDataSpec spec;
    private final SizedLRUCacheMap<String, CloverBitSet> coverageCache;
    private BitSet coverageMask;
    private BitSet passOnlyCoverageMask;

    public SamplingPerTestCoverage(Clover2Registry registry, CoverageDataSpec spec, int estPerTestRecordings) {
        super(registry.getDataLength());
        this.spec = spec;
        final LinkedList fileSamples = Lists.newLinkedList();
        final IntArrayList methodIdx = new IntArrayList();
        registry.getProject().visitFiles(new FileInfoVisitor(){

            @Override
            public void visitFileInfo(BaseFileInfo file) {
                for (ClassInfo classInfo : file.getClasses()) {
                    for (MethodInfo methodInfo : classInfo.getMethods()) {
                        methodIdx.add(methodInfo.getDataIndex());
                    }
                }
                fileSamples.add(new FileInfoSample(((FullFileInfo)file).getDataIndex(), methodIdx.toIntArray()));
                methodIdx.clear();
            }
        });
        this.fileInfoSamples = fileSamples.toArray(new FileInfoSample[fileSamples.size()]);
        Arrays.sort(this.fileInfoSamples, new Comparator<FileInfoSample>(){

            @Override
            public int compare(FileInfoSample fs1, FileInfoSample fs2) {
                return fs1.idx - fs2.idx;
            }
        });
        this.fileIdxToSamplings = new Int2ObjectRBTreeMap();
        for (FileInfoSample fileSample : this.fileInfoSamples) {
            this.fileIdxToSamplings.put(fileSample.idx, fileSample);
        }
        this.tciIdsToRecordingFiles = new Int2ObjectOpenHashMap();
        this.tciIdToTCIMap = new Int2ObjectOpenHashMap();
        this.coverageCache = new SizedLRUCacheMap(spec.getPerTestStorageSize().getSizeInBytes(), estPerTestRecordings, 1.1f);
    }

    @Override
    public void addCoverage(TestCaseInfo tci, PerTestRecordingTranscript recording) {
        CloverBitSet coverage = recording.getCoverage();
        for (FileInfoSample fileInfoSample : this.fileInfoSamples) {
            fileInfoSample.sample(tci, coverage);
        }
        HashSet<String> pathsToCoverage = (HashSet<String>)this.tciIdsToRecordingFiles.get(tci.getId());
        if (pathsToCoverage == null) {
            pathsToCoverage = Sets.newHashSet();
            this.tciIdsToRecordingFiles.put(tci.getId(), pathsToCoverage);
        }
        pathsToCoverage.add(recording.getFile().getAbsolutePath());
        this.tciIdToTCIMap.put(tci.getId(), tci);
    }

    @Override
    public boolean hasPerTestData() {
        return !this.tciIdToTCIMap.isEmpty();
    }

    @Override
    public BitSet getAllHits() {
        if (this.coverageMask == null) {
            this.initMasks();
        }
        return (BitSet)this.coverageMask.clone();
    }

    private synchronized CloverBitSet getCoverageFor(String pathToCoverageFile) throws IOException {
        CloverBitSet coverage = (CloverBitSet)this.coverageCache.get(pathToCoverageFile);
        if (coverage == null) {
            File coverageFile = new File(pathToCoverageFile);
            coverage = RecordingTranscripts.readSliceFromDisk(coverageFile.getParentFile(), coverageFile.getName(), this.spec).getCoverage();
            this.coverageCache.put(pathToCoverageFile, coverage);
        }
        return coverage;
    }

    private BitSet getHitsFor(TestCaseInfo tci, BitSet result) {
        Set pathsToCoverage = (Set)this.tciIdsToRecordingFiles.get(tci.getId());
        if (pathsToCoverage != null) {
            for (String pathToCoverage : pathsToCoverage) {
                try {
                    this.getCoverageFor(pathToCoverage).applyTo(result);
                }
                catch (IOException e) {
                    Logger.getInstance().error("Failed to load per-test coverage file \"" + pathToCoverage + "\"");
                }
            }
        }
        return result;
    }

    @Override
    public BitSet getHitsFor(TestCaseInfo tci) {
        return this.getHitsFor(tci, new BitSet(this.coverageSize));
    }

    @Override
    public BitSet getHitsFor(Set<TestCaseInfo> tcis) {
        BitSet result = new BitSet(this.coverageSize);
        for (TestCaseInfo tci : tcis) {
            this.getHitsFor(tci, result);
        }
        return result;
    }

    @Override
    public BitSet getHitsFor(Set<TestCaseInfo> tcis, CoverageDataRange range) {
        BitSet hits = this.getHitsFor(tcis);
        if (range != null) {
            BitSet mask = new BitSet();
            mask.set(range.getDataIndex(), range.getDataIndex() + range.getDataLength());
            hits.and(mask);
        }
        return hits;
    }

    @Override
    public BitSet getPassOnlyHits() {
        if (this.passOnlyCoverageMask == null) {
            this.initMasks();
        }
        return (BitSet)this.passOnlyCoverageMask.clone();
    }

    @Override
    public TestCaseInfo getTestById(int id) {
        return (TestCaseInfo)this.tciIdToTCIMap.get(id);
    }

    @Override
    public Set<TestCaseInfo> getTests() {
        return Sets.newHashSet(this.tciIdToTCIMap.values());
    }

    @Override
    public Set<TestCaseInfo> getTestsCovering(CoverageDataRange range) {
        Int2ObjectSortedMap head;
        int endIdx;
        HashSet<TestCaseInfo> tcis = Sets.newHashSet();
        int startIdx = range.getDataIndex();
        Int2ObjectSortedMap subFileIdxToSamplings = this.fileIdxToSamplings.subMap(startIdx, (endIdx = range.getDataLength() + range.getDataIndex()) + 1);
        if ((subFileIdxToSamplings.isEmpty() || subFileIdxToSamplings.firstIntKey() != startIdx) && !(head = this.fileIdxToSamplings.headMap(startIdx)).isEmpty()) {
            subFileIdxToSamplings = new Int2ObjectRBTreeMap(subFileIdxToSamplings);
            subFileIdxToSamplings.put(head.lastIntKey(), head.get(head.lastIntKey()));
        }
        for (FileInfoSample fileInfoSample : subFileIdxToSamplings.values()) {
            tcis.addAll(fileInfoSample.tcis);
        }
        Iterator tciIter = tcis.iterator();
        block3: while (tciIter.hasNext()) {
            Set pathToCoverageFiles = (Set)this.tciIdsToRecordingFiles.get(((TestCaseInfo)tciIter.next()).getId());
            if (pathToCoverageFiles == null) continue;
            for (String pathToCoverageFile : pathToCoverageFiles) {
                try {
                    CloverBitSet bitSet = this.getCoverageFor(pathToCoverageFile);
                    int firstBitSetAfterRange = bitSet.nextSetBit(startIdx);
                    if (firstBitSetAfterRange < startIdx || firstBitSetAfterRange >= endIdx) continue;
                    continue block3;
                }
                catch (IOException e) {
                    Logger.getInstance().warn(String.format("Failed to load coverage file: \"%s\" while calculating hits in range [%d,%d]", pathToCoverageFile, range.getDataIndex(), range.getDataIndex() + range.getDataLength()), e);
                }
            }
            tciIter.remove();
        }
        return tcis;
    }

    @Override
    public Map<TestCaseInfo, BitSet> mapTestsAndCoverageForFile(FullFileInfo fileInfo) {
        HashMap<TestCaseInfo, BitSet> tcisAndCoverage = Maps.newHashMap();
        FileInfoSample fileSample = (FileInfoSample)this.fileIdxToSamplings.get(fileInfo.getDataIndex());
        if (fileSample != null) {
            int minBitSize = fileInfo.getDataIndex() + fileInfo.getDataLength();
            for (TestCaseInfo tci : fileSample.tcis) {
                BitSet totalTciCoverage = new BitSet(minBitSize);
                Set pathToCoverageFiles = (Set)this.tciIdsToRecordingFiles.get(tci.getId());
                if (pathToCoverageFiles == null) continue;
                for (String pathToCoverageFile : pathToCoverageFiles) {
                    try {
                        CloverBitSet coverageForFile = this.getCoverageFor(pathToCoverageFile);
                        tcisAndCoverage.put(tci, coverageForFile.applyTo(totalTciCoverage));
                    }
                    catch (IOException e) {
                        Logger.getInstance().warn(String.format("Failed to load coverage file: \"%s\" while calculating hits in range [%d,%d]", pathToCoverageFile, fileInfo.getDataIndex(), fileInfo.getDataIndex() + fileInfo.getDataLength()), e);
                    }
                }
            }
        }
        return tcisAndCoverage;
    }

    @Override
    protected void initMasks() {
        BitSet coverageMask = new BitSet(this.coverageSize);
        BitSet passOnlyCoverageMask = new BitSet(this.coverageSize);
        BitSet coverageNotUniqueMask = new BitSet(this.coverageSize);
        for (Map.Entry entry : this.tciIdsToRecordingFiles.entrySet()) {
            boolean success = ((TestCaseInfo)this.tciIdToTCIMap.get((Integer)entry.getKey())).isSuccess();
            Set pathsToCoverageFiles = (Set)entry.getValue();
            if (pathsToCoverageFiles.size() <= 0) continue;
            for (String pathToCoverageFile : pathsToCoverageFiles) {
                try {
                    CloverBitSet coverage = this.getCoverageFor(pathToCoverageFile);
                    int i = coverage.nextSetBit(0);
                    while (i >= 0) {
                        if (success) {
                            passOnlyCoverageMask.set(i);
                        }
                        if (coverageMask.get(i)) {
                            coverageNotUniqueMask.set(i);
                        } else {
                            coverageMask.set(i);
                        }
                        i = coverage.nextSetBit(i + 1);
                    }
                }
                catch (IOException e) {
                    Logger.getInstance().warn(String.format("Failed to load coverage file while calculating unique coverage mask: \"%s\"", pathToCoverageFile), e);
                }
            }
        }
        coverageNotUniqueMask.flip(0, coverageNotUniqueMask.size());
        this.coverageMask = coverageMask;
        this.uniqueCoverageMask = coverageNotUniqueMask;
        this.passOnlyCoverageMask = passOnlyCoverageMask;
    }

    private class FileInfoSample {
        private final int idx;
        private final int[] methodIdx;
        private final Set<TestCaseInfo> tcis;

        private FileInfoSample(int idx, int[] methodIdx) {
            this.idx = idx;
            this.methodIdx = methodIdx;
            this.tcis = Sets.newHashSet();
        }

        public void sample(TestCaseInfo tci, CloverBitSet coverage) {
            for (int idx : this.methodIdx) {
                if (!coverage.member(idx)) continue;
                this.tcis.add(tci);
            }
        }
    }
}

