/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.recorder.junit;

import com.atlassian.clover.Logger;
import com_atlassian_clover.JUnitParameterizedTestSniffer;
import com_atlassian_clover.TestNameSniffer;
import java.lang.reflect.Field;
import junit.runner.TestRunListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.runner.Description;
import org.junit.runner.notification.RunListener;

public class JUnitTestRunnerInterceptor
extends RunListener
implements TestRunListener {
    public void testStarted(Description description) throws Exception {
        JUnitParameterizedTestSniffer junitSniffer;
        Logger.getInstance().debug("JUnitTestRunnerInterceptor: JUnit test started: \"" + description.getDisplayName() + "\"");
        Class testClass = description.getTestClass();
        if (testClass != null && (junitSniffer = this.lookupTestSnifferField(testClass)) != null) {
            junitSniffer.testStarted(description);
        }
    }

    public void testFinished(Description description) throws Exception {
        JUnitParameterizedTestSniffer junitSniffer;
        Logger.getInstance().debug("JUnitTestRunnerInterceptor: JUnit test ended: \"" + description.getDisplayName() + "\"");
        Class testClass = description.getTestClass();
        if (testClass != null && (junitSniffer = this.lookupTestSnifferField(testClass)) != null) {
            junitSniffer.testFinished(description);
        }
    }

    public void testStarted(String testName) {
        JUnitParameterizedTestSniffer junitSniffer;
        Logger.getInstance().debug("JUnitTestRunnerInterceptor: JUnit test ended: \"" + testName + "\"");
        Class testClass = this.getTestClass(testName);
        if (testClass != null && (junitSniffer = this.lookupTestSnifferField(testClass)) != null) {
            junitSniffer.testStarted(testName);
        }
    }

    public void testEnded(String testName) {
        JUnitParameterizedTestSniffer junitSniffer;
        Logger.getInstance().debug("JUnitTestRunnerInterceptor: JUnit test ended: \"" + testName + "\"");
        Class testClass = this.getTestClass(testName);
        if (testClass != null && (junitSniffer = this.lookupTestSnifferField(testClass)) != null) {
            junitSniffer.testEnded(testName);
        }
    }

    @Nullable
    protected Class getTestClass(@NotNull String testName) {
        int classNameEnd = testName.lastIndexOf(".");
        if (classNameEnd > 0) {
            String className = testName.substring(0, classNameEnd);
            try {
                return Class.forName(className);
            }
            catch (ClassNotFoundException e) {
                Logger.getInstance().debug("Unable to find class '" + className + "'. Clover cannot inject the current test name into coverage recorder.");
            }
        } else {
            Logger.getInstance().debug("Unknown class name for a test. Clover cannot inject the current test name into coverage recorder");
        }
        return null;
    }

    @Nullable
    protected JUnitParameterizedTestSniffer lookupTestSnifferField(Class currentTestClass) {
        try {
            Field sniffer = currentTestClass.getField("__CLR4_0_6_TEST_NAME_SNIFFER");
            if (sniffer.getType().isAssignableFrom(TestNameSniffer.class)) {
                Object snifferObj = sniffer.get(null);
                if (snifferObj instanceof JUnitParameterizedTestSniffer) {
                    return (JUnitParameterizedTestSniffer)snifferObj;
                }
                return null;
            }
            Logger.getInstance().debug("Unexpected type of the __CLR4_0_6_TEST_NAME_SNIFFER field: " + sniffer.getType().getName() + " - ignoring. Test name found during instrumentation may differ from the actual name of the test at runtime.");
        }
        catch (NoSuchFieldException ex) {
            Logger.getInstance().debug("Field __CLR4_0_6_TEST_NAME_SNIFFER was not found in an instance of " + currentTestClass.getClass().getName() + ". Test name found during instrumentation may differ from the actual name of the test at runtime.", ex);
        }
        catch (SecurityException ex) {
            Logger.getInstance().debug("Field __CLR4_0_6_TEST_NAME_SNIFFER couldn't be accessed in an instance of " + currentTestClass.getClass().getName() + ". Test name found during instrumentation may differ from the actual name of the test at runtime.", ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getInstance().debug("Field __CLR4_0_6_TEST_NAME_SNIFFER couldn't be accessed in an instance of " + currentTestClass.getClass().getName() + ". Test name found during instrumentation may differ from the actual name of the test at runtime.", ex);
        }
        return null;
    }

    public void testRunStarted(String testSuiteName, int testCount) {
    }

    public void testRunEnded(long elapsedTime) {
    }

    public void testRunStopped(long elapsedTime) {
    }

    public void testFailed(int status, String testName, String trace) {
    }
}

