/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.recorder.spock;

import com.atlassian.clover.Logger;
import com_atlassian_clover.SpockFeatureNameSniffer;
import com_atlassian_clover.TestNameSniffer;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.jetbrains.annotations.Nullable;
import org.spockframework.runtime.extension.IMethodInterceptor;
import org.spockframework.runtime.extension.IMethodInvocation;

public class CloverSpockIterationInterceptor
implements IMethodInterceptor {
    public void intercept(IMethodInvocation invocation) throws Throwable {
        if (invocation.getIteration() != null) {
            Logger.getInstance().debug("CloverSpockIterationInterceptor: Spock is about to call: \"" + invocation.getFeature().getName() + "\" (" + ((Method)invocation.getFeature().getFeatureMethod().getReflection()).toString() + ")");
            SpockFeatureNameSniffer spockSniffer = this.lookupSpockSnifferField(invocation.getInstance());
            if (spockSniffer != null) {
                spockSniffer.intercept(invocation);
            }
        }
        invocation.proceed();
    }

    @Nullable
    protected SpockFeatureNameSniffer lookupSpockSnifferField(Object currentTestClass) {
        try {
            Field sniffer = currentTestClass.getClass().getField("__CLR4_0_6_TEST_NAME_SNIFFER");
            if (sniffer.getType().isAssignableFrom(TestNameSniffer.class)) {
                Object snifferObj = sniffer.get(null);
                if (snifferObj instanceof SpockFeatureNameSniffer) {
                    return (SpockFeatureNameSniffer)snifferObj;
                }
                return null;
            }
            Logger.getInstance().debug("Unexpected type of the __CLR4_0_6_TEST_NAME_SNIFFER field: " + sniffer.getType().getName() + " - ignoring. Test name found during instrumentation may differ from the actual name of the test at runtime.");
        }
        catch (NoSuchFieldException ex) {
            Logger.getInstance().debug("Field __CLR4_0_6_TEST_NAME_SNIFFER was not found in an instance of " + currentTestClass.getClass().getName() + ". Test name found during instrumentation may differ from the actual name of the test at runtime.", ex);
        }
        catch (SecurityException ex) {
            Logger.getInstance().debug("Field __CLR4_0_6_TEST_NAME_SNIFFER couldn't be accessed in an instance of " + currentTestClass.getClass().getName() + ". Test name found during instrumentation may differ from the actual name of the test at runtime.", ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getInstance().debug("Field __CLR4_0_6_TEST_NAME_SNIFFER couldn't be accessed in an instance of " + currentTestClass.getClass().getName() + ". Test name found during instrumentation may differ from the actual name of the test at runtime.", ex);
        }
        return null;
    }
}

