/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.registry.format;

import com.atlassian.clover.registry.RegistryFormatException;
import com.atlassian.clover.registry.format.CoverageSegment;
import com.atlassian.clover.registry.format.InstrSessionSegment;
import com.atlassian.clover.registry.format.LazyLoader;
import com.atlassian.clover.registry.format.LazyProxy;
import com.atlassian.clover.registry.format.RegistryLoadException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.util.Iterator;

public class RegContents {
    private final RandomAccessFile file;
    private final LazyProxy<CoverageSegment> coverageSegment;
    private final Iterator<InstrSessionSegment> sessionSegments;

    public RegContents(RandomAccessFile file, long coverageLocation, long lastSessionLocation, long minSessionPosition) {
        this.file = file;
        FileChannel channel = file.getChannel();
        this.coverageSegment = coverageLocation != -1L ? new LazyLoader<CoverageSegment>(channel, coverageLocation){

            @Override
            public CoverageSegment getImpl(FileChannel channel) throws IOException, RegistryFormatException {
                return new CoverageSegment(channel);
            }
        } : new LazyProxy.Preloaded<Object>(null);
        this.sessionSegments = new SessionIterator(channel, lastSessionLocation, minSessionPosition);
    }

    public CoverageSegment getCoverage() {
        return this.coverageSegment.get();
    }

    public Iterable<InstrSessionSegment> getSessions() {
        return new Iterable<InstrSessionSegment>(){

            @Override
            public Iterator<InstrSessionSegment> iterator() {
                return RegContents.this.sessionSegments;
            }
        };
    }

    public void close() throws IOException {
        this.file.close();
    }

    private static class SessionIterator
    implements Iterator<InstrSessionSegment> {
        private final FileChannel channel;
        private final long minSessionPosition;
        private long position;

        private SessionIterator(FileChannel channel, long position, long minSessionPosition) {
            this.channel = channel;
            this.minSessionPosition = minSessionPosition;
            this.position = position;
        }

        @Override
        public boolean hasNext() {
            return this.position > this.minSessionPosition;
        }

        @Override
        public InstrSessionSegment next() {
            try {
                this.channel.position(this.position);
                InstrSessionSegment segment = new InstrSessionSegment(this.channel);
                this.position = this.channel.position();
                return segment;
            }
            catch (IOException e) {
                throw new RegistryLoadException("IO error while loading instrumentation session", e);
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

