/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.reporters;

import clover.com.google.common.collect.Maps;
import com.atlassian.clover.Logger;
import com.atlassian.clover.reporters.Column;
import com.atlassian.clover.reporters.ReportStyle;
import com.atlassian.clover.reporters.html.HtmlReporter;
import com.atlassian.clover.util.Formatting;
import java.util.Map;

public interface ColumnFormat {
    public static final String PERCENTAGE = "%";
    public static final String PC = "pc";
    public static final String RAW = "raw";
    public static final String BAR = "bar";
    public static final String LONGBAR = "longbar";
    public static final String SHORTBAR = "shortbar";
    public static final String SORT_TYPE_NUMBER = "number";
    public static final String SORT_TYPE_ALPHA = "alpha";

    public String format(Column.ColumnData var1, ReportStyle var2);

    public Number formatNumber(Column.ColumnData var1);

    public String formatTitle(String var1);

    public String sortValue(Column.ColumnData var1);

    public String sortType();

    public int getColSpan();

    public boolean isWithinThreshold(Column.ColumnData var1, float var2, float var3);

    public static class LongBarGraphColumnFormat
    extends BarGraphColumnFormat {
        @Override
        int getBarSize() {
            return 200;
        }
    }

    public static class ShortBarGraphColumnFormat
    extends BarGraphColumnFormat {
        @Override
        int getBarSize() {
            return 40;
        }
    }

    public static abstract class BarGraphColumnFormat
    extends PercentageColumnFormat {
        @Override
        public String format(Column.ColumnData data, ReportStyle reportStyle) {
            try {
                return HtmlReporter.renderHtmlBarTable(this.toPcData(data).getPcValue(), this.getBarSize(), data.getCustomClass(), this.toPcData(data).getCustomPositiveClass(), this.toPcData(data).getCustomNegativeClass(), reportStyle);
            }
            catch (Exception e) {
                Logger.getInstance().warn("Error rendering bar graph.", e);
                return "-";
            }
        }

        @Override
        public String formatTitle(String name) {
            return name;
        }

        @Override
        public int getColSpan() {
            return 2;
        }

        abstract int getBarSize();
    }

    public static class PercentageColumnFormat
    extends FloatColumnFormat {
        @Override
        public String format(Column.ColumnData data, ReportStyle reportStyle) {
            return Formatting.getPercentStr(this.toPcData(data).getPcValue());
        }

        @Override
        public Number formatNumber(Column.ColumnData data) {
            return new Float(this.toPcData(data).getPcValue() * 100.0f);
        }

        @Override
        public String sortValue(Column.ColumnData data) {
            return Float.toString(this.toPcData(data).getPcValue());
        }

        @Override
        public String formatTitle(String name) {
            return "% " + name;
        }

        @Override
        public boolean isWithinThreshold(Column.ColumnData data, float min, float max) {
            float pcValue = this.toPcData(data).getPcValue() * 100.0f;
            return min <= pcValue && pcValue <= max;
        }

        Column.PcColumnData toPcData(Column.ColumnData data) {
            return (Column.PcColumnData)data;
        }
    }

    public static class FloatColumnFormat
    implements ColumnFormat {
        @Override
        public String format(Column.ColumnData data, ReportStyle reportStyle) {
            return Formatting.format2d(data.getValue());
        }

        @Override
        public Number formatNumber(Column.ColumnData data) {
            return new Float(data.getValue());
        }

        @Override
        public String formatTitle(String name) {
            return name;
        }

        @Override
        public String sortValue(Column.ColumnData data) {
            return Float.toString(data.getValue());
        }

        @Override
        public String sortType() {
            return ColumnFormat.SORT_TYPE_NUMBER;
        }

        @Override
        public int getColSpan() {
            return 1;
        }

        @Override
        public boolean isWithinThreshold(Column.ColumnData data, float min, float max) {
            return min <= data.getValue() && data.getValue() <= max;
        }
    }

    public static class ErrorColumnFormat
    implements ColumnFormat {
        private final String errorMsg;

        public ErrorColumnFormat(String msg) {
            this.errorMsg = msg;
        }

        @Override
        public String format(Column.ColumnData data, ReportStyle reportStyle) {
            return this.errorMsg;
        }

        @Override
        public Number formatNumber(Column.ColumnData data) {
            return new Integer(-1);
        }

        @Override
        public String formatTitle(String name) {
            return name;
        }

        @Override
        public String sortValue(Column.ColumnData data) {
            return "-";
        }

        @Override
        public String sortType() {
            return "";
        }

        @Override
        public int getColSpan() {
            return 1;
        }

        @Override
        public boolean isWithinThreshold(Column.ColumnData data, float min, float max) {
            return true;
        }
    }

    public static class IntColumnFormat
    extends FloatColumnFormat {
        @Override
        public String format(Column.ColumnData data, ReportStyle reportStyle) {
            return Formatting.formatInt((int)data.getValue());
        }

        @Override
        public Number formatNumber(Column.ColumnData data) {
            return new Integer((int)data.getValue());
        }
    }

    public static class Factory {
        private static final Map<String, ColumnFormat> FORMATS = Maps.newHashMap();

        static ColumnFormat createFormat(String format) {
            return FORMATS.containsKey(format) ? FORMATS.get(format) : new PercentageColumnFormat();
        }

        static {
            FORMATS.put(ColumnFormat.RAW, new FloatColumnFormat());
            FORMATS.put(ColumnFormat.BAR, new ShortBarGraphColumnFormat());
            FORMATS.put(ColumnFormat.SHORTBAR, new ShortBarGraphColumnFormat());
            FORMATS.put(ColumnFormat.LONGBAR, new LongBarGraphColumnFormat());
            FORMATS.put(ColumnFormat.PC, new PercentageColumnFormat());
            FORMATS.put(ColumnFormat.PERCENTAGE, new PercentageColumnFormat());
        }
    }
}

