/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.reporters.html;

import clover.com.google.common.collect.Lists;
import clover.com.google.common.collect.Maps;
import com.atlassian.clover.Logger;
import com.atlassian.clover.api.registry.ClassInfo;
import com.atlassian.clover.api.registry.MethodInfo;
import com.atlassian.clover.registry.entities.FullClassInfo;
import com.atlassian.clover.registry.entities.FullFileInfo;
import com.atlassian.clover.registry.entities.TestCaseInfo;
import com.atlassian.clover.reporters.json.JSONException;
import com.atlassian.clover.reporters.json.JSONObject;
import com.atlassian.clover.spi.reporters.html.source.LineRenderInfo;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class JSONObjectFactory {
    public static JSONObject getJSONTestTargets(Map<TestCaseInfo, BitSet> targetMethods, Map<TestCaseInfo, BitSet> targetElements) throws JSONException {
        JSONObject jsonTestTargets = new JSONObject();
        for (TestCaseInfo testcase : targetMethods.keySet()) {
            BitSet methodSet = targetMethods.get(testcase);
            BitSet elementSet = targetElements.get(testcase);
            HashMap<String, Object> test = Maps.newHashMap();
            test.put("pass", testcase.isSuccess());
            test.put("name", testcase.getTestName());
            ArrayList methods = Lists.newArrayList();
            int i = methodSet.nextSetBit(0);
            while (i >= 0) {
                HashMap<String, Integer> method = Maps.newHashMap();
                method.put("sl", new Integer(i));
                methods.add(method);
                i = methodSet.nextSetBit(i + 1);
            }
            test.put("methods", methods);
            ArrayList statements = Lists.newArrayList();
            if (elementSet != null) {
                int i2 = elementSet.nextSetBit(0);
                while (i2 >= 0) {
                    HashMap<String, Integer> statement = Maps.newHashMap();
                    statement.put("sl", new Integer(i2));
                    statements.add(statement);
                    i2 = elementSet.nextSetBit(i2 + 1);
                }
            }
            test.put("statements", statements);
            jsonTestTargets.put("test_" + testcase.getId(), test);
        }
        return jsonTestTargets;
    }

    public static JSONObject getJSONPageData(FullFileInfo fileInfo) throws JSONException {
        JSONObject jsonPageData = new JSONObject();
        ArrayList classList = Lists.newArrayList();
        for (ClassInfo classInfo : fileInfo.getClasses()) {
            FullClassInfo classInfo2 = (FullClassInfo)classInfo;
            HashMap<String, Object> classMap = Maps.newHashMap();
            classMap.put("id", new Integer(classInfo2.getDataIndex()));
            classMap.put("sl", new Integer(classInfo2.getStartLine()));
            classMap.put("el", new Integer(classInfo2.getEndLine()));
            classMap.put("name", classInfo2.getName());
            ArrayList methods = Lists.newArrayList();
            for (MethodInfo methodInfo : classInfo2.getMethods()) {
                HashMap<String, Integer> method = Maps.newHashMap();
                method.put("sl", new Integer(methodInfo.getStartLine()));
                method.put("el", new Integer(methodInfo.getEndLine()));
                method.put("sc", new Integer(methodInfo.getStartColumn()));
                methods.add(method);
            }
            classMap.put("methods", methods);
            classList.add(classMap);
        }
        jsonPageData.put("classes", classList);
        return jsonPageData;
    }

    public static List<List<Integer>> getJSONSrcFileLines(LineRenderInfo[] renderInfos, String name) {
        ArrayList<List<Integer>> srcFileLines = Lists.newArrayList();
        ArrayList<Integer> srcFileLine = Lists.newArrayList();
        srcFileLines.add(srcFileLine);
        for (LineRenderInfo info : renderInfos) {
            srcFileLine = Lists.newArrayList();
            if (info == null) {
                Logger.getInstance().debug("LineRenderInfo is null for file '" + name + "'.");
                continue;
            }
            List<TestCaseInfo> testHits = info.getTestHits();
            if (testHits == null) {
                Logger.getInstance().debug("testHits is null for file '" + name + "'.");
                continue;
            }
            for (TestCaseInfo testHit : testHits) {
                srcFileLine.add(testHit.getId());
            }
            srcFileLines.add(srcFileLine);
        }
        return srcFileLines;
    }
}

