/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.reporters.html;

import clover.com.google.common.collect.Lists;
import clover.org.apache.velocity.VelocityContext;
import com.atlassian.clover.api.registry.ClassInfo;
import com.atlassian.clover.api.registry.PackageInfo;
import com.atlassian.clover.registry.entities.BaseClassInfo;
import com.atlassian.clover.registry.entities.FullProjectInfo;
import com.atlassian.clover.registry.metrics.HasMetricsSupport;
import com.atlassian.clover.reporters.Columns;
import com.atlassian.clover.reporters.Current;
import com.atlassian.clover.reporters.MetricsCollator;
import com.atlassian.clover.reporters.html.ClassInfoStatsCalculator;
import com.atlassian.clover.reporters.html.HtmlReportUtil;
import com.atlassian.clover.reporters.html.OrderedCalculatorComparator;
import com.atlassian.clover.reporters.html.StatisticsClassInfoVisitor;
import com.atlassian.clover.reporters.html.TestClassCoverageThresholdFilter;
import com.atlassian.clover.reporters.html.TestClassFilter;
import com.atlassian.clover.reporters.json.RenderTreeMapAction;
import com.atlassian.clover.reporters.util.CloverChartFactory;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;

public class RenderDashboardAction
implements Callable {
    private static final int DBRD_PROJECT_RISKS_COUNT = 20;
    private static final int DBRD_TOP_N_COUNT = 5;
    private final File mBasePath;
    private final FullProjectInfo mConfiguredInfo;
    private final FullProjectInfo mProjectInfo;
    private final VelocityContext mContext;
    private final CloverChartFactory.ChartInfo mHistogram;
    private final CloverChartFactory.ChartInfo mScatter;
    private final Current reportConfig;

    public RenderDashboardAction(VelocityContext ctx, File basePath, FullProjectInfo configured, FullProjectInfo full, CloverChartFactory.ChartInfo histogram, CloverChartFactory.ChartInfo scatter, Current reportConfig) {
        this.mBasePath = basePath;
        this.mConfiguredInfo = configured;
        this.mProjectInfo = full;
        this.mContext = ctx;
        this.mHistogram = histogram;
        this.mScatter = scatter;
        this.reportConfig = reportConfig;
    }

    public Object call() throws Exception {
        File outfile = this.insertDashboardProperties();
        HtmlReportUtil.mergeTemplateToFile(outfile, this.mContext, this.reportConfig.getFormat().getReportStyle(), "dashboard.vm");
        return null;
    }

    protected File insertDashboardProperties() throws Exception {
        if (Boolean.TRUE != this.mContext.get("skipCoverageTreeMap")) {
            RenderTreeMapAction tree = new RenderTreeMapAction(new VelocityContext(), this.reportConfig, this.mBasePath, this.mConfiguredInfo);
            tree.renderTreeMapJson("treemap-dash-json.js", "processTreeMapDashJson", false);
        }
        List<? extends BaseClassInfo> classes = this.mConfiguredInfo.getClasses(new TestClassCoverageThresholdFilter());
        ClassInfoStatsCalculator.AvgMethodComplexityCalculator avgMethodCmpCalculator = new ClassInfoStatsCalculator.AvgMethodComplexityCalculator();
        ClassInfoStatsCalculator.PcCoveredElementsCalculator pcCoveredEleCalculator = new ClassInfoStatsCalculator.PcCoveredElementsCalculator();
        ClassInfoStatsCalculator.ElementCountCalculator eleCountCalculator = new ClassInfoStatsCalculator.ElementCountCalculator();
        ArrayList<BaseClassInfo> amcOrder = Lists.newArrayList(classes);
        Collections.sort(amcOrder, new OrderedCalculatorComparator(new ClassInfoStatsCalculator[]{avgMethodCmpCalculator, pcCoveredEleCalculator, eleCountCalculator}));
        ArrayList<BaseClassInfo> pceOrder = Lists.newArrayList(classes);
        Collections.sort(pceOrder, new OrderedCalculatorComparator(new ClassInfoStatsCalculator[]{pcCoveredEleCalculator, avgMethodCmpCalculator, eleCountCalculator}));
        StatisticsClassInfoVisitor amcVisitor = StatisticsClassInfoVisitor.visit(amcOrder, avgMethodCmpCalculator);
        StatisticsClassInfoVisitor pceVisitor = StatisticsClassInfoVisitor.visit(pceOrder, pcCoveredEleCalculator);
        MetricsCollator collator = new MetricsCollator();
        Map<Integer, List<ClassInfo>> classMap = collator.rankProjectRisks(pceOrder, amcOrder);
        List topRisks = collator.getTopRisks(classMap, 20);
        Columns.TotalPercentageCovered tpc = new Columns.TotalPercentageCovered();
        tpc.setFormat("longbar");
        this.mContext.put("tpcColumn", tpc);
        this.mContext.put("hasResults", this.mProjectInfo.hasTestResults());
        this.mContext.put("appPagePresent", Boolean.TRUE);
        this.mContext.put("testPagePresent", Boolean.TRUE);
        this.mContext.put("projectInfo", this.mProjectInfo);
        this.mContext.put("headerMetrics", this.mConfiguredInfo.getMetrics());
        this.mContext.put("headerMetricsRaw", this.mConfiguredInfo.getRawMetrics());
        HtmlReportUtil.addFilteredPercentageToContext(this.mContext, this.mProjectInfo);
        List<? extends PackageInfo> packages = this.mConfiguredInfo.getAllPackages();
        List complexPkgs = collator.getTopOfList(packages, 5, HasMetricsSupport.CMP_COMPLEXITY);
        this.mContext.put("complexPkgs", complexPkgs);
        List<? extends BaseClassInfo> allClasses = this.mConfiguredInfo.getClasses(new TestClassFilter());
        List complexClasses = collator.getTopOfList(allClasses, 5, HasMetricsSupport.CMP_COMPLEXITY);
        this.mContext.put("complexClasses", complexClasses);
        this.mContext.put("leastTestedMethods", collator.getLeastTestedMethods(classes, this.reportConfig.isShowLambdaFunctions(), this.reportConfig.isShowInnerFunctions()));
        String filename = "dashboard.html";
        File outfile = new File(this.mBasePath, filename);
        this.mContext.put("currentPageURL", filename);
        this.mContext.put("topRisks", topRisks);
        this.mContext.put("axisColor", pceVisitor);
        this.mContext.put("axisSize", amcVisitor);
        this.mContext.put("chartInfoHistogram", this.mHistogram);
        this.mContext.put("chartInfoScatter", this.mScatter);
        return outfile;
    }
}

