/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.reporters.html;

import clover.org.apache.velocity.VelocityContext;
import com.atlassian.clover.registry.entities.FullPackageInfo;
import com.atlassian.clover.registry.metrics.HasMetricsSupport;
import com.atlassian.clover.reporters.CloverReportConfig;
import com.atlassian.clover.reporters.ReportStyle;
import com.atlassian.clover.reporters.html.ClassInfoStatsCalculator;
import com.atlassian.clover.reporters.html.HtmlReportUtil;
import com.atlassian.clover.reporters.html.HtmlReporter;
import com.atlassian.clover.reporters.html.RenderCoverageCloudAction;
import com.atlassian.clover.reporters.html.TabInfo;
import com.atlassian.clover.util.CloverUtils;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class RenderPackageCoverageCloudAction
extends RenderCoverageCloudAction {
    private List childAndDescendantClasses;
    private FullPackageInfo pkg;
    private final boolean appPagePresent;
    private final boolean testPagePresent;

    public RenderPackageCoverageCloudAction(VelocityContext context, CloverReportConfig reportConfig, File basePath, HtmlReporter.TreeInfo tree, FullPackageInfo pkg, boolean appPagePresent, boolean testPagePresent) {
        super(context, reportConfig, tree, RenderPackageCoverageCloudAction.sortedClassesFor(pkg), basePath);
        this.pkg = pkg;
        this.childAndDescendantClasses = this.sortedChildrenAndDescendantClassesFor(pkg);
        this.appPagePresent = appPagePresent;
        this.testPagePresent = testPagePresent;
    }

    private List sortedChildrenAndDescendantClassesFor(FullPackageInfo pkg) {
        return RenderPackageCoverageCloudAction.sortClasses(pkg.getClassesIncludingSubPackages(), HasMetricsSupport.CMP_LEX);
    }

    private static List sortClasses(List classes, Comparator comparator) {
        if (classes != null) {
            Collections.sort(classes, comparator);
        }
        return classes;
    }

    private static List sortedClassesFor(FullPackageInfo pkg) {
        return RenderPackageCoverageCloudAction.sortClasses(pkg.getClasses(), HasMetricsSupport.CMP_LEX);
    }

    @Override
    protected File createOutputDir() throws IOException {
        return CloverUtils.createOutDir(this.pkg, this.basePath);
    }

    @Override
    protected TabInfo createRisksTab() {
        return new TabInfo("Top Risks", this.reportConfig.getFormat().getReportStyle() == ReportStyle.CLASSIC ? "pkg-risks.html" : "top-risks.html", "help_pkg_risks");
    }

    @Override
    protected void applySpecificProperties() {
        this.context.put("packageInfo", this.pkg);
        this.context.put("packageName", this.pkg.getName());
        this.context.put("headerMetrics", this.pkg.getMetrics());
        this.context.put("headerMetricsRaw", this.pkg.getRawMetrics());
        this.context.put("classlist", this.classes);
        this.context.put("appPagePresent", this.appPagePresent);
        this.context.put("testPagePresent", this.testPagePresent);
        this.context.put("topLevel", Boolean.FALSE);
        HtmlReportUtil.addFilteredPercentageToContext(this.context, this.pkg);
    }

    @Override
    protected void applyAxies(ClassInfoStatsCalculator axis1, ClassInfoStatsCalculator axis2) {
        this.applyAxis("shallow", axis1, axis2, this.classes);
        if (this.classes.size() < this.childAndDescendantClasses.size()) {
            this.context.put("showCloudDepthToggle", Boolean.TRUE);
            this.applyAxis("deep", axis1, axis2, this.childAndDescendantClasses);
        }
    }
}

