/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.reporters.json;

import clover.org.apache.commons.lang3.ArrayUtils;
import clover.org.apache.velocity.VelocityContext;
import com.atlassian.clover.Logger;
import com.atlassian.clover.api.CloverException;
import com.atlassian.clover.api.registry.FileInfo;
import com.atlassian.clover.api.registry.PackageInfo;
import com.atlassian.clover.cfg.Interval;
import com.atlassian.clover.registry.entities.FullFileInfo;
import com.atlassian.clover.registry.entities.FullPackageInfo;
import com.atlassian.clover.registry.entities.FullProjectInfo;
import com.atlassian.clover.reporters.CloverReportConfig;
import com.atlassian.clover.reporters.CloverReporter;
import com.atlassian.clover.reporters.CommandLineArgProcessors;
import com.atlassian.clover.reporters.Current;
import com.atlassian.clover.reporters.Format;
import com.atlassian.clover.reporters.html.HtmlRenderingSupportImpl;
import com.atlassian.clover.reporters.json.RenderCloudsJSONAction;
import com.atlassian.clover.reporters.json.RenderColophonJSONAction;
import com.atlassian.clover.reporters.json.RenderFileJSONAction;
import com.atlassian.clover.reporters.json.RenderMetricsJSONAction;
import com.atlassian.clover.util.CloverExecutor;
import com.atlassian.clover.util.CloverExecutors;
import com.atlassian.clover.util.CloverUtils;
import java.io.File;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class JSONReporter
extends CloverReporter {
    static final CommandLineArgProcessors.ArgProcessor[] mandatoryArgProcessors = new CommandLineArgProcessors.ArgProcessor[]{CommandLineArgProcessors.InitString, CommandLineArgProcessors.OutputDirJson};
    static final CommandLineArgProcessors.ArgProcessor[] optionalArgProcessors = new CommandLineArgProcessors.ArgProcessor[]{CommandLineArgProcessors.AlwaysReport, CommandLineArgProcessors.DebugLogging, CommandLineArgProcessors.IncludeFailedTestCoverage, CommandLineArgProcessors.ShowInnerFunctions, CommandLineArgProcessors.ShowLambdaFunctions, CommandLineArgProcessors.ThreadCount, CommandLineArgProcessors.VerboseLogging};
    static final CommandLineArgProcessors.ArgProcessor[] allArgProcessors = ArrayUtils.addAll(mandatoryArgProcessors, optionalArgProcessors);
    private final HtmlRenderingSupportImpl renderingHelper;
    private final File basePath;

    public JSONReporter(CloverReportConfig config) throws CloverException {
        super(config);
        this.renderingHelper = new HtmlRenderingSupportImpl(config.getFormat(), true);
        this.basePath = config.getOutFile();
    }

    @Override
    protected long getPerms() {
        return 8L;
    }

    private Current getConfigAsCurrent() {
        return (Current)this.reportConfig;
    }

    @Override
    public int executeImpl() throws CloverException {
        long currentStartTime = System.currentTimeMillis();
        FullProjectInfo projectInfo = this.database.getAppOnlyModel();
        projectInfo.buildCaches();
        List<? extends PackageInfo> allPackages = projectInfo.getAllPackages();
        try {
            CloverUtils.createDir(this.basePath);
            CloverExecutor service = CloverExecutors.newCloverExecutor(this.getConfigAsCurrent().getNumThreads(), "Clover-JSON");
            Logger.getInstance().info("Generating JSON report to: " + this.getConfigAsCurrent().getOutFile().getAbsolutePath());
            RenderFileJSONAction.initThreadLocals();
            RenderMetricsJSONAction.initThreadLocals();
            service.submit(new RenderColophonJSONAction(new VelocityContext(), new File(this.getConfigAsCurrent().getOutFile(), "colophon.js"), this.getConfigAsCurrent()));
            service.submit(new RenderMetricsJSONAction(new VelocityContext(), projectInfo, this.getConfigAsCurrent(), new File(this.getConfigAsCurrent().getOutFile(), "project.js"), this.renderingHelper));
            service.submit(new RenderCloudsJSONAction.ForProjects.OfTheirRisks(projectInfo, new VelocityContext(), this.getConfigAsCurrent(), this.getConfigAsCurrent().getOutFile()));
            service.submit(new RenderCloudsJSONAction.ForProjects.OfTheirQuickWins(projectInfo, new VelocityContext(), this.getConfigAsCurrent(), this.getConfigAsCurrent().getOutFile()));
            for (PackageInfo packageInfo : allPackages) {
                FullPackageInfo pkg = (FullPackageInfo)packageInfo;
                Logger.getInstance().verbose("Processing package " + pkg.getName());
                long start = System.currentTimeMillis();
                this.processPackage(pkg, service);
                long total = System.currentTimeMillis() - start;
                if (!Logger.isDebug()) continue;
                Logger.getInstance().debug("Processed package: " + pkg.getName() + " (" + pkg.getClasses().size() + " classes, " + pkg.getMetrics().getNumTests() + " tests)" + " in " + total + "ms");
            }
            service.shutdown();
            Interval timeOut = this.getConfigAsCurrent().getTimeOut();
            if (!service.awaitTermination(timeOut.getValueInMillis(), TimeUnit.MILLISECONDS)) {
                throw new CloverException("Timout of '" + timeOut + "' reached during report generation. " + "Please increase this value and try again.");
            }
        }
        catch (Exception e) {
            throw new CloverException(e);
        }
        finally {
            RenderFileJSONAction.resetThreadLocals();
            RenderMetricsJSONAction.resetThreadLocals();
        }
        long currentTotalTime = System.currentTimeMillis() - currentStartTime;
        int n = allPackages.size();
        long msPerPkg = n == 0 ? currentTotalTime : currentTotalTime / (long)n;
        Logger.getInstance().info("Done. Processed " + n + " packages in " + currentTotalTime + "ms (" + msPerPkg + "ms per package).");
        return 0;
    }

    private void processPackage(FullPackageInfo pkg, CloverExecutor service) throws Exception {
        List<? extends FileInfo> files = pkg.getFiles();
        FullProjectInfo projectInfo = this.database.getFullModel();
        projectInfo.buildCaches();
        File basedir = CloverUtils.createOutDir(pkg, this.getConfigAsCurrent().getOutFile());
        File outfile = new File(basedir, "package.js");
        service.submit(new RenderMetricsJSONAction(new VelocityContext(), pkg, this.getConfigAsCurrent(), outfile, this.renderingHelper));
        service.submit(new RenderCloudsJSONAction.ForPackages.OfTheirRisks(new VelocityContext(), pkg, this.getConfigAsCurrent(), basedir, true));
        service.submit(new RenderCloudsJSONAction.ForPackages.OfTheirRisks(new VelocityContext(), pkg, this.getConfigAsCurrent(), basedir, false));
        service.submit(new RenderCloudsJSONAction.ForPackages.OfTheirQuickWins(new VelocityContext(), pkg, this.getConfigAsCurrent(), basedir, true));
        service.submit(new RenderCloudsJSONAction.ForPackages.OfTheirQuickWins(new VelocityContext(), pkg, this.getConfigAsCurrent(), basedir, false));
        for (FileInfo fileInfo : files) {
            service.submit(new RenderFileJSONAction((FullFileInfo)fileInfo, this.renderingHelper, this.getConfigAsCurrent(), new VelocityContext(), this.database, projectInfo));
        }
    }

    public static void main(String[] args) {
        JSONReporter.loadLicense();
        System.exit(JSONReporter.runReport(args));
    }

    public static int runReport(String[] args) {
        Current config = JSONReporter.processArgs(args);
        if (JSONReporter.canProceedWithReporting(config)) {
            try {
                return new JSONReporter(config).execute();
            }
            catch (Exception e) {
                Logger.getInstance().error("A problem was encountered while rendering the report: " + e.getMessage(), e);
            }
        }
        return 1;
    }

    private static void usage(String msg) {
        System.err.println();
        if (msg != null) {
            System.err.println("  *** ERROR: " + msg);
        }
        System.err.println();
        System.err.println(JSONReporter.buildHelp(JSONReporter.class.getName(), mandatoryArgProcessors, optionalArgProcessors));
        System.err.println();
    }

    public static Current processArgs(String[] args) {
        Current cfg = new Current();
        cfg.setFormat(Format.DEFAULT_JSON);
        try {
            for (int i = 0; i < args.length; ++i) {
                for (CommandLineArgProcessors.ArgProcessor argProcessor : allArgProcessors) {
                    if (!argProcessor.matches(args, i)) continue;
                    i = argProcessor.process(args, i, cfg);
                }
            }
            if (!cfg.validate()) {
                JSONReporter.usage(cfg.getValidationFailureReason());
                return null;
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            JSONReporter.usage("Missing a parameter.");
            return null;
        }
        return cfg;
    }
}

