/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.reporters.json;

import clover.org.apache.velocity.VelocityContext;
import com.atlassian.clover.registry.entities.BaseClassInfo;
import com.atlassian.clover.registry.entities.FullClassInfo;
import com.atlassian.clover.registry.entities.FullPackageInfo;
import com.atlassian.clover.registry.entities.FullProjectInfo;
import com.atlassian.clover.registry.metrics.HasMetricsFilter;
import com.atlassian.clover.registry.metrics.HasMetricsSupport;
import com.atlassian.clover.reporters.CloverReportConfig;
import com.atlassian.clover.reporters.html.ClassInfoStatsCalculator;
import com.atlassian.clover.reporters.html.HtmlReportUtil;
import com.atlassian.clover.reporters.html.StatisticsClassInfoVisitor;
import com.atlassian.clover.reporters.json.JSONArray;
import com.atlassian.clover.reporters.json.JSONException;
import com.atlassian.clover.reporters.json.JSONObject;
import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;

public abstract class RenderCloudsJSONAction
implements Callable {
    public static final String AGGREGATE_PREFIX = "aggregate-";
    public static final String PROJECT_RISKS_FILE_NAME = "proj-risks.js";
    public static final String PACKAGE_RISKS_FILE_NAME = "pkg-risks.js";
    public static final String QUICK_WINS_FILE_NAME = "quick-wins.js";
    protected final File dir;
    protected final CloverReportConfig cfg;
    protected final VelocityContext ctx;
    protected final boolean aggregate;

    public RenderCloudsJSONAction(VelocityContext ctx, CloverReportConfig cfg, File dir, boolean aggregate) {
        this.cfg = cfg;
        this.dir = dir;
        this.ctx = ctx;
        this.aggregate = aggregate;
    }

    public Object call() throws Exception {
        return Void.TYPE;
    }

    protected void apply(File dir, String fileName, String pageTitle, List deepClasses, ClassInfoStatsCalculator axis1, ClassInfoStatsCalculator axis2) throws Exception {
        JSONObject json = new JSONObject();
        this.applyAxis(deepClasses, axis1, axis2, json);
        this.ctx.put("json", json);
        this.ctx.put("callback", this.cfg.getFormat().getCallback());
        HtmlReportUtil.mergeTemplateToFile(new File(dir, fileName), this.ctx, this.cfg.getFormat().getReportStyle(), "api-json.vm");
    }

    protected void applyAxis(List classes, ClassInfoStatsCalculator axis1, ClassInfoStatsCalculator axis2, JSONObject json) throws JSONException {
        StatisticsClassInfoVisitor v2 = StatisticsClassInfoVisitor.visit(this.sort(classes), axis2);
        StatisticsClassInfoVisitor v1 = StatisticsClassInfoVisitor.visit(v2.getClasses(), axis1);
        json.put("axis", new JSONObject().put("x", new JSONObject().put("title", axis1.getName()).put("min", v1.getMin()).put("max", v1.getMax())).put("y", new JSONObject().put("title", axis2.getName()).put("min", v2.getMin()).put("max", v2.getMax())));
        JSONArray jsonClasses = new JSONArray();
        for (BaseClassInfo baseClassInfo : v1.getClasses()) {
            FullClassInfo classInfo = (FullClassInfo)baseClassInfo;
            String path = classInfo.getContainingFile().getPackagePath();
            jsonClasses.put(new JSONObject().put("name", classInfo.getName()).put("path", path.substring(0, path.length() - ".java".length())).put("x", axis1.getScaledValue(classInfo)).put("y", axis2.getScaledValue(classInfo)));
        }
        json.put("classes", jsonClasses);
    }

    protected List sort(List classes) {
        Collections.sort(classes, HasMetricsSupport.CMP_LEX);
        return classes;
    }

    public static abstract class ForPackages
    extends RenderCloudsJSONAction {
        protected final FullPackageInfo pkg;

        protected ForPackages(VelocityContext ctx, FullPackageInfo pkg, CloverReportConfig cfg, File dir, boolean aggregate) {
            super(ctx, cfg, dir, aggregate);
            this.pkg = pkg;
        }

        public static class OfTheirQuickWins
        extends ForPackages {
            public OfTheirQuickWins(VelocityContext ctx, FullPackageInfo pkg, CloverReportConfig cfg, File dir, boolean aggregate) {
                super(ctx, pkg, cfg, dir, aggregate);
            }

            @Override
            public Object call() throws Exception {
                this.apply(this.dir, (this.aggregate ? RenderCloudsJSONAction.AGGREGATE_PREFIX : "") + RenderCloudsJSONAction.QUICK_WINS_FILE_NAME, "Quick Wins", this.aggregate ? this.pkg.getAllClassesIncludingSubPackages() : this.pkg.getClasses(), new ClassInfoStatsCalculator.ElementCountCalculator(), new ClassInfoStatsCalculator.CoveredElementsCalculator());
                return super.call();
            }
        }

        public static class OfTheirRisks
        extends ForPackages {
            public OfTheirRisks(VelocityContext ctx, FullPackageInfo pkg, CloverReportConfig cfg, File dir, boolean aggregate) {
                super(ctx, pkg, cfg, dir, aggregate);
            }

            @Override
            public Object call() throws Exception {
                this.apply(this.dir, (this.aggregate ? RenderCloudsJSONAction.AGGREGATE_PREFIX : "") + RenderCloudsJSONAction.PACKAGE_RISKS_FILE_NAME, "Package Risks", this.aggregate ? this.pkg.getClassesIncludingSubPackages() : this.pkg.getClasses(), new ClassInfoStatsCalculator.AvgMethodComplexityCalculator(), new ClassInfoStatsCalculator.PcCoveredElementsCalculator());
                return super.call();
            }
        }
    }

    public static abstract class ForProjects
    extends RenderCloudsJSONAction {
        protected final FullProjectInfo project;

        protected ForProjects(FullProjectInfo project, VelocityContext ctx, CloverReportConfig cfg, File dir) {
            super(ctx, cfg, dir, false);
            this.project = project;
        }

        public static class OfTheirQuickWins
        extends ForProjects {
            public OfTheirQuickWins(FullProjectInfo project, VelocityContext ctx, CloverReportConfig cfg, File dir) {
                super(project, ctx, cfg, dir);
            }

            @Override
            public Object call() throws Exception {
                this.apply(this.dir, RenderCloudsJSONAction.QUICK_WINS_FILE_NAME, "Quick Wins", this.project.getClasses(HasMetricsFilter.ACCEPT_ALL), new ClassInfoStatsCalculator.ElementCountCalculator(), new ClassInfoStatsCalculator.CoveredElementsCalculator());
                return super.call();
            }
        }

        public static class OfTheirRisks
        extends ForProjects {
            public OfTheirRisks(FullProjectInfo project, VelocityContext ctx, CloverReportConfig cfg, File dir) {
                super(project, ctx, cfg, dir);
            }

            @Override
            public Object call() throws Exception {
                this.apply(this.dir, RenderCloudsJSONAction.PROJECT_RISKS_FILE_NAME, "Project Risks", this.project.getClasses(HasMetricsFilter.ACCEPT_ALL), new ClassInfoStatsCalculator.AvgMethodComplexityCalculator(), new ClassInfoStatsCalculator.PcCoveredElementsCalculator());
                return super.call();
            }
        }
    }
}

