/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.reporters.util;

import clover.com.google.common.collect.Lists;
import com.atlassian.clover.Logger;
import com.atlassian.clover.api.CloverException;
import com.atlassian.clover.api.registry.HasMetrics;
import com.atlassian.clover.cfg.Interval;
import com.atlassian.clover.cfg.Percentage;
import com.atlassian.clover.reporters.CloverReportConfig;
import com.atlassian.clover.reporters.Column;
import com.atlassian.clover.reporters.ColumnFormat;
import com.atlassian.clover.reporters.Historical;
import com.atlassian.clover.reporters.util.HistoricalSupport;
import com.atlassian.clover.reporters.util.MetricsDiffSummary;
import com.atlassian.clover.util.FileUtils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.SortedMap;

public class HistoricalReportDescriptor {
    private final Logger log = Logger.getInstance();
    private Historical histCfg;
    private SortedMap<Long, HasMetrics> models;
    private List<MoversDescriptor> moversDescriptors;
    private List<AddedDescriptor> addedDescriptors;
    private HasMetrics subjectMetrics;
    private Long firstTS;
    private Long lastTS;
    private boolean enoughForMovers;

    public HistoricalReportDescriptor(CloverReportConfig cfg) throws CloverException, IOException {
        this.histCfg = (Historical)cfg;
        if (this.histCfg == null) {
            throw new CloverException("Invalid report config");
        }
        this.moversDescriptors = new ArrayList<MoversDescriptor>(this.histCfg.getMovers().size());
        this.addedDescriptors = new ArrayList<AddedDescriptor>(this.histCfg.getAdded().size());
    }

    public boolean gatherHistoricalModels() throws CloverException, IOException {
        File[] historyFiles = this.histCfg.getHistoryFiles();
        if (historyFiles == null) {
            historyFiles = FileUtils.listMatchingFilesForDir(this.histCfg.getHistoryDir(), "clover-.*.xml.gz");
        }
        this.models = this.isPackageLevel() ? HistoricalSupport.getPackageMetricsForRange(this.getPackage(), historyFiles, this.histCfg.getFromTS().getTime(), this.histCfg.getToTS().getTime()) : HistoricalSupport.getProjectMetricsForRange(historyFiles, this.histCfg.getFromTS().getTime(), this.histCfg.getToTS().getTime());
        int numts = this.models.keySet().size();
        if (numts == 0) {
            Logger.getInstance().debug("No historical data found. No report can be generated.");
            return false;
        }
        this.enoughForMovers = numts > 1;
        this.firstTS = this.models.firstKey();
        this.lastTS = this.models.lastKey();
        try {
            this.subjectMetrics = HistoricalSupport.getFullMetrics((HistoricalSupport.HasMetricsWrapper)this.models.get(this.lastTS), this.getPackage());
            if (this.showMovers()) {
                for (Historical.Movers movers : this.histCfg.getMovers()) {
                    MoversDescriptor moversDescriptor = new MoversDescriptor(movers);
                    moversDescriptor.gatherMovers();
                    this.moversDescriptors.add(moversDescriptor);
                }
                for (Historical.Added added : this.histCfg.getAdded()) {
                    AddedDescriptor addedDescriptor = new AddedDescriptor(added);
                    addedDescriptor.gatherMovers();
                    this.addedDescriptors.add(addedDescriptor);
                }
            }
            return true;
        }
        catch (Exception e) {
            String msg = "An error occured reading historical data (" + e.getClass().getName() + ":" + e.getMessage() + ")";
            Logger.getInstance().debug(msg, e);
            e.printStackTrace();
            return false;
        }
    }

    public boolean showOverview() {
        return this.histCfg.getOverview() != null;
    }

    public boolean showMovers() {
        return this.enoughForMovers && this.histCfg.getMovers().size() > 0;
    }

    public boolean isPackageLevel() {
        return this.getPackage() != null;
    }

    public String getPackage() {
        return this.histCfg.getPackage();
    }

    public String getSubjectName() {
        if (this.isPackageLevel()) {
            return this.subjectMetrics.getName();
        }
        return "";
    }

    public String getSubjectType() {
        if (this.isPackageLevel()) {
            return "Package";
        }
        return "Project";
    }

    public HasMetrics getSubjectMetrics() {
        return this.subjectMetrics;
    }

    public long getFirstTimestamp() {
        return this.firstTS;
    }

    public long getLastTimestamp() {
        return this.lastTS;
    }

    public SortedMap getHistoricalModels() {
        return this.models;
    }

    public List<MoversDescriptor> getMoversDescriptors() {
        return this.moversDescriptors;
    }

    public List<AddedDescriptor> getAddedDescriptors() {
        return this.addedDescriptors;
    }

    private Long getFirstTSAfter(List<Long> timestamps, Long lastTS, Interval requested) {
        Collections.reverse(timestamps);
        Long firstTS = timestamps.get(1);
        if (requested != null) {
            long requestedTS = lastTS - requested.getValueInMillis();
            if (requestedTS >= lastTS) {
                this.log.warn("Ignoring interval setting of " + requested + ". ");
            } else {
                for (Long ts : timestamps) {
                    if (ts < requestedTS) break;
                    firstTS = ts;
                }
            }
        }
        if (firstTS.equals(lastTS)) {
            firstTS = timestamps.get(1);
        }
        return firstTS;
    }

    public class MoversDescriptor {
        Historical.Movers movers;
        private Interval moversInterval;
        private List<MetricsDiffSummary> positiveMovers;
        private List<MetricsDiffSummary> negativeMovers;

        public MoversDescriptor() {
        }

        public MoversDescriptor(Historical.Movers movers) {
            this.movers = movers;
        }

        public void gatherMovers() throws Exception {
            Interval requested = this.movers.getInterval();
            Long firstTS = HistoricalReportDescriptor.this.getFirstTSAfter(Lists.newLinkedList(HistoricalReportDescriptor.this.models.keySet()), HistoricalReportDescriptor.this.lastTS, requested);
            this.moversInterval = this.calcActualInterval(HistoricalReportDescriptor.this.lastTS, firstTS, requested);
            HasMetrics fromMetrics = HistoricalSupport.getFullMetrics((HistoricalSupport.HasMetricsWrapper)HistoricalReportDescriptor.this.models.get(firstTS), HistoricalReportDescriptor.this.getPackage());
            Column column = this.movers.getColumn();
            List<MetricsDiffSummary> moverClasses = this.getMoverClasses(fromMetrics, column);
            if (column.getFormat() instanceof ColumnFormat.PercentageColumnFormat) {
                this.movers.setMaxWidth(100);
            } else {
                this.movers.setMaxWidth(column.getNumber().intValue());
            }
            int lastMover = moverClasses.size() - 1;
            int range = this.movers.getRange();
            if (moverClasses.size() > 0) {
                this.positiveMovers = this.getPositiveMovers(moverClasses, lastMover, range);
                this.negativeMovers = this.getNegativeMovers(moverClasses, range);
            } else {
                this.positiveMovers = Lists.newArrayList();
                this.negativeMovers = Lists.newArrayList();
            }
        }

        protected List<MetricsDiffSummary> getNegativeMovers(List<MetricsDiffSummary> moverClasses, int range) {
            MetricsDiffSummary diff = moverClasses.get(0);
            ArrayList<MetricsDiffSummary> negativeMovers = Lists.newArrayList();
            if (diff.getPcDiff() < 0.0f) {
                Iterator<MetricsDiffSummary> bottom = moverClasses.iterator();
                for (int i = 0; i < range && bottom.hasNext() && !((diff = bottom.next()).getPcDiff() >= 0.0f); ++i) {
                    negativeMovers.add(diff);
                }
            }
            return negativeMovers;
        }

        protected List<MetricsDiffSummary> getPositiveMovers(List<MetricsDiffSummary> moverClasses, int lastMover, int range) {
            return this.getPositiveMoversInner(moverClasses, lastMover, range, false);
        }

        protected List<MetricsDiffSummary> getPositiveMoversInner(List<MetricsDiffSummary> moverClasses, int lastMover, int range, boolean includeZero) {
            MetricsDiffSummary diff = moverClasses.get(lastMover);
            ArrayList<MetricsDiffSummary> positiveMovers = Lists.newArrayList();
            if (diff.getPcDiff() > 0.0f || includeZero && diff.getPcDiff() == 0.0f) {
                ListIterator<MetricsDiffSummary> top = moverClasses.listIterator(lastMover + 1);
                for (int i = 0; i < range && top.hasPrevious() && !((diff = top.previous()).getPcDiff() < 0.0f) && (includeZero || diff.getPcDiff() != 0.0f); ++i) {
                    positiveMovers.add(diff);
                }
            }
            return positiveMovers;
        }

        protected List<MetricsDiffSummary> getMoverClasses(HasMetrics fromMetrics, Column column) throws CloverException {
            return HistoricalSupport.getClassesMetricsDifference(fromMetrics, HistoricalReportDescriptor.this.subjectMetrics, this.movers.getThreshold(), column, true);
        }

        private Interval calcActualInterval(Long lastTS, Long firstTS, Interval requested) {
            Interval actual = new Interval((lastTS - firstTS) / 1000L, 0);
            if (requested != null && !actual.equals(requested)) {
                HistoricalReportDescriptor.this.log.info("movers interval adjusted to " + actual.toSensibleString());
            } else {
                HistoricalReportDescriptor.this.log.info("using movers interval of " + actual.toSensibleString());
            }
            return actual;
        }

        public Interval getRequestedInterval() {
            if (HistoricalReportDescriptor.this.showMovers()) {
                Interval interval = this.movers.getInterval();
                if (interval == null) {
                    interval = this.getActualInterval();
                }
                return interval;
            }
            return null;
        }

        public int getMaxWidth() {
            return this.movers.getMaxWidth();
        }

        public List<MetricsDiffSummary> getGainers() {
            return this.positiveMovers;
        }

        public List<MetricsDiffSummary> getLosers() {
            return this.negativeMovers;
        }

        public Interval getActualInterval() {
            return this.moversInterval;
        }

        public Interval getInterval() {
            return this.movers.getInterval();
        }

        public Percentage getThreshold() {
            return this.movers.getThreshold();
        }

        public Column getColumn() {
            return this.movers.getColumn();
        }

        public int getRange() {
            return this.movers.getRange();
        }
    }

    public class AddedDescriptor
    extends MoversDescriptor {
        public AddedDescriptor(Historical.Movers movers) {
            this.movers = movers;
        }

        @Override
        protected List<MetricsDiffSummary> getPositiveMovers(List<MetricsDiffSummary> moverClasses, int lastMover, int range) {
            if (moverClasses.size() <= range) {
                Collections.sort(moverClasses, MetricsDiffSummary.INVERSE_DIFF_COMP);
                return this.removeAllEmpty(moverClasses);
            }
            List<MetricsDiffSummary> topN = this.getPositiveMoversInner(moverClasses, lastMover, range, true);
            Collections.sort(topN, MetricsDiffSummary.INVERSE_DIFF_COMP);
            List<MetricsDiffSummary> bottomN = this.getBottomMovers(moverClasses, range);
            ArrayList<MetricsDiffSummary> result = new ArrayList<MetricsDiffSummary>(topN.size() + bottomN.size());
            result.addAll(topN);
            result.addAll(bottomN);
            return this.removeAllEmpty(result);
        }

        private List<MetricsDiffSummary> removeAllEmpty(List<MetricsDiffSummary> result) {
            LinkedList<MetricsDiffSummary> nonEmpty = Lists.newLinkedList();
            for (MetricsDiffSummary diffSummary : result) {
                if (diffSummary.getCurrentClassInfo().getMetrics().isEmpty()) continue;
                nonEmpty.add(diffSummary);
            }
            return nonEmpty;
        }

        protected List<MetricsDiffSummary> getBottomMovers(List<MetricsDiffSummary> moverClasses, int range) {
            int toIndex = moverClasses.size() > range ? range : moverClasses.size();
            return moverClasses.subList(0, toIndex);
        }

        @Override
        protected List<MetricsDiffSummary> getMoverClasses(HasMetrics fromMetrics, Column column) throws CloverException {
            return HistoricalSupport.getClassesMetricsDifference(fromMetrics, HistoricalReportDescriptor.this.subjectMetrics, this.movers.getThreshold(), column, false);
        }
    }
}

