/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.spec.instr.test;

import clover.com.google.common.collect.Lists;
import com.atlassian.clover.api.CloverException;
import com.atlassian.clover.instr.tests.AggregateTestDetector;
import com.atlassian.clover.instr.tests.BooleanStrategy;
import com.atlassian.clover.instr.tests.DefaultTestDetector;
import com.atlassian.clover.instr.tests.OrStrategy;
import com.atlassian.clover.instr.tests.TestDetector;
import com.atlassian.clover.instr.tests.TestSpec;
import com.atlassian.clover.spec.instr.test.TestClassSpec;
import com.atlassian.clover.spec.instr.test.TestMethodSpec;
import java.io.Serializable;
import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public abstract class BooleanSpec
implements Serializable {
    private List<TestClassSpec> testClassSpecs = null;

    public void addConfiguredTestClass(TestClassSpec testClassSpec) {
        if (this.testClassSpecs == null) {
            this.testClassSpecs = Lists.newArrayList();
        }
        this.testClassSpecs.add(testClassSpec);
    }

    public List<TestClassSpec> getTestClassSpecs() {
        return this.testClassSpecs;
    }

    public abstract BooleanStrategy getStrategy();

    public static TestDetector buildTestDetectorFor(List<BooleanSpec> boolSpecs) throws CloverException {
        if (boolSpecs != null) {
            AggregateTestDetector testDetectorGroups = new AggregateTestDetector(new OrStrategy());
            for (BooleanSpec booleanSpec : boolSpecs) {
                if (booleanSpec.getTestClassSpecs() == null) continue;
                AggregateTestDetector testDetectors = new AggregateTestDetector(booleanSpec.getStrategy());
                for (TestClassSpec testClassSpec : booleanSpec.getTestClassSpecs()) {
                    TestSpec testSpec = new TestSpec();
                    try {
                        if (testClassSpec.getPackage() != null) {
                            testSpec.setPkgPattern(Pattern.compile(testClassSpec.getPackage()));
                        }
                        if (testClassSpec.getAnnotation() != null) {
                            testSpec.setClassAnnotationPattern(Pattern.compile(testClassSpec.getAnnotation()));
                        }
                        if (testClassSpec.getTag() != null) {
                            testSpec.setClassTagPattern(Pattern.compile(testClassSpec.getTag()));
                        }
                        if (testClassSpec.getName() != null) {
                            testSpec.setClassPattern(Pattern.compile(testClassSpec.getName()));
                        }
                        if (testClassSpec.getSuper() != null) {
                            testSpec.setSuperPattern(Pattern.compile(testClassSpec.getSuper()));
                        }
                        AggregateTestDetector methodDetectors = new AggregateTestDetector(new OrStrategy());
                        for (TestMethodSpec methodSpec : testClassSpec.getTestMethods()) {
                            TestSpec method = new TestSpec(testSpec);
                            if (methodSpec.getAnnotation() != null) {
                                method.setMethodAnnotationPattern(Pattern.compile(methodSpec.getAnnotation()));
                            }
                            if (methodSpec.getTag() != null) {
                                method.setMethodTagPattern(Pattern.compile(methodSpec.getTag()));
                            }
                            if (methodSpec.getName() != null) {
                                method.setMethodPattern(Pattern.compile(methodSpec.getName()));
                            }
                            if (methodSpec.getReturnType() != null) {
                                method.setMethodReturnTypePattern(Pattern.compile(methodSpec.getReturnType()));
                            }
                            methodDetectors.addDetector(method);
                        }
                        if (!methodDetectors.isEmpty()) {
                            testDetectors.addDetector(methodDetectors);
                            continue;
                        }
                        testDetectors.addDetector(testSpec);
                    }
                    catch (PatternSyntaxException e) {
                        throw new CloverException("Error parsing regular expression: " + e.getMessage());
                    }
                }
                testDetectorGroups.addDetector(testDetectors);
            }
            return testDetectorGroups;
        }
        return new DefaultTestDetector();
    }

    public String toString() {
        String content = "testclasses(";
        if (this.testClassSpecs != null) {
            for (TestClassSpec testClass : this.testClassSpecs) {
                content = content + "\n\t" + testClass.toString();
            }
        }
        content = content + ")";
        return content;
    }
}

