/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.util;

import com.atlassian.clover.api.CloverException;
import com.atlassian.clover.util.FileUtils;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.CodeSource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClassPathUtil {
    private static void addURL(@NotNull URLClassLoader ucl, @NotNull URL path) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, CloverException {
        try {
            Method addURLMethod = URLClassLoader.class.getDeclaredMethod("addURL", URL.class);
            addURLMethod.setAccessible(true);
            addURLMethod.invoke((Object)ucl, path);
        }
        catch (NoSuchMethodException e) {
            throw new CloverException("Unable to setup classpath extender", e);
        }
    }

    public static void extendClassPath(@NotNull String path, @NotNull URLClassLoader loader) throws CloverException {
        try {
            URL url = new File(path).toURI().toURL();
            ClassPathUtil.addURL(loader, url);
        }
        catch (Exception e) {
            throw new CloverException("Unable to add paths to the ClassLoader", e);
        }
    }

    @NotNull
    public static URLClassLoader findSystemClassLoader(@NotNull Class obj) throws CloverException {
        ClassLoader loader = obj.getClassLoader();
        while (!(loader instanceof URLClassLoader)) {
            if ((loader = loader.getParent()) != null) continue;
            throw new CloverException("Unable to find a URLClassLoader for object: " + obj);
        }
        return (URLClassLoader)loader;
    }

    public static boolean isClassOnClassPath(@NotNull String className, @NotNull ClassLoader loader) {
        try {
            Class.forName(className, true, loader);
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public static void assertOnClassPath(@NotNull String className, @NotNull ClassLoader loader) throws CloverException {
        if (!ClassPathUtil.isClassOnClassPath(className, loader)) {
            throw new CloverException(className + " is not on classpath of class loader: " + loader);
        }
    }

    @Nullable
    public static String getCloverJarPath() {
        Object uri;
        String pathToClass = "/" + ClassPathUtil.class.getName().replace('.', '/') + ".class";
        URL url = ClassPathUtil.class.getResource(pathToClass);
        if (url != null) {
            String path = url.toString();
            try {
                uri = null;
                if (path.startsWith("jar:file:")) {
                    int bang = path.indexOf("!");
                    uri = path.substring(4, bang);
                } else if (path.startsWith("file:")) {
                    int tail = path.indexOf(pathToClass);
                    uri = path.substring(0, tail);
                }
                if (uri != null) {
                    return new File(FileUtils.fromURI((String)uri)).getAbsolutePath();
                }
            }
            catch (Exception e) {
                return null;
            }
        }
        try {
            CodeSource code = ClassPathUtil.class.getProtectionDomain().getCodeSource();
            if (code != null) {
                uri = code.getLocation().toURI();
                if ("reference".equals(((URI)uri).getScheme())) {
                    return new File(FileUtils.fromURI(((URI)uri).getSchemeSpecificPart())).getAbsolutePath();
                }
                if ("file".equals(((URI)uri).getScheme())) {
                    return new File(FileUtils.fromURI(((URI)uri).toString())).getAbsolutePath();
                }
            }
        }
        catch (SecurityException ex) {
            return null;
        }
        catch (URISyntaxException ex) {
            return null;
        }
        return null;
    }
}

