/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.util.format;

import com.atlassian.clover.util.format.MessageFormatException;
import com.atlassian.clover.util.format.MessageTokenizer;
import com.atlassian.clover.util.format.StringFormatting;

public class HtmlFormatter {
    public static String format(String message) {
        try {
            StringBuilder buffer = new StringBuilder();
            MessageTokenizer tokenizer = new MessageTokenizer(message);
            while (tokenizer.hasNext()) {
                int token = tokenizer.nextToken();
                if (token == 1) {
                    buffer.append(HtmlFormatter.readAnchor(tokenizer));
                    continue;
                }
                if (token == 8) {
                    buffer.append("<hr>");
                    continue;
                }
                buffer.append(tokenizer.getContent());
            }
            String formatted = buffer.toString();
            return StringFormatting.replaceAll(formatted, "\n", "<br/>");
        }
        catch (MessageFormatException e) {
            return message;
        }
    }

    private static String readAnchor(MessageTokenizer tokenizer) throws MessageFormatException {
        StringBuilder buffer = new StringBuilder();
        int token = 0;
        while (tokenizer.hasNext() && (token = tokenizer.nextToken()) != 2) {
            buffer.append(tokenizer.getContent());
        }
        String anchor = buffer.toString();
        return "<a href=\"" + anchor + "\">" + anchor + "</a>";
    }
}

